/*
 * Decompiled with CFR 0.152.
 */
package org.datanucleus.store.valuegenerator;

import java.lang.reflect.Constructor;
import java.util.Map;
import java.util.Properties;
import java.util.concurrent.ConcurrentHashMap;
import org.datanucleus.store.StoreManager;
import org.datanucleus.store.valuegenerator.AbstractDatastoreGenerator;
import org.datanucleus.store.valuegenerator.ValueGenerationConnectionProvider;
import org.datanucleus.store.valuegenerator.ValueGenerationException;
import org.datanucleus.store.valuegenerator.ValueGenerator;
import org.datanucleus.util.Localiser;
import org.datanucleus.util.NucleusLogger;

public class ValueGenerationManager {
    protected Map<String, ValueGenerator> generatorsByName = new ConcurrentHashMap<String, ValueGenerator>();

    public void clear() {
        this.generatorsByName.clear();
    }

    public ValueGenerator getValueGenerator(String name) {
        if (name == null) {
            return null;
        }
        return this.generatorsByName.get(name);
    }

    public ValueGenerator createValueGenerator(String name, Class generatorClass, Properties props, StoreManager storeMgr, ValueGenerationConnectionProvider connectionProvider) {
        ValueGenerator generator;
        try {
            if (NucleusLogger.VALUEGENERATION.isDebugEnabled()) {
                NucleusLogger.VALUEGENERATION.debug(Localiser.msg("040001", generatorClass.getName(), name));
            }
            Class[] argTypes = new Class[]{String.class, Properties.class};
            Object[] args = new Object[]{name, props};
            Constructor ctor = generatorClass.getConstructor(argTypes);
            generator = (ValueGenerator)ctor.newInstance(args);
        }
        catch (Exception e) {
            NucleusLogger.VALUEGENERATION.error(e);
            throw new ValueGenerationException(Localiser.msg("040000", generatorClass.getName(), e), e);
        }
        if (generator instanceof AbstractDatastoreGenerator && storeMgr != null) {
            ((AbstractDatastoreGenerator)generator).setStoreManager(storeMgr);
            ((AbstractDatastoreGenerator)generator).setConnectionProvider(connectionProvider);
        }
        this.generatorsByName.put(name, generator);
        return generator;
    }
}

