/*
 * Decompiled with CFR 0.152.
 */
package org.datanucleus.store.connection;

import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import javax.transaction.xa.XAResource;
import org.datanucleus.ClassConstants;
import org.datanucleus.ExecutionContext;
import org.datanucleus.PersistenceNucleusContext;
import org.datanucleus.Transaction;
import org.datanucleus.TransactionEventListener;
import org.datanucleus.exceptions.NucleusException;
import org.datanucleus.exceptions.NucleusUserException;
import org.datanucleus.plugin.ConfigurationElement;
import org.datanucleus.store.StoreManager;
import org.datanucleus.store.connection.AbstractManagedConnection;
import org.datanucleus.store.connection.ConnectionFactory;
import org.datanucleus.store.connection.ConnectionManager;
import org.datanucleus.store.connection.ConnectionResourceType;
import org.datanucleus.store.connection.ManagedConnection;
import org.datanucleus.store.connection.ManagedConnectionResourceListener;
import org.datanucleus.transaction.ResourcedTransaction;
import org.datanucleus.util.Localiser;
import org.datanucleus.util.NucleusLogger;

public class ConnectionManagerImpl
implements ConnectionManager {
    StoreManager storeMgr;
    PersistenceNucleusContext nucleusContext;
    boolean connectionCachingEnabled = true;
    ConnectionFactory primaryConnectionFactory = null;
    ConnectionFactory secondaryConnectionFactory = null;
    Map<ExecutionContext, ManagedConnection> primaryConnectionsCache;
    Map<ExecutionContext, ManagedConnection> secondaryConnectionsCache;

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public ConnectionManagerImpl(StoreManager storeMgr) {
        String cfName;
        this.storeMgr = storeMgr;
        this.nucleusContext = storeMgr.getNucleusContext();
        String datastoreName = storeMgr.getStringProperty("DATA_FEDERATION_DATASTORE_NAME");
        ConfigurationElement cfElem = this.nucleusContext.getPluginManager().getConfigurationElementForExtension("org.datanucleus.store_connectionfactory", new String[]{"datastore", "transactional"}, new String[]{storeMgr.getStoreManagerKey(), "true"});
        if (cfElem == null) throw new NucleusException("Error creating transactional connection factory. No connection factory plugin defined");
        try {
            this.primaryConnectionFactory = (ConnectionFactory)this.nucleusContext.getPluginManager().createExecutableExtension("org.datanucleus.store_connectionfactory", new String[]{"datastore", "transactional"}, new String[]{storeMgr.getStoreManagerKey(), "true"}, "class-name", new Class[]{ClassConstants.STORE_MANAGER, ClassConstants.JAVA_LANG_STRING}, new Object[]{storeMgr, "tx"});
            this.primaryConnectionsCache = new ConcurrentHashMap<ExecutionContext, ManagedConnection>();
            if (NucleusLogger.CONNECTION.isDebugEnabled()) {
                cfName = cfElem.getAttribute("name");
                if (datastoreName != null) {
                    cfName = cfName + "-" + datastoreName;
                }
                NucleusLogger.CONNECTION.debug(Localiser.msg("032018", cfName));
            }
        }
        catch (Exception e) {
            throw new NucleusException("Error creating transactional connection factory", e).setFatal();
        }
        cfElem = this.nucleusContext.getPluginManager().getConfigurationElementForExtension("org.datanucleus.store_connectionfactory", new String[]{"datastore", "transactional"}, new String[]{storeMgr.getStoreManagerKey(), "false"});
        if (cfElem == null) return;
        try {
            this.secondaryConnectionFactory = (ConnectionFactory)this.nucleusContext.getPluginManager().createExecutableExtension("org.datanucleus.store_connectionfactory", new String[]{"datastore", "transactional"}, new String[]{storeMgr.getStoreManagerKey(), "false"}, "class-name", new Class[]{ClassConstants.STORE_MANAGER, ClassConstants.JAVA_LANG_STRING}, new Object[]{storeMgr, "nontx"});
            this.secondaryConnectionsCache = new ConcurrentHashMap<ExecutionContext, ManagedConnection>();
            if (!NucleusLogger.CONNECTION.isDebugEnabled()) return;
            cfName = cfElem.getAttribute("name");
            if (datastoreName != null) {
                cfName = cfName + "-" + datastoreName;
            }
            NucleusLogger.CONNECTION.debug(Localiser.msg("032019", cfName));
            return;
        }
        catch (Exception e) {
            throw new NucleusException("Error creating nontransactional connection factory", e).setFatal();
        }
    }

    @Override
    public void close() {
        if (this.primaryConnectionFactory != null) {
            if (this.primaryConnectionsCache != null) {
                this.primaryConnectionsCache = null;
            }
            this.primaryConnectionFactory.close();
        }
        if (this.secondaryConnectionFactory != null) {
            if (this.secondaryConnectionsCache != null) {
                this.secondaryConnectionsCache = null;
            }
            this.secondaryConnectionFactory.close();
        }
    }

    @Override
    public void disableConnectionCaching() {
        this.connectionCachingEnabled = false;
        this.primaryConnectionsCache = null;
        this.secondaryConnectionsCache = null;
    }

    @Override
    public ManagedConnection getConnection(ExecutionContext ec, Map options) {
        boolean primary = true;
        if (!ec.getTransaction().isActive()) {
            boolean singleConnection = this.storeMgr.getBooleanProperty("datanucleus.connection.singleConnectionPerExecutionContext");
            primary = singleConnection ? true : this.secondaryConnectionFactory == null;
        }
        ManagedConnection mconn = this.allocateManagedConnection(primary, ec, ec.getTransaction(), options);
        ((AbstractManagedConnection)mconn).incrementUseCount();
        return mconn;
    }

    @Override
    public ManagedConnection getConnection(int isolationLevel) {
        boolean primary = this.secondaryConnectionFactory == null;
        HashMap<String, Integer> options = null;
        if (isolationLevel >= 0) {
            options = new HashMap<String, Integer>();
            options.put("transaction.isolation", isolationLevel);
        }
        ManagedConnection mconn = this.allocateManagedConnection(primary, null, null, options);
        ((AbstractManagedConnection)mconn).incrementUseCount();
        return mconn;
    }

    @Override
    public ManagedConnection getConnection(boolean primary, ExecutionContext ec, Transaction txn) {
        ManagedConnection mconn = this.allocateManagedConnection(primary, ec, txn, null);
        ((AbstractManagedConnection)mconn).incrementUseCount();
        return mconn;
    }

    @Override
    public void closeAllConnections(ExecutionContext ec) {
        if (ec != null && this.connectionCachingEnabled) {
            ManagedConnection mc;
            if (this.primaryConnectionFactory != null && this.primaryConnectionsCache != null && (mc = this.primaryConnectionsCache.remove(ec)) != null) {
                mc.close();
            }
            if (this.secondaryConnectionFactory != null && this.secondaryConnectionsCache != null && (mc = this.secondaryConnectionsCache.remove(ec)) != null) {
                mc.close();
            }
        }
    }

    protected void removeManagedConnection(boolean primary, ExecutionContext ec) {
        ManagedConnection prevMC;
        ManagedConnection managedConnection = prevMC = primary ? this.primaryConnectionsCache.remove(ec) : this.secondaryConnectionsCache.remove(ec);
        if (this.nucleusContext.getStatistics() != null && prevMC != null) {
            this.nucleusContext.getStatistics().decrementActiveConnections();
        }
    }

    protected ManagedConnection getManagedConnection(boolean primary, ExecutionContext ec) {
        ManagedConnection mconn;
        ManagedConnection managedConnection = mconn = primary ? this.primaryConnectionsCache.get(ec) : this.secondaryConnectionsCache.get(ec);
        if (mconn != null) {
            if (mconn.isLocked()) {
                throw new NucleusUserException(Localiser.msg("009000"));
            }
            return mconn;
        }
        return null;
    }

    protected void putManagedConnection(boolean primary, ExecutionContext ec, ManagedConnection mconn) {
        ManagedConnection prevMC;
        ManagedConnection managedConnection = prevMC = primary ? this.primaryConnectionsCache.put(ec, mconn) : this.secondaryConnectionsCache.put(ec, mconn);
        if (this.nucleusContext.getStatistics() != null && prevMC == null) {
            this.nucleusContext.getStatistics().incrementActiveConnections();
        }
    }

    private ManagedConnection allocateManagedConnection(final boolean primary, final ExecutionContext ec, Transaction transaction, Map options) {
        ManagedConnection mconnFromPool;
        ConnectionFactory factory;
        ConnectionFactory connectionFactory = factory = primary ? this.primaryConnectionFactory : this.secondaryConnectionFactory;
        if (ec != null && this.connectionCachingEnabled && (mconnFromPool = this.getManagedConnection(primary, ec)) != null) {
            if (!mconnFromPool.closeAfterTransactionEnd()) {
                if (transaction.isActive()) {
                    if (mconnFromPool.commitOnRelease()) {
                        mconnFromPool.setCommitOnRelease(false);
                    }
                    if (mconnFromPool.closeOnRelease()) {
                        mconnFromPool.setCloseOnRelease(false);
                    }
                    XAResource res = mconnFromPool.getXAResource();
                    ResourcedTransaction tx = this.nucleusContext.getResourcedTransactionManager().getTransaction(ec);
                    if (res != null && tx != null && !tx.isEnlisted(res)) {
                        String cfResourceType = factory.getResourceType();
                        if (!ConnectionResourceType.JTA.toString().equalsIgnoreCase(cfResourceType)) {
                            tx.enlistResource(res);
                        }
                    }
                } else {
                    if (!mconnFromPool.commitOnRelease()) {
                        mconnFromPool.setCommitOnRelease(true);
                    }
                    if (mconnFromPool.closeOnRelease()) {
                        mconnFromPool.setCloseOnRelease(false);
                    }
                }
            }
            return mconnFromPool;
        }
        HashMap<String, Object> txnOptions = new HashMap<String, Object>();
        if (transaction != null && transaction.getOptions() != null && !transaction.getOptions().isEmpty()) {
            txnOptions.putAll(transaction.getOptions());
        }
        if (options != null && !options.isEmpty()) {
            txnOptions.putAll(options);
        }
        final ManagedConnection mconn = factory.createManagedConnection(ec, txnOptions);
        if (ec != null) {
            if (transaction.isActive()) {
                this.configureTransactionEventListener(transaction, mconn);
                ResourcedTransaction tx = this.nucleusContext.getResourcedTransactionManager().getTransaction(ec);
                mconn.setCommitOnRelease(false);
                mconn.setCloseOnRelease(false);
                XAResource res = mconn.getXAResource();
                if (res != null && tx != null && !tx.isEnlisted(res)) {
                    String cfResourceType = factory.getResourceType();
                    if (!ConnectionResourceType.JTA.toString().equalsIgnoreCase(cfResourceType)) {
                        tx.enlistResource(res);
                    }
                }
            }
            if (this.connectionCachingEnabled) {
                mconn.addListener(new ManagedConnectionResourceListener(){

                    @Override
                    public void transactionFlushed() {
                    }

                    @Override
                    public void transactionPreClose() {
                    }

                    @Override
                    public void managedConnectionPreClose() {
                    }

                    @Override
                    public void managedConnectionPostClose() {
                        ConnectionManagerImpl.this.removeManagedConnection(primary, ec);
                        mconn.removeListener(this);
                    }

                    @Override
                    public void resourcePostClose() {
                    }
                });
                this.putManagedConnection(primary, ec, mconn);
            }
        }
        return mconn;
    }

    private void configureTransactionEventListener(final Transaction transaction, final ManagedConnection mconn) {
        if (mconn.closeAfterTransactionEnd()) {
            transaction.addTransactionEventListener(new TransactionEventListener(){

                @Override
                public void transactionStarted() {
                }

                @Override
                public void transactionRolledBack() {
                    try {
                        mconn.close();
                    }
                    finally {
                        transaction.removeTransactionEventListener(this);
                    }
                }

                @Override
                public void transactionCommitted() {
                    try {
                        mconn.close();
                    }
                    finally {
                        transaction.removeTransactionEventListener(this);
                    }
                }

                @Override
                public void transactionEnded() {
                    try {
                        mconn.close();
                    }
                    finally {
                        transaction.removeTransactionEventListener(this);
                    }
                }

                @Override
                public void transactionPreCommit() {
                    if (mconn.isLocked()) {
                        throw new NucleusUserException(Localiser.msg("009000"));
                    }
                    mconn.transactionPreClose();
                }

                @Override
                public void transactionPreRollBack() {
                    if (mconn.isLocked()) {
                        throw new NucleusUserException(Localiser.msg("009000"));
                    }
                    mconn.transactionPreClose();
                }

                @Override
                public void transactionPreFlush() {
                }

                @Override
                public void transactionFlushed() {
                    mconn.transactionFlushed();
                }

                @Override
                public void transactionSetSavepoint(String name) {
                    mconn.setSavepoint(name);
                }

                @Override
                public void transactionReleaseSavepoint(String name) {
                    mconn.releaseSavepoint(name);
                }

                @Override
                public void transactionRollbackToSavepoint(String name) {
                    mconn.rollbackToSavepoint(name);
                }
            });
        } else {
            transaction.bindTransactionEventListener(new TransactionEventListener(){

                @Override
                public void transactionStarted() {
                }

                @Override
                public void transactionPreFlush() {
                }

                @Override
                public void transactionFlushed() {
                    mconn.transactionFlushed();
                }

                @Override
                public void transactionPreCommit() {
                    if (mconn.isLocked()) {
                        throw new NucleusUserException(Localiser.msg("009000"));
                    }
                    mconn.transactionPreClose();
                }

                @Override
                public void transactionCommitted() {
                }

                @Override
                public void transactionPreRollBack() {
                    if (mconn.isLocked()) {
                        throw new NucleusUserException(Localiser.msg("009000"));
                    }
                    mconn.transactionPreClose();
                }

                @Override
                public void transactionRolledBack() {
                }

                @Override
                public void transactionEnded() {
                }

                @Override
                public void transactionSetSavepoint(String name) {
                    mconn.setSavepoint(name);
                }

                @Override
                public void transactionReleaseSavepoint(String name) {
                    mconn.releaseSavepoint(name);
                }

                @Override
                public void transactionRollbackToSavepoint(String name) {
                    mconn.rollbackToSavepoint(name);
                }
            });
        }
    }
}

