/*
 * Decompiled with CFR 0.152.
 */
package org.datanucleus;

import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import javax.enterprise.context.spi.CreationalContext;
import javax.enterprise.inject.spi.AnnotatedType;
import javax.enterprise.inject.spi.BeanManager;
import javax.enterprise.inject.spi.InjectionTarget;

public class CDIHandler {
    BeanManager beanManager;
    Set<CreationalContext> creationalContexts = new HashSet<CreationalContext>();
    Map<Object, InjectionTarget> injectionTargets = new HashMap<Object, InjectionTarget>();

    public CDIHandler(Object beanMgr) {
        this.beanManager = (BeanManager)beanMgr;
    }

    public <T> T createObjectWithInjectedDependencies(Class<T> cls) {
        AnnotatedType type = this.beanManager.createAnnotatedType(cls);
        CreationalContext creationalCtx = this.beanManager.createCreationalContext(null);
        this.creationalContexts.add(creationalCtx);
        InjectionTarget injectionTarget = this.beanManager.createInjectionTarget(type);
        Object obj = injectionTarget.produce(creationalCtx);
        injectionTarget.inject(obj, creationalCtx);
        injectionTarget.postConstruct(obj);
        this.injectionTargets.put(obj, injectionTarget);
        return (T)obj;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void close() {
        if (!this.injectionTargets.isEmpty()) {
            HashSet<Object> keys = new HashSet<Object>();
            Map<Object, InjectionTarget> map = this.injectionTargets;
            synchronized (map) {
                keys.addAll(this.injectionTargets.keySet());
                for (Object e : keys) {
                    try {
                        InjectionTarget target = this.injectionTargets.get(e);
                        target.preDestroy(e);
                        target.dispose(e);
                        this.injectionTargets.remove(e);
                    }
                    catch (Exception exception) {}
                }
            }
        }
        if (!this.creationalContexts.isEmpty()) {
            for (CreationalContext ctx : this.creationalContexts) {
                ctx.release();
                this.creationalContexts.remove(ctx);
            }
        }
    }
}

