/*
 * Decompiled with CFR 0.152.
 */
package org.datanucleus.store;

import java.util.HashMap;
import java.util.List;
import org.datanucleus.ExecutionContext;
import org.datanucleus.exceptions.DatastoreReadOnlyException;
import org.datanucleus.exceptions.NucleusObjectNotFoundException;
import org.datanucleus.exceptions.NucleusUserException;
import org.datanucleus.metadata.AbstractClassMetaData;
import org.datanucleus.state.ObjectProvider;
import org.datanucleus.store.StoreManager;
import org.datanucleus.store.StorePersistenceHandler;
import org.datanucleus.store.query.Query;
import org.datanucleus.util.Localiser;
import org.datanucleus.util.NucleusLogger;
import org.datanucleus.util.StringUtils;

public abstract class AbstractPersistenceHandler
implements StorePersistenceHandler {
    protected StoreManager storeMgr;

    public AbstractPersistenceHandler(StoreManager storeMgr) {
        this.storeMgr = storeMgr;
    }

    @Override
    public Object findObjectForUnique(ExecutionContext ec, AbstractClassMetaData cmd, String[] memberNames, Object[] values) {
        if (memberNames.length != values.length) {
            throw new NucleusUserException("findObjectForUnique should have same number of member names and values");
        }
        StringBuilder jdoqlStr = new StringBuilder("SELECT FROM ").append(cmd.getFullClassName()).append(" WHERE ");
        HashMap<String, Object> paramValueMap = new HashMap<String, Object>();
        for (int i = 0; i < memberNames.length; ++i) {
            jdoqlStr.append("this.").append(memberNames[i]).append("==:val").append(i);
            paramValueMap.put("val" + i, values[i]);
            if (i == memberNames.length - 1) continue;
            jdoqlStr.append(" && ");
        }
        Query q = this.storeMgr.getQueryManager().newQuery("JDOQL", ec, jdoqlStr.toString());
        List results = (List)q.executeWithMap(paramValueMap);
        if (results == null || results.size() == 0) {
            throw new NucleusObjectNotFoundException("No object found for specified members and values of type " + cmd.getFullClassName());
        }
        if (results.size() == 1) {
            return results.get(0);
        }
        throw new NucleusUserException("Specified members for class " + cmd.getFullClassName() + " finds multiple objects!");
    }

    public void assertReadOnlyForUpdateOfObject(ObjectProvider op) {
        boolean readonly;
        String value;
        if (op.getExecutionContext().getBooleanProperty("datanucleus.readOnlyDatastore").booleanValue()) {
            if (op.getExecutionContext().getStringProperty("datanucleus.readOnlyDatastoreAction").equalsIgnoreCase("EXCEPTION")) {
                throw new DatastoreReadOnlyException(Localiser.msg("032004", op.getObjectAsPrintable()), op.getExecutionContext().getClassLoaderResolver());
            }
            if (NucleusLogger.PERSISTENCE.isDebugEnabled()) {
                NucleusLogger.PERSISTENCE.debug(Localiser.msg("032005", op.getObjectAsPrintable()));
            }
            return;
        }
        AbstractClassMetaData cmd = op.getClassMetaData();
        if (cmd.hasExtension("read-only") && !StringUtils.isWhitespace(value = cmd.getValueForExtension("read-only")) && (readonly = Boolean.valueOf(value).booleanValue())) {
            if (op.getExecutionContext().getStringProperty("datanucleus.readOnlyDatastoreAction").equalsIgnoreCase("EXCEPTION")) {
                throw new DatastoreReadOnlyException(Localiser.msg("032006", op.getObjectAsPrintable()), op.getExecutionContext().getClassLoaderResolver());
            }
            if (NucleusLogger.PERSISTENCE.isDebugEnabled()) {
                NucleusLogger.PERSISTENCE.debug(Localiser.msg("032007", op.getObjectAsPrintable()));
            }
            return;
        }
    }
}

