/*
 * Decompiled with CFR 0.152.
 */
package org.datanucleus.store.types.converters;

import java.text.DateFormat;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.Date;
import org.datanucleus.exceptions.NucleusDataStoreException;
import org.datanucleus.store.types.converters.ColumnLengthDefiningTypeConverter;
import org.datanucleus.store.types.converters.TypeConverter;
import org.datanucleus.util.Localiser;

public class CalendarStringConverter
implements TypeConverter<Calendar, String>,
ColumnLengthDefiningTypeConverter {
    private static final long serialVersionUID = -4905708644688677004L;
    private static final ThreadLocal<FormatterInfo> formatterThreadInfo = new ThreadLocal<FormatterInfo>(){

        @Override
        protected FormatterInfo initialValue() {
            return new FormatterInfo();
        }
    };

    private DateFormat getFormatter() {
        FormatterInfo formatInfo = formatterThreadInfo.get();
        if (formatInfo.formatter == null) {
            formatInfo.formatter = new SimpleDateFormat("EEE MMM dd HH:mm:ss zzz yyyy");
        }
        return formatInfo.formatter;
    }

    @Override
    public int getDefaultColumnLength(int columnPosition) {
        if (columnPosition != 0) {
            return -1;
        }
        return 28;
    }

    @Override
    public Calendar toMemberType(String str) {
        if (str == null) {
            return null;
        }
        try {
            Date date = this.getFormatter().parse(str);
            Calendar cal = Calendar.getInstance();
            cal.setTime(date);
            return cal;
        }
        catch (ParseException pe) {
            throw new NucleusDataStoreException(Localiser.msg("016002", str, Calendar.class.getName()), pe);
        }
    }

    @Override
    public String toDatastoreType(Calendar cal) {
        return cal != null ? this.getFormatter().format(cal.getTime()) : null;
    }

    static class FormatterInfo {
        SimpleDateFormat formatter;

        FormatterInfo() {
        }
    }
}

