/*
 * Decompiled with CFR 0.152.
 */
package org.datanucleus.metadata;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.datanucleus.ClassLoaderResolver;
import org.datanucleus.ClassNameConstants;
import org.datanucleus.api.ApiAdapter;
import org.datanucleus.exceptions.ClassNotResolvedException;
import org.datanucleus.exceptions.NucleusException;
import org.datanucleus.exceptions.NucleusUserException;
import org.datanucleus.metadata.AbstractMemberMetaData;
import org.datanucleus.metadata.ClassMetaData;
import org.datanucleus.metadata.ClassPersistenceModifier;
import org.datanucleus.metadata.ColumnMetaData;
import org.datanucleus.metadata.DiscriminatorMetaData;
import org.datanucleus.metadata.DiscriminatorStrategy;
import org.datanucleus.metadata.EventListenerMetaData;
import org.datanucleus.metadata.FetchGroupMetaData;
import org.datanucleus.metadata.FieldMetaData;
import org.datanucleus.metadata.FieldPersistenceModifier;
import org.datanucleus.metadata.ForeignKeyMetaData;
import org.datanucleus.metadata.IdentityMetaData;
import org.datanucleus.metadata.IdentityStrategy;
import org.datanucleus.metadata.IdentityType;
import org.datanucleus.metadata.IndexMetaData;
import org.datanucleus.metadata.InheritanceMetaData;
import org.datanucleus.metadata.InheritanceStrategy;
import org.datanucleus.metadata.InterfaceMetaData;
import org.datanucleus.metadata.InvalidClassMetaDataException;
import org.datanucleus.metadata.InvalidMetaDataException;
import org.datanucleus.metadata.JoinMetaData;
import org.datanucleus.metadata.MetaData;
import org.datanucleus.metadata.MetaDataManager;
import org.datanucleus.metadata.MetaDataUtils;
import org.datanucleus.metadata.PackageMetaData;
import org.datanucleus.metadata.PrimaryKeyMetaData;
import org.datanucleus.metadata.PropertyMetaData;
import org.datanucleus.metadata.QueryMetaData;
import org.datanucleus.metadata.QueryResultMetaData;
import org.datanucleus.metadata.RelationType;
import org.datanucleus.metadata.StoredProcQueryMetaData;
import org.datanucleus.metadata.UniqueMetaData;
import org.datanucleus.metadata.VersionMetaData;
import org.datanucleus.metadata.VersionStrategy;
import org.datanucleus.store.StoreManager;
import org.datanucleus.util.ClassUtils;
import org.datanucleus.util.Localiser;
import org.datanucleus.util.MacroString;
import org.datanucleus.util.NucleusLogger;
import org.datanucleus.util.StringUtils;

public abstract class AbstractClassMetaData
extends MetaData {
    private static final long serialVersionUID = -2433561862769017940L;
    public static final String GENERATED_PK_SUFFIX = "_PK";
    protected transient MetaDataManager mmgr;
    protected final String name;
    protected String entityName;
    protected boolean mappedSuperclass = false;
    protected boolean instantiable = true;
    protected Boolean accessViaField = null;
    protected IdentityType identityType = IdentityType.DATASTORE;
    protected ClassPersistenceModifier persistenceModifier = ClassPersistenceModifier.PERSISTENCE_CAPABLE;
    protected String persistableSuperclass;
    protected String objectidClass;
    protected boolean requiresExtent = true;
    protected boolean detachable = false;
    protected boolean embeddedOnly = false;
    protected String catalog;
    protected String schema;
    protected String table;
    protected Boolean cacheable = null;
    protected final String fullName;
    protected VersionMetaData versionMetaData;
    protected IdentityMetaData identityMetaData;
    protected boolean identitySpecified = false;
    protected InheritanceMetaData inheritanceMetaData;
    protected PrimaryKeyMetaData primaryKeyMetaData;
    protected List<EventListenerMetaData> listeners = null;
    protected Boolean excludeSuperClassListeners = null;
    protected Boolean excludeDefaultListeners = null;
    protected Map<String, FetchGroupMetaData> fetchGroupMetaDataByName;
    protected AbstractClassMetaData pcSuperclassMetaData = null;
    protected boolean metaDataComplete = false;
    protected boolean serializeRead = false;
    protected Collection<QueryMetaData> queries = null;
    protected Collection<StoredProcQueryMetaData> storedProcQueries = null;
    protected Collection<QueryResultMetaData> queryResultMetaData = null;
    protected List<ColumnMetaData> unmappedColumns = null;
    protected Set<FetchGroupMetaData> fetchGroups = null;
    protected List<ForeignKeyMetaData> foreignKeys = null;
    protected List<IndexMetaData> indexes = null;
    protected List<UniqueMetaData> uniqueConstraints = null;
    protected List<JoinMetaData> joins = null;
    protected List<AbstractMemberMetaData> members = new ArrayList<AbstractMemberMetaData>();
    protected AbstractMemberMetaData[] managedMembers;
    protected AbstractMemberMetaData[] overriddenMembers;
    protected Map<String, Integer> memberPositionsByName;
    protected int[] allMemberPositions;
    protected int[] pkMemberPositions;
    protected int[] nonPkMemberPositions;
    protected boolean[] nonPkMemberFlags;
    protected int[] dfgMemberPositions;
    protected boolean[] dfgMemberFlags;
    protected int[] scoMutableMemberPositions;
    protected boolean[] scoMutableMemberFlags;
    protected int[] scoNonContainerMemberPositions = null;
    protected int[] relationPositions = null;
    protected int noOfInheritedManagedMembers = 0;
    protected boolean usesSingleFieldIdentityClass;
    protected int memberCount;
    protected boolean implementationOfPersistentDefinition = false;
    boolean populating = false;
    boolean initialising = false;
    protected Boolean fetchGroupMetaWithPostLoad;
    protected Boolean pkIsDatastoreAttributed = null;
    protected Boolean hasRelations = null;
    protected transient boolean persistentInterfaceImplNeedingTableFromSuperclass = false;
    protected transient boolean persistentInterfaceImplNeedingTableFromSubclass = false;
    protected int[] secondClassContainerMemberPositions = null;

    protected AbstractClassMetaData(PackageMetaData parent, String name) {
        super(parent);
        if (StringUtils.isWhitespace(name)) {
            throw new InvalidMetaDataException("044061", parent.name);
        }
        this.name = name;
        this.fullName = ClassUtils.createFullClassName(parent.name, name);
    }

    public AbstractClassMetaData(InterfaceMetaData imd, String implClassName, boolean copyMembers) {
        this((PackageMetaData)imd.parent, implClassName);
        this.setMappedSuperclass(imd.mappedSuperclass);
        this.setRequiresExtent(imd.requiresExtent);
        this.setDetachable(imd.detachable);
        this.setTable(imd.table);
        this.setCatalog(imd.catalog);
        this.setSchema(imd.schema);
        this.setEntityName(imd.entityName);
        this.setObjectIdClass(imd.objectidClass);
        this.setPersistenceModifier(ClassPersistenceModifier.PERSISTENCE_CAPABLE);
        this.setEmbeddedOnly(imd.embeddedOnly);
        this.setIdentityType(imd.identityType);
        this.implementationOfPersistentDefinition = true;
        if (copyMembers) {
            for (int i = 0; i < imd.getMemberCount(); ++i) {
                FieldMetaData fmd = new FieldMetaData((MetaData)this, imd.getMetaDataForManagedMemberAtAbsolutePosition(i));
                this.addMember(fmd);
            }
        }
        this.setVersionMetaData(imd.versionMetaData);
        this.setIdentityMetaData(imd.identityMetaData);
        this.setPrimaryKeyMetaData(imd.primaryKeyMetaData);
        if (imd.inheritanceMetaData != null) {
            if (imd.inheritanceMetaData.getStrategy() == InheritanceStrategy.SUPERCLASS_TABLE) {
                this.persistentInterfaceImplNeedingTableFromSuperclass = true;
            } else if (imd.getInheritanceMetaData().getStrategy() == InheritanceStrategy.SUBCLASS_TABLE) {
                this.persistentInterfaceImplNeedingTableFromSubclass = true;
            }
            InheritanceMetaData inhmd = new InheritanceMetaData();
            inhmd.setStrategy(InheritanceStrategy.NEW_TABLE);
            if (imd.inheritanceMetaData.getStrategy() == InheritanceStrategy.SUPERCLASS_TABLE) {
                for (AbstractClassMetaData acmd = imd.getSuperAbstractClassMetaData(); acmd != null; acmd = acmd.getSuperAbstractClassMetaData()) {
                    if (acmd.getInheritanceMetaData() == null || acmd.getInheritanceMetaData().getStrategy() != InheritanceStrategy.NEW_TABLE) continue;
                    if (acmd.getInheritanceMetaData().getDiscriminatorMetaData() != null) {
                        inhmd.setDiscriminatorMetaData(new DiscriminatorMetaData(acmd.getInheritanceMetaData().getDiscriminatorMetaData()));
                    }
                    inhmd.setJoinMetaData(acmd.getInheritanceMetaData().getJoinMetaData());
                    break;
                }
            } else if (imd.inheritanceMetaData.getStrategy() == InheritanceStrategy.NEW_TABLE) {
                if (imd.getInheritanceMetaData().getDiscriminatorMetaData() != null) {
                    inhmd.setDiscriminatorMetaData(new DiscriminatorMetaData(imd.getInheritanceMetaData().getDiscriminatorMetaData()));
                }
                inhmd.setJoinMetaData(imd.getInheritanceMetaData().getJoinMetaData());
            }
            this.setInheritanceMetaData(inhmd);
        }
        if (imd.joins != null) {
            for (JoinMetaData joinmd : imd.joins) {
                this.addJoin(joinmd);
            }
        }
        if (imd.foreignKeys != null) {
            for (ForeignKeyMetaData fkmd : imd.foreignKeys) {
                this.addForeignKey(fkmd);
            }
        }
        if (imd.indexes != null) {
            for (IndexMetaData idxmd : imd.indexes) {
                this.addIndex(idxmd);
            }
        }
        if (imd.uniqueConstraints != null) {
            for (UniqueMetaData unimd : imd.uniqueConstraints) {
                this.addUniqueConstraint(unimd);
            }
        }
        if (imd.fetchGroups != null) {
            for (FetchGroupMetaData fgmd : imd.fetchGroups) {
                this.addFetchGroup(fgmd);
            }
        }
        if (imd.queries != null) {
            for (MetaData query : imd.queries) {
                this.addQuery((QueryMetaData)query);
            }
        }
        if (imd.storedProcQueries != null) {
            for (MetaData query : imd.storedProcQueries) {
                this.addStoredProcQuery((StoredProcQueryMetaData)query);
            }
        }
        if (imd.listeners != null) {
            if (this.listeners == null) {
                this.listeners = new ArrayList<EventListenerMetaData>();
            }
            this.listeners.addAll(imd.listeners);
        }
    }

    public AbstractClassMetaData(ClassMetaData cmd, String implClassName) {
        this((PackageMetaData)cmd.parent, implClassName);
        this.setMappedSuperclass(cmd.mappedSuperclass);
        this.setRequiresExtent(cmd.requiresExtent);
        this.setDetachable(cmd.detachable);
        this.setCatalog(cmd.catalog);
        this.setSchema(cmd.schema);
        this.setTable(cmd.table);
        this.setEntityName(cmd.entityName);
        this.setPersistenceModifier(ClassPersistenceModifier.PERSISTENCE_CAPABLE);
        this.setEmbeddedOnly(cmd.embeddedOnly);
        this.setIdentityType(cmd.identityType);
        this.persistableSuperclass = cmd.getFullClassName();
        this.implementationOfPersistentDefinition = true;
        for (int i = 0; i < cmd.getMemberCount(); ++i) {
            FieldMetaData fmd = new FieldMetaData((MetaData)this, cmd.getMetaDataForManagedMemberAtAbsolutePosition(i));
            fmd.persistenceModifier = FieldPersistenceModifier.NONE;
            fmd.primaryKey = Boolean.FALSE;
            fmd.defaultFetchGroup = Boolean.FALSE;
            this.addMember(fmd);
        }
    }

    @Override
    public MetaDataManager getMetaDataManager() {
        return this.mmgr;
    }

    public boolean isInstantiable() {
        return this.instantiable;
    }

    protected AbstractClassMetaData getRootInstantiableClass() {
        if (this.pcSuperclassMetaData == null) {
            if (this.instantiable) {
                return this;
            }
        } else {
            AbstractClassMetaData rootCmd = this.pcSuperclassMetaData.getRootInstantiableClass();
            return rootCmd == null && this.instantiable ? this : rootCmd;
        }
        return null;
    }

    public boolean isRootInstantiableClass() {
        return this.getRootInstantiableClass() == this;
    }

    public boolean isImplementationOfPersistentDefinition() {
        return this.implementationOfPersistentDefinition;
    }

    protected void checkInitialised() {
        if (!this.isInitialised()) {
            throw new NucleusException(Localiser.msg("044069", this.fullName)).setFatal();
        }
    }

    protected void checkPopulated() {
        if (!this.isPopulated() && !this.isInitialised()) {
            throw new NucleusException(Localiser.msg("044070", this.fullName)).setFatal();
        }
    }

    protected void checkNotYetPopulated() {
        if (this.isPopulated() || this.isInitialised()) {
            throw new NucleusUserException("Already populated/initialised");
        }
    }

    protected Class loadClass(ClassLoaderResolver clr, ClassLoader primary) {
        Class cls;
        if (clr == null) {
            NucleusLogger.METADATA.warn(Localiser.msg("044067", this.fullName));
            clr = this.mmgr.getNucleusContext().getClassLoaderResolver(null);
        }
        try {
            cls = clr.classForName(this.fullName, primary, false);
            if (cls == null) {
                NucleusLogger.METADATA.error(Localiser.msg("044080", this.fullName));
                throw new InvalidClassMetaDataException("044080", new Object[]{this.fullName});
            }
        }
        catch (ClassNotResolvedException cnre) {
            NucleusLogger.METADATA.error(Localiser.msg("044080", this.fullName));
            InvalidClassMetaDataException ne = new InvalidClassMetaDataException("044080", new Object[]{this.fullName});
            ne.setNestedException(cnre);
            throw ne;
        }
        return cls;
    }

    protected void determineIdentity() {
        if (this.identityType == null) {
            if (this.objectidClass != null) {
                this.identityType = IdentityType.APPLICATION;
            } else {
                int noOfPkKeys = 0;
                for (AbstractMemberMetaData mmd : this.members) {
                    if (!mmd.isPrimaryKey()) continue;
                    ++noOfPkKeys;
                }
                this.identityType = noOfPkKeys > 0 ? IdentityType.APPLICATION : IdentityType.DATASTORE;
            }
        }
    }

    protected void determineSuperClassName(ClassLoaderResolver clr, Class cls) {
        String realPcSuperclassName = null;
        Collection<Class<?>> superclasses = cls.isInterface() ? ClassUtils.getSuperinterfaces(cls) : ClassUtils.getSuperclasses(cls);
        for (Class<?> superclass : superclasses) {
            AbstractClassMetaData superCmd = this.mmgr.getMetaDataForClassInternal(superclass, clr);
            if (superCmd == null || superCmd.getPersistenceModifier() != ClassPersistenceModifier.PERSISTENCE_CAPABLE) continue;
            realPcSuperclassName = superclass.getName();
            break;
        }
        this.persistableSuperclass = realPcSuperclassName;
        if (this.persistableSuperclass != null) {
            Class pcsc = null;
            try {
                pcsc = clr.classForName(this.persistableSuperclass);
            }
            catch (ClassNotResolvedException cnre) {
                throw new InvalidClassMetaDataException("044081", this.fullName, this.persistableSuperclass);
            }
            if (this.persistableSuperclass.equals(this.fullName) || !pcsc.isAssignableFrom(cls)) {
                throw new InvalidClassMetaDataException("044082", this.fullName, this.persistableSuperclass);
            }
            if (this.mmgr != null) {
                this.pcSuperclassMetaData = this.mmgr.getMetaDataForClassInternal(pcsc, clr);
                if (this.pcSuperclassMetaData == null) {
                    throw new InvalidClassMetaDataException("044083", this.fullName, this.persistableSuperclass);
                }
            } else {
                String superclassPkgName = this.persistableSuperclass.substring(0, this.persistableSuperclass.lastIndexOf(46));
                PackageMetaData pmd = this.getPackageMetaData().getFileMetaData().getPackage(superclassPkgName);
                if (pmd != null) {
                    String superclassClsName = this.persistableSuperclass.substring(this.persistableSuperclass.lastIndexOf(46) + 1);
                    this.pcSuperclassMetaData = pmd.getClass(superclassClsName);
                }
            }
            if (this.pcSuperclassMetaData == null) {
                throw new InvalidClassMetaDataException("044084", this.fullName, this.persistableSuperclass);
            }
            if (!this.pcSuperclassMetaData.isPopulated() && !this.pcSuperclassMetaData.isInitialised()) {
                this.pcSuperclassMetaData.populate(clr, cls.getClassLoader(), this.mmgr);
            }
        }
        if (this.persistableSuperclass != null && !this.isDetachable() && this.pcSuperclassMetaData.isDetachable()) {
            this.detachable = true;
        }
    }

    protected void validateUserInputForIdentity() {
        if (this.pcSuperclassMetaData != null) {
            AbstractClassMetaData baseCmd = this.getBaseAbstractClassMetaData();
            IdentityMetaData baseImd = baseCmd.getIdentityMetaData();
            if (baseCmd.identitySpecified && this.identitySpecified && baseImd != null && baseImd.getValueStrategy() != null && this.identityMetaData != null && this.identityMetaData.getValueStrategy() != null && this.identityMetaData.getValueStrategy() != baseImd.getValueStrategy() && this.identityMetaData.getValueStrategy() != null && this.identityMetaData.getValueStrategy() != IdentityStrategy.NATIVE) {
                throw new InvalidClassMetaDataException("044094", this.fullName, this.identityMetaData.getValueStrategy(), baseImd.getValueStrategy());
            }
            if (baseCmd.identitySpecified && this.identityMetaData != null && baseImd.getValueStrategy() != this.identityMetaData.getValueStrategy()) {
                this.identityMetaData.setValueStrategy(baseImd.getValueStrategy());
            }
        }
    }

    public AbstractClassMetaData getBaseAbstractClassMetaData() {
        if (this.pcSuperclassMetaData != null) {
            return this.pcSuperclassMetaData.getBaseAbstractClassMetaData();
        }
        return this;
    }

    public boolean isDescendantOf(AbstractClassMetaData cmd) {
        if (this.pcSuperclassMetaData == null) {
            return false;
        }
        if (this.pcSuperclassMetaData == cmd) {
            return true;
        }
        return this.pcSuperclassMetaData.isDescendantOf(cmd);
    }

    protected String getBaseInheritanceStrategy() {
        if (this.inheritanceMetaData != null && this.inheritanceMetaData.getStrategyForTree() != null) {
            return this.inheritanceMetaData.getStrategyForTree();
        }
        if (this.pcSuperclassMetaData != null) {
            return this.pcSuperclassMetaData.getBaseInheritanceStrategy();
        }
        return null;
    }

    protected void inheritIdentity() {
        if (this.objectidClass != null) {
            this.objectidClass = ClassUtils.createFullClassName(((PackageMetaData)this.parent).name, this.objectidClass);
        }
        if (this.persistableSuperclass != null) {
            if (this.objectidClass != null) {
                String superObjectIdClass = this.pcSuperclassMetaData.getObjectidClass();
                if (superObjectIdClass == null || !this.objectidClass.equals(superObjectIdClass)) {
                    throw new InvalidClassMetaDataException("044085", this.fullName, this.persistableSuperclass);
                }
                NucleusLogger.METADATA.info(Localiser.msg("044086", this.name, this.persistableSuperclass));
            } else {
                this.objectidClass = this.pcSuperclassMetaData.getObjectidClass();
            }
            if (this.identityType == null) {
                this.identityType = this.pcSuperclassMetaData.getIdentityType();
            }
            if (this.identityType != null && !this.identityType.equals((Object)this.pcSuperclassMetaData.getIdentityType())) {
                throw new InvalidClassMetaDataException("044093", new Object[]{this.fullName});
            }
            if (this.pcSuperclassMetaData.getIdentityType() == IdentityType.APPLICATION && this.pcSuperclassMetaData.getNoOfPopulatedPKMembers() > 0) {
                int noOfPkKeys = 0;
                for (AbstractMemberMetaData mmd : this.members) {
                    if (!mmd.isPrimaryKey() || !mmd.fieldBelongsToClass()) continue;
                    ++noOfPkKeys;
                }
                if (noOfPkKeys > 0) {
                    throw new InvalidClassMetaDataException("044034", this.getFullClassName(), noOfPkKeys, this.pcSuperclassMetaData.getNoOfPopulatedPKMembers());
                }
            }
        }
    }

    protected AbstractMemberMetaData newDefaultedProperty(String name) {
        return new PropertyMetaData((MetaData)this, name);
    }

    protected void validateUserInputForInheritanceMetaData(boolean isAbstract) {
        String baseInhStrategy;
        if (this.mappedSuperclass && (baseInhStrategy = this.getBaseInheritanceStrategy()) != null && baseInhStrategy.equalsIgnoreCase("SINGLE_TABLE") && this.getSuperclassManagingTable() != null && this.inheritanceMetaData != null) {
            this.inheritanceMetaData.setStrategy(InheritanceStrategy.SUPERCLASS_TABLE);
        }
        if (this.inheritanceMetaData != null) {
            DiscriminatorMetaData dismd;
            if (this.inheritanceMetaData.getStrategy() == InheritanceStrategy.SUPERCLASS_TABLE) {
                AbstractClassMetaData superCmd = this.getClassManagingTable();
                if (superCmd == null) {
                    throw new InvalidClassMetaDataException("044099", new Object[]{this.fullName});
                }
                DiscriminatorMetaData superDismd = superCmd.getInheritanceMetaData().getDiscriminatorMetaData();
                if (superDismd == null) {
                    throw new InvalidClassMetaDataException("044100", this.fullName, superCmd.fullName);
                }
                DiscriminatorMetaData dismd2 = this.inheritanceMetaData.getDiscriminatorMetaData();
                if (!(superDismd.getStrategy() != DiscriminatorStrategy.VALUE_MAP || dismd2 != null && dismd2.getValue() != null || this.mappedSuperclass || isAbstract)) {
                    throw new InvalidClassMetaDataException("044102", this.fullName, superCmd.fullName, superDismd.getColumnName());
                }
            }
            if (isAbstract) {
                dismd = this.inheritanceMetaData.getDiscriminatorMetaData();
                if (dismd != null && !StringUtils.isWhitespace(dismd.getValue())) {
                    NucleusLogger.METADATA.info(Localiser.msg("044105", this.fullName));
                }
            } else {
                ColumnMetaData superDiscrimColmd;
                dismd = this.inheritanceMetaData.getDiscriminatorMetaData();
                if (dismd != null && dismd.getColumnMetaData() != null && this.pcSuperclassMetaData != null && (superDiscrimColmd = this.pcSuperclassMetaData.getDiscriminatorColumnMetaData()) != null) {
                    NucleusLogger.GENERAL.debug(Localiser.msg("044126", this.fullName));
                }
            }
        }
    }

    protected void determineInheritanceMetaData() {
        if (this.inheritanceMetaData == null) {
            if (this.pcSuperclassMetaData != null) {
                AbstractClassMetaData baseCmd = this.getBaseAbstractClassMetaData();
                if (this.getBaseInheritanceStrategy() != null) {
                    String treeStrategy = this.getBaseInheritanceStrategy();
                    if ("JOINED".equals(treeStrategy)) {
                        this.inheritanceMetaData = new InheritanceMetaData();
                        this.inheritanceMetaData.setStrategy(InheritanceStrategy.NEW_TABLE);
                        return;
                    }
                    if ("SINGLE_TABLE".equals(treeStrategy)) {
                        this.inheritanceMetaData = new InheritanceMetaData();
                        this.inheritanceMetaData.setStrategy(InheritanceStrategy.SUPERCLASS_TABLE);
                        return;
                    }
                    if ("TABLE_PER_CLASS".equals(treeStrategy)) {
                        this.inheritanceMetaData = new InheritanceMetaData();
                        this.inheritanceMetaData.setStrategy(InheritanceStrategy.COMPLETE_TABLE);
                        return;
                    }
                }
                if (baseCmd.getInheritanceMetaData() != null && baseCmd.getInheritanceMetaData().getStrategy() == InheritanceStrategy.COMPLETE_TABLE) {
                    this.inheritanceMetaData = new InheritanceMetaData();
                    this.inheritanceMetaData.setStrategy(InheritanceStrategy.COMPLETE_TABLE);
                } else if (this.pcSuperclassMetaData.getInheritanceMetaData() != null && this.pcSuperclassMetaData.getInheritanceMetaData().getStrategy() == InheritanceStrategy.SUBCLASS_TABLE) {
                    this.inheritanceMetaData = new InheritanceMetaData();
                    this.inheritanceMetaData.setStrategy(InheritanceStrategy.NEW_TABLE);
                } else if (this.mmgr.getNucleusContext().getConfiguration().getStringProperty("datanucleus.metadata.defaultInheritanceStrategy").equalsIgnoreCase("TABLE_PER_CLASS")) {
                    this.inheritanceMetaData = new InheritanceMetaData();
                    this.inheritanceMetaData.setStrategy(InheritanceStrategy.NEW_TABLE);
                } else {
                    this.inheritanceMetaData = new InheritanceMetaData();
                    this.inheritanceMetaData.setStrategy(InheritanceStrategy.SUPERCLASS_TABLE);
                    if (!(baseCmd.getInheritanceMetaData() != null && baseCmd.getInheritanceMetaData().getDiscriminatorMetaData() != null || this.mmgr.isEnhancing())) {
                        NucleusLogger.METADATA.warn("Class " + this.getFullClassName() + " is defined to use the same table as " + baseCmd.getFullClassName() + " yet this root class has not been defined with a discriminator!!!");
                    }
                }
            } else {
                this.inheritanceMetaData = new InheritanceMetaData();
                this.inheritanceMetaData.setStrategy(InheritanceStrategy.NEW_TABLE);
            }
            return;
        }
        if (this.inheritanceMetaData.getStrategy() == null) {
            if (this.getBaseInheritanceStrategy() != null) {
                String treeStrategy = this.getBaseInheritanceStrategy();
                if ("SINGLE_TABLE".equalsIgnoreCase(treeStrategy)) {
                    if (this.pcSuperclassMetaData != null) {
                        this.inheritanceMetaData.strategy = this.pcSuperclassMetaData.getInheritanceMetaData() != null && this.pcSuperclassMetaData.getInheritanceMetaData().getStrategy() == InheritanceStrategy.SUBCLASS_TABLE ? InheritanceStrategy.NEW_TABLE : InheritanceStrategy.SUPERCLASS_TABLE;
                    } else {
                        if (this.inheritanceMetaData.getDiscriminatorMetaData() == null && this.mmgr.getNucleusContext().getConfiguration().getBooleanProperty("datanucleus.metadata.useDiscriminatorForSingleTable")) {
                            if (NucleusLogger.METADATA.isDebugEnabled()) {
                                NucleusLogger.METADATA.debug("Class " + this.getFullClassName() + " defined to use SINGLE_TABLE for the inheritance tree but no discriminator defined, so adding one");
                            }
                            if (this.mmgr.getNucleusContext().getConfiguration().getBooleanProperty("datanucleus.metadata.useDiscriminatorClassNameByDefault")) {
                                this.inheritanceMetaData.newDiscriminatorMetadata().setStrategy(DiscriminatorStrategy.CLASS_NAME).setIndexed("true").newColumnMetaData().setLength(31);
                            } else {
                                this.inheritanceMetaData.newDiscriminatorMetadata().setStrategy(DiscriminatorStrategy.ENTITY_NAME).setIndexed("true").newColumnMetaData().setLength(31);
                            }
                        }
                        this.inheritanceMetaData.strategy = InheritanceStrategy.NEW_TABLE;
                    }
                } else if ("TABLE_PER_CLASS".equalsIgnoreCase(treeStrategy)) {
                    this.inheritanceMetaData.strategy = InheritanceStrategy.COMPLETE_TABLE;
                } else if ("JOINED".equalsIgnoreCase(treeStrategy)) {
                    this.inheritanceMetaData.strategy = InheritanceStrategy.NEW_TABLE;
                }
                return;
            }
            if (this.pcSuperclassMetaData != null) {
                String treeStrategy = this.getBaseInheritanceStrategy();
                InheritanceStrategy baseStrategy = null;
                if ("SINGLE_TABLE".equalsIgnoreCase(treeStrategy)) {
                    baseStrategy = InheritanceStrategy.SUPERCLASS_TABLE;
                } else if ("TABLE_PER_CLASS".equalsIgnoreCase(treeStrategy)) {
                    baseStrategy = InheritanceStrategy.COMPLETE_TABLE;
                } else if ("JOINED".equalsIgnoreCase(treeStrategy)) {
                    baseStrategy = InheritanceStrategy.NEW_TABLE;
                } else {
                    AbstractClassMetaData baseCmd = this.getBaseAbstractClassMetaData();
                    if (baseCmd.getInheritanceMetaData() != null) {
                        baseStrategy = baseCmd.getInheritanceMetaData().getStrategy();
                    }
                }
                this.inheritanceMetaData.strategy = baseStrategy == InheritanceStrategy.COMPLETE_TABLE ? InheritanceStrategy.COMPLETE_TABLE : (this.pcSuperclassMetaData.getInheritanceMetaData() != null && this.pcSuperclassMetaData.getInheritanceMetaData().getStrategy() == InheritanceStrategy.SUBCLASS_TABLE ? InheritanceStrategy.NEW_TABLE : (this.mmgr.getNucleusContext().getConfiguration().getStringProperty("datanucleus.metadata.defaultInheritanceStrategy").equalsIgnoreCase("TABLE_PER_CLASS") ? InheritanceStrategy.NEW_TABLE : InheritanceStrategy.SUPERCLASS_TABLE));
            } else {
                this.inheritanceMetaData.strategy = InheritanceStrategy.NEW_TABLE;
            }
        }
    }

    protected void applyDefaultDiscriminatorValueWhenNotSpecified() {
        DiscriminatorMetaData dismd;
        if (this.inheritanceMetaData != null && this.inheritanceMetaData.getStrategy() == InheritanceStrategy.SUPERCLASS_TABLE) {
            AbstractClassMetaData superCmd = this.getClassManagingTable();
            if (superCmd == null) {
                throw new InvalidClassMetaDataException("044064", new Object[]{this.getFullClassName()});
            }
            if (superCmd.getInheritanceMetaData() != null) {
                DiscriminatorMetaData superDismd = superCmd.getInheritanceMetaData().getDiscriminatorMetaData();
                DiscriminatorMetaData dismd2 = this.inheritanceMetaData.getDiscriminatorMetaData();
                if (superDismd != null && superDismd.getStrategy() == DiscriminatorStrategy.VALUE_MAP && (dismd2 == null || dismd2.getValue() == null)) {
                    if (dismd2 == null) {
                        dismd2 = this.inheritanceMetaData.newDiscriminatorMetadata();
                    }
                    if (NucleusLogger.METADATA.isDebugEnabled()) {
                        NucleusLogger.METADATA.debug("No discriminator value specified for " + this.getFullClassName() + " so using fully-qualified class name");
                    }
                    dismd2.setValue(this.getFullClassName());
                }
            }
        }
        if (this.inheritanceMetaData != null && (dismd = this.inheritanceMetaData.getDiscriminatorMetaData()) != null && this.getDiscriminatorStrategy() == DiscriminatorStrategy.VALUE_MAP && dismd.getValue() != null) {
            this.mmgr.registerDiscriminatorValueForClass(this, dismd.getValue());
        }
    }

    protected void validateUnmappedColumns() {
        if (this.unmappedColumns != null && !this.unmappedColumns.isEmpty()) {
            for (ColumnMetaData colmd : this.unmappedColumns) {
                if (colmd.getName() == null) {
                    throw new InvalidClassMetaDataException("044119", new Object[]{this.fullName});
                }
                if (colmd.getJdbcType() != null) continue;
                throw new InvalidClassMetaDataException("044120", this.fullName, colmd.getName());
            }
        }
    }

    private AbstractClassMetaData getSuperclassManagingTable() {
        if (this.pcSuperclassMetaData != null) {
            if (this.pcSuperclassMetaData.getInheritanceMetaData().getStrategy() == InheritanceStrategy.NEW_TABLE) {
                return this.pcSuperclassMetaData;
            }
            return this.pcSuperclassMetaData.getSuperclassManagingTable();
        }
        return null;
    }

    private AbstractClassMetaData getClassManagingTable() {
        if (this.inheritanceMetaData == null) {
            return this;
        }
        if (this.inheritanceMetaData.getStrategy() == InheritanceStrategy.NEW_TABLE) {
            return this;
        }
        if (this.inheritanceMetaData.getStrategy() == InheritanceStrategy.SUPERCLASS_TABLE) {
            if (this.pcSuperclassMetaData == null) {
                return null;
            }
            return this.pcSuperclassMetaData.getClassManagingTable();
        }
        return null;
    }

    public final AbstractClassMetaData getSuperAbstractClassMetaData() {
        this.checkPopulated();
        return this.pcSuperclassMetaData;
    }

    public boolean pkIsDatastoreAttributed(StoreManager storeMgr) {
        if (this.pkIsDatastoreAttributed == null) {
            this.pkIsDatastoreAttributed = Boolean.FALSE;
            if (this.identityType == IdentityType.APPLICATION) {
                for (int i = 0; i < this.pkMemberPositions.length; ++i) {
                    if (!storeMgr.isStrategyDatastoreAttributed(this, this.pkMemberPositions[i])) continue;
                    this.pkIsDatastoreAttributed = true;
                }
            } else if (this.identityType == IdentityType.DATASTORE) {
                this.pkIsDatastoreAttributed = storeMgr.isStrategyDatastoreAttributed(this, -1);
            }
        }
        return this.pkIsDatastoreAttributed;
    }

    protected void determineObjectIdClass() {
        if (this.identityType != IdentityType.APPLICATION || this.objectidClass != null) {
            return;
        }
        int no_of_pk_fields = 0;
        AbstractMemberMetaData mmd_pk = null;
        for (AbstractMemberMetaData mmd : this.members) {
            if (!mmd.isPrimaryKey()) continue;
            mmd_pk = mmd;
            ++no_of_pk_fields;
        }
        if (no_of_pk_fields == 0 && this.inheritanceMetaData.getStrategy() == InheritanceStrategy.SUBCLASS_TABLE && this.getSuperclassManagingTable() == null) {
            NucleusLogger.METADATA.debug(Localiser.msg("044163", this.getFullClassName()));
            this.instantiable = false;
            return;
        }
        boolean needsObjectidClass = false;
        if (this.persistableSuperclass == null) {
            needsObjectidClass = true;
        } else if (this.getSuperclassManagingTable() == null) {
            needsObjectidClass = true;
        }
        if (needsObjectidClass) {
            if (no_of_pk_fields == 0) {
                NucleusLogger.METADATA.error(Localiser.msg("044065", this.fullName, "" + no_of_pk_fields));
                throw new InvalidClassMetaDataException("044065", this.fullName, "" + no_of_pk_fields);
            }
            if (no_of_pk_fields > 1) {
                NucleusLogger.METADATA.warn(Localiser.msg("044065", this.fullName, "" + no_of_pk_fields));
                if (!this.mmgr.isEnhancing()) {
                    this.objectidClass = this.fullName + GENERATED_PK_SUFFIX;
                    NucleusLogger.METADATA.debug(Localiser.msg("044164", this.fullName, "" + this.getNoOfPrimaryKeyMembers(), this.objectidClass));
                }
            } else {
                Class pk_type = mmd_pk.getType();
                if (Byte.class.isAssignableFrom(pk_type) || Byte.TYPE.isAssignableFrom(pk_type)) {
                    this.objectidClass = ClassNameConstants.IDENTITY_SINGLEFIELD_BYTE;
                } else if (Character.class.isAssignableFrom(pk_type) || Character.TYPE.isAssignableFrom(pk_type)) {
                    this.objectidClass = ClassNameConstants.IDENTITY_SINGLEFIELD_CHAR;
                } else if (Integer.class.isAssignableFrom(pk_type) || Integer.TYPE.isAssignableFrom(pk_type)) {
                    this.objectidClass = ClassNameConstants.IDENTITY_SINGLEFIELD_INT;
                } else if (Long.class.isAssignableFrom(pk_type) || Long.TYPE.isAssignableFrom(pk_type)) {
                    this.objectidClass = ClassNameConstants.IDENTITY_SINGLEFIELD_LONG;
                } else if (Short.class.isAssignableFrom(pk_type) || Short.TYPE.isAssignableFrom(pk_type)) {
                    this.objectidClass = ClassNameConstants.IDENTITY_SINGLEFIELD_SHORT;
                } else if (String.class.isAssignableFrom(pk_type)) {
                    this.objectidClass = ClassNameConstants.IDENTITY_SINGLEFIELD_STRING;
                } else if (Object.class.isAssignableFrom(pk_type)) {
                    this.objectidClass = ClassNameConstants.IDENTITY_SINGLEFIELD_OBJECT;
                } else {
                    NucleusLogger.METADATA.error(Localiser.msg("044066", this.fullName, pk_type.getName()));
                    throw new InvalidClassMetaDataException("044066", this.fullName, pk_type.getName());
                }
            }
        }
    }

    protected void validateObjectIdClass(ClassLoaderResolver clr) {
        if (this.getPersistableSuperclass() == null && this.objectidClass != null) {
            ApiAdapter api = this.mmgr.getApiAdapter();
            Class obj_cls = null;
            try {
                obj_cls = clr.classForName(this.objectidClass);
            }
            catch (ClassNotResolvedException cnre) {
                throw new InvalidClassMetaDataException("044079", this.fullName, this.objectidClass);
            }
            boolean validated = false;
            HashSet<NucleusException> errors = new HashSet<NucleusException>();
            try {
                if (api.isValidPrimaryKeyClass(obj_cls, this, clr, this.getNoOfPopulatedPKMembers(), this.mmgr)) {
                    validated = true;
                }
            }
            catch (NucleusException ex) {
                errors.add(ex);
            }
            if (!validated) {
                throw new NucleusUserException(Localiser.msg("019016", this.getFullClassName(), obj_cls.getName()), errors.toArray(new Throwable[errors.size()]));
            }
        }
    }

    public abstract void populate(ClassLoaderResolver var1, ClassLoader var2, MetaDataManager var3);

    protected void initialiseMemberPositionInformation() {
        AbstractMemberMetaData mmd;
        int i;
        this.memberCount = this.noOfInheritedManagedMembers + this.managedMembers.length;
        this.dfgMemberFlags = new boolean[this.memberCount];
        this.scoMutableMemberFlags = new boolean[this.memberCount];
        this.nonPkMemberFlags = new boolean[this.memberCount];
        int pkFieldCount = 0;
        int dfgFieldCount = 0;
        int scmFieldCount = 0;
        for (i = 0; i < this.memberCount; ++i) {
            AbstractMemberMetaData mmd2 = this.getMetaDataForManagedMemberAtAbsolutePositionInternal(i);
            if (mmd2.isPrimaryKey()) {
                ++pkFieldCount;
            } else {
                this.nonPkMemberFlags[i] = true;
            }
            if (mmd2.isDefaultFetchGroup()) {
                this.dfgMemberFlags[i] = true;
                ++dfgFieldCount;
            }
            if (!mmd2.calcIsSecondClassMutable(this.mmgr)) continue;
            this.scoMutableMemberFlags[i] = true;
            ++scmFieldCount;
        }
        if (pkFieldCount > 0 && this.identityType != IdentityType.APPLICATION) {
            throw new InvalidClassMetaDataException("044078", new Object[]{this.fullName, pkFieldCount, this.identityType});
        }
        if (pkFieldCount > 0) {
            this.pkMemberPositions = new int[pkFieldCount];
            int pk_num = 0;
            for (i = 0; i < this.memberCount; ++i) {
                mmd = this.getMetaDataForManagedMemberAtAbsolutePositionInternal(i);
                if (!mmd.isPrimaryKey()) continue;
                this.pkMemberPositions[pk_num++] = i;
            }
        } else if (this.instantiable && pkFieldCount == 0 && this.identityType == IdentityType.APPLICATION) {
            throw new InvalidClassMetaDataException("044077", this.fullName, this.objectidClass);
        }
        this.nonPkMemberPositions = new int[this.memberCount - pkFieldCount];
        int npkf = 0;
        for (i = 0; i < this.memberCount; ++i) {
            mmd = this.getMetaDataForManagedMemberAtAbsolutePositionInternal(i);
            if (mmd.isPrimaryKey()) continue;
            this.nonPkMemberPositions[npkf++] = i;
        }
        this.dfgMemberPositions = new int[dfgFieldCount];
        this.scoMutableMemberPositions = new int[scmFieldCount];
        int dfgNum = 0;
        int scmNum = 0;
        for (i = 0; i < this.memberCount; ++i) {
            if (this.dfgMemberFlags[i]) {
                this.dfgMemberPositions[dfgNum++] = i;
            }
            if (!this.scoMutableMemberFlags[i]) continue;
            this.scoMutableMemberPositions[scmNum++] = i;
        }
    }

    public final DiscriminatorMetaData getDiscriminatorMetaDataForTable() {
        DiscriminatorMetaData superDismd;
        if (this.pcSuperclassMetaData != null && (this.pcSuperclassMetaData.getInheritanceMetaData().getStrategy() == InheritanceStrategy.SUBCLASS_TABLE || this.pcSuperclassMetaData.getInheritanceMetaData().getStrategy() == InheritanceStrategy.COMPLETE_TABLE) && (superDismd = this.pcSuperclassMetaData.getDiscriminatorMetaDataForTable()) != null) {
            return superDismd;
        }
        return this.inheritanceMetaData != null ? this.inheritanceMetaData.getDiscriminatorMetaData() : null;
    }

    public final DiscriminatorStrategy getDiscriminatorStrategyForTable() {
        if (this.inheritanceMetaData == null) {
            return null;
        }
        if (this.inheritanceMetaData.getStrategy() == InheritanceStrategy.NEW_TABLE && this.inheritanceMetaData.getDiscriminatorMetaData() != null) {
            return this.inheritanceMetaData.getDiscriminatorMetaData().getStrategy();
        }
        if (this.getSuperAbstractClassMetaData() != null) {
            return this.getSuperAbstractClassMetaData().getDiscriminatorStrategy();
        }
        return null;
    }

    public final DiscriminatorMetaData getDiscriminatorMetaData() {
        if (this.inheritanceMetaData != null && this.inheritanceMetaData.getDiscriminatorMetaData() != null) {
            return this.inheritanceMetaData.getDiscriminatorMetaData();
        }
        if (this.getSuperAbstractClassMetaData() != null) {
            return this.getSuperAbstractClassMetaData().getDiscriminatorMetaData();
        }
        return null;
    }

    public final DiscriminatorMetaData getDiscriminatorMetaDataRoot() {
        DiscriminatorMetaData dismd = null;
        if (this.pcSuperclassMetaData != null) {
            dismd = this.pcSuperclassMetaData.getDiscriminatorMetaDataRoot();
        }
        if (dismd == null) {
            dismd = this.inheritanceMetaData != null ? this.inheritanceMetaData.getDiscriminatorMetaData() : null;
        }
        return dismd;
    }

    public final boolean hasDiscriminatorStrategy() {
        DiscriminatorStrategy strategy = this.getDiscriminatorStrategy();
        return strategy != null && strategy != DiscriminatorStrategy.NONE;
    }

    public final DiscriminatorStrategy getDiscriminatorStrategy() {
        if (this.inheritanceMetaData != null && this.inheritanceMetaData.getDiscriminatorMetaData() != null && this.inheritanceMetaData.getDiscriminatorMetaData().getStrategy() != null) {
            return this.inheritanceMetaData.getDiscriminatorMetaData().getStrategy();
        }
        if (this.pcSuperclassMetaData != null) {
            return this.pcSuperclassMetaData.getDiscriminatorStrategy();
        }
        return null;
    }

    public String getDiscriminatorColumnName() {
        if (this.inheritanceMetaData != null && this.inheritanceMetaData.getDiscriminatorMetaData() != null && this.inheritanceMetaData.getDiscriminatorMetaData().getColumnMetaData() != null && this.inheritanceMetaData.getDiscriminatorMetaData().getColumnMetaData().getName() != null) {
            return this.inheritanceMetaData.getDiscriminatorMetaData().getColumnMetaData().getName();
        }
        if (this.pcSuperclassMetaData != null) {
            return this.pcSuperclassMetaData.getDiscriminatorColumnName();
        }
        return null;
    }

    public ColumnMetaData getDiscriminatorColumnMetaData() {
        if (this.inheritanceMetaData != null && this.inheritanceMetaData.getDiscriminatorMetaData() != null && this.inheritanceMetaData.getDiscriminatorMetaData().getColumnMetaData() != null) {
            return this.inheritanceMetaData.getDiscriminatorMetaData().getColumnMetaData();
        }
        if (this.pcSuperclassMetaData != null) {
            return this.pcSuperclassMetaData.getDiscriminatorColumnMetaData();
        }
        return null;
    }

    public Object getDiscriminatorValue() {
        if (this.hasDiscriminatorStrategy()) {
            DiscriminatorStrategy str = this.getDiscriminatorStrategy();
            if (str == DiscriminatorStrategy.CLASS_NAME) {
                return this.getFullClassName();
            }
            if (str == DiscriminatorStrategy.ENTITY_NAME) {
                return this.getEntityName();
            }
            if (str == DiscriminatorStrategy.VALUE_MAP) {
                ColumnMetaData colmd;
                DiscriminatorMetaData dismd = this.getDiscriminatorMetaDataRoot();
                Object value = this.getInheritanceMetaData().getDiscriminatorMetaData().getValue();
                if (dismd.getColumnMetaData() != null && MetaDataUtils.isJdbcTypeNumeric((colmd = dismd.getColumnMetaData()).getJdbcType())) {
                    value = Long.parseLong((String)value);
                }
                return value;
            }
        }
        return null;
    }

    public IdentityType getIdentityType() {
        return this.identityType;
    }

    public synchronized void setIdentityType(IdentityType type) {
        this.checkNotYetPopulated();
        this.identityType = type;
    }

    public String getName() {
        return this.name;
    }

    public String getFullClassName() {
        return this.fullName;
    }

    public String getObjectidClass() {
        return this.objectidClass;
    }

    public AbstractClassMetaData setObjectIdClass(String objectidClass) {
        this.objectidClass = StringUtils.isWhitespace(objectidClass) ? this.objectidClass : objectidClass;
        return this;
    }

    public String getEntityName() {
        return this.entityName;
    }

    public AbstractClassMetaData setEntityName(String name) {
        this.entityName = StringUtils.isWhitespace(name) ? this.entityName : name;
        return this;
    }

    public String getCatalog() {
        if (this.catalog == null) {
            return ((PackageMetaData)this.parent).getCatalog();
        }
        return this.catalog;
    }

    public AbstractClassMetaData setCatalog(String catalog) {
        this.catalog = StringUtils.isWhitespace(catalog) ? this.catalog : catalog;
        return this;
    }

    public String getSchema() {
        if (this.schema == null) {
            return ((PackageMetaData)this.parent).getSchema();
        }
        return this.schema;
    }

    public AbstractClassMetaData setSchema(String schema) {
        this.schema = StringUtils.isWhitespace(schema) ? this.schema : schema;
        return this;
    }

    public String getTable() {
        return this.table;
    }

    public AbstractClassMetaData setTable(String table) {
        this.table = StringUtils.isWhitespace(table) ? this.table : table;
        return this;
    }

    public boolean isRequiresExtent() {
        return this.requiresExtent;
    }

    public AbstractClassMetaData setRequiresExtent(boolean flag) {
        this.requiresExtent = flag;
        return this;
    }

    public AbstractClassMetaData setRequiresExtent(String flag) {
        if (!StringUtils.isWhitespace(flag)) {
            this.requiresExtent = Boolean.parseBoolean(flag);
        }
        return this;
    }

    public boolean isDetachable() {
        return this.detachable;
    }

    public AbstractClassMetaData setDetachable(boolean flag) {
        this.detachable = flag;
        return this;
    }

    public AbstractClassMetaData setDetachable(String flag) {
        if (!StringUtils.isWhitespace(flag)) {
            this.detachable = Boolean.parseBoolean(flag);
        }
        return this;
    }

    public Boolean isCacheable() {
        return this.cacheable;
    }

    public AbstractClassMetaData setCacheable(boolean cache) {
        this.cacheable = cache;
        return this;
    }

    public AbstractClassMetaData setCacheable(String cache) {
        if (!StringUtils.isWhitespace(cache)) {
            this.cacheable = Boolean.parseBoolean(cache);
        }
        return this;
    }

    public boolean isEmbeddedOnly() {
        return this.embeddedOnly;
    }

    public AbstractClassMetaData setEmbeddedOnly(boolean flag) {
        this.embeddedOnly = flag;
        return this;
    }

    public AbstractClassMetaData setEmbeddedOnly(String flag) {
        if (!StringUtils.isWhitespace(flag)) {
            this.embeddedOnly = Boolean.parseBoolean(flag);
        }
        return this;
    }

    public PackageMetaData getPackageMetaData() {
        if (this.parent != null) {
            return (PackageMetaData)this.parent;
        }
        return null;
    }

    public String getPackageName() {
        return this.getPackageMetaData().getName();
    }

    public ClassPersistenceModifier getPersistenceModifier() {
        return this.persistenceModifier;
    }

    public AbstractClassMetaData setPersistenceModifier(ClassPersistenceModifier modifier) {
        this.persistenceModifier = modifier;
        return this;
    }

    public String getPersistableSuperclass() {
        return this.persistableSuperclass;
    }

    public boolean usesSingleFieldIdentityClass() {
        return this.usesSingleFieldIdentityClass;
    }

    public boolean isSameOrAncestorOf(AbstractClassMetaData cmd) {
        this.checkInitialised();
        if (cmd == null) {
            return false;
        }
        if (this.fullName.equals(cmd.fullName)) {
            return true;
        }
        for (AbstractClassMetaData parent = cmd.getSuperAbstractClassMetaData(); parent != null; parent = parent.getSuperAbstractClassMetaData()) {
            if (!this.fullName.equals(parent.fullName)) continue;
            return true;
        }
        return false;
    }

    public String[] getPrimaryKeyMemberNames() {
        if (this.identityType != IdentityType.APPLICATION) {
            return null;
        }
        ArrayList<String> memberNames = new ArrayList<String>();
        for (AbstractMemberMetaData mmd : this.members) {
            if (!Boolean.TRUE.equals(mmd.primaryKey)) continue;
            memberNames.add(mmd.name);
        }
        if (!memberNames.isEmpty()) {
            return memberNames.toArray(new String[memberNames.size()]);
        }
        memberNames = null;
        return this.pcSuperclassMetaData.getPrimaryKeyMemberNames();
    }

    public boolean hasMember(String memberName) {
        for (AbstractMemberMetaData mmd : this.members) {
            if (!mmd.getName().equals(memberName)) continue;
            return true;
        }
        if (this.pcSuperclassMetaData != null) {
            return this.pcSuperclassMetaData.hasMember(memberName);
        }
        return false;
    }

    public int getNoOfMembers() {
        return this.members.size();
    }

    public AbstractMemberMetaData getMetaDataForMember(String name) {
        if (name == null) {
            return null;
        }
        for (AbstractMemberMetaData mmd : this.members) {
            if (!mmd.getName().equals(name)) continue;
            return mmd;
        }
        if (this.pcSuperclassMetaData != null) {
            return this.pcSuperclassMetaData.getMetaDataForMember(name);
        }
        return null;
    }

    public int getNoOfManagedMembers() {
        if (this.managedMembers == null) {
            return 0;
        }
        return this.managedMembers.length;
    }

    public AbstractMemberMetaData[] getManagedMembers() {
        this.checkInitialised();
        return this.managedMembers;
    }

    public AbstractMemberMetaData[] getOverriddenMembers() {
        this.checkInitialised();
        return this.overriddenMembers;
    }

    public AbstractMemberMetaData getOverriddenMember(String name) {
        this.checkInitialised();
        if (this.overriddenMembers == null) {
            return null;
        }
        for (int i = 0; i < this.overriddenMembers.length; ++i) {
            if (!this.overriddenMembers[i].getName().equals(name)) continue;
            return this.overriddenMembers[i];
        }
        return null;
    }

    protected AbstractMemberMetaData getMemberBeingOverridden(String name) {
        for (AbstractMemberMetaData mmd : this.members) {
            if (!mmd.name.equals(name) || !mmd.fieldBelongsToClass()) continue;
            return mmd;
        }
        if (this.pcSuperclassMetaData != null) {
            return this.pcSuperclassMetaData.getMemberBeingOverridden(name);
        }
        return null;
    }

    public int getNoOfInheritedManagedMembers() {
        this.checkInitialised();
        return this.noOfInheritedManagedMembers;
    }

    public int getMemberCount() {
        return this.memberCount;
    }

    public AbstractMemberMetaData getMetaDataForMemberAtRelativePosition(int index) {
        if (index < 0 || index >= this.members.size()) {
            return null;
        }
        return this.members.get(index);
    }

    public AbstractMemberMetaData getMetaDataForManagedMemberAtRelativePosition(int position) {
        this.checkInitialised();
        if (this.managedMembers == null) {
            return null;
        }
        if (position < 0 || position >= this.managedMembers.length) {
            return null;
        }
        return this.managedMembers[position];
    }

    public AbstractMemberMetaData getMetaDataForManagedMemberAtAbsolutePosition(int position) {
        this.checkInitialised();
        return this.getMetaDataForManagedMemberAtAbsolutePositionInternal(position);
    }

    protected AbstractMemberMetaData getMetaDataForManagedMemberAtAbsolutePositionInternal(int abs_position) {
        if (abs_position < this.noOfInheritedManagedMembers) {
            if (this.pcSuperclassMetaData == null) {
                return null;
            }
            AbstractMemberMetaData mmd = this.pcSuperclassMetaData.getMetaDataForManagedMemberAtAbsolutePositionInternal(abs_position);
            if (mmd != null) {
                for (int i = 0; i < this.overriddenMembers.length; ++i) {
                    if (!this.overriddenMembers[i].getName().equals(mmd.getName()) || !this.overriddenMembers[i].getClassName().equals(mmd.getClassName())) continue;
                    return this.overriddenMembers[i];
                }
                return mmd;
            }
            return null;
        }
        if (abs_position - this.noOfInheritedManagedMembers >= this.managedMembers.length) {
            return null;
        }
        return this.managedMembers[abs_position - this.noOfInheritedManagedMembers];
    }

    public int getRelativePositionOfMember(String memberName) {
        this.checkInitialised();
        if (memberName == null) {
            return -1;
        }
        Integer i = this.memberPositionsByName.get(memberName);
        return i == null ? -1 : i;
    }

    public int getAbsolutePositionOfMember(String memberName) {
        this.checkInitialised();
        if (memberName == null) {
            return -1;
        }
        int i = this.getRelativePositionOfMember(memberName);
        if (i < 0) {
            if (this.pcSuperclassMetaData != null) {
                i = this.pcSuperclassMetaData.getAbsolutePositionOfMember(memberName);
            }
        } else {
            i += this.noOfInheritedManagedMembers;
        }
        return i;
    }

    private int getNoOfPopulatedPKMembers() {
        if (this.pcSuperclassMetaData != null) {
            return this.pcSuperclassMetaData.getNoOfPopulatedPKMembers();
        }
        Iterator<AbstractMemberMetaData> fields_iter = this.members.iterator();
        int noOfPks = 0;
        while (fields_iter.hasNext()) {
            AbstractMemberMetaData mmd = fields_iter.next();
            if (!mmd.isPrimaryKey()) continue;
            ++noOfPks;
        }
        return noOfPks;
    }

    public int getNoOfPrimaryKeyMembers() {
        if (this.pkMemberPositions == null) {
            return 0;
        }
        return this.pkMemberPositions.length;
    }

    public int[] getAllMemberPositions() {
        this.checkInitialised();
        if (this.allMemberPositions == null) {
            this.allMemberPositions = new int[this.memberCount];
            for (int i = 0; i < this.memberCount; ++i) {
                this.allMemberPositions[i] = i;
            }
        }
        return this.allMemberPositions;
    }

    public int[] getPKMemberPositions() {
        this.checkInitialised();
        return this.pkMemberPositions;
    }

    public int[] getNonPKMemberPositions() {
        this.checkInitialised();
        return this.nonPkMemberPositions;
    }

    public boolean[] getNonPKMemberFlags() {
        this.checkInitialised();
        return this.nonPkMemberFlags;
    }

    public int[] getDFGMemberPositions() {
        this.checkInitialised();
        return this.dfgMemberPositions;
    }

    public boolean[] getDFGMemberFlags() {
        this.checkInitialised();
        return this.dfgMemberFlags;
    }

    public int[] getBasicMemberPositions(ClassLoaderResolver clr) {
        Iterator<AbstractMemberMetaData> iter = this.members.iterator();
        int numBasics = 0;
        while (iter.hasNext()) {
            AbstractMemberMetaData mmd = iter.next();
            if (mmd.getRelationType(clr) != RelationType.NONE || mmd.isPersistentInterface(clr) || Collection.class.isAssignableFrom(mmd.getType()) || Map.class.isAssignableFrom(mmd.getType()) || mmd.getType().isArray()) continue;
            ++numBasics;
        }
        int[] inheritedBasicPositions = null;
        if (this.pcSuperclassMetaData != null) {
            inheritedBasicPositions = this.pcSuperclassMetaData.getBasicMemberPositions(clr);
        }
        int[] basicPositions = new int[numBasics + (inheritedBasicPositions != null ? inheritedBasicPositions.length : 0)];
        int number = 0;
        if (inheritedBasicPositions != null) {
            for (int i = 0; i < inheritedBasicPositions.length; ++i) {
                basicPositions[number++] = inheritedBasicPositions[i];
            }
        }
        for (AbstractMemberMetaData mmd : this.members) {
            if (mmd.getRelationType(clr) != RelationType.NONE || mmd.isPersistentInterface(clr) || Collection.class.isAssignableFrom(mmd.getType()) || Map.class.isAssignableFrom(mmd.getType()) || mmd.getType().isArray()) continue;
            basicPositions[number++] = mmd.getAbsoluteFieldNumber();
        }
        return basicPositions;
    }

    public int[] getMultivaluedMemberPositions() {
        Iterator<AbstractMemberMetaData> iter = this.members.iterator();
        int numMultivalues = 0;
        while (iter.hasNext()) {
            AbstractMemberMetaData mmd = iter.next();
            if (!mmd.getType().isArray() && !Collection.class.isAssignableFrom(mmd.getType()) && !Map.class.isAssignableFrom(mmd.getType())) continue;
            ++numMultivalues;
        }
        int[] inheritedMultivaluePositions = null;
        if (this.pcSuperclassMetaData != null) {
            inheritedMultivaluePositions = this.pcSuperclassMetaData.getMultivaluedMemberPositions();
        }
        int[] multivaluePositions = new int[numMultivalues + (inheritedMultivaluePositions != null ? inheritedMultivaluePositions.length : 0)];
        int number = 0;
        if (inheritedMultivaluePositions != null) {
            for (int i = 0; i < inheritedMultivaluePositions.length; ++i) {
                multivaluePositions[number++] = inheritedMultivaluePositions[i];
            }
        }
        for (AbstractMemberMetaData mmd : this.members) {
            if (!mmd.getType().isArray() && !Collection.class.isAssignableFrom(mmd.getType()) && !Map.class.isAssignableFrom(mmd.getType())) continue;
            multivaluePositions[number++] = mmd.getAbsoluteFieldNumber();
        }
        return multivaluePositions;
    }

    public int[] getSCOMutableMemberPositions() {
        this.checkInitialised();
        return this.scoMutableMemberPositions;
    }

    public int[] getSCONonContainerMemberPositions() {
        this.checkInitialised();
        if (this.scoNonContainerMemberPositions == null) {
            int numberNonContainerSCOFields = 0;
            for (int i = 0; i < this.scoMutableMemberPositions.length; ++i) {
                AbstractMemberMetaData mmd = this.getMetaDataForManagedMemberAtAbsolutePosition(this.scoMutableMemberPositions[i]);
                if (Collection.class.isAssignableFrom(mmd.getType()) || Map.class.isAssignableFrom(mmd.getType())) continue;
                ++numberNonContainerSCOFields;
            }
            int[] noncontainerMemberPositions = new int[numberNonContainerSCOFields];
            int nonContNum = 0;
            for (int i = 0; i < this.scoMutableMemberPositions.length; ++i) {
                AbstractMemberMetaData mmd = this.getMetaDataForManagedMemberAtAbsolutePosition(this.scoMutableMemberPositions[i]);
                if (Collection.class.isAssignableFrom(mmd.getType()) || Map.class.isAssignableFrom(mmd.getType())) continue;
                noncontainerMemberPositions[nonContNum++] = this.scoMutableMemberPositions[i];
            }
            this.scoNonContainerMemberPositions = noncontainerMemberPositions;
        }
        return this.scoNonContainerMemberPositions;
    }

    public int[] getSCOContainerMemberPositions() {
        this.checkInitialised();
        if (this.secondClassContainerMemberPositions == null) {
            int numberContainerSCOFields = 0;
            for (int i = 0; i < this.scoMutableMemberPositions.length; ++i) {
                AbstractMemberMetaData mmd = this.getMetaDataForManagedMemberAtAbsolutePosition(this.scoMutableMemberPositions[i]);
                if (!Collection.class.isAssignableFrom(mmd.getType()) && !Map.class.isAssignableFrom(mmd.getType())) continue;
                ++numberContainerSCOFields;
            }
            int[] containerMemberPositions = new int[numberContainerSCOFields];
            int contNum = 0;
            for (int i = 0; i < this.scoMutableMemberPositions.length; ++i) {
                AbstractMemberMetaData mmd = this.getMetaDataForManagedMemberAtAbsolutePosition(this.scoMutableMemberPositions[i]);
                if (!Collection.class.isAssignableFrom(mmd.getType()) && !Map.class.isAssignableFrom(mmd.getType())) continue;
                containerMemberPositions[contNum++] = this.scoMutableMemberPositions[i];
            }
            this.secondClassContainerMemberPositions = containerMemberPositions;
        }
        return this.secondClassContainerMemberPositions;
    }

    public boolean[] getSCOMutableMemberFlags() {
        this.checkInitialised();
        return this.scoMutableMemberFlags;
    }

    public boolean hasRelations(ClassLoaderResolver clr) {
        if (this.hasRelations == null) {
            this.hasRelations = this.getRelationMemberPositions(clr).length > 0;
        }
        return this.hasRelations;
    }

    public int[] getNonRelationMemberPositions(ClassLoaderResolver clr) {
        int[] relPositions = this.getRelationMemberPositions(clr);
        if (relPositions == null || relPositions.length == 0) {
            return this.getAllMemberPositions();
        }
        int[] allPositions = this.getAllMemberPositions();
        int[] nonrelPositions = new int[allPositions.length - relPositions.length];
        int nonrelPos = 0;
        int nextRelPos = 0;
        for (int i = 0; i < allPositions.length; ++i) {
            if (nextRelPos == relPositions.length) {
                nonrelPositions[nonrelPos++] = i;
                continue;
            }
            if (allPositions[i] == relPositions[nextRelPos]) {
                ++nextRelPos;
                continue;
            }
            nonrelPositions[nonrelPos++] = i;
        }
        return nonrelPositions;
    }

    public int[] getRelationMemberPositions(ClassLoaderResolver clr) {
        if (this.relationPositions == null) {
            int i;
            int numRelationsSuperclass;
            int[] superclassRelationPositions = null;
            if (this.pcSuperclassMetaData != null) {
                superclassRelationPositions = this.pcSuperclassMetaData.getRelationMemberPositions(clr);
            }
            int numRelations = numRelationsSuperclass = superclassRelationPositions != null ? superclassRelationPositions.length : 0;
            for (int i2 = 0; i2 < this.managedMembers.length; ++i2) {
                if (this.managedMembers[i2].getRelationType(clr) == RelationType.NONE && !this.managedMembers[i2].isPersistentInterface(clr)) continue;
                ++numRelations;
            }
            this.relationPositions = new int[numRelations];
            int num = 0;
            if (numRelationsSuperclass > 0) {
                for (i = 0; i < superclassRelationPositions.length; ++i) {
                    this.relationPositions[num++] = superclassRelationPositions[i];
                }
            }
            if (numRelations > numRelationsSuperclass) {
                for (i = 0; i < this.managedMembers.length; ++i) {
                    if (this.managedMembers[i].getRelationType(clr) == RelationType.NONE && !this.managedMembers[i].isPersistentInterface(clr)) continue;
                    this.relationPositions[num++] = this.managedMembers[i].getAbsoluteFieldNumber();
                }
            }
        }
        return this.relationPositions;
    }

    public int[] getBidirectionalRelationMemberPositions(ClassLoaderResolver clr) {
        if (this.relationPositions == null) {
            this.getRelationMemberPositions(clr);
        }
        int numBidirs = 0;
        for (int i = 0; i < this.relationPositions.length; ++i) {
            AbstractMemberMetaData mmd = this.getMetaDataForManagedMemberAtAbsolutePosition(this.relationPositions[i]);
            RelationType relationType = mmd.getRelationType(clr);
            if (!RelationType.isBidirectional(relationType)) continue;
            ++numBidirs;
        }
        int[] bidirRelations = new int[numBidirs];
        numBidirs = 0;
        for (int i = 0; i < this.relationPositions.length; ++i) {
            AbstractMemberMetaData mmd = this.getMetaDataForManagedMemberAtAbsolutePosition(this.relationPositions[i]);
            RelationType relationType = mmd.getRelationType(clr);
            if (!RelationType.isBidirectional(relationType)) continue;
            bidirRelations[numBidirs] = mmd.getAbsoluteFieldNumber();
        }
        return bidirRelations;
    }

    public void setAccessViaField(boolean flag) {
        this.accessViaField = flag;
    }

    public Boolean getAccessViaField() {
        return this.accessViaField;
    }

    public void setMappedSuperclass(boolean mapped) {
        this.mappedSuperclass = mapped;
    }

    public boolean isMappedSuperclass() {
        return this.mappedSuperclass;
    }

    public void setSerializeRead(boolean serialise) {
        this.serializeRead = serialise;
    }

    public boolean isSerializeRead() {
        return this.serializeRead;
    }

    public void setMetaDataComplete() {
        this.metaDataComplete = true;
    }

    public boolean isMetaDataComplete() {
        return this.metaDataComplete;
    }

    public void addQuery(QueryMetaData qmd) {
        if (qmd == null) {
            return;
        }
        if (this.queries == null) {
            this.queries = new HashSet<QueryMetaData>();
        }
        this.queries.add(qmd);
        qmd.parent = this;
    }

    public int getNoOfQueries() {
        return this.queries.size();
    }

    public QueryMetaData[] getQueries() {
        return this.queries == null ? null : this.queries.toArray(new QueryMetaData[this.queries.size()]);
    }

    public QueryMetaData newQueryMetadata(String queryName) {
        if (StringUtils.isWhitespace(queryName)) {
            throw new InvalidClassMetaDataException("044154", new Object[]{this.fullName});
        }
        QueryMetaData qmd = new QueryMetaData(queryName);
        this.addQuery(qmd);
        return qmd;
    }

    public void addStoredProcQuery(StoredProcQueryMetaData qmd) {
        if (qmd == null) {
            return;
        }
        if (this.storedProcQueries == null) {
            this.storedProcQueries = new HashSet<StoredProcQueryMetaData>();
        }
        this.storedProcQueries.add(qmd);
        qmd.parent = this;
    }

    public int getNoOfStoredProcQueries() {
        return this.storedProcQueries.size();
    }

    public StoredProcQueryMetaData[] getStoredProcQueries() {
        return this.storedProcQueries == null ? null : this.storedProcQueries.toArray(new StoredProcQueryMetaData[this.storedProcQueries.size()]);
    }

    public StoredProcQueryMetaData newStoredProcQueryMetadata(String queryName) {
        if (StringUtils.isWhitespace(queryName)) {
            throw new InvalidClassMetaDataException("044154", new Object[]{this.fullName});
        }
        StoredProcQueryMetaData qmd = new StoredProcQueryMetaData(queryName);
        this.addStoredProcQuery(qmd);
        return qmd;
    }

    public void addQueryResultMetaData(QueryResultMetaData resultMetaData) {
        if (this.queryResultMetaData == null) {
            this.queryResultMetaData = new HashSet<QueryResultMetaData>();
        }
        if (!this.queryResultMetaData.contains(resultMetaData)) {
            this.queryResultMetaData.add(resultMetaData);
            resultMetaData.parent = this;
        }
    }

    public QueryResultMetaData[] getQueryResultMetaData() {
        if (this.queryResultMetaData == null) {
            return null;
        }
        return this.queryResultMetaData.toArray(new QueryResultMetaData[this.queryResultMetaData.size()]);
    }

    public void addIndex(IndexMetaData idxmd) {
        if (idxmd == null) {
            return;
        }
        if (this.isInitialised()) {
            throw new NucleusUserException("Already initialised");
        }
        if (this.indexes == null) {
            this.indexes = new ArrayList<IndexMetaData>();
        }
        this.indexes.add(idxmd);
        idxmd.parent = this;
    }

    public final List<IndexMetaData> getIndexMetaData() {
        return this.indexes;
    }

    public IndexMetaData newIndexMetadata() {
        IndexMetaData idxmd = new IndexMetaData();
        this.addIndex(idxmd);
        return idxmd;
    }

    public void addForeignKey(ForeignKeyMetaData fkmd) {
        if (fkmd == null) {
            return;
        }
        if (this.isInitialised()) {
            throw new NucleusUserException("Already initialised");
        }
        if (this.foreignKeys == null) {
            this.foreignKeys = new ArrayList<ForeignKeyMetaData>();
        }
        this.foreignKeys.add(fkmd);
        fkmd.parent = this;
    }

    public final List<ForeignKeyMetaData> getForeignKeyMetaData() {
        return this.foreignKeys;
    }

    public ForeignKeyMetaData newForeignKeyMetadata() {
        ForeignKeyMetaData fkmd = new ForeignKeyMetaData();
        this.addForeignKey(fkmd);
        return fkmd;
    }

    public void addUniqueConstraint(UniqueMetaData unimd) {
        if (unimd == null) {
            return;
        }
        if (this.isInitialised()) {
            throw new NucleusUserException("Already initialised");
        }
        if (this.uniqueConstraints == null) {
            this.uniqueConstraints = new ArrayList<UniqueMetaData>();
        }
        this.uniqueConstraints.add(unimd);
        unimd.parent = this;
    }

    public final List<UniqueMetaData> getUniqueMetaData() {
        return this.uniqueConstraints;
    }

    public UniqueMetaData newUniqueMetadata() {
        UniqueMetaData unimd = new UniqueMetaData();
        this.addUniqueConstraint(unimd);
        return unimd;
    }

    public final void addUnmappedColumn(ColumnMetaData colmd) {
        if (this.unmappedColumns == null) {
            this.unmappedColumns = new ArrayList<ColumnMetaData>();
        }
        this.unmappedColumns.add(colmd);
        colmd.parent = this;
    }

    public final List<ColumnMetaData> getUnmappedColumns() {
        return this.unmappedColumns;
    }

    public ColumnMetaData newUnmappedColumnMetaData() {
        ColumnMetaData colmd = new ColumnMetaData();
        this.addUnmappedColumn(colmd);
        return colmd;
    }

    public FieldMetaData newFieldMetadata(String fieldName) {
        FieldMetaData fmd = new FieldMetaData((MetaData)this, fieldName);
        this.addMember(fmd);
        return fmd;
    }

    public PropertyMetaData newPropertyMetadata(String propName) {
        PropertyMetaData pmd = new PropertyMetaData((MetaData)this, propName);
        this.addMember(pmd);
        return pmd;
    }

    public void addMember(AbstractMemberMetaData mmd) {
        if (mmd == null) {
            return;
        }
        if (this.isInitialised()) {
            throw new NucleusUserException("adding field/property " + mmd.getName() + " when already initialised!");
        }
        Iterator<AbstractMemberMetaData> iter = this.members.iterator();
        while (iter.hasNext()) {
            AbstractMemberMetaData md = iter.next();
            if (mmd.getName().equals(md.getName()) && (mmd instanceof PropertyMetaData && md instanceof PropertyMetaData || mmd instanceof FieldMetaData && md instanceof FieldMetaData)) {
                throw new NucleusUserException(Localiser.msg("044090", this.fullName, mmd.getName()));
            }
            String existingName = md.getName();
            boolean existingIsProperty = md instanceof PropertyMetaData;
            if (existingIsProperty && (existingName = ((PropertyMetaData)md).getFieldName()) == null) {
                existingName = md.getName();
            }
            String newName = mmd.getName();
            boolean newIsProperty = mmd instanceof PropertyMetaData;
            if (newIsProperty && (newName = ((PropertyMetaData)mmd).getFieldName()) == null) {
                newName = mmd.getName();
            }
            if (!existingName.equals(newName)) continue;
            if (existingIsProperty && newIsProperty) {
                throw new NucleusUserException(Localiser.msg("044090", this.fullName, mmd.getName()));
            }
            if (existingIsProperty && !newIsProperty) {
                NucleusLogger.METADATA.debug("Ignoring metadata for field " + mmd.getFullFieldName() + " since we already have MetaData for the property " + md.getFullFieldName());
                return;
            }
            if (existingIsProperty || !newIsProperty) continue;
            NucleusLogger.METADATA.debug("Ignoring existing metadata for field " + md.getFullFieldName() + " since now we have MetaData for the property " + mmd.getFullFieldName());
            iter.remove();
        }
        mmd.parent = this;
        this.members.add(mmd);
    }

    public void addFetchGroup(FetchGroupMetaData fgmd) {
        if (fgmd == null) {
            return;
        }
        if (this.isInitialised()) {
            throw new NucleusUserException("Already initialised");
        }
        if (this.fetchGroups == null) {
            this.fetchGroups = new HashSet<FetchGroupMetaData>();
        }
        this.fetchGroups.add(fgmd);
        fgmd.parent = this;
    }

    public FetchGroupMetaData newFetchGroupMetaData(String name) {
        FetchGroupMetaData fgmd = new FetchGroupMetaData(name);
        this.addFetchGroup(fgmd);
        return fgmd;
    }

    public Set<FetchGroupMetaData> getFetchGroupMetaData(Collection groupNames) {
        HashSet<FetchGroupMetaData> results = new HashSet<FetchGroupMetaData>();
        for (String groupname : groupNames) {
            FetchGroupMetaData fgmd = this.getFetchGroupMetaData(groupname);
            if (fgmd == null) continue;
            results.add(fgmd);
        }
        return results;
    }

    public FetchGroupMetaData getFetchGroupMetaData(String groupname) {
        FetchGroupMetaData fgmd;
        FetchGroupMetaData fetchGroupMetaData = fgmd = this.fetchGroupMetaDataByName != null ? this.fetchGroupMetaDataByName.get(groupname) : null;
        if (fgmd == null && this.pcSuperclassMetaData != null) {
            return this.pcSuperclassMetaData.getFetchGroupMetaData(groupname);
        }
        return fgmd;
    }

    public final Set<FetchGroupMetaData> getFetchGroupMetaData() {
        return this.fetchGroups;
    }

    public final boolean hasFetchGroupWithPostLoad() {
        if (this.fetchGroupMetaWithPostLoad == null) {
            this.fetchGroupMetaWithPostLoad = Boolean.FALSE;
            if (this.fetchGroups != null) {
                for (FetchGroupMetaData fgmd : this.fetchGroups) {
                    if (!fgmd.getPostLoad().booleanValue()) continue;
                    this.fetchGroupMetaWithPostLoad = Boolean.TRUE;
                    break;
                }
            }
        }
        if (this.getSuperAbstractClassMetaData() != null) {
            return this.getSuperAbstractClassMetaData().hasFetchGroupWithPostLoad() || this.fetchGroupMetaWithPostLoad != false;
        }
        return this.fetchGroupMetaWithPostLoad;
    }

    public void addJoin(JoinMetaData jnmd) {
        if (jnmd == null) {
            return;
        }
        if (this.isInitialised()) {
            throw new NucleusUserException("Already initialised");
        }
        if (this.joins == null) {
            this.joins = new ArrayList<JoinMetaData>();
        }
        this.joins.add(jnmd);
        jnmd.parent = this;
    }

    public final List<JoinMetaData> getJoinMetaData() {
        return this.joins;
    }

    public JoinMetaData newJoinMetaData() {
        JoinMetaData joinmd = new JoinMetaData();
        this.addJoin(joinmd);
        return joinmd;
    }

    public void addListener(EventListenerMetaData listener) {
        if (this.listeners == null) {
            this.listeners = new ArrayList<EventListenerMetaData>();
        }
        if (!this.listeners.contains(listener)) {
            this.listeners.add(listener);
            listener.parent = this;
        }
    }

    public EventListenerMetaData getListenerForClass(String className) {
        if (this.listeners == null) {
            return null;
        }
        for (int i = 0; i < this.listeners.size(); ++i) {
            EventListenerMetaData elmd = this.listeners.get(i);
            if (!elmd.getClassName().equals(className)) continue;
            return elmd;
        }
        return null;
    }

    public List getListeners() {
        return this.listeners;
    }

    public void excludeSuperClassListeners() {
        this.excludeSuperClassListeners = Boolean.TRUE;
    }

    public boolean isExcludeSuperClassListeners() {
        return this.excludeSuperClassListeners != null && Boolean.TRUE.equals(this.excludeSuperClassListeners);
    }

    public void excludeDefaultListeners() {
        this.excludeDefaultListeners = Boolean.TRUE;
    }

    public boolean isExcludeDefaultListeners() {
        return this.excludeDefaultListeners != null && Boolean.TRUE.equals(this.excludeDefaultListeners);
    }

    public final void setVersionMetaData(VersionMetaData versionMetaData) {
        this.versionMetaData = versionMetaData;
        if (this.versionMetaData != null) {
            this.versionMetaData.parent = this;
        }
    }

    public final VersionMetaData getVersionMetaData() {
        return this.versionMetaData;
    }

    public final VersionMetaData getVersionMetaDataForClass() {
        if (this.versionMetaData != null) {
            return this.versionMetaData;
        }
        if (this.getSuperAbstractClassMetaData() != null) {
            return this.getSuperAbstractClassMetaData().getVersionMetaDataForClass();
        }
        return null;
    }

    public final boolean isVersioned() {
        VersionMetaData vermd = this.getVersionMetaDataForClass();
        return vermd != null && vermd.getVersionStrategy() != null && vermd.getVersionStrategy() != VersionStrategy.NONE;
    }

    public final VersionMetaData getVersionMetaDataForTable() {
        if (this.pcSuperclassMetaData != null) {
            VersionMetaData vermd;
            if (this.getInheritanceMetaData().getStrategy() == InheritanceStrategy.SUPERCLASS_TABLE && this.pcSuperclassMetaData.getInheritanceMetaData().getStrategy() == InheritanceStrategy.NEW_TABLE && (vermd = this.pcSuperclassMetaData.getVersionMetaDataForTable()) != null) {
                return vermd;
            }
            if (this.getInheritanceMetaData().getStrategy() == InheritanceStrategy.NEW_TABLE && this.pcSuperclassMetaData.getInheritanceMetaData().getStrategy() == InheritanceStrategy.SUBCLASS_TABLE && (vermd = this.pcSuperclassMetaData.getVersionMetaDataForTable()) != null) {
                return vermd;
            }
            if (this.getInheritanceMetaData().getStrategy() == InheritanceStrategy.COMPLETE_TABLE && (vermd = this.pcSuperclassMetaData.getVersionMetaDataForTable()) != null) {
                return vermd;
            }
        }
        return this.versionMetaData;
    }

    public VersionMetaData newVersionMetadata() {
        VersionMetaData vermd = new VersionMetaData();
        this.setVersionMetaData(vermd);
        return vermd;
    }

    public final void setIdentityMetaData(IdentityMetaData identityMetaData) {
        this.identityMetaData = identityMetaData;
        if (this.identityMetaData != null) {
            this.identityMetaData.parent = this;
        }
        this.identitySpecified = true;
    }

    public final IdentityMetaData getIdentityMetaData() {
        return this.identityMetaData;
    }

    public final IdentityMetaData getBaseIdentityMetaData() {
        if (this.pcSuperclassMetaData != null) {
            return this.pcSuperclassMetaData.getBaseIdentityMetaData();
        }
        return this.identityMetaData;
    }

    public IdentityMetaData newIdentityMetadata() {
        IdentityMetaData idmd = new IdentityMetaData();
        this.setIdentityMetaData(idmd);
        return idmd;
    }

    public final void setInheritanceMetaData(InheritanceMetaData inheritanceMetaData) {
        this.inheritanceMetaData = inheritanceMetaData;
        if (this.inheritanceMetaData != null) {
            this.inheritanceMetaData.parent = this;
        }
    }

    public final InheritanceMetaData getInheritanceMetaData() {
        return this.inheritanceMetaData;
    }

    public InheritanceMetaData newInheritanceMetadata() {
        InheritanceMetaData inhmd = new InheritanceMetaData();
        this.setInheritanceMetaData(inhmd);
        return inhmd;
    }

    public final void setPrimaryKeyMetaData(PrimaryKeyMetaData primaryKeyMetaData) {
        this.primaryKeyMetaData = primaryKeyMetaData;
        if (this.primaryKeyMetaData != null) {
            this.primaryKeyMetaData.parent = this;
        }
    }

    public final PrimaryKeyMetaData getPrimaryKeyMetaData() {
        return this.primaryKeyMetaData;
    }

    public PrimaryKeyMetaData newPrimaryKeyMetadata() {
        PrimaryKeyMetaData pkmd = new PrimaryKeyMetaData();
        this.setPrimaryKeyMetaData(pkmd);
        return pkmd;
    }

    void getReferencedClassMetaData(List<AbstractClassMetaData> orderedCmds, Set<AbstractClassMetaData> referencedCmds, ClassLoaderResolver clr) {
        HashMap<String, Set<String>> viewReferences = new HashMap<String, Set<String>>();
        this.getReferencedClassMetaData(orderedCmds, referencedCmds, viewReferences, clr);
    }

    private void getReferencedClassMetaData(final List<AbstractClassMetaData> orderedCmds, final Set<AbstractClassMetaData> referencedCmds, final Map<String, Set<String>> viewReferences, final ClassLoaderResolver clr) {
        if (!referencedCmds.contains(this)) {
            String viewDefStr;
            AbstractClassMetaData idCmd;
            referencedCmds.add(this);
            for (int i = 0; i < this.managedMembers.length; ++i) {
                this.managedMembers[i].getReferencedClassMetaData(orderedCmds, referencedCmds, clr);
            }
            if (this.persistableSuperclass != null) {
                this.getSuperAbstractClassMetaData().getReferencedClassMetaData(orderedCmds, referencedCmds, clr);
            }
            if (this.objectidClass != null && !this.usesSingleFieldIdentityClass() && (idCmd = this.mmgr.getMetaDataForClass(this.objectidClass, clr)) != null) {
                idCmd.getReferencedClassMetaData(orderedCmds, referencedCmds, clr);
            }
            if ((viewDefStr = this.getValueForExtension("view-definition")) != null) {
                MacroString viewDef = new MacroString(this.fullName, this.getValueForExtension("view-imports"), viewDefStr);
                viewDef.substituteMacros(new MacroString.MacroHandler(){

                    @Override
                    public void onIdentifierMacro(MacroString.IdentifierMacro im) {
                        if (!AbstractClassMetaData.this.getFullClassName().equals(im.className)) {
                            AbstractClassMetaData.this.addViewReference(viewReferences, im.className);
                            AbstractClassMetaData viewCmd = AbstractClassMetaData.this.mmgr.getMetaDataForClass(im.className, clr);
                            viewCmd.getReferencedClassMetaData(orderedCmds, referencedCmds, viewReferences, clr);
                        }
                    }

                    @Override
                    public void onParameterMacro(MacroString.ParameterMacro pm) {
                        throw new NucleusUserException("Parameter macros not allowed in view definitions: " + pm);
                    }
                }, clr);
            }
            orderedCmds.add(this);
        }
    }

    private void addViewReference(Map<String, Set<String>> viewReferences, String referencedName) {
        if (this.fullName.equals(referencedName)) {
            Set<String> referencedSet = viewReferences.get(referencedName);
            if (referencedSet == null) {
                referencedSet = new HashSet<String>();
                viewReferences.put(this.fullName, referencedSet);
            }
            referencedSet.add(referencedName);
            AbstractClassMetaData.checkForCircularViewReferences(viewReferences, this.fullName, referencedName, null);
        }
    }

    protected static void checkForCircularViewReferences(Map<String, Set<String>> viewReferences, String referencerName, String referenceeName, List<String> referenceChain) {
        Set<String> classNames = viewReferences.get(referenceeName);
        if (classNames != null) {
            if (referenceChain == null) {
                referenceChain = new ArrayList<String>();
                referenceChain.add(referencerName);
            }
            referenceChain.add(referenceeName);
            for (String currentName : classNames) {
                if (currentName.equals(referencerName)) {
                    StringBuilder error = new StringBuilder(Localiser.msg("031003"));
                    Iterator<String> chainIter = referenceChain.iterator();
                    while (chainIter.hasNext()) {
                        error.append((Object)chainIter.next());
                        if (!chainIter.hasNext()) continue;
                        error.append(" -> ");
                    }
                    throw new NucleusUserException(error.toString()).setFatal();
                }
                AbstractClassMetaData.checkForCircularViewReferences(viewReferences, referencerName, currentName, referenceChain);
            }
        }
    }
}

