/*
 * Decompiled with CFR 0.152.
 */
package org.datanucleus.store.federation;

import org.datanucleus.ExecutionContext;
import org.datanucleus.metadata.AbstractClassMetaData;
import org.datanucleus.state.ObjectProvider;
import org.datanucleus.store.StoreManager;
import org.datanucleus.store.StorePersistenceHandler;
import org.datanucleus.store.federation.FederatedStoreManager;

public class FederatedPersistenceHandler
implements StorePersistenceHandler {
    FederatedStoreManager storeMgr;

    public FederatedPersistenceHandler(StoreManager storeMgr) {
        this.storeMgr = (FederatedStoreManager)storeMgr;
    }

    @Override
    public void close() {
    }

    public boolean useReferentialIntegrity() {
        return false;
    }

    @Override
    public void insertObjects(ObjectProvider ... ops) {
        for (int i = 0; i < ops.length; ++i) {
            this.insertObject(ops[i]);
        }
    }

    @Override
    public void deleteObjects(ObjectProvider ... ops) {
        for (int i = 0; i < ops.length; ++i) {
            this.deleteObject(ops[i]);
        }
    }

    @Override
    public void batchStart(ExecutionContext ec, StorePersistenceHandler.PersistenceBatchType batchType) {
    }

    @Override
    public void batchEnd(ExecutionContext ec, StorePersistenceHandler.PersistenceBatchType type) {
    }

    @Override
    public void insertObject(ObjectProvider op) {
        StoreManager classStoreMgr = this.storeMgr.getStoreManagerForClass(op.getClassMetaData());
        classStoreMgr.getPersistenceHandler().insertObject(op);
    }

    @Override
    public void updateObject(ObjectProvider op, int[] fieldNumbers) {
        StoreManager classStoreMgr = this.storeMgr.getStoreManagerForClass(op.getClassMetaData());
        classStoreMgr.getPersistenceHandler().updateObject(op, fieldNumbers);
    }

    @Override
    public void deleteObject(ObjectProvider op) {
        StoreManager classStoreMgr = this.storeMgr.getStoreManagerForClass(op.getClassMetaData());
        classStoreMgr.getPersistenceHandler().deleteObject(op);
    }

    @Override
    public void fetchObject(ObjectProvider op, int[] fieldNumbers) {
        StoreManager classStoreMgr = this.storeMgr.getStoreManagerForClass(op.getClassMetaData());
        classStoreMgr.getPersistenceHandler().fetchObject(op, fieldNumbers);
    }

    @Override
    public void fetchObjects(int[] fieldNumbers, ObjectProvider ... ops) {
        for (ObjectProvider op : ops) {
            this.fetchObject(op, fieldNumbers);
        }
    }

    @Override
    public void locateObject(ObjectProvider op) {
        StoreManager classStoreMgr = this.storeMgr.getStoreManagerForClass(op.getClassMetaData());
        classStoreMgr.getPersistenceHandler().locateObject(op);
    }

    @Override
    public void locateObjects(ObjectProvider[] ops) {
        StoreManager classStoreMgr = this.storeMgr.getStoreManagerForClass(ops[0].getClassMetaData());
        classStoreMgr.getPersistenceHandler().locateObjects(ops);
    }

    @Override
    public Object findObject(ExecutionContext ec, Object id) {
        return null;
    }

    @Override
    public Object[] findObjects(ExecutionContext ec, Object[] ids) {
        return null;
    }

    @Override
    public Object findObjectForKeys(ExecutionContext ec, AbstractClassMetaData cmd, String[] memberNames, Object[] values) {
        return null;
    }
}

