/*
 * Decompiled with CFR 0.152.
 */
package org.datanucleus.query;

import java.util.List;
import org.datanucleus.query.expression.DyadicExpression;
import org.datanucleus.query.expression.Expression;
import org.datanucleus.query.expression.InvokeExpression;
import org.datanucleus.query.expression.Literal;
import org.datanucleus.query.expression.ParameterExpression;
import org.datanucleus.query.expression.PrimaryExpression;
import org.datanucleus.query.expression.VariableExpression;

public class JPQLQueryHelper {
    static final String[] SINGLE_STRING_KEYWORDS = new String[]{"SELECT", "INSERT", "UPDATE", "DELETE", "FROM", "WHERE", "GROUP BY", "HAVING", "ORDER BY"};
    static final String[] SINGLE_STRING_KEYWORDS_INCLUDING_RANGE = new String[]{"SELECT", "INSERT", "UPDATE", "DELETE", "FROM", "WHERE", "GROUP BY", "HAVING", "ORDER BY", "RANGE"};
    static final String[] RESERVED_IDENTIFIERS = new String[]{"SELECT", "FROM", "WHERE", "UPDATE", "DELETE", "JOIN", "OUTER", "INNER", "LEFT", "GROUP", "BY", "HAVING", "FETCH", "DISTINCT", "OBJECT", "NULL", "TRUE", "FALSE", "NOT", "AND", "OR", "BETWEEN", "LIKE", "IN", "AS", "UNKNOWN", "EMPTY", "MEMBER", "OF", "IS", "AVG", "MAX", "MIN", "SUM", "COUNT", "ORDER", "ASC", "DESC", "MOD", "UPPER", "LOWER", "TRIM", "POSITION", "CHARACTER_LENGTH", "CHAR_LENGTH", "BIT_LENGTH", "CURRENT_TIME", "CURRENT_DATE", "CURRENT_TIMESTAMP", "NEW", "EXISTS", "ALL", "ANY", "SOME"};

    public static boolean isKeyword(String name) {
        for (int i = 0; i < SINGLE_STRING_KEYWORDS.length; ++i) {
            if (!name.equalsIgnoreCase(SINGLE_STRING_KEYWORDS[i])) continue;
            return true;
        }
        return false;
    }

    public static boolean isKeyword(String name, boolean allowRange) {
        if (!allowRange) {
            return JPQLQueryHelper.isKeyword(name);
        }
        for (int i = 0; i < SINGLE_STRING_KEYWORDS_INCLUDING_RANGE.length; ++i) {
            if (!name.equalsIgnoreCase(SINGLE_STRING_KEYWORDS_INCLUDING_RANGE[i])) continue;
            return true;
        }
        return false;
    }

    public static boolean isReservedIdentifier(String name) {
        for (int i = 0; i < RESERVED_IDENTIFIERS.length; ++i) {
            if (!name.equalsIgnoreCase(RESERVED_IDENTIFIERS[i])) continue;
            return true;
        }
        return false;
    }

    public static String getJPQLForExpression(Expression expr) {
        if (expr instanceof DyadicExpression) {
            DyadicExpression dyExpr = (DyadicExpression)expr;
            Expression left = dyExpr.getLeft();
            Expression right = dyExpr.getRight();
            StringBuilder str = new StringBuilder("(");
            if (left != null) {
                str.append(JPQLQueryHelper.getJPQLForExpression(left));
            }
            if (right != null && right instanceof Literal && ((Literal)right).getLiteral() == null && (dyExpr.getOperator() == Expression.OP_EQ || dyExpr.getOperator() == Expression.OP_NOTEQ)) {
                str.append(dyExpr.getOperator() == Expression.OP_EQ ? " IS NULL" : " IS NOT NULL");
            } else {
                if (dyExpr.getOperator() == Expression.OP_AND) {
                    str.append(" AND ");
                } else if (dyExpr.getOperator() == Expression.OP_OR) {
                    str.append(" OR ");
                } else if (dyExpr.getOperator() == Expression.OP_ADD) {
                    str.append(" + ");
                } else if (dyExpr.getOperator() == Expression.OP_SUB) {
                    str.append(" - ");
                } else if (dyExpr.getOperator() == Expression.OP_MUL) {
                    str.append(" * ");
                } else if (dyExpr.getOperator() == Expression.OP_DIV) {
                    str.append(" / ");
                } else if (dyExpr.getOperator() == Expression.OP_EQ) {
                    str.append(" = ");
                } else if (dyExpr.getOperator() == Expression.OP_GT) {
                    str.append(" > ");
                } else if (dyExpr.getOperator() == Expression.OP_LT) {
                    str.append(" < ");
                } else if (dyExpr.getOperator() == Expression.OP_GTEQ) {
                    str.append(" >= ");
                } else if (dyExpr.getOperator() == Expression.OP_LTEQ) {
                    str.append(" <= ");
                } else if (dyExpr.getOperator() == Expression.OP_NOTEQ) {
                    str.append(" <> ");
                } else {
                    throw new UnsupportedOperationException("Dont currently support operator " + dyExpr.getOperator() + " in JPQL conversion");
                }
                if (right != null) {
                    str.append(JPQLQueryHelper.getJPQLForExpression(right));
                }
            }
            str.append(")");
            return str.toString();
        }
        if (expr instanceof PrimaryExpression) {
            PrimaryExpression primExpr = (PrimaryExpression)expr;
            return primExpr.getId();
        }
        if (expr instanceof ParameterExpression) {
            ParameterExpression paramExpr = (ParameterExpression)expr;
            if (paramExpr.getId() != null) {
                return ":" + paramExpr.getId();
            }
            return "?" + paramExpr.getPosition();
        }
        if (expr instanceof InvokeExpression) {
            InvokeExpression invExpr = (InvokeExpression)expr;
            Expression invoked = invExpr.getLeft();
            List<Expression> args = invExpr.getArguments();
            String method = invExpr.getOperation();
            if (method.equalsIgnoreCase("CURRENT_DATE")) {
                return "CURRENT_DATE";
            }
            if (method.equalsIgnoreCase("CURRENT_TIME")) {
                return "CURRENT_TIME";
            }
            if (method.equalsIgnoreCase("CURRENT_TIMESTAMP")) {
                return "CURRENT_TIMESTAMP";
            }
            if (method.equalsIgnoreCase("length")) {
                StringBuilder str = new StringBuilder("LENGTH(");
                str.append(JPQLQueryHelper.getJPQLForExpression(invoked));
                if (args != null && !args.isEmpty()) {
                    Expression firstExpr = args.get(0);
                    str.append(",").append(JPQLQueryHelper.getJPQLForExpression(firstExpr));
                    if (args.size() == 2) {
                        Expression secondExpr = args.get(1);
                        str.append(",").append(JPQLQueryHelper.getJPQLForExpression(secondExpr));
                    }
                }
                str.append(")");
                return str.toString();
            }
            if (method.equals("toLowerCase")) {
                return "LOWER(" + JPQLQueryHelper.getJPQLForExpression(invoked) + ")";
            }
            if (method.equals("toUpperCase")) {
                return "UPPER(" + JPQLQueryHelper.getJPQLForExpression(invoked) + ")";
            }
            if (method.equalsIgnoreCase("isEmpty")) {
                StringBuilder str = new StringBuilder();
                str.append(JPQLQueryHelper.getJPQLForExpression(invoked));
                str.append(" IS EMPTY");
                return str.toString();
            }
            if (method.equalsIgnoreCase("indexOf")) {
                StringBuilder str = new StringBuilder("LOCATE(");
                str.append(JPQLQueryHelper.getJPQLForExpression(invoked));
                Expression firstExpr = args.get(0);
                str.append(",").append(JPQLQueryHelper.getJPQLForExpression(firstExpr));
                if (args.size() > 1) {
                    Expression secondExpr = args.get(1);
                    str.append(",").append(JPQLQueryHelper.getJPQLForExpression(secondExpr));
                }
                str.append(")");
                return str.toString();
            }
            if (method.equalsIgnoreCase("substring")) {
                StringBuilder str = new StringBuilder("SUBSTRING(");
                str.append(JPQLQueryHelper.getJPQLForExpression(invoked));
                Expression firstExpr = args.get(0);
                str.append(",").append(JPQLQueryHelper.getJPQLForExpression(firstExpr));
                if (args.size() > 1) {
                    Expression secondExpr = args.get(1);
                    str.append(",").append(JPQLQueryHelper.getJPQLForExpression(secondExpr));
                }
                str.append(")");
                return str.toString();
            }
            if (method.equalsIgnoreCase("trim")) {
                StringBuilder str = new StringBuilder("TRIM(BOTH ");
                str.append(JPQLQueryHelper.getJPQLForExpression(invoked));
                if (!args.isEmpty()) {
                    Expression trimChrExpr = args.get(0);
                    str.append(JPQLQueryHelper.getJPQLForExpression(trimChrExpr));
                }
                str.append(" FROM ");
                str.append(JPQLQueryHelper.getJPQLForExpression(invoked));
                str.append(")");
                return str.toString();
            }
            if (method.equalsIgnoreCase("trimLeft")) {
                StringBuilder str = new StringBuilder("TRIM(LEADING ");
                str.append(JPQLQueryHelper.getJPQLForExpression(invoked));
                if (!args.isEmpty()) {
                    Expression trimChrExpr = args.get(0);
                    str.append(JPQLQueryHelper.getJPQLForExpression(trimChrExpr));
                }
                str.append(" FROM ");
                str.append(JPQLQueryHelper.getJPQLForExpression(invoked));
                str.append(")");
                return str.toString();
            }
            if (method.equalsIgnoreCase("trimRight")) {
                StringBuilder str = new StringBuilder("TRIM(TRAILING ");
                str.append(JPQLQueryHelper.getJPQLForExpression(invoked));
                if (!args.isEmpty()) {
                    Expression trimChrExpr = args.get(0);
                    str.append(JPQLQueryHelper.getJPQLForExpression(trimChrExpr));
                }
                str.append(" FROM ");
                str.append(JPQLQueryHelper.getJPQLForExpression(invoked));
                str.append(")");
                return str.toString();
            }
            if (method.equalsIgnoreCase("matches")) {
                StringBuilder str = new StringBuilder();
                str.append(JPQLQueryHelper.getJPQLForExpression(invoked));
                str.append(" LIKE ");
                Expression firstExpr = args.get(0);
                str.append(JPQLQueryHelper.getJPQLForExpression(firstExpr));
                if (args.size() > 1) {
                    Expression secondExpr = args.get(1);
                    str.append(" ESCAPE ").append(JPQLQueryHelper.getJPQLForExpression(secondExpr));
                }
                return str.toString();
            }
            if (method.equalsIgnoreCase("contains")) {
                StringBuilder str = new StringBuilder();
                Expression firstExpr = args.get(0);
                str.append(JPQLQueryHelper.getJPQLForExpression(firstExpr));
                str.append(" MEMBER OF ");
                str.append(JPQLQueryHelper.getJPQLForExpression(invoked));
                return str.toString();
            }
            if (method.equalsIgnoreCase("COUNT")) {
                Expression argExpr = args.get(0);
                if (argExpr instanceof DyadicExpression && ((DyadicExpression)argExpr).getOperator() == Expression.OP_DISTINCT) {
                    DyadicExpression dyExpr = (DyadicExpression)argExpr;
                    return "COUNT(DISTINCT " + JPQLQueryHelper.getJPQLForExpression(dyExpr.getLeft()) + ")";
                }
                return "COUNT(" + JPQLQueryHelper.getJPQLForExpression(argExpr) + ")";
            }
            if (method.equalsIgnoreCase("COALESCE")) {
                StringBuilder str = new StringBuilder("COALESCE(");
                for (int i = 0; i < args.size(); ++i) {
                    Expression argExpr = args.get(i);
                    str.append(JPQLQueryHelper.getJPQLForExpression(argExpr));
                    if (i >= args.size() - 1) continue;
                    str.append(",");
                }
                str.append(")");
                return str.toString();
            }
            if (method.equalsIgnoreCase("NULLIF")) {
                StringBuilder str = new StringBuilder("NULLIF(");
                for (int i = 0; i < args.size(); ++i) {
                    Expression argExpr = args.get(i);
                    str.append(JPQLQueryHelper.getJPQLForExpression(argExpr));
                    if (i >= args.size() - 1) continue;
                    str.append(",");
                }
                str.append(")");
                return str.toString();
            }
            if (method.equalsIgnoreCase("ABS")) {
                Expression argExpr = args.get(0);
                return "ABS(" + JPQLQueryHelper.getJPQLForExpression(argExpr) + ")";
            }
            if (method.equalsIgnoreCase("AVG")) {
                Expression argExpr = args.get(0);
                return "AVG(" + JPQLQueryHelper.getJPQLForExpression(argExpr) + ")";
            }
            if (method.equalsIgnoreCase("MAX")) {
                Expression argExpr = args.get(0);
                return "MAX(" + JPQLQueryHelper.getJPQLForExpression(argExpr) + ")";
            }
            if (method.equalsIgnoreCase("MIN")) {
                Expression argExpr = args.get(0);
                return "MIN(" + JPQLQueryHelper.getJPQLForExpression(argExpr) + ")";
            }
            if (method.equalsIgnoreCase("SQRT")) {
                Expression argExpr = args.get(0);
                return "SQRT(" + JPQLQueryHelper.getJPQLForExpression(argExpr) + ")";
            }
            if (method.equalsIgnoreCase("SUM")) {
                Expression argExpr = args.get(0);
                return "SUM(" + JPQLQueryHelper.getJPQLForExpression(argExpr) + ")";
            }
            throw new UnsupportedOperationException("Dont currently support InvokeExpression (" + invExpr + ") conversion into JPQL");
        }
        if (expr instanceof Literal) {
            Literal litExpr = (Literal)expr;
            Object value = litExpr.getLiteral();
            if (value instanceof String || value instanceof Character) {
                return "'" + value.toString() + "'";
            }
            if (value instanceof Boolean) {
                return (Boolean)value != false ? "TRUE" : "FALSE";
            }
            return litExpr.getLiteral().toString();
        }
        if (expr instanceof VariableExpression) {
            VariableExpression varExpr = (VariableExpression)expr;
            return varExpr.getId();
        }
        throw new UnsupportedOperationException("Dont currently support " + expr.getClass().getName() + " in JPQLQueryHelper");
    }
}

