/*
 * Decompiled with CFR 0.152.
 */
package org.datanucleus.store.valuegenerator;

import java.util.Date;
import java.util.GregorianCalendar;
import java.util.Random;
import org.datanucleus.util.NucleusLogger;

class AUID
implements Comparable {
    private static final int VERSION_RANDOM_NODE = 3;
    private static final int VARIANT_NCS = 0;
    private static final int VARIANT_DCE = 32768;
    private static final int VARIANT_MICROSOFT = 49152;
    private static final int VARIANT_RESERVED = 57344;
    private static final int CS_MASK_NCS = Short.MAX_VALUE;
    private static final int CS_MASK_DCE = 16383;
    private static final int CS_MASK_MICROSOFT = 8191;
    private static final int CS_MASK_RESERVED = 8191;
    private static final long MAXIMUM_ENTROPIC_TIME_MS = 5000L;
    private static final long TIME_SCALE = 10000L;
    private static final long UTC_OFFSET = new GregorianCalendar().getGregorianChange().getTime() * 10000L;
    private static final char[] HEX_CHARS = new char[]{'0', '1', '2', '3', '4', '5', '6', '7', '8', '9', 'a', 'b', 'c', 'd', 'e', 'f'};
    private static volatile State auidState = null;
    private long firstHalf;
    private long secondHalf;

    public AUID() {
        this.makeUnique(0, false);
    }

    protected AUID(int securityAttributes) {
        this.makeUnique(securityAttributes, true);
    }

    protected AUID(long time, int version, int clockSeq, int variant, long node) {
        this.packFirstHalf(time, version);
        this.packSecondHalf(clockSeq, variant, node);
    }

    protected AUID(long timeLow, long timeMid, long timeHiAndVersion, int clockSeqHiAndVariant, int clockSeqLow, long node) {
        this.packDCEFieldsFirstHalf(timeLow, timeMid, timeHiAndVersion);
        this.packDCEFieldsSecondHalf(clockSeqHiAndVariant, clockSeqLow, node);
    }

    protected AUID(AUID auid) {
        this.firstHalf = auid.firstHalf;
        this.secondHalf = auid.secondHalf;
    }

    public AUID(String auid) {
        try {
            this.firstHalf = this.parseFirstHalf(auid.subSequence(0, 18));
            this.secondHalf = this.parseSecondHalf(auid.subSequence(18, 36));
        }
        catch (IndexOutOfBoundsException ioobe) {
            throw new NumberFormatException();
        }
        catch (NumberFormatException nfe) {
            throw new NumberFormatException();
        }
    }

    public AUID(CharSequence auid) {
        try {
            this.firstHalf = this.parseFirstHalf(auid.subSequence(0, 18));
            this.secondHalf = this.parseSecondHalf(auid.subSequence(18, 36));
        }
        catch (IndexOutOfBoundsException ioobe) {
            throw new NumberFormatException();
        }
        catch (NumberFormatException nfe) {
            throw new NumberFormatException();
        }
    }

    public AUID(byte[] bytes) {
        this(bytes, 0);
    }

    public AUID(byte[] bytes, int offset) {
        long timeLow = AUID.getOctets(4, bytes, 0 + offset, true);
        long timeMid = AUID.getOctets(2, bytes, 4 + offset, true);
        long timeHAV = AUID.getOctets(2, bytes, 6 + offset, true);
        int csHAV = (int)AUID.getOctets(1, bytes, 8 + offset, true);
        int csLow = (int)AUID.getOctets(1, bytes, 9 + offset, true);
        long node = AUID.getOctets(6, bytes, 10 + offset, true);
        this.packDCEFieldsFirstHalf(timeLow, timeMid, timeHAV);
        this.packDCEFieldsSecondHalf(csHAV, csLow, node);
    }

    public static AUID parse(String auid) {
        return new AUID(auid);
    }

    public static AUID parse(CharSequence auid) {
        return new AUID(auid);
    }

    protected int identifyVariant(int clockSeqAndVariant) {
        if ((clockSeqAndVariant & Short.MIN_VALUE) == 0) {
            return 0;
        }
        if ((clockSeqAndVariant & 0xFFFFC000) == 32768) {
            return 32768;
        }
        if ((clockSeqAndVariant & 0xFFFFE000) == 49152) {
            return 0;
        }
        if ((clockSeqAndVariant & 0xFFFFE000) == 57344) {
            return 57344;
        }
        throw new IllegalArgumentException();
    }

    public int getClockSeqMaskForVariant(int variant) {
        switch (variant) {
            case 0: {
                return Short.MAX_VALUE;
            }
            case 32768: {
                return 16383;
            }
            case 49152: {
                return 8191;
            }
            case 57344: {
                return 8191;
            }
        }
        throw new IllegalArgumentException();
    }

    protected long getCurrentTime() {
        return System.currentTimeMillis() * 10000L - UTC_OFFSET;
    }

    protected State loadState(State state) {
        State loadInto = state;
        if (loadInto == null) {
            if (auidState == null) {
                loadInto = auidState = new State();
            }
            state = auidState;
        }
        if (loadInto != null) {
            if (loadInto.getRandom() == null) {
                loadInto.setRandom(new Random(AUID.entropicSeed(32, System.currentTimeMillis())));
            }
            loadInto.setLastTime(this.getCurrentTime());
            loadInto.setAdjustTime(0L);
            loadInto.setClockSequence(loadInto.getRandom().nextInt());
            loadInto.setNode(loadInto.getRandom().nextLong() & 0xFFFFFFFFFFFFL);
            loadInto.setVersion(3);
            loadInto.setVariant(32768);
            loadInto.setIncludeSecurityAttributes(false);
        }
        return state;
    }

    protected void saveState(State state) {
    }

    protected byte[] getBytes(byte[] dst, int dstBegin, boolean bigendian) {
        if (dst == null) {
            dst = new byte[16];
            dstBegin = 0;
        }
        AUID.putOctets(this.getTimeLow(), 4, dst, dstBegin, bigendian);
        AUID.putOctets(this.getTimeMid(), 2, dst, dstBegin + 4, bigendian);
        AUID.putOctets(this.getTimeHighAndVersion(), 2, dst, dstBegin + 6, bigendian);
        AUID.putOctets(this.getClockSeqHighAndVariant(), 1, dst, dstBegin + 8, bigendian);
        AUID.putOctets(this.getClockSeqLow(), 1, dst, dstBegin + 9, bigendian);
        AUID.putOctets(this.getNode(), 6, dst, dstBegin + 10, bigendian);
        return dst;
    }

    public byte[] getBytes(byte[] dst, int dstBegin) {
        return this.getBytes(dst, dstBegin, true);
    }

    public StringBuilder toStringBuilder(StringBuilder sb) {
        if (sb == null) {
            sb = new StringBuilder();
        }
        this.toHex(sb, this.getTimeLow(), 8);
        sb.append('-');
        this.toHex(sb, this.getTimeMid(), 4);
        sb.append('-');
        this.toHex(sb, this.getTimeHighAndVersion(), 4);
        sb.append('-');
        this.toHex(sb, this.getClockSeqAndVariant(), 4);
        sb.append('-');
        this.toHex(sb, this.getNode(), 12);
        return sb;
    }

    private void packFirstHalf(long time, int version) {
        this.firstHalf = (long)version << 60 | time & 0xFFFFFFFFFFFFFFFL;
    }

    private void packDCEFieldsFirstHalf(long timeLow, long timeMid, long timeHiAndVersion) {
        this.firstHalf = timeHiAndVersion << 48 | timeMid << 32 | timeLow;
    }

    private void packSecondHalf(int clockSeq, int variant, long node) {
        int csMasked = clockSeq & this.getClockSeqMaskForVariant(variant);
        int csLow = csMasked & 0xFF;
        int csHigh = (variant | csMasked) >>> 8;
        this.secondHalf = node << 16 | (long)(csLow << 8) | (long)csHigh;
    }

    private void packDCEFieldsSecondHalf(int clockSeqHiAndVariant, int clockSeqLow, long node) {
        this.secondHalf = node << 16 | (long)(clockSeqLow << 8) | (long)clockSeqHiAndVariant;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private void makeUnique(int securityAttributes, boolean hasSecurityAttributes) {
        Class<AUID> clazz = AUID.class;
        synchronized (AUID.class) {
            State state = this.loadState(null);
            long now = this.getCurrentTime();
            if (now < state.getLastTime()) {
                state.setClockSequence(state.getClockSequence() + 1);
                state.setAdjustTime(0L);
                state.setLastTime(now);
            } else if (now != state.getLastTime()) {
                if (now < state.getLastTime() + state.getAdjustTime()) {
                    throw new IllegalStateException("Clock overrun occured.");
                }
                state.setAdjustTime(0L);
                state.setLastTime(now);
            }
            now += state.incrementAdjustTime();
            if (state.getIncludeSecurityAttributes()) {
                if (!hasSecurityAttributes) throw new IllegalArgumentException("Required to include security attributes as declared in state.");
                now = now & 0xFFFFFFFF00000000L | (long)securityAttributes;
            } else if (hasSecurityAttributes) {
                throw new IllegalArgumentException("Cannot include security attributes if not declared in state.");
            }
            this.packFirstHalf(now, state.getVersion());
            this.packSecondHalf(state.getClockSequence(), state.getVariant(), state.getNode());
            this.saveState(state);
            // ** MonitorExit[var3_3] (shouldn't be in output)
            return;
        }
    }

    private void toHex(StringBuilder result, long value, int nibbles) {
        if (nibbles > 0) {
            this.toHex(result, value >>> 4, nibbles - 1);
            result.append(HEX_CHARS[(int)value & 0xF]);
        }
    }

    private long parseNibble(char c) {
        switch (c) {
            case '0': {
                return 0L;
            }
            case '1': {
                return 1L;
            }
            case '2': {
                return 2L;
            }
            case '3': {
                return 3L;
            }
            case '4': {
                return 4L;
            }
            case '5': {
                return 5L;
            }
            case '6': {
                return 6L;
            }
            case '7': {
                return 7L;
            }
            case '8': {
                return 8L;
            }
            case '9': {
                return 9L;
            }
            case 'A': 
            case 'a': {
                return 10L;
            }
            case 'B': 
            case 'b': {
                return 11L;
            }
            case 'C': 
            case 'c': {
                return 12L;
            }
            case 'D': 
            case 'd': {
                return 13L;
            }
            case 'E': 
            case 'e': {
                return 14L;
            }
            case 'F': 
            case 'f': {
                return 15L;
            }
        }
        throw new NumberFormatException();
    }

    private void parseHyphen(char c) {
        if (c != '-') {
            throw new NumberFormatException();
        }
    }

    private long parseHex(CharSequence cs) {
        long retval = 0L;
        for (int i = 0; i < cs.length(); ++i) {
            retval = (retval << 4) + this.parseNibble(cs.charAt(i));
        }
        return retval;
    }

    private long parseFirstHalf(CharSequence charSequence) {
        long timeLow = this.parseHex(charSequence.subSequence(0, 8));
        this.parseHyphen(charSequence.charAt(8));
        long timeMid = this.parseHex(charSequence.subSequence(9, 13));
        this.parseHyphen(charSequence.charAt(13));
        long timeHi = this.parseHex(charSequence.subSequence(14, 18));
        return timeHi << 48 | timeMid << 32 | timeLow;
    }

    private long parseSecondHalf(CharSequence charSequence) {
        this.parseHyphen(charSequence.charAt(0));
        long clockSeq = this.parseHex(charSequence.subSequence(1, 5));
        this.parseHyphen(charSequence.charAt(5));
        long node = this.parseHex(charSequence.subSequence(6, 18));
        return node << 16 | (clockSeq & 0xFFL) << 8 | clockSeq >>> 8;
    }

    protected static final long getOctets(int octets, byte[] bytes, int begin, boolean bigendian) {
        if (octets > 1) {
            if (bigendian) {
                return ((long)bytes[begin] & 0xFFL) << 8 * (octets - 1) | AUID.getOctets(octets - 1, bytes, begin + 1, bigendian);
            }
            return AUID.getOctets(octets - 1, bytes, begin, bigendian) | ((long)bytes[begin + octets - 1] & 0xFFL) << 8 * (octets - 1);
        }
        return (long)bytes[begin] & 0xFFL;
    }

    protected static final void putOctets(long value, int octets, byte[] dst, int dstBegin, boolean bigendian) {
        if (bigendian) {
            if (octets > 1) {
                AUID.putOctets(value >>> 8, octets - 1, dst, dstBegin, bigendian);
            }
            dst[dstBegin + octets - 1] = (byte)(value & 0xFFL);
        } else {
            dst[dstBegin] = (byte)(value & 0xFFL);
            if (octets > 1) {
                AUID.putOctets(value >>> 8, octets - 1, dst, dstBegin + 1, bigendian);
            }
        }
    }

    public final long getTimeLow() {
        return this.firstHalf & 0xFFFFFFFFFFFFFFFFL;
    }

    public final long getTimeMid() {
        return this.firstHalf >>> 32 & 0xFFFFL;
    }

    public final long getTimeHigh() {
        return this.firstHalf >>> 48 & 0xFFFL;
    }

    public final long getTimeHighAndVersion() {
        return this.firstHalf >>> 48;
    }

    public final long getTime() {
        return this.firstHalf & 0xFFFFFFFFFFFFFFFL;
    }

    public final Date getDate() {
        return new Date((this.getTime() + UTC_OFFSET) / 10000L);
    }

    public final long getNanos() {
        return (this.getTime() + UTC_OFFSET) % 10000L;
    }

    public final int getVersion() {
        return (int)(this.firstHalf >>> 60);
    }

    public final int getClockSeqHighAndVariant() {
        return (int)(this.secondHalf & 0xFFL);
    }

    public final int getClockSeqLow() {
        return (int)(this.secondHalf >>> 8 & 0xFFL);
    }

    public final int getClockSeqAndVariant() {
        return this.getClockSeqHighAndVariant() << 8 | this.getClockSeqLow();
    }

    public final int getClockSeq() {
        int csv = this.getClockSeqAndVariant();
        return csv & this.getClockSeqMaskForVariant(this.identifyVariant(csv));
    }

    public final int getVariant() {
        return this.identifyVariant(this.getClockSeqAndVariant());
    }

    public final long getNode() {
        return this.secondHalf >>> 16;
    }

    public final byte[] getBytes() {
        return this.getBytes(null, 0);
    }

    public boolean equals(Object obj) {
        if (obj instanceof AUID) {
            AUID other = (AUID)obj;
            return this.firstHalf == other.firstHalf && this.secondHalf == other.secondHalf;
        }
        return false;
    }

    public int hashCode() {
        return (int)(this.firstHalf ^ this.firstHalf >>> 32 ^ this.secondHalf ^ this.secondHalf >>> 32);
    }

    public String toString() {
        return this.toStringBuilder(null).toString();
    }

    public int compareTo(Object o) {
        AUID other = (AUID)o;
        long cmp = this.getTimeLow() - other.getTimeLow();
        if (cmp != 0L && (cmp = this.getTimeMid() - other.getTimeMid()) != 0L && (cmp = this.getTimeHighAndVersion() - other.getTimeHighAndVersion()) != 0L && (cmp = (long)(this.getClockSeqHighAndVariant() - other.getClockSeqHighAndVariant())) != 0L && (cmp = (long)(this.getClockSeqLow() - other.getClockSeqLow())) != 0L) {
            cmp = this.getNode() - other.getNode();
        }
        return cmp == 0L ? 0 : (cmp < 0L ? -1 : 1);
    }

    private static long entropicSeed(int bits, long initialSeed) {
        int i;
        if (bits > 63) {
            bits = 63;
        } else if (bits < 1) {
            bits = 1;
        }
        final long startTime = System.currentTimeMillis();
        final int[] counters = new int[bits + 1];
        final Random[] randoms = new Random[bits];
        final Thread[] threads = new Thread[bits];
        final int endvalue = bits * 128;
        final int lastindex = bits;
        Random random = new Random(initialSeed);
        for (i = 0; i < bits; ++i) {
            final int thisindex = i;
            long nextSeed = random.nextLong();
            randoms[i] = new Random(nextSeed);
            threads[i] = new Thread(){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                @Override
                public void run() {
                    try {
                        while (counters[lastindex] < endvalue) {
                            long value = randoms[thisindex].nextLong();
                            int loop = (int)(value & 0xFFL) + 16;
                            for (int a = 0; a < loop; ++a) {
                                randoms[thisindex].nextLong();
                                if (System.currentTimeMillis() - startTime > 5000L) break;
                            }
                            int n = thisindex;
                            counters[n] = counters[n] + 1;
                            if (System.currentTimeMillis() - startTime <= 5000L) continue;
                            break;
                        }
                    }
                    catch (Throwable t) {
                        NucleusLogger.VALUEGENERATION.error(t);
                        counters[thisindex] = endvalue;
                    }
                    finally {
                        threads[thisindex] = null;
                    }
                }
            };
            threads[i].start();
        }
        for (i = 0; i < bits; ++i) {
            while (counters[i] < bits) {
                Thread.yield();
                if (System.currentTimeMillis() - startTime <= 5000L) continue;
            }
        }
        while (counters[lastindex] < endvalue) {
            Thread.yield();
            int sum = 0;
            for (int i2 = 0; i2 < bits; ++i2) {
                sum += counters[i2];
            }
            counters[lastindex] = sum;
            if (System.currentTimeMillis() - startTime <= 5000L) continue;
            break;
        }
        for (i = 0; i < bits; ++i) {
            while (threads[i] != null) {
                Thread.yield();
            }
        }
        long seed = 0L;
        for (int i3 = 0; i3 < bits; ++i3) {
            seed += randoms[i3].nextLong();
        }
        return seed;
    }

    protected static class State {
        private long lastTime;
        private long adjustTime;
        private int clockSequence;
        private long node;
        private int version;
        private int variant;
        private Random random;
        private boolean includeSecurityAttributes;

        protected State() {
        }

        public void setLastTime(long lastTime) {
            this.lastTime = lastTime;
        }

        public long getLastTime() {
            return this.lastTime;
        }

        public void setAdjustTime(long adjustTime) {
            this.adjustTime = adjustTime;
        }

        public long getAdjustTime() {
            return this.adjustTime;
        }

        public long incrementAdjustTime() {
            return this.adjustTime++;
        }

        public void setClockSequence(int clockSequence) {
            this.clockSequence = clockSequence;
        }

        public int getClockSequence() {
            return this.clockSequence;
        }

        public void setNode(long node) {
            this.node = node;
        }

        public long getNode() {
            return this.node;
        }

        public void setVersion(int version) {
            this.version = version;
        }

        public int getVersion() {
            return this.version;
        }

        public void setVariant(int variant) {
            this.variant = variant;
        }

        public int getVariant() {
            return this.variant;
        }

        public void setRandom(Random random) {
            this.random = random;
        }

        public Random getRandom() {
            return this.random;
        }

        public void setIncludeSecurityAttributes(boolean includeSecurityAttributes) {
            this.includeSecurityAttributes = includeSecurityAttributes;
        }

        public boolean getIncludeSecurityAttributes() {
            return this.includeSecurityAttributes;
        }
    }
}

