/*
 * Decompiled with CFR 0.152.
 */
package org.datanucleus.metadata;

import org.datanucleus.ClassLoaderResolver;
import org.datanucleus.exceptions.ClassNotResolvedException;
import org.datanucleus.exceptions.NucleusFatalUserException;
import org.datanucleus.metadata.AbstractElementMetaData;
import org.datanucleus.metadata.AbstractMemberMetaData;
import org.datanucleus.metadata.EmbeddedMetaData;
import org.datanucleus.metadata.InvalidMemberMetaDataException;

public class ValueMetaData
extends AbstractElementMetaData {
    private static final long serialVersionUID = -3179830024157613599L;

    public ValueMetaData(ValueMetaData vmd) {
        super(vmd);
    }

    public ValueMetaData() {
    }

    @Override
    public void populate(ClassLoaderResolver clr, ClassLoader primary) {
        AbstractMemberMetaData fmd = (AbstractMemberMetaData)this.parent;
        if (fmd.getMap() == null) {
            throw new NucleusFatalUserException("The field " + fmd.getFullFieldName() + " is defined with <value>, however no <map> definition was found.");
        }
        fmd.getMap().value.populate(fmd.getAbstractClassMetaData().getPackageName(), clr, primary);
        String valueType = fmd.getMap().getValueType();
        Class valueTypeClass = null;
        try {
            valueTypeClass = clr.classForName(valueType, primary);
        }
        catch (ClassNotResolvedException cnre) {
            throw new InvalidMemberMetaDataException("044150", fmd.getClassName(), fmd.getName(), valueType);
        }
        if (this.embeddedMetaData != null && (valueTypeClass.isInterface() || valueTypeClass.getName().equals("java.lang.Object"))) {
            throw new InvalidMemberMetaDataException("044152", fmd.getClassName(), fmd.getName(), valueTypeClass.getName());
        }
        if (this.embeddedMetaData == null && ((AbstractMemberMetaData)this.parent).hasMap() && ((AbstractMemberMetaData)this.parent).getMap().isEmbeddedValue() && ((AbstractMemberMetaData)this.parent).getJoinMetaData() != null && ((AbstractMemberMetaData)this.parent).getMap().valueIsPersistent()) {
            this.embeddedMetaData = new EmbeddedMetaData();
            this.embeddedMetaData.parent = this;
        }
        super.populate(clr, primary);
    }
}

