/*
 * Decompiled with CFR 0.152.
 */
package org.datanucleus.metadata;

import org.datanucleus.ClassLoaderResolver;
import org.datanucleus.exceptions.ClassNotResolvedException;
import org.datanucleus.exceptions.NucleusUserException;
import org.datanucleus.metadata.AbstractElementMetaData;
import org.datanucleus.metadata.AbstractMemberMetaData;
import org.datanucleus.metadata.EmbeddedMetaData;
import org.datanucleus.metadata.InvalidMemberMetaDataException;

public class KeyMetaData
extends AbstractElementMetaData {
    private static final long serialVersionUID = -3379637846354140692L;

    public KeyMetaData(KeyMetaData kmd) {
        super(kmd);
    }

    public KeyMetaData() {
    }

    @Override
    public void populate(ClassLoaderResolver clr, ClassLoader primary) {
        AbstractMemberMetaData fmd = (AbstractMemberMetaData)this.parent;
        if (fmd.getMap() == null) {
            throw new NucleusUserException("The field " + fmd.getFullFieldName() + " is defined with <key>, however no <map> definition was found.").setFatal();
        }
        fmd.getMap().key.populate(fmd.getAbstractClassMetaData().getPackageName(), clr, primary);
        String keyType = fmd.getMap().getKeyType();
        Class keyTypeClass = null;
        try {
            keyTypeClass = clr.classForName(keyType, primary);
        }
        catch (ClassNotResolvedException cnre) {
            throw new InvalidMemberMetaDataException("044147", fmd.getClassName(), fmd.getName(), keyType);
        }
        if (this.embeddedMetaData != null && (keyTypeClass.isInterface() || keyTypeClass.getName().equals("java.lang.Object"))) {
            throw new InvalidMemberMetaDataException("044152", fmd.getClassName(), fmd.getName(), keyTypeClass.getName());
        }
        if (this.embeddedMetaData == null && ((AbstractMemberMetaData)this.parent).hasMap() && ((AbstractMemberMetaData)this.parent).getMap().isEmbeddedKey() && ((AbstractMemberMetaData)this.parent).getJoinMetaData() != null && ((AbstractMemberMetaData)this.parent).getMap().keyIsPersistent()) {
            this.embeddedMetaData = new EmbeddedMetaData();
            this.embeddedMetaData.parent = this;
        }
        super.populate(clr, primary);
    }
}

