/*
 * Decompiled with CFR 0.152.
 */
package org.datanucleus.store.types;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import org.datanucleus.ClassLoaderResolver;
import org.datanucleus.NucleusContext;
import org.datanucleus.exceptions.ClassNotResolvedException;
import org.datanucleus.exceptions.NucleusException;
import org.datanucleus.plugin.ConfigurationElement;
import org.datanucleus.plugin.PluginManager;
import org.datanucleus.store.types.ContainerAdapter;
import org.datanucleus.store.types.ContainerHandler;
import org.datanucleus.store.types.TypeManager;
import org.datanucleus.store.types.converters.ClassStringConverter;
import org.datanucleus.store.types.converters.TypeConverter;
import org.datanucleus.util.ClassUtils;
import org.datanucleus.util.Localiser;
import org.datanucleus.util.NucleusLogger;
import org.datanucleus.util.StringUtils;

public class TypeManagerImpl
implements TypeManager,
Serializable {
    private static final long serialVersionUID = 8217508318434539002L;
    protected NucleusContext nucCtx;
    protected transient ClassLoaderResolver clr;
    protected Map<String, JavaType> javaTypes = new ConcurrentHashMap<String, JavaType>();
    protected Map<Class, ? super ContainerHandler> containerHandlersByClass = new ConcurrentHashMap<Class, ContainerHandler>();
    protected Map<String, TypeConverter> typeConverterByName = null;
    protected Map<String, TypeConverter> autoApplyConvertersByType = null;
    protected Map<Class, Map<Class, TypeConverter>> typeConverterMap = null;
    protected Map<TypeConverter, Class> typeConverterDatastoreTypeByConverter = new ConcurrentHashMap<TypeConverter, Class>();
    protected Map<TypeConverter, Class> typeConverterMemberTypeByConverter = new ConcurrentHashMap<TypeConverter, Class>();
    private static Comparator<Class> ALPHABETICAL_ORDER = new Comparator<Class>(){

        @Override
        public int compare(Class cls1, Class cls2) {
            int res = String.CASE_INSENSITIVE_ORDER.compare(cls1.getName(), cls2.getName());
            if (res == 0) {
                res = cls1.getName().compareTo(cls2.getName());
            }
            return res;
        }
    };
    private static Comparator<String> ALPHABETICAL_ORDER_STRING = new Comparator<String>(){

        @Override
        public int compare(String cls1, String cls2) {
            int res = String.CASE_INSENSITIVE_ORDER.compare(cls1, cls2);
            if (res == 0) {
                res = cls1.compareTo(cls2);
            }
            return res;
        }
    };

    public TypeManagerImpl(NucleusContext nucCtx) {
        this.nucCtx = nucCtx;
        this.loadJavaTypes(nucCtx.getPluginManager());
        this.loadTypeConverters(nucCtx.getPluginManager());
    }

    @Override
    public void close() {
        this.containerHandlersByClass = null;
        this.javaTypes = null;
        this.typeConverterByName = null;
        this.typeConverterMap = null;
        this.typeConverterMemberTypeByConverter = null;
        this.typeConverterDatastoreTypeByConverter = null;
        this.autoApplyConvertersByType = null;
    }

    protected ClassLoaderResolver getClassLoaderResolver() {
        if (this.clr == null) {
            this.clr = this.nucCtx.getClassLoaderResolver(null);
        }
        return this.clr;
    }

    @Override
    public Set<String> getSupportedSecondClassTypes() {
        return new HashSet<String>(this.javaTypes.keySet());
    }

    @Override
    public boolean isSupportedSecondClassType(String className) {
        if (className == null) {
            return false;
        }
        JavaType type = this.javaTypes.get(className);
        if (type == null) {
            try {
                Class cls = this.getClassLoaderResolver().classForName(className);
                type = this.findJavaTypeForClass(cls);
                return type != null;
            }
            catch (Exception exception) {
                return false;
            }
        }
        return true;
    }

    @Override
    public String[] filterOutSupportedSecondClassNames(String[] inputClassNames) {
        int filteredClasses = 0;
        for (int i = 0; i < inputClassNames.length; ++i) {
            if (!this.isSupportedSecondClassType(inputClassNames[i])) continue;
            inputClassNames[i] = null;
            ++filteredClasses;
        }
        if (filteredClasses == 0) {
            return inputClassNames;
        }
        String[] restClasses = new String[inputClassNames.length - filteredClasses];
        int m = 0;
        for (int i = 0; i < inputClassNames.length; ++i) {
            if (inputClassNames[i] == null) continue;
            restClasses[m++] = inputClassNames[i];
        }
        return restClasses;
    }

    @Override
    public boolean isDefaultPersistent(Class c) {
        if (c == null) {
            return false;
        }
        JavaType type = this.javaTypes.get(c.getName());
        if (type != null) {
            return true;
        }
        type = this.findJavaTypeForClass(c);
        return type != null;
    }

    @Override
    public boolean isDefaultFetchGroup(Class c) {
        if (c == null) {
            return false;
        }
        if (this.nucCtx.getApiAdapter().isPersistable(c)) {
            return this.nucCtx.getApiAdapter().getDefaultDFGForPersistableField();
        }
        JavaType type = this.javaTypes.get(c.getName());
        if (type != null) {
            return type.dfg;
        }
        type = this.findJavaTypeForClass(c);
        if (type != null) {
            return type.dfg;
        }
        return false;
    }

    @Override
    public boolean isDefaultFetchGroupForCollection(Class c, Class genericType) {
        if (c != null && genericType == null) {
            return this.isDefaultFetchGroup(c);
        }
        if (c == null) {
            return false;
        }
        String name = c.getName() + "<" + genericType.getName() + ">";
        JavaType type = this.javaTypes.get(name);
        if (type != null) {
            return type.dfg;
        }
        type = this.findJavaTypeForCollectionClass(c, genericType);
        if (type != null) {
            return type.dfg;
        }
        return false;
    }

    @Override
    public boolean isDefaultEmbeddedType(Class c) {
        if (c == null) {
            return false;
        }
        JavaType type = this.javaTypes.get(c.getName());
        if (type != null) {
            return type.embedded;
        }
        type = this.findJavaTypeForClass(c);
        if (type != null) {
            return type.embedded;
        }
        return false;
    }

    @Override
    public boolean isSecondClassMutableType(String className) {
        return this.getWrapperTypeForType(className) != null;
    }

    @Override
    public Class getWrapperTypeForType(String className) {
        if (className == null) {
            return null;
        }
        JavaType type = this.javaTypes.get(className);
        return type == null ? null : type.wrapperType;
    }

    @Override
    public Class getWrappedTypeBackedForType(String className) {
        if (className == null) {
            return null;
        }
        JavaType type = this.javaTypes.get(className);
        return type == null ? null : type.wrapperTypeBacked;
    }

    @Override
    public boolean isSecondClassWrapper(String className) {
        if (className == null) {
            return false;
        }
        for (JavaType type : this.javaTypes.values()) {
            if (type.wrapperType != null && type.wrapperType.getName().equals(className)) {
                return true;
            }
            if (type.wrapperTypeBacked == null || !type.wrapperTypeBacked.getName().equals(className)) continue;
            return true;
        }
        return false;
    }

    @Override
    public Class getTypeForSecondClassWrapper(String className) {
        for (JavaType type : this.javaTypes.values()) {
            if (type.wrapperType != null && type.wrapperType.getName().equals(className)) {
                return type.cls;
            }
            if (type.wrapperTypeBacked == null || !type.wrapperTypeBacked.getName().equals(className)) continue;
            return type.cls;
        }
        return null;
    }

    @Override
    public ContainerAdapter getContainerAdapter(Object container) {
        Object containerHandler = this.getContainerHandler(container.getClass());
        return containerHandler == null ? null : (ContainerAdapter)containerHandler.getAdapter((Object)container);
    }

    @Override
    public <H extends ContainerHandler> H getContainerHandler(Class containerClass) {
        JavaType type;
        ContainerHandler containerHandler = this.containerHandlersByClass.get(containerClass);
        if (containerHandler == null && (type = this.findJavaTypeForClass(containerClass)) != null && type.containerHandlerType != null) {
            Class[] parameterTypes = null;
            Object[] parameters = null;
            Class[] classParameterTypes = new Class[]{Class.class};
            if (ClassUtils.getConstructorWithArguments(type.containerHandlerType, classParameterTypes) != null) {
                parameterTypes = classParameterTypes;
                parameters = new Object[]{containerClass};
            }
            containerHandler = (ContainerHandler)ClassUtils.newInstance(type.containerHandlerType, parameterTypes, parameters);
            this.containerHandlersByClass.put(containerClass, containerHandler);
        }
        return (H)containerHandler;
    }

    @Override
    public TypeConverter getTypeConverterForName(String converterName) {
        return this.typeConverterByName == null || converterName == null ? null : this.typeConverterByName.get(converterName);
    }

    @Override
    public void registerConverter(String name, TypeConverter converter, Class memberType, Class dbType, boolean autoApply, String autoApplyType) {
        Map<Class, TypeConverter> convertersForMember;
        if (name != null) {
            if (this.typeConverterByName == null) {
                this.typeConverterByName = new ConcurrentHashMap<String, TypeConverter>();
            }
            this.typeConverterByName.put(name, converter);
        }
        this.typeConverterDatastoreTypeByConverter.put(converter, dbType);
        this.typeConverterMemberTypeByConverter.put(converter, memberType);
        if (this.typeConverterMap == null) {
            this.typeConverterMap = new ConcurrentHashMap<Class, Map<Class, TypeConverter>>();
        }
        if ((convertersForMember = this.typeConverterMap.get(memberType)) == null) {
            convertersForMember = new ConcurrentHashMap<Class, TypeConverter>();
            this.typeConverterMap.put(memberType, convertersForMember);
        }
        convertersForMember.put(dbType, converter);
        if (converter instanceof ClassStringConverter) {
            ((ClassStringConverter)converter).setClassLoaderResolver(this.getClassLoaderResolver());
        }
        if (autoApply) {
            if (this.autoApplyConvertersByType == null) {
                this.autoApplyConvertersByType = new ConcurrentHashMap<String, TypeConverter>();
            }
            this.autoApplyConvertersByType.put(autoApplyType, converter);
        }
    }

    @Override
    public TypeConverter getAutoApplyTypeConverterForType(Class memberType) {
        return this.autoApplyConvertersByType == null ? null : this.autoApplyConvertersByType.get(memberType.getName());
    }

    @Override
    public void setDefaultTypeConverterForType(Class memberType, String converterName) {
        JavaType javaType = this.javaTypes.get(memberType.getName());
        if (javaType == null) {
            return;
        }
        String typeConverterName = javaType.typeConverterName;
        if (typeConverterName == null || !typeConverterName.equals(converterName)) {
            javaType.typeConverterName = converterName;
        }
    }

    @Override
    public TypeConverter getDefaultTypeConverterForType(Class memberType) {
        JavaType javaType = this.javaTypes.get(memberType.getName());
        if (javaType == null) {
            return null;
        }
        String typeConverterName = javaType.typeConverterName;
        if (typeConverterName == null) {
            return null;
        }
        return this.getTypeConverterForName(typeConverterName);
    }

    @Override
    public TypeConverter getTypeConverterForType(Class memberType, Class datastoreType) {
        if (this.typeConverterMap == null || memberType == null) {
            return null;
        }
        Map<Class, TypeConverter> convertersForMember = this.typeConverterMap.get(memberType);
        if (convertersForMember == null) {
            return null;
        }
        return convertersForMember.get(datastoreType);
    }

    @Override
    public Collection<TypeConverter> getTypeConvertersForType(Class memberType) {
        if (this.typeConverterMap == null || memberType == null) {
            return null;
        }
        Map<Class, TypeConverter> convertersForMember = this.typeConverterMap.get(memberType);
        if (convertersForMember == null) {
            return null;
        }
        return convertersForMember.values();
    }

    @Override
    public Class getDatastoreTypeForTypeConverter(TypeConverter conv, Class memberType) {
        return this.typeConverterDatastoreTypeByConverter.get(conv);
    }

    @Override
    public Class getMemberTypeForTypeConverter(TypeConverter conv, Class datastoreType) {
        return this.typeConverterMemberTypeByConverter.get(conv);
    }

    protected JavaType findJavaTypeForClass(Class cls) {
        if (cls == null) {
            return null;
        }
        JavaType type2 = this.javaTypes.get(cls.getName());
        if (type2 != null) {
            return type2;
        }
        HashSet<JavaType> supportedTypes = new HashSet<JavaType>(this.javaTypes.values());
        for (JavaType type2 : supportedTypes) {
            Class<?> componentCls;
            if (type2.cls == cls && type2.genericType == null) {
                return type2;
            }
            if (type2.cls.getName().equals("java.lang.Object") || type2.cls.getName().equals("java.io.Serializable")) continue;
            Class<?> clazz = componentCls = cls.isArray() ? cls.getComponentType() : null;
            if (componentCls != null) {
                if (!type2.cls.isArray() || !type2.cls.getComponentType().isAssignableFrom(componentCls)) continue;
                this.javaTypes.put(cls.getName(), type2);
                if (NucleusLogger.PERSISTENCE.isDebugEnabled()) {
                    NucleusLogger.PERSISTENCE.debug(Localiser.msg("016001", cls.getName(), type2.cls.getName()));
                }
                return type2;
            }
            if (!type2.cls.isAssignableFrom(cls) || type2.genericType != null) continue;
            this.javaTypes.put(cls.getName(), type2);
            if (NucleusLogger.PERSISTENCE.isDebugEnabled()) {
                NucleusLogger.PERSISTENCE.debug(Localiser.msg("016001", cls.getName(), type2.cls.getName()));
            }
            return type2;
        }
        return null;
    }

    protected JavaType findJavaTypeForCollectionClass(Class cls, Class genericType) {
        if (cls == null) {
            return null;
        }
        if (genericType == null) {
            return this.findJavaTypeForClass(cls);
        }
        String typeName = cls.getName() + "<" + genericType.getName() + ">";
        JavaType type2 = this.javaTypes.get(typeName);
        if (type2 != null) {
            return type2;
        }
        HashSet<JavaType> supportedTypes = new HashSet<JavaType>(this.javaTypes.values());
        for (JavaType type2 : supportedTypes) {
            if (!type2.cls.isAssignableFrom(cls) || type2.genericType == null || !type2.genericType.isAssignableFrom(genericType)) continue;
            this.javaTypes.put(typeName, type2);
            return type2;
        }
        return this.findJavaTypeForClass(cls);
    }

    private void loadJavaTypes(PluginManager mgr) {
        if (NucleusLogger.PERSISTENCE.isDebugEnabled()) {
            NucleusLogger.PERSISTENCE.debug(Localiser.msg("016003"));
        }
        ClassLoaderResolver clr = this.getClassLoaderResolver();
        ConfigurationElement[] elems = mgr.getConfigurationElementsForExtension("org.datanucleus.java_type", (String)null, (String)null);
        if (elems != null) {
            for (int i = 0; i < elems.length; ++i) {
                String javaName = elems[i].getAttribute("name").trim();
                String genericTypeName = elems[i].getAttribute("generic-type");
                String embeddedString = elems[i].getAttribute("embedded");
                String dfgString = elems[i].getAttribute("dfg");
                String wrapperType = elems[i].getAttribute("wrapper-type");
                String wrapperTypeBacked = elems[i].getAttribute("wrapper-type-backed");
                String typeConverterName = elems[i].getAttribute("converter-name");
                String containerHandlerType = elems[i].getAttribute("container-handler");
                boolean embedded = false;
                if (embeddedString != null && embeddedString.equalsIgnoreCase("true")) {
                    embedded = true;
                }
                boolean dfg = false;
                if (dfgString != null && dfgString.equalsIgnoreCase("true")) {
                    dfg = true;
                }
                wrapperType = !StringUtils.isWhitespace(wrapperType) ? wrapperType.trim() : null;
                wrapperTypeBacked = !StringUtils.isWhitespace(wrapperTypeBacked) ? wrapperTypeBacked.trim() : null;
                containerHandlerType = !StringUtils.isWhitespace(containerHandlerType) ? containerHandlerType.trim() : null;
                try {
                    Class cls = clr.classForName(javaName);
                    Class genericType = null;
                    String javaTypeName = cls.getName();
                    if (!StringUtils.isWhitespace(genericTypeName)) {
                        genericType = clr.classForName(genericTypeName);
                        javaTypeName = javaTypeName + "<" + genericTypeName + ">";
                    }
                    if (this.javaTypes.containsKey(javaTypeName)) continue;
                    Class wrapperClass = this.loadClass(mgr, elems, i, wrapperType, "016005");
                    Class wrapperClassBacked = this.loadClass(mgr, elems, i, wrapperTypeBacked, "016005");
                    Class containerHandlerClass = this.loadClass(mgr, elems, i, containerHandlerType, "016009");
                    String typeName = cls.getName();
                    if (genericType != null) {
                        typeName = typeName + "<" + genericType.getName() + ">";
                    }
                    this.javaTypes.put(typeName, new JavaType(cls, genericType, embedded, dfg, wrapperClass, wrapperClassBacked, containerHandlerClass, typeConverterName));
                    continue;
                }
                catch (ClassNotResolvedException cnre) {
                    NucleusLogger.PERSISTENCE.debug("Not enabling java type support for " + javaName + " : java type not present in CLASSPATH");
                    continue;
                }
                catch (Exception e) {
                    NucleusLogger.PERSISTENCE.debug("Not enabling java type support for " + javaName + " : " + e.getMessage());
                }
            }
        }
        if (NucleusLogger.PERSISTENCE.isDebugEnabled()) {
            ArrayList<String> typesList = new ArrayList<String>(this.javaTypes.keySet());
            Collections.sort(typesList, ALPHABETICAL_ORDER_STRING);
            NucleusLogger.PERSISTENCE.debug(Localiser.msg("016006", StringUtils.collectionToString(typesList)));
        }
    }

    private Class loadClass(PluginManager mgr, ConfigurationElement[] elems, int i, String className, String messageKey) {
        Class result = null;
        if (className != null) {
            try {
                result = mgr.loadClass(elems[i].getExtension().getPlugin().getSymbolicName(), className);
            }
            catch (NucleusException jpe) {
                NucleusLogger.PERSISTENCE.error(Localiser.msg(messageKey, className));
                throw new NucleusException(Localiser.msg(messageKey, className));
            }
        }
        return result;
    }

    private void loadTypeConverters(PluginManager mgr) {
        if (NucleusLogger.PERSISTENCE.isDebugEnabled()) {
            NucleusLogger.PERSISTENCE.debug(Localiser.msg("016007"));
        }
        ClassLoaderResolver clr = this.getClassLoaderResolver();
        ConfigurationElement[] elems = mgr.getConfigurationElementsForExtension("org.datanucleus.type_converter", (String)null, (String)null);
        if (elems != null) {
            for (int i = 0; i < elems.length; ++i) {
                String name = elems[i].getAttribute("name").trim();
                String memberTypeName = elems[i].getAttribute("member-type").trim();
                String datastoreTypeName = elems[i].getAttribute("datastore-type").trim();
                String converterClsName = elems[i].getAttribute("converter-class").trim();
                Class memberType = null;
                try {
                    TypeConverter conv = (TypeConverter)mgr.createExecutableExtension("org.datanucleus.type_converter", "name", name, "converter-class", null, null);
                    memberType = clr.classForName(memberTypeName);
                    Class datastoreType = clr.classForName(datastoreTypeName);
                    this.registerConverter(name, conv, memberType, datastoreType, false, null);
                    continue;
                }
                catch (Exception e) {
                    if (!NucleusLogger.PERSISTENCE.isDebugEnabled()) continue;
                    if (memberType != null) {
                        NucleusLogger.PERSISTENCE.debug("TypeConverter for " + memberTypeName + "<->" + datastoreTypeName + " using " + converterClsName + " not instantiable (missing dependencies?) so ignoring");
                        continue;
                    }
                    NucleusLogger.PERSISTENCE.debug("TypeConverter for " + memberTypeName + "<->" + datastoreTypeName + " ignored since java type not present in CLASSPATH");
                }
            }
        }
        if (NucleusLogger.PERSISTENCE.isDebugEnabled()) {
            NucleusLogger.PERSISTENCE.debug(Localiser.msg("016008"));
            if (this.typeConverterMap != null) {
                ArrayList<Class> typesList = new ArrayList<Class>(this.typeConverterMap.keySet());
                Collections.sort(typesList, ALPHABETICAL_ORDER);
                for (Class javaType : typesList) {
                    Set<Class> datastoreTypes = this.typeConverterMap.get(javaType).keySet();
                    StringBuilder str = new StringBuilder();
                    for (Class datastoreCls : datastoreTypes) {
                        if (str.length() > 0) {
                            str.append(',');
                        }
                        str.append(StringUtils.getNameOfClass(datastoreCls));
                    }
                    NucleusLogger.PERSISTENCE.debug("TypeConverter(s) available for " + StringUtils.getNameOfClass(javaType) + " to : " + str.toString());
                }
            }
        }
    }

    static class JavaType
    implements Serializable {
        private static final long serialVersionUID = -811442140006259453L;
        final Class cls;
        final Class genericType;
        final boolean embedded;
        final boolean dfg;
        final Class wrapperType;
        final Class wrapperTypeBacked;
        String typeConverterName;
        final Class containerHandlerType;

        public JavaType(Class cls, Class genericType, boolean embedded, boolean dfg, Class wrapperType, Class wrapperTypeBacked, Class containerHandlerType, String typeConverterName) {
            this.cls = cls;
            this.genericType = genericType;
            this.embedded = embedded;
            this.dfg = dfg;
            this.wrapperType = wrapperType;
            this.wrapperTypeBacked = wrapperTypeBacked != null ? wrapperTypeBacked : wrapperType;
            this.containerHandlerType = containerHandlerType;
            this.typeConverterName = typeConverterName;
        }
    }
}

