/*
 * Decompiled with CFR 0.152.
 */
package org.datanucleus.store.fieldmanager;

import java.util.Map;
import org.datanucleus.DetachState;
import org.datanucleus.ExecutionContext;
import org.datanucleus.FetchPlanForClass;
import org.datanucleus.FetchPlanState;
import org.datanucleus.api.ApiAdapter;
import org.datanucleus.metadata.AbstractMemberMetaData;
import org.datanucleus.metadata.MapMetaData;
import org.datanucleus.metadata.RelationType;
import org.datanucleus.state.ObjectProvider;
import org.datanucleus.store.fieldmanager.AbstractFetchDepthFieldManager;
import org.datanucleus.store.fieldmanager.SingleValueFieldManager;
import org.datanucleus.store.types.ContainerHandler;
import org.datanucleus.store.types.ElementContainerAdapter;
import org.datanucleus.store.types.MapContainerAdapter;
import org.datanucleus.store.types.SCO;
import org.datanucleus.store.types.SCOUtils;
import org.datanucleus.store.types.TypeManager;

public class DetachFieldManager
extends AbstractFetchDepthFieldManager {
    boolean copy = true;

    public DetachFieldManager(ObjectProvider op, boolean[] secondClassMutableFields, FetchPlanForClass fpClass, FetchPlanState state, boolean copy) {
        super(op, secondClassMutableFields, fpClass, state);
        this.copy = copy;
    }

    protected Object processPersistableCopy(Object pc) {
        ExecutionContext ec = this.op.getExecutionContext();
        ApiAdapter api = ec.getApiAdapter();
        if (!api.isDetached(pc) && api.isPersistent(pc)) {
            return ec.detachObjectCopy(pc, this.state);
        }
        return pc;
    }

    protected void processPersistable(Object pc) {
        ExecutionContext ec = this.op.getExecutionContext();
        ApiAdapter api = ec.getApiAdapter();
        if (!api.isDetached(pc) && api.isPersistent(pc)) {
            ec.detachObject(pc, this.state);
        }
    }

    @Override
    protected Object internalFetchObjectField(int fieldNumber) {
        SingleValueFieldManager sfv = new SingleValueFieldManager();
        this.op.provideFields(new int[]{fieldNumber}, sfv);
        Object value = sfv.fetchObjectField(fieldNumber);
        Object detachedValue = null;
        if (value != null) {
            AbstractMemberMetaData mmd = this.op.getClassMetaData().getMetaDataForManagedMemberAtAbsolutePosition(fieldNumber);
            detachedValue = mmd.hasContainer() ? this.processContainer(fieldNumber, value, mmd) : this.processField(fieldNumber, value, mmd);
        }
        return detachedValue;
    }

    private Object processField(int fieldNumber, Object value, AbstractMemberMetaData mmd) {
        RelationType relType = mmd.getRelationType(this.op.getExecutionContext().getClassLoaderResolver());
        if (relType == RelationType.NONE) {
            if (this.secondClassMutableFields[fieldNumber]) {
                if (!(value instanceof SCO)) {
                    value = SCOUtils.wrapSCOField(this.op, fieldNumber, value, true);
                }
                if (this.copy) {
                    return ((SCO)value).detachCopy(this.state);
                }
                return SCOUtils.detachAsWrapped(this.op) ? value : SCOUtils.unwrapSCOField(this.op, fieldNumber, (SCO)value);
            }
        } else {
            if (this.copy) {
                return this.processPersistableCopy(value);
            }
            this.processPersistable(value);
        }
        return value;
    }

    private Object processContainer(int fieldNumber, Object container, AbstractMemberMetaData mmd) {
        TypeManager typeManager = this.op.getExecutionContext().getTypeManager();
        Object containerHandler = typeManager.getContainerHandler(mmd.getType());
        Object detachedContainer = mmd.hasMap() ? this.processMapContainer(fieldNumber, container, mmd, (ContainerHandler<Object, MapContainerAdapter<Object>>)containerHandler) : this.processElementContainer(fieldNumber, container, mmd, (ContainerHandler<Object, ElementContainerAdapter<Object>>)containerHandler);
        if (!mmd.hasArray()) {
            Object wrappedContainer;
            if (SCOUtils.detachAsWrapped(this.op)) {
                detachedContainer = wrappedContainer = SCOUtils.wrapSCOField(this.op, fieldNumber, detachedContainer, true);
            } else {
                wrappedContainer = SCOUtils.wrapSCOField(this.op, fieldNumber, detachedContainer, false);
                if (detachedContainer instanceof SCO) {
                    detachedContainer = SCOUtils.unwrapSCOField(this.op, fieldNumber, (SCO)detachedContainer);
                }
            }
            if (wrappedContainer instanceof SCO) {
                ((SCO)wrappedContainer).unsetOwner();
            }
        }
        return detachedContainer;
    }

    private Object processElementContainer(int fieldNumber, Object container, AbstractMemberMetaData mmd, ContainerHandler<Object, ElementContainerAdapter<Object>> containerHandler) {
        Object detachedContainer;
        ElementContainerAdapter<Object> containerAdapter = containerHandler.getAdapter(container);
        if (this.copy) {
            detachedContainer = containerHandler.newContainer(mmd);
            ElementContainerAdapter<Object> copyAdapter = containerHandler.getAdapter(detachedContainer);
            for (Object t : containerAdapter) {
                copyAdapter.add(this.processPersistableCopy(t));
            }
            detachedContainer = copyAdapter.getContainer();
        } else {
            detachedContainer = container;
            for (Object t : containerAdapter) {
                this.processPersistable(t);
            }
        }
        return detachedContainer;
    }

    private Object processMapContainer(int fieldNumber, Object mapContainer, AbstractMemberMetaData mmd, ContainerHandler<Object, MapContainerAdapter<Object>> containerHandler) {
        Object detachedMapContainer;
        MapContainerAdapter<Object> mapAdapter = containerHandler.getAdapter(mapContainer);
        if (this.copy) {
            detachedMapContainer = containerHandler.newContainer(mmd);
            MapMetaData mapMd = mmd.getMap();
            MapContainerAdapter<Object> copyAdapter = containerHandler.getAdapter(detachedMapContainer);
            for (Map.Entry<Object, Object> entry : mapAdapter.entries()) {
                Object key = entry.getKey();
                if (mapMd.keyIsPersistent()) {
                    key = this.processPersistableCopy(key);
                }
                Object value = entry.getValue();
                if (mapMd.valueIsPersistent()) {
                    value = this.processPersistableCopy(value);
                }
                copyAdapter.put(key, value);
            }
            detachedMapContainer = copyAdapter.getContainer();
        } else {
            detachedMapContainer = mapContainer;
            MapMetaData mapMd = mmd.getMap();
            for (Map.Entry<Object, Object> entry : mapAdapter.entries()) {
                Object key = entry.getKey();
                if (mapMd.keyIsPersistent()) {
                    this.processPersistable(key);
                }
                Object value = entry.getValue();
                if (!mapMd.valueIsPersistent()) continue;
                this.processPersistable(value);
            }
        }
        return detachedMapContainer;
    }

    @Override
    protected Object endOfGraphOperation(int fieldNumber) {
        SingleValueFieldManager sfv = new SingleValueFieldManager();
        this.op.provideFields(new int[]{fieldNumber}, sfv);
        Object value = sfv.fetchObjectField(fieldNumber);
        ApiAdapter api = this.op.getExecutionContext().getApiAdapter();
        if (api.isPersistable(value)) {
            if (this.copy) {
                DetachState.Entry entry = ((DetachState)this.state).getDetachedCopyEntry(value);
                if (entry != null) {
                    return entry.getDetachedCopyObject();
                }
            } else if (this.op.getExecutionContext().getApiAdapter().isDetached(value)) {
                return value;
            }
        }
        throw new AbstractFetchDepthFieldManager.EndOfFetchPlanGraphException();
    }
}

