/*
 * Decompiled with CFR 0.152.
 */
package org.datanucleus.store;

import java.sql.Timestamp;
import org.datanucleus.exceptions.NucleusOptimisticException;
import org.datanucleus.exceptions.NucleusUserException;
import org.datanucleus.metadata.VersionMetaData;
import org.datanucleus.metadata.VersionStrategy;
import org.datanucleus.state.ObjectProvider;
import org.datanucleus.util.Localiser;
import org.datanucleus.util.NucleusLogger;

public class VersionHelper {
    public static final int VERSION_INITIAL_VALUE = 1;

    public static void performVersionCheck(ObjectProvider op, Object versionDatastore, VersionMetaData versionMetaData) {
        boolean valid;
        Object versionObject = op.getTransactionalVersion();
        if (versionObject == null) {
            return;
        }
        if (versionMetaData == null) {
            NucleusLogger.PERSISTENCE.info(op.getClassMetaData().getFullClassName() + " has no version metadata so no check of version is required, since this will not have the version flag in its table");
            return;
        }
        if (versionMetaData.getVersionStrategy() == VersionStrategy.DATE_TIME) {
            valid = ((Timestamp)versionObject).getTime() == ((Timestamp)versionDatastore).getTime();
        } else if (versionMetaData.getVersionStrategy() == VersionStrategy.VERSION_NUMBER) {
            valid = ((Number)versionObject).longValue() == ((Number)versionDatastore).longValue();
        } else {
            if (versionMetaData.getVersionStrategy() == VersionStrategy.STATE_IMAGE) {
                throw new NucleusUserException(Localiser.msg("032017", new Object[]{op.getClassMetaData().getFullClassName(), versionMetaData.getVersionStrategy()}));
            }
            throw new NucleusUserException(Localiser.msg("032017", new Object[]{op.getClassMetaData().getFullClassName(), versionMetaData.getVersionStrategy()}));
        }
        if (!valid) {
            String msg = Localiser.msg("032016", op.getObjectAsPrintable(), op.getInternalObjectId(), "" + versionDatastore, "" + versionObject);
            NucleusLogger.PERSISTENCE.error(msg);
            throw new NucleusOptimisticException(msg, op.getObject());
        }
    }

    public static Object getNextVersion(VersionStrategy versionStrategy, Object currentVersion) {
        if (versionStrategy == null) {
            return null;
        }
        if (versionStrategy == VersionStrategy.NONE) {
            if (currentVersion == null) {
                return 1L;
            }
            if (currentVersion instanceof Integer) {
                return (Integer)currentVersion + 1;
            }
            return (Long)currentVersion + 1L;
        }
        if (versionStrategy == VersionStrategy.DATE_TIME) {
            return new Timestamp(System.currentTimeMillis());
        }
        if (versionStrategy == VersionStrategy.VERSION_NUMBER) {
            if (currentVersion == null) {
                return 1L;
            }
            if (currentVersion instanceof Integer) {
                return (Integer)currentVersion + 1;
            }
            return (Long)currentVersion + 1L;
        }
        if (versionStrategy == VersionStrategy.STATE_IMAGE) {
            throw new NucleusUserException("DataNucleus doesnt currently support version strategy \"state-image\"");
        }
        throw new NucleusUserException("Unknown version strategy - not supported");
    }
}

