/*
 * Decompiled with CFR 0.152.
 */
package org.datanucleus.cache;

import java.util.Iterator;
import java.util.List;
import java.util.Map;
import javax.cache.Cache;
import javax.cache.CacheException;
import javax.cache.CacheManager;
import javax.cache.Caching;
import javax.cache.configuration.MutableConfiguration;
import javax.cache.spi.CachingProvider;
import org.datanucleus.Configuration;
import org.datanucleus.NucleusContext;
import org.datanucleus.exceptions.NucleusException;
import org.datanucleus.query.QueryUtils;
import org.datanucleus.store.query.Query;
import org.datanucleus.store.query.cache.QueryResultsCache;
import org.datanucleus.util.NucleusLogger;

public class JavaxCacheQueryResultCache
implements QueryResultsCache {
    private static final long serialVersionUID = -3967431477335678467L;
    private Cache cache;

    public JavaxCacheQueryResultCache(NucleusContext nucleusCtx) {
        Configuration conf = nucleusCtx.getConfiguration();
        String cacheName = conf.getStringProperty("datanucleus.cache.queryResults.cacheName");
        if (cacheName == null) {
            NucleusLogger.CACHE.warn("No 'datanucleus.cache.queryResults.cacheName' specified so using name of 'DataNucleus-Query'");
            cacheName = "datanucleus-query";
        }
        try {
            CachingProvider cacheProvider = Caching.getCachingProvider();
            CacheManager cacheMgr = cacheProvider.getCacheManager();
            Cache tmpcache = cacheMgr.getCache(cacheName);
            if (tmpcache == null) {
                MutableConfiguration cacheConfig = new MutableConfiguration();
                cacheMgr.createCache(cacheName, (javax.cache.configuration.Configuration)cacheConfig);
                tmpcache = cacheMgr.getCache(cacheName);
            }
            this.cache = tmpcache;
        }
        catch (CacheException e) {
            throw new NucleusException("Error creating cache", e);
        }
    }

    @Override
    public void close() {
        this.evictAll();
        this.cache = null;
    }

    @Override
    public boolean contains(String queryKey) {
        return this.get(queryKey) != null;
    }

    @Override
    public void evict(Class candidate) {
    }

    @Override
    public synchronized void evict(Query query) {
        String baseKey = QueryUtils.getKeyForQueryResultsCache(query, null);
        Iterator entryIter = this.cache.iterator();
        while (entryIter.hasNext()) {
            Cache.Entry entry = (Cache.Entry)entryIter.next();
            String key = (String)entry.getKey();
            if (!key.startsWith(baseKey)) continue;
            entryIter.remove();
        }
    }

    @Override
    public synchronized void evict(Query query, Map params) {
        String key = QueryUtils.getKeyForQueryResultsCache(query, params);
        this.cache.remove((Object)key);
    }

    @Override
    public synchronized void evictAll() {
        this.cache.removeAll();
    }

    @Override
    public void pin(Query query, Map params) {
    }

    @Override
    public void pin(Query query) {
    }

    @Override
    public void unpin(Query query, Map params) {
    }

    @Override
    public void unpin(Query query) {
    }

    @Override
    public List<Object> get(String queryKey) {
        return (List)this.cache.get((Object)queryKey);
    }

    @Override
    public boolean isEmpty() {
        return this.size() == 0;
    }

    @Override
    public synchronized List<Object> put(String queryKey, List<Object> results) {
        if (queryKey == null || results == null) {
            return null;
        }
        try {
            this.cache.put((Object)queryKey, results);
        }
        catch (RuntimeException re) {
            NucleusLogger.CACHE.info("Query results with key '" + queryKey + "' not cached. " + re.getMessage());
        }
        return results;
    }

    @Override
    public int size() {
        throw new UnsupportedOperationException("size() method not supported by this plugin");
    }
}

