/*
 * Decompiled with CFR 0.152.
 */
package org.datanucleus.query.inmemory;

import java.time.LocalDate;
import java.time.LocalDateTime;
import java.util.Calendar;
import java.util.Date;
import org.datanucleus.exceptions.NucleusException;
import org.datanucleus.exceptions.NucleusUserException;
import org.datanucleus.query.expression.InvokeExpression;
import org.datanucleus.query.inmemory.InMemoryExpressionEvaluator;
import org.datanucleus.query.inmemory.InvocationEvaluator;
import org.datanucleus.util.Localiser;

public class TemporalDayMethod
implements InvocationEvaluator {
    @Override
    public Object evaluate(InvokeExpression expr, Object invokedValue, InMemoryExpressionEvaluator eval) {
        if (invokedValue == null) {
            return Boolean.FALSE;
        }
        if (!(invokedValue instanceof Date)) {
            throw new NucleusException(Localiser.msg("021011", expr.getOperation(), invokedValue.getClass().getName()));
        }
        if (invokedValue instanceof Date) {
            Calendar cal = Calendar.getInstance();
            cal.setTime((Date)invokedValue);
            return cal.get(5);
        }
        if (invokedValue instanceof Calendar) {
            return ((Calendar)invokedValue).get(5);
        }
        if (invokedValue instanceof LocalDate) {
            return ((LocalDate)invokedValue).getDayOfMonth();
        }
        if (invokedValue instanceof LocalDateTime) {
            return ((LocalDateTime)invokedValue).getDayOfMonth();
        }
        throw new NucleusUserException("We do not currently support DAY() with argument of type " + invokedValue.getClass().getName());
    }
}

