/*
 * Decompiled with CFR 0.152.
 */
package org.datanucleus.store.valuegenerator;

import java.net.InetAddress;
import java.util.Properties;
import org.datanucleus.store.valuegenerator.AbstractGenerator;
import org.datanucleus.store.valuegenerator.ValueGenerationBlock;
import org.datanucleus.util.Localiser;
import org.datanucleus.util.NucleusLogger;
import org.datanucleus.util.TypeConversionHelper;

public abstract class AbstractUUIDGenerator
extends AbstractGenerator<String> {
    static final int IP_ADDRESS;
    static final int JVM_UNIQUE;
    static short counter;

    public AbstractUUIDGenerator(String name, Properties props) {
        super(name, props);
    }

    public static Class getStorageClass() {
        return String.class;
    }

    @Override
    protected ValueGenerationBlock<String> reserveBlock(long size) {
        Object[] ids = new Object[(int)size];
        int i = 0;
        while ((long)i < size) {
            ids[i] = this.getIdentifier();
            ++i;
        }
        if (NucleusLogger.VALUEGENERATION.isDebugEnabled()) {
            NucleusLogger.VALUEGENERATION.debug(Localiser.msg("040004", "" + size));
        }
        return new ValueGenerationBlock<Object>(ids);
    }

    protected abstract String getIdentifier();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected short getCount() {
        Class<AbstractUUIDGenerator> clazz = AbstractUUIDGenerator.class;
        synchronized (AbstractUUIDGenerator.class) {
            if (counter < 0) {
                counter = 0;
            }
            short s = counter;
            counter = (short)(s + 1);
            // ** MonitorExit[var1_1] (shouldn't be in output)
            return s;
        }
    }

    static {
        int ipAddr = 0;
        try {
            ipAddr = TypeConversionHelper.getIntFromByteArray(InetAddress.getLocalHost().getAddress());
        }
        catch (Exception e) {
            ipAddr = 0;
        }
        IP_ADDRESS = ipAddr;
        JVM_UNIQUE = (int)(System.currentTimeMillis() >>> 8);
        counter = 0;
    }
}

