/*
 * Decompiled with CFR 0.152.
 */
package org.datanucleus.store.types.converters;

import java.time.LocalDateTime;
import java.util.Calendar;
import java.util.Date;
import org.datanucleus.store.types.converters.TypeConverter;

public class LocalDateTimeDateConverter
implements TypeConverter<LocalDateTime, Date> {
    private static final long serialVersionUID = -2827944255601470964L;

    @Override
    public LocalDateTime toMemberType(Date date) {
        if (date == null) {
            return null;
        }
        Calendar cal = Calendar.getInstance();
        cal.setTime(date);
        return LocalDateTime.of(cal.get(1), cal.get(2) + 1, cal.get(5), cal.get(11), cal.get(12), cal.get(13), cal.get(14) * 1000000);
    }

    @Override
    public Date toDatastoreType(LocalDateTime datetime) {
        if (datetime == null) {
            return null;
        }
        Calendar cal = Calendar.getInstance();
        cal.set(datetime.getYear(), datetime.getMonth().ordinal(), datetime.getDayOfMonth(), datetime.getHour(), datetime.getMinute(), datetime.getSecond());
        cal.set(14, datetime.getNano() / 1000000);
        return new Date(cal.getTimeInMillis());
    }
}

