/*
 * Decompiled with CFR 0.152.
 */
package org.datanucleus.store.types.converters;

import java.time.LocalDate;
import java.util.Calendar;
import java.util.Date;
import org.datanucleus.store.types.converters.TypeConverter;

public class LocalDateDateConverter
implements TypeConverter<LocalDate, Date> {
    private static final long serialVersionUID = -7505431105592812715L;

    @Override
    public LocalDate toMemberType(Date date) {
        if (date == null) {
            return null;
        }
        Calendar cal = Calendar.getInstance();
        cal.setTime(date);
        LocalDate localDate = LocalDate.of(cal.get(1), cal.get(2) + 1, cal.get(5));
        return localDate;
    }

    @Override
    public Date toDatastoreType(LocalDate localDate) {
        if (localDate == null) {
            return null;
        }
        Calendar cal = Calendar.getInstance();
        cal.set(localDate.getYear(), localDate.getMonth().ordinal(), localDate.getDayOfMonth());
        return new Date(cal.getTimeInMillis());
    }
}

