/**********************************************************************
Copyright (c) 2008 Andy Jefferson and others. All rights reserved.
Licensed under the Apache License, Version 2.0 (the "License");
you may not use this file except in compliance with the License.
You may obtain a copy of the License at

    http://www.apache.org/licenses/LICENSE-2.0

Unless required by applicable law or agreed to in writing, software
distributed under the License is distributed on an "AS IS" BASIS,
WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
See the License for the specific language governing permissions and
limitations under the License.

Contributors:
    ...
**********************************************************************/
package org.datanucleus.store.types.converters;

import java.util.Currency;

/**
 * Class to handle the conversion between java.util.Currency and a String form.
 */
public class CurrencyStringConverter implements TypeConverter<Currency, String>, ColumnLengthDefiningTypeConverter
{
    private static final long serialVersionUID = 466510473779336706L;

    public Currency toMemberType(String str)
    {
        if (str == null)
        {
            return null;
        }

        return java.util.Currency.getInstance(str);
    }

    public String toDatastoreType(Currency curr)
    {
        return curr != null ? curr.toString() : null;
    }

    public int getDefaultColumnLength(int columnPosition)
    {
        if (columnPosition != 0)
        {
            return -1;
        }
        // ISO4217 currencies use 3 character codes, so return 3.
        return 3;
    }
}