/*
 * Decompiled with CFR 0.152.
 */
package org.datanucleus.query.compiler;

import java.math.BigDecimal;
import java.math.BigInteger;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Deque;
import java.util.List;
import java.util.Map;
import java.util.StringTokenizer;
import org.datanucleus.exceptions.NucleusException;
import org.datanucleus.exceptions.NucleusUserException;
import org.datanucleus.query.JDOQLQueryHelper;
import org.datanucleus.query.compiler.Lexer;
import org.datanucleus.query.compiler.Node;
import org.datanucleus.query.compiler.NodeType;
import org.datanucleus.query.compiler.ParameterNode;
import org.datanucleus.query.compiler.Parser;
import org.datanucleus.store.query.QueryCompilerSyntaxException;
import org.datanucleus.util.Localiser;
import org.datanucleus.util.StringUtils;

public class JDOQLParser
implements Parser {
    private static String[] jdoqlMethodNames = new String[]{"contains", "get", "containsKey", "containsValue", "isEmpty", "size", "toLowerCase", "toUpperCase", "indexOf", "matches", "substring", "startsWith", "endsWith", "getObjectId", "abs", "sqrt"};
    private ParameterType paramType = ParameterType.IMPLICIT;
    private String jdoqlMode = "DataNucleus";
    private Lexer p;
    private Deque<Node> stack = new ArrayDeque<Node>();
    private static String paramPrefixes = ":";
    private boolean allowSingleEquals = false;
    private List<Object> parameterNameList = null;

    public JDOQLParser(Map options) {
        if (options != null && options.containsKey("jdoql.level")) {
            this.jdoqlMode = (String)options.get("jdoql.level");
        }
        if (options != null && options.containsKey("explicitParameters")) {
            this.paramType = ParameterType.EXPLICIT;
        }
    }

    public void allowSingleEquals(boolean flag) {
        this.allowSingleEquals = flag;
    }

    @Override
    public Node parse(String expression) {
        this.p = new Lexer(expression, paramPrefixes, true);
        this.stack = new ArrayDeque<Node>();
        Node result = this.processExpression();
        if (this.p.ci.getIndex() != this.p.ci.getEndIndex()) {
            String unparsed = this.p.getInput().substring(this.p.ci.getIndex());
            throw new QueryCompilerSyntaxException("Portion of expression could not be parsed: " + unparsed);
        }
        return result;
    }

    @Override
    public Node parseVariable(String expression) {
        this.p = new Lexer(expression, paramPrefixes, true);
        this.stack = new ArrayDeque<Node>();
        if (!this.processIdentifier()) {
            throw new QueryCompilerSyntaxException("expected identifier", this.p.getIndex(), this.p.getInput());
        }
        if (!this.processIdentifier()) {
            throw new QueryCompilerSyntaxException("expected identifier", this.p.getIndex(), this.p.getInput());
        }
        Node nodeVariable = this.stack.pop();
        Node nodeType = this.stack.pop();
        nodeType.appendChildNode(nodeVariable);
        return nodeType;
    }

    @Override
    public Node[] parseFrom(String expression) {
        this.p = new Lexer(expression, paramPrefixes, true);
        this.stack = new ArrayDeque<Node>();
        return this.processFromExpression();
    }

    private Node[] processFromExpression() {
        this.processExpression();
        Node id = this.stack.pop();
        StringBuilder className = new StringBuilder(id.getNodeValue().toString());
        while (id.getChildNodes().size() > 0) {
            id = id.getFirstChild();
            className.append(".").append(id.getNodeValue().toString());
        }
        String alias = this.p.parseIdentifier();
        if (alias != null && alias.equalsIgnoreCase("AS")) {
            alias = this.p.parseIdentifier();
        }
        if (alias == null) {
            alias = "this";
        }
        Node classNode = new Node(NodeType.CLASS, className.toString());
        Node aliasNode = new Node(NodeType.NAME, alias);
        classNode.insertChildNode(aliasNode);
        this.stack.push(classNode);
        return new Node[]{classNode};
    }

    @Override
    public Node[] parseUpdate(String expression) {
        return null;
    }

    @Override
    public Node[] parseOrder(String expression) {
        this.p = new Lexer(expression, paramPrefixes, true);
        this.stack = new ArrayDeque<Node>();
        return this.processOrderExpression();
    }

    @Override
    public Node[] parseResult(String expression) {
        this.p = new Lexer(expression, paramPrefixes, true);
        this.stack = new ArrayDeque<Node>();
        ArrayList<Node> nodes = new ArrayList<Node>();
        do {
            this.processExpression();
            Node expr = this.stack.pop();
            String alias = this.p.parseIdentifier();
            if (alias != null && alias.equalsIgnoreCase("AS")) {
                alias = this.p.parseIdentifier();
            }
            if (alias != null) {
                Node aliasNode = new Node(NodeType.NAME, alias);
                expr.appendChildNode(aliasNode);
            }
            nodes.add(expr);
        } while (this.p.parseString(","));
        return nodes.toArray(new Node[nodes.size()]);
    }

    @Override
    public Node[] parseTuple(String expression) {
        this.p = new Lexer(expression, paramPrefixes, true);
        this.stack = new ArrayDeque<Node>();
        ArrayList<Node> nodes = new ArrayList<Node>();
        do {
            this.processExpression();
            Node expr = this.stack.pop();
            nodes.add(expr);
        } while (this.p.parseString(","));
        return nodes.toArray(new Node[nodes.size()]);
    }

    @Override
    public Node[][] parseVariables(String expression) {
        this.p = new Lexer(expression, paramPrefixes, true);
        ArrayList<Node[]> nodes = new ArrayList<Node[]>();
        while (!StringUtils.isWhitespace(this.p.remaining())) {
            this.processPrimary();
            if (this.stack.isEmpty()) {
                throw new QueryCompilerSyntaxException("Parsing variable list and expected variable type", this.p.getIndex(), this.p.getInput());
            }
            if (!this.processIdentifier()) {
                throw new QueryCompilerSyntaxException("Parsing variable list and expected variable name", this.p.getIndex(), this.p.getInput());
            }
            Node nodeVariable = this.stack.pop();
            String varName = (String)nodeVariable.getNodeValue();
            if (!JDOQLQueryHelper.isValidJavaIdentifierForJDOQL(varName)) {
                throw new NucleusUserException(Localiser.msg("021105", varName));
            }
            Node nodeType = this.stack.pop();
            nodes.add(new Node[]{nodeType, nodeVariable});
            if (this.p.parseString(";")) continue;
        }
        return (Node[][])nodes.toArray((T[])new Node[nodes.size()][2]);
    }

    @Override
    public Node[][] parseParameters(String expression) {
        ArrayList<Node[]> nodes = new ArrayList<Node[]>();
        StringTokenizer tokeniser = new StringTokenizer(expression, ",");
        while (tokeniser.hasMoreTokens()) {
            String token = tokeniser.nextToken();
            StringTokenizer subTokeniser = new StringTokenizer(token, " ");
            if (subTokeniser.countTokens() != 2) {
                throw new QueryCompilerSyntaxException(Localiser.msg("021101", expression));
            }
            String classDecl = subTokeniser.nextToken();
            String parameterName = subTokeniser.nextToken();
            Node declNode = new Node(NodeType.IDENTIFIER, classDecl);
            Node nameNode = new Node(NodeType.IDENTIFIER, parameterName);
            nodes.add(new Node[]{declNode, nameNode});
        }
        return (Node[][])nodes.toArray((T[])new Node[nodes.size()][2]);
    }

    private Node[] processOrderExpression() {
        ArrayList<Node> nodes = new ArrayList<Node>();
        do {
            this.processExpression();
            Node directionNode = null;
            directionNode = this.p.parseString("ascending") || this.p.parseString("asc") || this.p.parseString("ASCENDING") || this.p.parseString("ASC") ? new Node(NodeType.OPERATOR, "ascending") : (this.p.parseString("descending") || this.p.parseString("desc") || this.p.parseString("DESCENDING") || this.p.parseString("DESC") ? new Node(NodeType.OPERATOR, "descending") : new Node(NodeType.OPERATOR, "ascending"));
            Node nullsNode = null;
            if (this.p.parseString("NULLS FIRST") || this.p.parseString("nulls first")) {
                nullsNode = new Node(NodeType.OPERATOR, "nulls first");
            } else if (this.p.parseString("NULLS LAST") || this.p.parseString("nulls last")) {
                nullsNode = new Node(NodeType.OPERATOR, "nulls last");
            }
            Node expr = new Node(NodeType.OPERATOR, "order");
            expr.insertChildNode(directionNode);
            if (nullsNode != null) {
                expr.appendChildNode(nullsNode);
            }
            if (!this.stack.isEmpty()) {
                expr.insertChildNode(this.stack.pop());
            }
            nodes.add(expr);
        } while (this.p.parseChar(','));
        return nodes.toArray(new Node[nodes.size()]);
    }

    private Node processExpression() {
        this.processConditionalOrExpression();
        return this.stack.peek();
    }

    private void processConditionalOrExpression() {
        this.processConditionalAndExpression();
        while (this.p.parseString("||")) {
            this.processConditionalAndExpression();
            Node expr = new Node(NodeType.OPERATOR, "||");
            expr.insertChildNode(this.stack.pop());
            expr.insertChildNode(this.stack.pop());
            this.stack.push(expr);
        }
    }

    private void processConditionalAndExpression() {
        this.processInclusiveOrExpression();
        while (this.p.parseString("&&")) {
            this.processInclusiveOrExpression();
            Node expr = new Node(NodeType.OPERATOR, "&&");
            expr.insertChildNode(this.stack.pop());
            expr.insertChildNode(this.stack.pop());
            this.stack.push(expr);
        }
    }

    private void processInclusiveOrExpression() {
        this.processExclusiveOrExpression();
        while (this.p.parseChar('|', '|')) {
            this.processExclusiveOrExpression();
            Node expr = new Node(NodeType.OPERATOR, "|");
            expr.insertChildNode(this.stack.pop());
            expr.insertChildNode(this.stack.pop());
            this.stack.push(expr);
        }
    }

    private void processExclusiveOrExpression() {
        this.processAndExpression();
        while (this.p.parseChar('^')) {
            this.processAndExpression();
            Node expr = new Node(NodeType.OPERATOR, "^");
            expr.insertChildNode(this.stack.pop());
            expr.insertChildNode(this.stack.pop());
            this.stack.push(expr);
        }
    }

    private void processAndExpression() {
        this.processRelationalExpression();
        while (this.p.parseChar('&', '&')) {
            this.processRelationalExpression();
            Node expr = new Node(NodeType.OPERATOR, "&");
            expr.insertChildNode(this.stack.pop());
            expr.insertChildNode(this.stack.pop());
            this.stack.push(expr);
        }
    }

    private void processRelationalExpression() {
        this.processAdditiveExpression();
        while (true) {
            Node expr;
            if (this.p.parseString("==")) {
                this.processAdditiveExpression();
                expr = new Node(NodeType.OPERATOR, "==");
                expr.insertChildNode(this.stack.pop());
                expr.insertChildNode(this.stack.pop());
                this.stack.push(expr);
                continue;
            }
            if (this.p.parseString("!=")) {
                this.processAdditiveExpression();
                expr = new Node(NodeType.OPERATOR, "!=");
                expr.insertChildNode(this.stack.pop());
                expr.insertChildNode(this.stack.pop());
                this.stack.push(expr);
                continue;
            }
            if (this.p.parseString("=")) {
                if (this.allowSingleEquals) {
                    this.processAdditiveExpression();
                    expr = new Node(NodeType.OPERATOR, "==");
                    expr.insertChildNode(this.stack.pop());
                    expr.insertChildNode(this.stack.pop());
                    this.stack.push(expr);
                    continue;
                }
                throw new QueryCompilerSyntaxException("Invalid operator \"=\". Did you mean to use \"==\"?");
            }
            if (this.p.parseString("<=")) {
                this.processAdditiveExpression();
                expr = new Node(NodeType.OPERATOR, "<=");
                expr.insertChildNode(this.stack.pop());
                expr.insertChildNode(this.stack.pop());
                this.stack.push(expr);
                continue;
            }
            if (this.p.parseString(">=")) {
                this.processAdditiveExpression();
                expr = new Node(NodeType.OPERATOR, ">=");
                expr.insertChildNode(this.stack.pop());
                expr.insertChildNode(this.stack.pop());
                this.stack.push(expr);
                continue;
            }
            if (this.p.parseChar('<')) {
                this.processAdditiveExpression();
                expr = new Node(NodeType.OPERATOR, "<");
                expr.insertChildNode(this.stack.pop());
                expr.insertChildNode(this.stack.pop());
                this.stack.push(expr);
                continue;
            }
            if (this.p.parseChar('>')) {
                this.processAdditiveExpression();
                expr = new Node(NodeType.OPERATOR, ">");
                expr.insertChildNode(this.stack.pop());
                expr.insertChildNode(this.stack.pop());
                this.stack.push(expr);
                continue;
            }
            if (!this.p.parseString("instanceof")) break;
            this.processAdditiveExpression();
            expr = new Node(NodeType.OPERATOR, "instanceof");
            expr.insertChildNode(this.stack.pop());
            expr.insertChildNode(this.stack.pop());
            this.stack.push(expr);
        }
    }

    protected void processAdditiveExpression() {
        this.processMultiplicativeExpression();
        while (true) {
            Node expr;
            if (this.p.parseChar('+')) {
                this.processMultiplicativeExpression();
                expr = new Node(NodeType.OPERATOR, "+");
                expr.insertChildNode(this.stack.pop());
                expr.insertChildNode(this.stack.pop());
                this.stack.push(expr);
                continue;
            }
            if (!this.p.parseChar('-')) break;
            this.processMultiplicativeExpression();
            expr = new Node(NodeType.OPERATOR, "-");
            expr.insertChildNode(this.stack.pop());
            expr.insertChildNode(this.stack.pop());
            this.stack.push(expr);
        }
    }

    protected void processMultiplicativeExpression() {
        this.processUnaryExpression();
        while (true) {
            Node expr;
            if (this.p.parseChar('*')) {
                this.processUnaryExpression();
                expr = new Node(NodeType.OPERATOR, "*");
                expr.insertChildNode(this.stack.pop());
                expr.insertChildNode(this.stack.pop());
                this.stack.push(expr);
                continue;
            }
            if (this.p.parseChar('/')) {
                this.processUnaryExpression();
                expr = new Node(NodeType.OPERATOR, "/");
                expr.insertChildNode(this.stack.pop());
                expr.insertChildNode(this.stack.pop());
                this.stack.push(expr);
                continue;
            }
            if (!this.p.parseChar('%')) break;
            this.processUnaryExpression();
            expr = new Node(NodeType.OPERATOR, "%");
            expr.insertChildNode(this.stack.pop());
            expr.insertChildNode(this.stack.pop());
            this.stack.push(expr);
        }
    }

    protected void processUnaryExpression() {
        if (this.p.parseString("++")) {
            throw new QueryCompilerSyntaxException("Unsupported operator '++'");
        }
        if (this.p.parseString("--")) {
            throw new QueryCompilerSyntaxException("Unsupported operator '--'");
        }
        if (this.p.parseChar('+')) {
            this.processUnaryExpression();
        } else if (this.p.parseChar('-')) {
            this.processUnaryExpression();
            Node expr = new Node(NodeType.OPERATOR, "-");
            expr.insertChildNode(this.stack.pop());
            this.stack.push(expr);
        } else if (this.p.parseChar('~')) {
            this.processUnaryExpression();
            Node expr = new Node(NodeType.OPERATOR, "~");
            expr.insertChildNode(this.stack.pop());
            this.stack.push(expr);
        } else if (this.p.parseChar('!')) {
            this.processUnaryExpression();
            Node expr = new Node(NodeType.OPERATOR, "!");
            expr.insertChildNode(this.stack.pop());
            this.stack.push(expr);
        } else {
            this.processPrimary();
        }
    }

    protected void processPrimary() {
        if (this.p.parseString("DISTINCT ") || this.p.parseString("distinct")) {
            Node distinctNode = new Node(NodeType.OPERATOR, "DISTINCT");
            this.processExpression();
            Node identifierNode = this.stack.pop();
            distinctNode.appendChildNode(identifierNode);
            this.stack.push(distinctNode);
            return;
        }
        Node castNode = null;
        if (this.processCast()) {
            castNode = this.stack.pop();
        }
        if (this.p.peekString("IF(") || this.p.peekString("if(") || this.p.peekString("IF (") || this.p.peekString("if (")) {
            this.processIfElseExpression();
            return;
        }
        if (this.processCreator()) {
            boolean endOfChain = false;
            while (!endOfChain) {
                if (this.p.parseChar('.')) {
                    if (!this.processMethod()) continue;
                    Node invokeNode = this.stack.pop();
                    Node invokedNode = this.stack.peek();
                    invokedNode.appendChildNode(invokeNode);
                    continue;
                }
                endOfChain = true;
            }
            if (castNode != null) {
                throw new NucleusException("Dont currently support compile of cast of creator expression");
            }
            return;
        }
        if (this.processLiteral()) {
            boolean endOfChain = false;
            while (!endOfChain) {
                if (this.p.parseChar('.')) {
                    if (!this.processMethod()) continue;
                    Node invokeNode = this.stack.pop();
                    Node invokedNode = this.stack.peek();
                    invokedNode.appendChildNode(invokeNode);
                    continue;
                }
                endOfChain = true;
            }
            if (castNode != null) {
                throw new NucleusException("Dont currently support compile of cast of literal expression");
            }
            return;
        }
        if (this.processMethod()) {
            if (castNode != null) {
                throw new NucleusException("Dont currently support compile of cast of static method call");
            }
            return;
        }
        if (this.processArray()) {
            boolean endOfChain = false;
            while (!endOfChain) {
                if (this.p.parseChar('.')) {
                    if (!this.processMethod()) continue;
                    Node invokeNode = this.stack.pop();
                    Node invokedNode = this.stack.peek();
                    invokedNode.appendChildNode(invokeNode);
                    continue;
                }
                endOfChain = true;
            }
            if (castNode != null) {
                throw new NucleusException("Dont currently support compile of cast of array expression");
            }
            return;
        }
        int sizeBeforeBraceProcessing = this.stack.size();
        boolean braceProcessing = false;
        if (this.p.parseChar('(')) {
            this.processExpression();
            if (!this.p.parseChar(')')) {
                throw new QueryCompilerSyntaxException("expected ')'", this.p.getIndex(), this.p.getInput());
            }
            if (!this.p.parseChar('.')) {
                return;
            }
            braceProcessing = true;
        }
        if (!this.processMethod() && !this.processIdentifier()) {
            throw new QueryCompilerSyntaxException("Method/Identifier expected", this.p.getIndex(), this.p.getInput());
        }
        int size = this.stack.size();
        if (braceProcessing) {
            size = sizeBeforeBraceProcessing + 1;
        }
        while (this.p.parseChar('.')) {
            if (this.processMethod() || this.processIdentifier()) continue;
            throw new QueryCompilerSyntaxException("Identifier expected", this.p.getIndex(), this.p.getInput());
        }
        if (castNode != null) {
            this.stack.peek().appendChildNode(castNode);
        }
        while (this.stack.size() > size) {
            Node top = this.stack.pop();
            Node peek = this.stack.peek();
            Node lastDescendant = this.getLastDescendantNodeForNode(peek);
            if (lastDescendant != null) {
                lastDescendant.appendChildNode(top);
                continue;
            }
            Node primNode = new Node(NodeType.PRIMARY);
            primNode.appendChildNode(peek);
            primNode.appendChildNode(top);
            this.stack.pop();
            this.stack.push(primNode);
        }
    }

    private Node getLastDescendantNodeForNode(Node node) {
        if (node == null) {
            return null;
        }
        if (node.getChildNodes() == null) {
            return node;
        }
        if (node.getChildNodes().size() > 1) {
            return null;
        }
        if (!node.hasNextChild()) {
            return node;
        }
        return this.getLastDescendantNodeForNode(node.getChildNode(0));
    }

    private void processIfElseExpression() {
        Node caseNode = new Node(NodeType.CASE);
        if (!this.p.parseString("IF") || this.p.parseString("if")) {
            throw new QueryCompilerSyntaxException("Expected IF or if", this.p.getIndex(), this.p.getInput());
        }
        if (!this.p.parseChar('(')) {
            throw new QueryCompilerSyntaxException("Expected '(' as part of IF (...)", this.p.getIndex(), this.p.getInput());
        }
        this.processExpression();
        Node whenNode = this.stack.pop();
        caseNode.appendChildNode(whenNode);
        if (!this.p.parseChar(')')) {
            throw new QueryCompilerSyntaxException("Expected ')' as part of IF (...)", this.p.getIndex(), this.p.getInput());
        }
        this.processExpression();
        Node actionNode = this.stack.pop();
        caseNode.appendChildNode(actionNode);
        boolean elseClause = false;
        while (this.p.parseString("ELSE") || this.p.parseString("else")) {
            boolean hasIf = false;
            if (this.p.parseString("IF") || this.p.parseString("if")) {
                hasIf = true;
                if (!this.p.parseChar('(')) {
                    throw new QueryCompilerSyntaxException("Expected '(' as part of IF (...)", this.p.getIndex(), this.p.getInput());
                }
                this.processExpression();
                whenNode = this.stack.pop();
                caseNode.appendChildNode(whenNode);
                if (!this.p.parseChar(')')) {
                    throw new QueryCompilerSyntaxException("Expected ')' as part of IF (...)", this.p.getIndex(), this.p.getInput());
                }
            }
            this.processExpression();
            actionNode = this.stack.pop();
            caseNode.appendChildNode(actionNode);
            if (hasIf) continue;
            elseClause = true;
        }
        if (!elseClause) {
            throw new QueryCompilerSyntaxException("Use of IF {expr} ELSE IF {expr} structure should always terminate with ELSE {expr} but doesn't", this.p.getIndex(), this.p.getInput());
        }
        this.stack.push(caseNode);
    }

    private boolean processCast() {
        String typeName = this.p.parseCast();
        if (typeName == null) {
            return false;
        }
        Node castNode = new Node(NodeType.CAST, typeName);
        this.stack.push(castNode);
        return true;
    }

    private boolean processCreator() {
        if (this.p.parseString("new ")) {
            int size = this.stack.size();
            if (!this.processMethod()) {
                if (!this.processIdentifier()) {
                    throw new QueryCompilerSyntaxException("Identifier expected", this.p.getIndex(), this.p.getInput());
                }
                while (this.p.parseChar('.')) {
                    if (this.processMethod() || this.processIdentifier()) continue;
                    throw new QueryCompilerSyntaxException("Identifier expected", this.p.getIndex(), this.p.getInput());
                }
            }
            while (this.stack.size() - 1 > size) {
                Node top = this.stack.pop();
                Node peek = this.stack.peek();
                peek.insertChildNode(top);
            }
            Node expr = this.stack.pop();
            Node newExpr = new Node(NodeType.CREATOR);
            newExpr.insertChildNode(expr);
            this.stack.push(newExpr);
            return true;
        }
        return false;
    }

    private boolean processMethod() {
        String method = this.p.parseMethod();
        if (method != null) {
            this.p.skipWS();
            this.p.parseChar('(');
            if (this.jdoqlMode.equals("JDO2") && Arrays.binarySearch(jdoqlMethodNames, method) < 0) {
                throw new QueryCompilerSyntaxException("Query uses method \"" + method + "\" but this is not a standard JDOQL method name");
            }
            Node expr = new Node(NodeType.INVOKE, method);
            if (!this.p.parseChar(')')) {
                do {
                    this.processExpression();
                    expr.addProperty(this.stack.pop());
                } while (this.p.parseChar(','));
                if (!this.p.parseChar(')')) {
                    throw new QueryCompilerSyntaxException("')' expected", this.p.getIndex(), this.p.getInput());
                }
            }
            this.stack.push(expr);
            return true;
        }
        return false;
    }

    private boolean processArray() {
        if (this.p.parseChar('{')) {
            ArrayList<Node> elements = new ArrayList<Node>();
            while (!this.p.parseChar('}')) {
                this.processPrimary();
                Node elementNode = this.stack.pop();
                elements.add(elementNode);
                if (this.p.parseChar('}')) break;
                if (this.p.parseChar(',')) continue;
                throw new QueryCompilerSyntaxException("',' or '}' expected", this.p.getIndex(), this.p.getInput());
            }
            Node arrayNode = new Node(NodeType.ARRAY, elements);
            this.stack.push(arrayNode);
            if (this.p.parseString(".length")) {
                Node lengthMethod = new Node(NodeType.INVOKE, "length");
                arrayNode.appendChildNode(lengthMethod);
            }
            return true;
        }
        return false;
    }

    protected boolean processLiteral() {
        Object litValue = null;
        boolean single_quote_next = this.p.nextIsSingleQuote();
        String sLiteral = this.p.parseStringLiteral();
        if (sLiteral != null) {
            litValue = sLiteral.length() == 1 && single_quote_next ? Character.valueOf(sLiteral.charAt(0)) : sLiteral;
        } else {
            BigDecimal fLiteral = this.p.parseFloatingPointLiteral();
            if (fLiteral != null) {
                litValue = fLiteral;
            } else {
                BigInteger iLiteral = this.p.parseIntegerLiteral();
                if (iLiteral != null) {
                    litValue = iLiteral.longValue();
                } else {
                    Boolean bLiteral = this.p.parseBooleanLiteral();
                    if (bLiteral != null) {
                        litValue = bLiteral;
                    } else if (!this.p.parseNullLiteral()) {
                        return false;
                    }
                }
            }
        }
        this.stack.push(new Node(NodeType.LITERAL, litValue));
        return true;
    }

    private boolean processIdentifier() {
        String id = this.p.parseIdentifier();
        if (id == null) {
            return false;
        }
        char first = id.charAt(0);
        if (first == ':') {
            if (this.paramType == ParameterType.EXPLICIT) {
                throw new QueryCompilerSyntaxException("Explicit parameters defined for query, yet implicit parameter syntax (\"" + id + "\") found");
            }
            String name = id.substring(1);
            ParameterNode expr = new ParameterNode(NodeType.PARAMETER, name, this.getPositionFromParameterName(name));
            this.stack.push(expr);
            return true;
        }
        Node expr = new Node(NodeType.IDENTIFIER, id);
        this.stack.push(expr);
        return true;
    }

    private int getPositionFromParameterName(Object name) {
        int pos;
        if (this.parameterNameList == null) {
            this.parameterNameList = new ArrayList<Object>(1);
        }
        if ((pos = this.parameterNameList.indexOf(name)) == -1) {
            pos = this.parameterNameList.size();
            this.parameterNameList.add(name);
        }
        return pos;
    }

    private static enum ParameterType {
        IMPLICIT,
        EXPLICIT;

    }
}

