/*
 * Decompiled with CFR 0.152.
 */
package org.datanucleus.metadata;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.datanucleus.exceptions.NucleusException;
import org.datanucleus.exceptions.NucleusUserException;
import org.datanucleus.metadata.AbstractClassMetaData;
import org.datanucleus.metadata.AbstractMemberMetaData;
import org.datanucleus.metadata.ColumnMetaData;
import org.datanucleus.metadata.EventListenerMetaData;
import org.datanucleus.metadata.ExtensionMetaData;
import org.datanucleus.metadata.FetchGroupMetaData;
import org.datanucleus.metadata.FieldMetaData;
import org.datanucleus.metadata.FieldPersistenceModifier;
import org.datanucleus.metadata.FileMetaData;
import org.datanucleus.metadata.ForeignKeyMetaData;
import org.datanucleus.metadata.IndexMetaData;
import org.datanucleus.metadata.JoinMetaData;
import org.datanucleus.metadata.MetaData;
import org.datanucleus.metadata.MetaDataManager;
import org.datanucleus.metadata.NullValue;
import org.datanucleus.metadata.PackageMetaData;
import org.datanucleus.metadata.PropertyMetaData;
import org.datanucleus.metadata.QueryMetaData;
import org.datanucleus.metadata.SequenceMetaData;
import org.datanucleus.metadata.TableGeneratorMetaData;
import org.datanucleus.metadata.UniqueMetaData;
import org.datanucleus.util.Localiser;
import org.datanucleus.util.NucleusLogger;

public class MetaDataMerger {
    public static void mergeFileORMData(FileMetaData primaryFmd, FileMetaData ormFmd) {
        if (ormFmd == null || primaryFmd == null) {
            return;
        }
        if (primaryFmd.isInitialised() || primaryFmd.isPopulated()) {
            throw new NucleusException(Localiser.msg("MetaData.File.AlreadyPopulatedError", primaryFmd.getFilename())).setFatal();
        }
        if (NucleusLogger.METADATA.isDebugEnabled()) {
            NucleusLogger.METADATA.debug(Localiser.msg("044056", primaryFmd.getFilename()));
        }
        if (ormFmd.getCatalog() != null) {
            primaryFmd.setCatalog(ormFmd.getCatalog());
        }
        if (ormFmd.getSchema() != null) {
            primaryFmd.setSchema(ormFmd.getSchema());
        }
    }

    public static void mergeClassORMData(AbstractClassMetaData primaryCmd, AbstractClassMetaData ormCmd, MetaDataManager mmgr) {
        Iterator<MetaData> iter;
        if (ormCmd == null || primaryCmd == null) {
            return;
        }
        if (primaryCmd.isInitialised() || primaryCmd.isPopulated()) {
            throw new NucleusException(Localiser.msg("044068", primaryCmd.name)).setFatal();
        }
        if (NucleusLogger.METADATA.isDebugEnabled()) {
            NucleusLogger.METADATA.debug(Localiser.msg("044096", primaryCmd.getFullClassName()));
        }
        if (ormCmd.getCatalog() != null) {
            primaryCmd.catalog = ormCmd.getCatalog();
        }
        if (ormCmd.getSchema() != null) {
            primaryCmd.schema = ormCmd.getSchema();
        }
        if (ormCmd.getTable() != null) {
            primaryCmd.table = ormCmd.getTable();
        }
        if (ormCmd.detachable) {
            primaryCmd.detachable = true;
        }
        if (!ormCmd.requiresExtent) {
            primaryCmd.requiresExtent = false;
        }
        if (ormCmd.embeddedOnly) {
            primaryCmd.embeddedOnly = true;
        }
        if (ormCmd.getPrimaryKeyMetaData() != null) {
            primaryCmd.setPrimaryKeyMetaData(ormCmd.getPrimaryKeyMetaData());
        }
        if (ormCmd.getInheritanceMetaData() != null) {
            primaryCmd.setInheritanceMetaData(ormCmd.getInheritanceMetaData());
        }
        if (ormCmd.getIdentityMetaData() != null) {
            primaryCmd.setIdentityMetaData(ormCmd.getIdentityMetaData());
        }
        if (ormCmd.getVersionMetaData() != null) {
            primaryCmd.setVersionMetaData(ormCmd.getVersionMetaData());
        }
        if (ormCmd.listeners != null) {
            if (primaryCmd.listeners == null) {
                primaryCmd.listeners = new ArrayList();
            }
            primaryCmd.listeners.addAll(ormCmd.listeners);
        }
        if (ormCmd.queries != null) {
            if (primaryCmd.queries == null) {
                primaryCmd.queries = new ArrayList<QueryMetaData>();
            } else {
                primaryCmd.queries.clear();
            }
            primaryCmd.queries.addAll(ormCmd.queries);
        }
        if (!ormCmd.joins.isEmpty()) {
            primaryCmd.joins.clear();
            iter = ormCmd.joins.iterator();
            while (iter.hasNext()) {
                primaryCmd.addJoin((JoinMetaData)iter.next());
            }
        }
        if (!ormCmd.indexes.isEmpty()) {
            primaryCmd.indexes.clear();
            iter = ormCmd.indexes.iterator();
            while (iter.hasNext()) {
                primaryCmd.addIndex((IndexMetaData)iter.next());
            }
        }
        if (!ormCmd.foreignKeys.isEmpty()) {
            primaryCmd.foreignKeys.clear();
            iter = ormCmd.foreignKeys.iterator();
            while (iter.hasNext()) {
                primaryCmd.addForeignKey((ForeignKeyMetaData)iter.next());
            }
        }
        if (!ormCmd.uniqueConstraints.isEmpty()) {
            primaryCmd.uniqueConstraints.clear();
            iter = ormCmd.uniqueConstraints.iterator();
            while (iter.hasNext()) {
                primaryCmd.addUniqueConstraint((UniqueMetaData)iter.next());
            }
        }
        if (!ormCmd.fetchGroups.isEmpty()) {
            primaryCmd.fetchGroups.clear();
            iter = ormCmd.fetchGroups.iterator();
            while (iter.hasNext()) {
                primaryCmd.addFetchGroup((FetchGroupMetaData)iter.next());
            }
        }
        if (ormCmd.unmappedColumns != null) {
            primaryCmd.unmappedColumns = null;
            iter = ormCmd.unmappedColumns.iterator();
            while (iter.hasNext()) {
                primaryCmd.addUnmappedColumn((ColumnMetaData)iter.next());
            }
        }
        for (int i = 0; i < ormCmd.getNoOfMembers(); ++i) {
            AbstractMemberMetaData ormFmd = ormCmd.getMetaDataForMemberAtRelativePosition(i);
            AbstractMemberMetaData primaryFmd = primaryCmd.getMetaDataForMember(ormFmd.getName());
            if (Boolean.TRUE.equals(ormFmd.primaryKey) && (primaryFmd == null || Boolean.FALSE.equals(primaryFmd.primaryKey))) {
                throw new NucleusUserException(Localiser.msg("044025", ormFmd.getFullFieldName())).setFatal();
            }
            if (primaryFmd == null) {
                AbstractMemberMetaData fmd = null;
                if (ormFmd.className != null) {
                    AbstractMemberMetaData jdoFmd = mmgr.readMetaDataForMember(ormFmd.className, ormFmd.name);
                    if (jdoFmd == null) {
                        jdoFmd = mmgr.readMetaDataForMember(ormCmd.getPackageName() + "." + ormFmd.className, ormFmd.name);
                    }
                    if (jdoFmd != null) {
                        fmd = jdoFmd instanceof FieldMetaData ? new FieldMetaData((MetaData)primaryCmd, jdoFmd) : new PropertyMetaData((MetaData)primaryCmd, (PropertyMetaData)jdoFmd);
                        fmd.className = ormFmd.className;
                        MetaDataMerger.mergeMemberORMData(fmd, ormFmd);
                    } else {
                        fmd = ormFmd instanceof FieldMetaData ? new FieldMetaData((MetaData)primaryCmd, ormFmd) : new PropertyMetaData((MetaData)primaryCmd, (PropertyMetaData)ormFmd);
                        fmd.className = ormFmd.className;
                    }
                } else {
                    fmd = ormFmd instanceof FieldMetaData ? new FieldMetaData((MetaData)primaryCmd, ormFmd) : new PropertyMetaData((MetaData)primaryCmd, (PropertyMetaData)ormFmd);
                }
                primaryCmd.addMember(fmd);
                continue;
            }
            MetaDataMerger.mergeMemberORMData(primaryFmd, ormFmd);
        }
        ExtensionMetaData[] ormExtensions = ormCmd.getExtensions();
        if (ormExtensions != null) {
            for (int i = 0; i < ormExtensions.length; ++i) {
                primaryCmd.addExtension(ormExtensions[i].vendorName, ormExtensions[i].key, ormExtensions[i].value);
            }
        }
    }

    static void mergeMemberORMData(AbstractMemberMetaData primaryFmd, AbstractMemberMetaData ormFmd) {
        ExtensionMetaData[] ormExtensions;
        ColumnMetaData[] ormColumns;
        if (ormFmd == null || primaryFmd == null) {
            return;
        }
        if (primaryFmd.isInitialised() || primaryFmd.isPopulated()) {
            throw new NucleusException(Localiser.msg("044107", primaryFmd.getClassName(), primaryFmd.getName())).setFatal();
        }
        if (ormFmd.persistenceModifier != null && ormFmd.persistenceModifier != FieldPersistenceModifier.DEFAULT && primaryFmd.persistenceModifier != ormFmd.persistenceModifier) {
            primaryFmd.persistenceModifier = ormFmd.persistenceModifier;
        }
        if (ormFmd.className != null) {
            primaryFmd.className = ormFmd.className;
        }
        if (ormFmd.containerMetaData != null) {
            primaryFmd.containerMetaData = ormFmd.containerMetaData;
            primaryFmd.containerMetaData.parent = primaryFmd;
        }
        if (ormFmd.defaultFetchGroup != null) {
            primaryFmd.defaultFetchGroup = ormFmd.defaultFetchGroup;
        }
        if (ormFmd.getTable() != null) {
            primaryFmd.table = ormFmd.getTable();
        }
        if (ormFmd.getCatalog() != null) {
            primaryFmd.catalog = ormFmd.getCatalog();
        }
        if (ormFmd.getSchema() != null) {
            primaryFmd.schema = ormFmd.getSchema();
        }
        if (ormFmd.column != null) {
            primaryFmd.column = ormFmd.column;
        }
        if (ormFmd.dependent != null) {
            primaryFmd.dependent = ormFmd.dependent;
        }
        if (ormFmd.getMappedBy() != null) {
            primaryFmd.mappedBy = ormFmd.getMappedBy();
        }
        if (ormFmd.getValueStrategy() != null) {
            primaryFmd.valueStrategy = ormFmd.getValueStrategy();
        }
        if (ormFmd.getSequence() != null) {
            primaryFmd.sequence = ormFmd.getSequence();
        }
        if (ormFmd.indexed != null) {
            primaryFmd.indexed = ormFmd.indexed;
        }
        if (ormFmd.nullValue != NullValue.NONE) {
            primaryFmd.nullValue = ormFmd.nullValue;
        }
        if (ormFmd.getJoinMetaData() != null) {
            primaryFmd.setJoinMetaData(ormFmd.joinMetaData);
        }
        if (ormFmd.getEmbeddedMetaData() != null) {
            primaryFmd.setEmbeddedMetaData(ormFmd.embeddedMetaData);
        }
        if (ormFmd.getElementMetaData() != null) {
            primaryFmd.setElementMetaData(ormFmd.elementMetaData);
        }
        if (ormFmd.getKeyMetaData() != null) {
            primaryFmd.setKeyMetaData(ormFmd.keyMetaData);
        }
        if (ormFmd.getValueMetaData() != null) {
            primaryFmd.setValueMetaData(ormFmd.valueMetaData);
        }
        if (ormFmd.getOrderMetaData() != null) {
            primaryFmd.setOrderMetaData(ormFmd.orderMetaData);
        }
        if (ormFmd.getForeignKeyMetaData() != null) {
            primaryFmd.foreignKeyMetaData = ormFmd.getForeignKeyMetaData();
            if (primaryFmd.foreignKeyMetaData != null) {
                primaryFmd.foreignKeyMetaData.parent = primaryFmd;
            }
        }
        if (ormFmd.getIndexMetaData() != null) {
            primaryFmd.indexMetaData = ormFmd.getIndexMetaData();
            if (primaryFmd.indexMetaData != null) {
                primaryFmd.indexMetaData.parent = primaryFmd;
            }
        }
        if (ormFmd.getUniqueMetaData() != null) {
            primaryFmd.uniqueMetaData = ormFmd.getUniqueMetaData();
            if (primaryFmd.uniqueMetaData != null) {
                primaryFmd.uniqueMetaData.parent = primaryFmd;
            }
        }
        if ((ormColumns = ormFmd.getColumnMetaData()) != null) {
            primaryFmd.columns.clear();
            for (int i = 0; i < ormColumns.length; ++i) {
                primaryFmd.columns.add(ormColumns[i]);
            }
        }
        if ((ormExtensions = ormFmd.getExtensions()) != null) {
            for (int i = 0; i < ormExtensions.length; ++i) {
                primaryFmd.addExtension(ormExtensions[i].vendorName, ormExtensions[i].key, ormExtensions[i].value);
            }
        }
    }

    public static void mergeClassAnnotationsData(AbstractClassMetaData primaryCmd, AbstractClassMetaData annotCmd, MetaDataManager mmgr) {
        Iterator<Object> iter;
        int i;
        PackageMetaData annotPmd;
        if (annotCmd == null || primaryCmd == null) {
            return;
        }
        if (primaryCmd.isInitialised() || primaryCmd.isPopulated()) {
            throw new NucleusException(Localiser.msg("044068", primaryCmd.name)).setFatal();
        }
        if (NucleusLogger.METADATA.isDebugEnabled()) {
            NucleusLogger.METADATA.debug(Localiser.msg("044095", primaryCmd.getFullClassName()));
        }
        if ((annotPmd = annotCmd.getPackageMetaData()).getSequences() != null) {
            mmgr.registerSequencesForFile(annotCmd.getPackageMetaData().getFileMetaData());
            SequenceMetaData[] seqmds = annotPmd.getSequences();
            for (i = 0; i < seqmds.length; ++i) {
                primaryCmd.getPackageMetaData().addSequence(seqmds[i]);
            }
        }
        if (annotPmd.getTableGenerators() != null) {
            mmgr.registerTableGeneratorsForFile(annotCmd.getPackageMetaData().getFileMetaData());
            TableGeneratorMetaData[] tablegenmds = annotPmd.getTableGenerators();
            for (i = 0; i < tablegenmds.length; ++i) {
                primaryCmd.getPackageMetaData().addTableGenerator(tablegenmds[i]);
            }
        }
        if (primaryCmd.entityName == null && annotCmd.entityName != null) {
            primaryCmd.entityName = annotCmd.entityName;
        }
        if (annotCmd.detachable) {
            primaryCmd.detachable = true;
        }
        if (!annotCmd.requiresExtent) {
            primaryCmd.requiresExtent = false;
        }
        if (annotCmd.embeddedOnly) {
            primaryCmd.embeddedOnly = true;
        }
        if (primaryCmd.identityType == null && annotCmd.identityType != null) {
            primaryCmd.identityType = annotCmd.identityType;
        }
        if (primaryCmd.objectidClass == null && annotCmd.objectidClass != null) {
            primaryCmd.objectidClass = annotCmd.objectidClass;
        }
        if (primaryCmd.catalog == null && annotCmd.catalog != null) {
            primaryCmd.catalog = annotCmd.catalog;
        }
        if (primaryCmd.schema == null && annotCmd.schema != null) {
            primaryCmd.schema = annotCmd.schema;
        }
        if (primaryCmd.table == null && annotCmd.table != null) {
            primaryCmd.table = annotCmd.table;
        }
        if (primaryCmd.versionMetaData == null && annotCmd.versionMetaData != null) {
            primaryCmd.setVersionMetaData(annotCmd.versionMetaData);
        }
        if (primaryCmd.identityMetaData == null && annotCmd.identityMetaData != null) {
            primaryCmd.setIdentityMetaData(annotCmd.identityMetaData);
        }
        if (primaryCmd.inheritanceMetaData == null && annotCmd.inheritanceMetaData != null) {
            primaryCmd.setInheritanceMetaData(annotCmd.inheritanceMetaData);
        }
        if (primaryCmd.primaryKeyMetaData == null && annotCmd.primaryKeyMetaData != null) {
            primaryCmd.setPrimaryKeyMetaData(annotCmd.primaryKeyMetaData);
        }
        if (primaryCmd.listeners == null && annotCmd.listeners != null) {
            iter = annotCmd.listeners.iterator();
            while (iter.hasNext()) {
                primaryCmd.addListener((EventListenerMetaData)iter.next());
            }
        } else if (primaryCmd.listeners != null && annotCmd.listeners != null) {
            if (primaryCmd.getListenerForClass(primaryCmd.getFullClassName()) == null) {
                if (annotCmd.getListenerForClass(primaryCmd.getFullClassName()) != null) {
                    primaryCmd.addListener(annotCmd.getListenerForClass(primaryCmd.getFullClassName()));
                }
            } else if (primaryCmd.getListenerForClass(primaryCmd.getFullClassName()) != null && primaryCmd.getListeners().size() == 1) {
                List annotListeners = annotCmd.getListeners();
                for (EventListenerMetaData elmd : annotListeners) {
                    if (elmd.getClassName().equals(primaryCmd.getFullClassName())) continue;
                    primaryCmd.addListener(elmd);
                }
            }
        }
        if (annotCmd.excludeDefaultListeners != null && primaryCmd.excludeDefaultListeners == null) {
            primaryCmd.excludeDefaultListeners = annotCmd.excludeDefaultListeners;
        }
        if (annotCmd.excludeSuperClassListeners != null && primaryCmd.excludeSuperClassListeners == null) {
            primaryCmd.excludeSuperClassListeners = annotCmd.excludeSuperClassListeners;
        }
        if (primaryCmd.queries == null && annotCmd.queries != null) {
            iter = annotCmd.queries.iterator();
            while (iter.hasNext()) {
                primaryCmd.addQuery((QueryMetaData)iter.next());
            }
        }
        if (primaryCmd.joins.isEmpty() && !annotCmd.joins.isEmpty()) {
            iter = annotCmd.joins.iterator();
            while (iter.hasNext()) {
                primaryCmd.addJoin((JoinMetaData)iter.next());
            }
        }
        if (primaryCmd.indexes.isEmpty() && !annotCmd.indexes.isEmpty()) {
            iter = annotCmd.indexes.iterator();
            while (iter.hasNext()) {
                primaryCmd.addIndex((IndexMetaData)iter.next());
            }
        }
        if (primaryCmd.foreignKeys.isEmpty() && !annotCmd.foreignKeys.isEmpty()) {
            iter = annotCmd.foreignKeys.iterator();
            while (iter.hasNext()) {
                primaryCmd.addForeignKey((ForeignKeyMetaData)iter.next());
            }
        }
        if (primaryCmd.uniqueConstraints.isEmpty() && !annotCmd.uniqueConstraints.isEmpty()) {
            iter = annotCmd.uniqueConstraints.iterator();
            while (iter.hasNext()) {
                primaryCmd.addUniqueConstraint((UniqueMetaData)iter.next());
            }
        }
        if (primaryCmd.fetchGroups.isEmpty() && !annotCmd.fetchGroups.isEmpty()) {
            iter = annotCmd.fetchGroups.iterator();
            while (iter.hasNext()) {
                primaryCmd.addFetchGroup((FetchGroupMetaData)iter.next());
            }
        }
        for (int i2 = 0; i2 < annotCmd.getNoOfMembers(); ++i2) {
            AbstractMemberMetaData annotFmd = annotCmd.getMetaDataForMemberAtRelativePosition(i2);
            AbstractMemberMetaData primaryFmd = primaryCmd.getMetaDataForMember(annotFmd.getName());
            if (primaryFmd == null) {
                AbstractMemberMetaData fmd = null;
                if (annotFmd.className != null) {
                    AbstractMemberMetaData baseFmd = mmgr.readMetaDataForMember(annotFmd.className, annotFmd.name);
                    if (baseFmd == null) {
                        baseFmd = mmgr.readMetaDataForMember(annotCmd.getPackageName() + "." + annotFmd.className, annotFmd.name);
                    }
                    if (baseFmd != null) {
                        fmd = baseFmd instanceof FieldMetaData ? new FieldMetaData((MetaData)primaryCmd, baseFmd) : new PropertyMetaData((MetaData)primaryCmd, (PropertyMetaData)baseFmd);
                        fmd.className = annotFmd.className;
                        MetaDataMerger.mergeMemberAnnotationsData(fmd, annotFmd);
                    } else {
                        fmd = annotFmd instanceof FieldMetaData ? new FieldMetaData((MetaData)primaryCmd, annotFmd) : new PropertyMetaData((MetaData)primaryCmd, (PropertyMetaData)annotFmd);
                        fmd.className = annotFmd.className;
                    }
                } else {
                    fmd = annotFmd instanceof FieldMetaData ? new FieldMetaData((MetaData)primaryCmd, annotFmd) : new PropertyMetaData((MetaData)primaryCmd, (PropertyMetaData)annotFmd);
                }
                primaryCmd.addMember(fmd);
                continue;
            }
            MetaDataMerger.mergeMemberAnnotationsData(primaryFmd, annotFmd);
        }
        ExtensionMetaData[] ormExtensions = annotCmd.getExtensions();
        if (ormExtensions != null) {
            for (int i3 = 0; i3 < ormExtensions.length; ++i3) {
                primaryCmd.addExtension(ormExtensions[i3].vendorName, ormExtensions[i3].key, ormExtensions[i3].value);
            }
        }
    }

    static void mergeMemberAnnotationsData(AbstractMemberMetaData primaryFmd, AbstractMemberMetaData annotFmd) {
        ExtensionMetaData[] annotExtensions;
        int i;
        ColumnMetaData[] annotColumns;
        if (annotFmd == null || primaryFmd == null) {
            return;
        }
        if (primaryFmd.isInitialised() || primaryFmd.isPopulated()) {
            throw new NucleusException(Localiser.msg("044107", primaryFmd.getClassName(), primaryFmd.getName())).setFatal();
        }
        if (primaryFmd.className == null && annotFmd.className != null) {
            primaryFmd.className = annotFmd.className;
        }
        if (primaryFmd.containerMetaData == null && annotFmd.containerMetaData != null) {
            primaryFmd.containerMetaData = annotFmd.containerMetaData;
            primaryFmd.containerMetaData.parent = primaryFmd;
        }
        if (annotFmd.storeInLob) {
            primaryFmd.storeInLob = true;
        }
        if (annotFmd.persistenceModifier != FieldPersistenceModifier.DEFAULT && primaryFmd.persistenceModifier == FieldPersistenceModifier.DEFAULT) {
            primaryFmd.persistenceModifier = annotFmd.persistenceModifier;
        }
        if (annotFmd.defaultFetchGroup != null && primaryFmd.defaultFetchGroup == null) {
            primaryFmd.defaultFetchGroup = annotFmd.defaultFetchGroup;
        }
        if (annotFmd.primaryKey != null) {
            primaryFmd.primaryKey = annotFmd.primaryKey;
        }
        if (primaryFmd.table == null && annotFmd.table != null) {
            primaryFmd.table = annotFmd.table;
        }
        if (primaryFmd.catalog == null && annotFmd.catalog != null) {
            primaryFmd.catalog = annotFmd.catalog;
        }
        if (primaryFmd.schema == null && annotFmd.schema != null) {
            primaryFmd.schema = annotFmd.schema;
        }
        if (primaryFmd.column == null && annotFmd.column != null) {
            primaryFmd.column = annotFmd.column;
        }
        if (primaryFmd.dependent == null && annotFmd.dependent != null) {
            primaryFmd.dependent = annotFmd.dependent;
        }
        if (primaryFmd.mappedBy == null && annotFmd.mappedBy != null) {
            primaryFmd.mappedBy = annotFmd.mappedBy;
        }
        if (primaryFmd.valueStrategy == null && annotFmd.valueStrategy != null) {
            primaryFmd.valueStrategy = annotFmd.valueStrategy;
        }
        if (primaryFmd.sequence == null && annotFmd.sequence != null) {
            primaryFmd.sequence = annotFmd.sequence;
        }
        if (primaryFmd.valueGeneratorName == null && annotFmd.valueGeneratorName != null) {
            primaryFmd.valueGeneratorName = annotFmd.valueGeneratorName;
        }
        if (primaryFmd.indexed == null && annotFmd.indexed != null) {
            primaryFmd.indexed = annotFmd.indexed;
        }
        if (annotFmd.nullValue != NullValue.NONE) {
            primaryFmd.nullValue = annotFmd.nullValue;
        }
        if (annotFmd.cascadePersist != null && primaryFmd.cascadePersist == null) {
            primaryFmd.cascadePersist = annotFmd.cascadePersist;
        }
        if (annotFmd.cascadeUpdate != null && primaryFmd.cascadeUpdate == null) {
            primaryFmd.cascadeUpdate = annotFmd.cascadeUpdate;
        }
        if (annotFmd.cascadeDelete != null && primaryFmd.cascadeDelete == null) {
            primaryFmd.cascadeDelete = annotFmd.cascadeDelete;
        }
        if (annotFmd.cascadeRefresh != null && primaryFmd.cascadeRefresh == null) {
            primaryFmd.cascadeRefresh = annotFmd.cascadeRefresh;
        }
        if (primaryFmd.joinMetaData == null && annotFmd.joinMetaData != null) {
            primaryFmd.setJoinMetaData(annotFmd.joinMetaData);
        }
        if (primaryFmd.embeddedMetaData == null && annotFmd.embeddedMetaData != null) {
            primaryFmd.setEmbeddedMetaData(annotFmd.embeddedMetaData);
        }
        if (primaryFmd.elementMetaData == null && annotFmd.elementMetaData != null) {
            primaryFmd.setElementMetaData(annotFmd.elementMetaData);
        }
        if (primaryFmd.keyMetaData == null && annotFmd.keyMetaData != null) {
            primaryFmd.setKeyMetaData(annotFmd.keyMetaData);
        }
        if (primaryFmd.valueMetaData == null && annotFmd.valueMetaData != null) {
            primaryFmd.setValueMetaData(annotFmd.valueMetaData);
        }
        if (primaryFmd.orderMetaData == null && annotFmd.orderMetaData != null) {
            primaryFmd.setOrderMetaData(annotFmd.orderMetaData);
        }
        if (primaryFmd.foreignKeyMetaData == null && annotFmd.foreignKeyMetaData != null) {
            primaryFmd.foreignKeyMetaData = annotFmd.foreignKeyMetaData;
            primaryFmd.foreignKeyMetaData.parent = primaryFmd;
        }
        if (primaryFmd.indexMetaData == null && annotFmd.indexMetaData != null) {
            primaryFmd.indexMetaData = annotFmd.indexMetaData;
            primaryFmd.indexMetaData.parent = primaryFmd;
        }
        if (primaryFmd.uniqueMetaData == null && annotFmd.uniqueMetaData != null) {
            primaryFmd.uniqueMetaData = annotFmd.uniqueMetaData;
            primaryFmd.uniqueMetaData.parent = primaryFmd;
        }
        if (primaryFmd.columns.isEmpty() && !annotFmd.columns.isEmpty() && (annotColumns = annotFmd.getColumnMetaData()) != null) {
            for (i = 0; i < annotColumns.length; ++i) {
                primaryFmd.columns.add(annotColumns[i]);
            }
        }
        if ((annotExtensions = annotFmd.getExtensions()) != null) {
            for (i = 0; i < annotExtensions.length; ++i) {
                primaryFmd.addExtension(annotExtensions[i].vendorName, annotExtensions[i].key, annotExtensions[i].value);
            }
        }
    }
}

