/*
 * Decompiled with CFR 0.152.
 */
package org.datanucleus.flush;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.ListIterator;
import java.util.Map;
import org.datanucleus.ExecutionContext;
import org.datanucleus.flush.CollectionAddOperation;
import org.datanucleus.flush.CollectionRemoveOperation;
import org.datanucleus.flush.DeleteOperation;
import org.datanucleus.flush.MapPutOperation;
import org.datanucleus.flush.MapRemoveOperation;
import org.datanucleus.flush.Operation;
import org.datanucleus.flush.PersistOperation;
import org.datanucleus.flush.SCOOperation;
import org.datanucleus.flush.UpdateMemberOperation;
import org.datanucleus.state.ObjectProvider;
import org.datanucleus.store.scostore.CollectionStore;
import org.datanucleus.store.scostore.ListStore;
import org.datanucleus.store.scostore.MapStore;
import org.datanucleus.store.scostore.Store;
import org.datanucleus.store.types.SCOUtils;
import org.datanucleus.util.Localiser;
import org.datanucleus.util.NucleusLogger;
import org.datanucleus.util.StringUtils;

public class OperationQueue {
    protected List<Operation> queuedOperations = new ArrayList<Operation>();

    public synchronized void enqueue(Operation oper) {
        this.queuedOperations.add(oper);
    }

    public synchronized void log() {
        NucleusLogger.GENERAL.debug(">> OperationQueue :" + (this.queuedOperations.isEmpty() ? " Empty" : "" + this.queuedOperations.size() + " operations"));
        for (Operation oper : this.queuedOperations) {
            NucleusLogger.GENERAL.debug(">> " + oper);
        }
    }

    public void clear() {
        this.queuedOperations.clear();
    }

    public List<Operation> getOperations() {
        return Collections.unmodifiableList(this.queuedOperations);
    }

    public void removeOperations(List<Operation> removedOps) {
        this.queuedOperations.removeAll(removedOps);
    }

    public synchronized void performAll() {
        for (Operation op : this.queuedOperations) {
            op.perform();
        }
        this.queuedOperations.clear();
    }

    public synchronized void performAll(Store store, ObjectProvider op) {
        if (NucleusLogger.PERSISTENCE.isDebugEnabled()) {
            NucleusLogger.PERSISTENCE.debug(Localiser.msg("023005", op.getObjectAsPrintable(), store.getOwnerMemberMetaData().getFullFieldName()));
        }
        ArrayList<Operation> flushOperations = new ArrayList<Operation>();
        ListIterator<Operation> operIter = this.queuedOperations.listIterator();
        while (operIter.hasNext()) {
            Operation oper = operIter.next();
            if (!(oper instanceof SCOOperation) || ((SCOOperation)oper).getStore() != store) continue;
            flushOperations.add(oper);
            operIter.remove();
        }
        ListIterator<Operation> flushOperIter = flushOperations.listIterator();
        while (flushOperIter.hasNext()) {
            Operation oper = (Operation)flushOperIter.next();
            if (store instanceof CollectionStore) {
                if (!(store instanceof ListStore)) {
                    if (OperationQueue.isAddFollowedByRemoveOnSameSCO(store, op, oper, flushOperIter)) {
                        flushOperIter.next();
                        continue;
                    }
                    if (OperationQueue.isRemoveFollowedByAddOnSameSCO(store, op, oper, flushOperIter)) {
                        flushOperIter.next();
                        continue;
                    }
                    oper.perform();
                    continue;
                }
                oper.perform();
                continue;
            }
            if (store instanceof MapStore) {
                if (OperationQueue.isPutFollowedByRemoveOnSameSCO(store, op, oper, flushOperIter)) {
                    flushOperIter.next();
                    continue;
                }
                oper.perform();
                continue;
            }
            oper.perform();
        }
    }

    public void clearPersistDeleteUpdateOperations() {
        if (this.queuedOperations != null) {
            Iterator<Operation> opsIter = this.queuedOperations.iterator();
            while (opsIter.hasNext()) {
                Operation op = opsIter.next();
                if (!(op instanceof PersistOperation) && !(op instanceof DeleteOperation) && !(op instanceof UpdateMemberOperation)) continue;
                opsIter.remove();
            }
        }
    }

    public void processOperationsForNoBackingStoreSCOs(ExecutionContext ec) {
        if (this.queuedOperations != null && !ec.getStoreManager().usesBackedSCOWrappers()) {
            ArrayList<Operation> opersToIgnore = new ArrayList<Operation>();
            ArrayList<Object> objectsToCascadeDelete = null;
            for (Operation oper : this.queuedOperations) {
                MapRemoveOperation mapRemoveOperation;
                if (oper instanceof CollectionRemoveOperation) {
                    CollectionRemoveOperation collectionRemoveOperation = (CollectionRemoveOperation)oper;
                    if (collectionRemoveOperation.getStore() == null && SCOUtils.hasDependentElement(collectionRemoveOperation.getMemberMetaData())) {
                        boolean needsRemoving = true;
                        if (this.queuedOperations.size() > 1) {
                            for (Operation subOper : this.queuedOperations) {
                                Collection persColl;
                                PersistOperation persOp;
                                if (subOper instanceof CollectionAddOperation) {
                                    CollectionAddOperation collAddOper = (CollectionAddOperation)subOper;
                                    if (!collectionRemoveOperation.getValue().equals(collAddOper.getValue())) continue;
                                    needsRemoving = false;
                                    break;
                                }
                                if (!(subOper instanceof PersistOperation) || !(persOp = (PersistOperation)subOper).getObjectProvider().getObject().getClass().equals(collectionRemoveOperation.getObjectProvider().getObject().getClass()) || (persColl = (Collection)persOp.getObjectProvider().provideField(collectionRemoveOperation.getMemberMetaData().getAbsoluteFieldNumber())) == null || !persColl.contains(collectionRemoveOperation.getValue())) continue;
                                needsRemoving = false;
                                break;
                            }
                        }
                        if (needsRemoving) {
                            if (objectsToCascadeDelete == null) {
                                objectsToCascadeDelete = new ArrayList<Object>();
                            }
                            NucleusLogger.GENERAL.info(">> Flush collection element needs cascade delete " + collectionRemoveOperation.getValue());
                            objectsToCascadeDelete.add(collectionRemoveOperation.getValue());
                        }
                    }
                } else if (oper instanceof MapRemoveOperation && (mapRemoveOperation = (MapRemoveOperation)oper).getStore() == null) {
                    Map persMap;
                    PersistOperation persOper;
                    MapPutOperation mapPutOper;
                    if (SCOUtils.hasDependentKey(mapRemoveOperation.getMemberMetaData())) {
                        boolean keyNeedsRemoving = true;
                        if (this.queuedOperations.size() > 1) {
                            for (Operation subOper : this.queuedOperations) {
                                if (subOper instanceof MapPutOperation) {
                                    mapPutOper = (MapPutOperation)subOper;
                                    if (!mapRemoveOperation.getKey().equals(mapPutOper.getKey())) continue;
                                    keyNeedsRemoving = false;
                                    break;
                                }
                                if (!(subOper instanceof PersistOperation) || !(persOper = (PersistOperation)subOper).getObjectProvider().getObject().getClass().equals(mapRemoveOperation.getObjectProvider().getObject().getClass()) || (persMap = (Map)persOper.getObjectProvider().provideField(mapRemoveOperation.getMemberMetaData().getAbsoluteFieldNumber())) == null || !persMap.containsKey(mapRemoveOperation.getKey())) continue;
                                keyNeedsRemoving = false;
                                break;
                            }
                        }
                        if (keyNeedsRemoving) {
                            if (objectsToCascadeDelete == null) {
                                objectsToCascadeDelete = new ArrayList();
                            }
                            objectsToCascadeDelete.add(mapRemoveOperation.getKey());
                        }
                    } else if (SCOUtils.hasDependentValue(mapRemoveOperation.getMemberMetaData())) {
                        boolean valNeedsRemoving = true;
                        if (this.queuedOperations.size() > 1) {
                            for (Operation subOper : this.queuedOperations) {
                                if (subOper instanceof MapPutOperation) {
                                    mapPutOper = (MapPutOperation)subOper;
                                    if (!mapRemoveOperation.getValue().equals(mapPutOper.getValue())) continue;
                                    valNeedsRemoving = false;
                                    break;
                                }
                                if (!(subOper instanceof PersistOperation) || !(persOper = (PersistOperation)subOper).getObjectProvider().getObject().getClass().equals(mapRemoveOperation.getObjectProvider().getObject().getClass()) || (persMap = (Map)persOper.getObjectProvider().provideField(mapRemoveOperation.getMemberMetaData().getAbsoluteFieldNumber())) == null || !persMap.containsValue(mapRemoveOperation.getValue())) continue;
                                valNeedsRemoving = false;
                                break;
                            }
                        }
                        if (valNeedsRemoving) {
                            if (objectsToCascadeDelete == null) {
                                objectsToCascadeDelete = new ArrayList();
                            }
                            objectsToCascadeDelete.add(mapRemoveOperation.getValue());
                        }
                    }
                }
                if (!(oper instanceof SCOOperation)) continue;
                opersToIgnore.add(oper);
            }
            this.queuedOperations.removeAll(opersToIgnore);
            if (objectsToCascadeDelete != null) {
                for (Object e : objectsToCascadeDelete) {
                    NucleusLogger.PERSISTENCE.debug("Initiating cascade delete of " + e);
                    ec.deleteObjectInternal(e);
                }
            }
        }
    }

    protected static boolean isAddFollowedByRemoveOnSameSCO(Store store, ObjectProvider op, Operation currentOper, ListIterator<Operation> listIter) {
        if (CollectionAddOperation.class.isInstance(currentOper)) {
            boolean addThenRemove = false;
            if (listIter.hasNext()) {
                Object value;
                Operation operNext = listIter.next();
                if (CollectionRemoveOperation.class.isInstance(operNext) && (value = ((CollectionAddOperation)CollectionAddOperation.class.cast(currentOper)).getValue()) == ((CollectionRemoveOperation)CollectionRemoveOperation.class.cast(operNext)).getValue()) {
                    addThenRemove = true;
                    NucleusLogger.PERSISTENCE.info("Member " + store.getOwnerMemberMetaData().getFullFieldName() + " of " + StringUtils.toJVMIDString(op.getObject()) + " had an add then a remove of element " + StringUtils.toJVMIDString(value) + " - operations ignored");
                }
                listIter.previous();
            }
            return addThenRemove;
        }
        return false;
    }

    protected static boolean isRemoveFollowedByAddOnSameSCO(Store store, ObjectProvider op, Operation currentOper, ListIterator<Operation> listIter) {
        if (CollectionRemoveOperation.class.isInstance(currentOper)) {
            boolean removeThenAdd = false;
            if (listIter.hasNext()) {
                Object value;
                Operation opNext = listIter.next();
                if (CollectionAddOperation.class.isInstance(opNext) && (value = ((CollectionRemoveOperation)CollectionRemoveOperation.class.cast(currentOper)).getValue()) == ((CollectionAddOperation)CollectionAddOperation.class.cast(opNext)).getValue()) {
                    removeThenAdd = true;
                    NucleusLogger.PERSISTENCE.info("Member" + store.getOwnerMemberMetaData().getFullFieldName() + " of " + StringUtils.toJVMIDString(op.getObject()) + " had a remove then add of element " + StringUtils.toJVMIDString(value) + " - operations ignored");
                }
                listIter.previous();
            }
            return removeThenAdd;
        }
        return false;
    }

    protected static boolean isPutFollowedByRemoveOnSameSCO(Store store, ObjectProvider op, Operation currentOper, ListIterator<Operation> listIter) {
        if (MapPutOperation.class.isInstance(currentOper)) {
            boolean putThenRemove = false;
            if (listIter.hasNext()) {
                Object key;
                Operation operNext = listIter.next();
                if (MapRemoveOperation.class.isInstance(operNext) && (key = ((MapPutOperation)MapPutOperation.class.cast(currentOper)).getKey()) == ((MapRemoveOperation)MapRemoveOperation.class.cast(operNext)).getKey()) {
                    putThenRemove = true;
                    NucleusLogger.PERSISTENCE.info("Member " + store.getOwnerMemberMetaData().getFullFieldName() + " of " + StringUtils.toJVMIDString(op.getObject()) + " had a put then a remove of key " + StringUtils.toJVMIDString(key) + " - operations ignored");
                }
                listIter.previous();
            }
            return putThenRemove;
        }
        return false;
    }
}

