/*
 * Decompiled with CFR 0.152.
 */
package org.datanucleus.store.schema.table;

import org.datanucleus.metadata.AbstractMemberMetaData;
import org.datanucleus.store.schema.table.Column;
import org.datanucleus.store.schema.table.MemberColumnMapping;
import org.datanucleus.store.types.converters.TypeConverter;
import org.datanucleus.util.StringUtils;

public class MemberColumnMappingImpl
implements MemberColumnMapping {
    protected AbstractMemberMetaData mmd;
    protected TypeConverter typeConverter;
    protected Column[] columns;

    public MemberColumnMappingImpl(AbstractMemberMetaData mmd, Column col) {
        this.mmd = mmd;
        this.columns = new Column[]{col};
    }

    public MemberColumnMappingImpl(AbstractMemberMetaData mmd, Column[] cols, TypeConverter typeConv) {
        this.mmd = mmd;
        this.columns = cols;
        this.typeConverter = typeConv;
    }

    @Override
    public void setTypeConverter(TypeConverter typeConv) {
        this.typeConverter = typeConv;
    }

    @Override
    public AbstractMemberMetaData getMemberMetaData() {
        return this.mmd;
    }

    @Override
    public Column getColumn(int position) {
        if (position >= this.getNumberOfColumns()) {
            return null;
        }
        return this.columns[position];
    }

    @Override
    public Column[] getColumns() {
        return this.columns;
    }

    @Override
    public int getNumberOfColumns() {
        return this.columns != null ? this.columns.length : 0;
    }

    @Override
    public TypeConverter getTypeConverter() {
        return this.typeConverter;
    }

    public String toString() {
        return "Member: " + this.mmd.getFullFieldName() + " converter=" + this.typeConverter + " columns=" + StringUtils.objectArrayToString(this.columns);
    }
}

