/*
 * Decompiled with CFR 0.152.
 */
package org.datanucleus.store.types.converters;

import java.nio.ByteBuffer;
import org.datanucleus.store.types.converters.TypeConverter;
import org.datanucleus.util.TypeConversionHelper;

public class BooleanArrayByteBufferConverter
implements TypeConverter<boolean[], ByteBuffer> {
    private static final long serialVersionUID = -1034562477183576606L;

    @Override
    public ByteBuffer toDatastoreType(boolean[] memberValue) {
        byte[] bytes = TypeConversionHelper.getByteArrayFromBooleanArray(memberValue);
        ByteBuffer byteBuffer = ByteBuffer.allocate(memberValue.length);
        byteBuffer.put(bytes);
        return byteBuffer;
    }

    @Override
    public boolean[] toMemberType(ByteBuffer datastoreValue) {
        return TypeConversionHelper.getBooleanArrayFromByteArray(datastoreValue.array());
    }
}

