/*
 * Decompiled with CFR 0.152.
 */
package org.datanucleus.store.types.converters;

import java.text.DateFormat;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Date;
import org.datanucleus.exceptions.NucleusDataStoreException;
import org.datanucleus.store.types.converters.TypeConverter;
import org.datanucleus.util.Localiser;

public class DateStringConverter
implements TypeConverter<Date, String> {
    private static final ThreadLocal<FormatterInfo> formatterThreadInfo = new ThreadLocal<FormatterInfo>(){

        @Override
        protected FormatterInfo initialValue() {
            return new FormatterInfo();
        }
    };

    private DateFormat getFormatter() {
        FormatterInfo formatInfo = formatterThreadInfo.get();
        if (formatInfo.formatter == null) {
            formatInfo.formatter = new SimpleDateFormat("EEE MMM dd HH:mm:ss zzz yyyy");
        }
        return formatInfo.formatter;
    }

    @Override
    public Date toMemberType(String str) {
        if (str == null) {
            return null;
        }
        try {
            return this.getFormatter().parse(str);
        }
        catch (ParseException pe) {
            throw new NucleusDataStoreException(Localiser.msg("016002", str, Date.class.getName()), pe);
        }
    }

    @Override
    public String toDatastoreType(Date date) {
        return date != null ? this.getFormatter().format(date) : null;
    }

    static class FormatterInfo {
        SimpleDateFormat formatter;

        FormatterInfo() {
        }
    }
}

