/*
 * Decompiled with CFR 0.152.
 */
package org.datanucleus.store.types.converters;

import java.math.BigDecimal;
import org.datanucleus.exceptions.NucleusDataStoreException;
import org.datanucleus.store.types.converters.TypeConverter;
import org.datanucleus.util.Localiser;

public class BigDecimalStringConverter
implements TypeConverter<BigDecimal, String> {
    @Override
    public BigDecimal toMemberType(String str) {
        if (str == null) {
            return null;
        }
        try {
            return new BigDecimal(str.trim());
        }
        catch (NumberFormatException nfe) {
            throw new NucleusDataStoreException(Localiser.msg("016002", str, BigDecimal.class.getName()), nfe);
        }
    }

    @Override
    public String toDatastoreType(BigDecimal bd) {
        return bd != null ? bd.toString() : null;
    }
}

