/*
 * Decompiled with CFR 0.152.
 */
package org.datanucleus.metadata;

import java.net.URI;
import java.net.URL;
import java.util.HashSet;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import org.datanucleus.metadata.MetaData;
import org.datanucleus.metadata.TransactionType;

public class PersistenceUnitMetaData
extends MetaData {
    String name = null;
    URI rootURI = null;
    TransactionType transactionType = null;
    String description = null;
    String provider = null;
    String validationMode = null;
    String jtaDataSource = null;
    String nonJtaDataSource = null;
    Set<String> classNames = null;
    Set jarFiles = null;
    Set<String> mappingFileNames = null;
    Properties properties = null;
    boolean excludeUnlistedClasses = false;
    String caching = "UNSPECIFIED";

    public PersistenceUnitMetaData(String name, String transactionType, URI rootURI) {
        this.name = name;
        this.transactionType = TransactionType.getValue(transactionType);
        this.rootURI = rootURI;
    }

    public String getName() {
        return this.name;
    }

    public URI getRootURI() {
        return this.rootURI;
    }

    public TransactionType getTransactionType() {
        return this.transactionType;
    }

    public String getCaching() {
        return this.caching;
    }

    public void setCaching(String cache) {
        this.caching = cache;
    }

    public String getDescription() {
        return this.description;
    }

    public void setDescription(String desc) {
        this.description = desc;
    }

    public String getProvider() {
        return this.provider;
    }

    public void setProvider(String provider) {
        this.provider = provider;
    }

    public String getJtaDataSource() {
        return this.jtaDataSource;
    }

    public void setJtaDataSource(String data) {
        this.jtaDataSource = data;
    }

    public String getNonJtaDataSource() {
        return this.nonJtaDataSource;
    }

    public void setNonJtaDataSource(String data) {
        this.nonJtaDataSource = data;
    }

    public void setValidationMode(String validationMode) {
        this.validationMode = validationMode;
    }

    public String getValidationMode() {
        return this.validationMode;
    }

    public void setExcludeUnlistedClasses() {
        this.excludeUnlistedClasses = true;
    }

    public void setExcludeUnlistedClasses(boolean flag) {
        this.excludeUnlistedClasses = flag;
    }

    public boolean getExcludeUnlistedClasses() {
        return this.excludeUnlistedClasses;
    }

    public void addClassName(String className) {
        if (this.classNames == null) {
            this.classNames = new HashSet<String>();
        }
        this.classNames.add(className);
    }

    public void addClassNames(Set<String> classNames) {
        if (classNames == null) {
            this.classNames = new HashSet<String>();
        }
        this.classNames.addAll(classNames);
    }

    public void addJarFile(String jarName) {
        if (this.jarFiles == null) {
            this.jarFiles = new HashSet();
        }
        this.jarFiles.add(jarName);
    }

    public void addJarFiles(Set<String> jarNames) {
        if (this.jarFiles == null) {
            this.jarFiles = new HashSet();
        }
        this.jarFiles.addAll(jarNames);
    }

    public void addJarFile(URL jarURL) {
        if (this.jarFiles == null) {
            this.jarFiles = new HashSet();
        }
        this.jarFiles.add(jarURL);
    }

    public void clearJarFiles() {
        if (this.jarFiles != null) {
            this.jarFiles.clear();
        }
        this.jarFiles = null;
    }

    public void addMappingFile(String mappingFile) {
        if (this.mappingFileNames == null) {
            this.mappingFileNames = new HashSet<String>();
        }
        this.mappingFileNames.add(mappingFile);
    }

    public void addProperty(String key, String value) {
        if (key == null || value == null) {
            return;
        }
        if (this.properties == null) {
            this.properties = new Properties();
        }
        this.properties.setProperty(key, value);
    }

    public Set<String> getClassNames() {
        return this.classNames;
    }

    public Set<String> getMappingFiles() {
        return this.mappingFileNames;
    }

    public Set getJarFiles() {
        return this.jarFiles;
    }

    public Properties getProperties() {
        return this.properties;
    }

    @Override
    public String toString(String prefix, String indent) {
        StringBuilder sb = new StringBuilder();
        sb.append(prefix).append("<persistence-unit name=\"" + this.name + "\"");
        if (this.transactionType != null) {
            sb.append(" transaction-type=\"" + (Object)((Object)this.transactionType) + "\"");
        }
        sb.append(">\n");
        if (this.description != null) {
            sb.append(prefix).append(indent).append("<description>" + this.description + "</description>\n");
        }
        if (this.provider != null) {
            sb.append(prefix).append(indent).append("<provider>" + this.provider + "</provider>\n");
        }
        if (this.jtaDataSource != null) {
            sb.append(prefix).append(indent).append("<jta-data-source>" + this.jtaDataSource + "</jta-data-source>\n");
        }
        if (this.nonJtaDataSource != null) {
            sb.append(prefix).append(indent).append("<non-jta-data-source>" + this.nonJtaDataSource + "</non-jta-data-source>\n");
        }
        if (this.classNames != null) {
            for (String className : this.classNames) {
                sb.append(prefix).append(indent).append("<class>" + className + "</class>\n");
            }
        }
        if (this.mappingFileNames != null) {
            for (String mappingFileName : this.mappingFileNames) {
                sb.append(prefix).append(indent).append("<mapping-file>" + mappingFileName + "</mapping-file>\n");
            }
        }
        if (this.jarFiles != null) {
            for (String jarFile : this.jarFiles) {
                sb.append(prefix).append(indent).append("<jar-file>" + jarFile + "</jar-file>\n");
            }
        }
        if (this.properties != null) {
            sb.append(prefix).append(indent).append("<properties>\n");
            Set<Map.Entry<Object, Object>> entries = this.properties.entrySet();
            for (Map.Entry<Object, Object> entry : entries) {
                sb.append(prefix).append(indent).append(indent).append("<property name=" + entry.getKey() + " value=" + entry.getValue() + "</property>\n");
            }
            sb.append(prefix).append(indent).append("</properties>\n");
        }
        if (this.excludeUnlistedClasses) {
            sb.append(prefix).append(indent).append("<exclude-unlisted-classes/>\n");
        }
        sb.append(prefix).append("</persistence-unit>\n");
        return sb.toString();
    }
}

