/*
 * Decompiled with CFR 0.152.
 */
package org.datanucleus.store.valuegenerator;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.NoSuchElementException;
import org.datanucleus.util.StringUtils;

public class ValueGenerationBlock<T>
implements Serializable {
    private int nextIndex = 0;
    private final List<T> valueList;

    public ValueGenerationBlock(T[] values) {
        this.valueList = Arrays.asList(values);
    }

    public ValueGenerationBlock(List<T> oid) {
        this.valueList = new ArrayList<T>(oid);
    }

    public T current() {
        if (this.nextIndex == 0 || this.nextIndex - 1 >= this.valueList.size()) {
            throw new NoSuchElementException();
        }
        return this.valueList.get(this.nextIndex - 1);
    }

    public T next() {
        if (this.nextIndex >= this.valueList.size()) {
            throw new NoSuchElementException();
        }
        return this.valueList.get(this.nextIndex++);
    }

    public boolean hasNext() {
        return this.nextIndex < this.valueList.size();
    }

    public void addBlock(ValueGenerationBlock<T> block) {
        if (block == null) {
            return;
        }
        while (block.hasNext()) {
            this.valueList.add(block.next());
        }
    }

    public String toString() {
        return "ValueGenerationBlock : " + StringUtils.collectionToString(this.valueList);
    }
}

