/*
 * Decompiled with CFR 0.152.
 */
package org.datanucleus.metadata;

import java.util.ArrayList;
import java.util.List;
import org.datanucleus.ClassLoaderResolver;
import org.datanucleus.exceptions.ClassNotResolvedException;
import org.datanucleus.metadata.ClassMetaData;
import org.datanucleus.metadata.InvalidClassMetaDataException;
import org.datanucleus.metadata.MetaData;
import org.datanucleus.metadata.MetaDataManager;
import org.datanucleus.metadata.PropertyMetaData;
import org.datanucleus.util.ClassUtils;
import org.datanucleus.util.Localiser;
import org.datanucleus.util.NucleusLogger;

public class ImplementsMetaData
extends MetaData {
    protected String name;
    protected final List<PropertyMetaData> properties = new ArrayList<PropertyMetaData>();

    public ImplementsMetaData(String name) {
        this.name = name;
    }

    public synchronized void populate(ClassLoaderResolver clr, ClassLoader primary, MetaDataManager mmgr) {
        try {
            clr.classForName(this.name);
        }
        catch (ClassNotResolvedException cnre) {
            try {
                String clsName = ClassUtils.createFullClassName(((ClassMetaData)this.parent).getPackageName(), this.name);
                clr.classForName(clsName);
                this.name = clsName;
            }
            catch (ClassNotResolvedException cnre2) {
                NucleusLogger.METADATA.error(Localiser.msg("044097", ((ClassMetaData)this.parent).getFullClassName(), this.name));
                throw new InvalidClassMetaDataException("044097", ((ClassMetaData)this.parent).getFullClassName(), this.name);
            }
        }
        this.setPopulated();
    }

    public String getName() {
        return this.name;
    }

    public void addProperty(PropertyMetaData pmd) {
        if (pmd == null) {
            return;
        }
        this.properties.add(pmd);
        pmd.parent = this;
    }

    @Override
    public String toString(String prefix, String indent) {
        StringBuilder sb = new StringBuilder();
        sb.append(prefix).append("<implements name=\"" + this.name + "\">\n");
        for (int i = 0; i < this.properties.size(); ++i) {
            PropertyMetaData pmd = this.properties.get(i);
            sb.append(pmd.toString(prefix + indent, indent));
        }
        sb.append(super.toString(prefix + indent, indent));
        sb.append(prefix + "</implements>\n");
        return sb.toString();
    }
}

