/*
 * Decompiled with CFR 0.152.
 */
package org.datanucleus.metadata;

import java.util.ArrayList;
import java.util.List;
import org.datanucleus.metadata.MetaData;

public class AbstractConstraintMetaData
extends MetaData {
    protected String name;
    protected String table;
    protected List<String> memberNames = null;
    protected List<String> columnNames = null;

    public AbstractConstraintMetaData() {
    }

    public AbstractConstraintMetaData(AbstractConstraintMetaData acmd) {
        super(null, acmd);
        this.name = acmd.name;
        this.table = acmd.table;
        if (acmd.memberNames != null) {
            for (String memberName : acmd.memberNames) {
                this.addMember(memberName);
            }
        }
        if (acmd.columnNames != null) {
            for (String columnName : acmd.columnNames) {
                this.addColumn(columnName);
            }
        }
    }

    public void addMember(String memberName) {
        if (this.memberNames == null) {
            this.memberNames = new ArrayList<String>();
        }
        this.memberNames.add(memberName);
    }

    public final String[] getMemberNames() {
        if (this.memberNames == null) {
            return null;
        }
        return this.memberNames.toArray(new String[this.memberNames.size()]);
    }

    public int getNumberOfMembers() {
        return this.memberNames != null ? this.memberNames.size() : 0;
    }

    public void addColumn(String columnName) {
        if (this.columnNames == null) {
            this.columnNames = new ArrayList<String>();
        }
        this.columnNames.add(columnName);
    }

    public final String[] getColumnNames() {
        if (this.columnNames == null) {
            return null;
        }
        return this.columnNames.toArray(new String[this.columnNames.size()]);
    }

    public int getNumberOfColumns() {
        return this.columnNames != null ? this.columnNames.size() : 0;
    }
}

