/*
 * Decompiled with CFR 0.152.
 */
package org.datanucleus.store.types.converters;

import java.lang.reflect.Method;
import org.datanucleus.store.types.converters.TypeConverter;
import org.datanucleus.util.NucleusLogger;

public class TypeConverterHelper {
    public static Class getMemberTypeForTypeConverter(TypeConverter conv, Class datastoreType) {
        try {
            Method m = conv.getClass().getDeclaredMethod("toMemberType", datastoreType);
            return m.getReturnType();
        }
        catch (Exception e) {
            try {
                Method m = conv.getClass().getDeclaredMethod("getMemberClass", null);
                return (Class)m.invoke((Object)conv, null);
            }
            catch (Exception e2) {
                NucleusLogger.GENERAL.warn(">> Converter " + conv + " didn't have adequate information from toMemberType nor from getDatastoreClass");
                return null;
            }
        }
    }

    public static Class getDatastoreTypeForTypeConverter(TypeConverter conv, Class memberType) {
        try {
            Method m = conv.getClass().getDeclaredMethod("toDatastoreType", memberType);
            return m.getReturnType();
        }
        catch (Exception e) {
            try {
                Method m = conv.getClass().getDeclaredMethod("getDatastoreClass", null);
                return (Class)m.invoke((Object)conv, null);
            }
            catch (Exception e2) {
                try {
                    Method[] methods = conv.getClass().getDeclaredMethods();
                    if (methods != null) {
                        for (int i = 0; i < methods.length; ++i) {
                            Class<?>[] paramTypes = methods[i].getParameterTypes();
                            if (!methods[i].getName().equals("toDatastoreType") || methods[i].getReturnType() == Object.class || paramTypes == null || paramTypes.length != 1) continue;
                            return methods[i].getReturnType();
                        }
                    }
                }
                catch (Exception e3) {
                    NucleusLogger.GENERAL.warn(">> Converter " + conv + " didn't have adequate information from toDatastoreType nor from getDatastoreClass");
                }
                return null;
            }
        }
    }
}

