/*
 * Decompiled with CFR 0.152.
 */
package org.datanucleus.store.types;

import java.lang.reflect.Array;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Queue;
import java.util.Set;
import java.util.SortedMap;
import java.util.SortedSet;
import java.util.TreeMap;
import java.util.TreeSet;
import org.datanucleus.ClassConstants;
import org.datanucleus.ClassLoaderResolver;
import org.datanucleus.ExecutionContext;
import org.datanucleus.api.ApiAdapter;
import org.datanucleus.exceptions.NucleusException;
import org.datanucleus.exceptions.NucleusObjectNotFoundException;
import org.datanucleus.exceptions.NucleusUserException;
import org.datanucleus.metadata.AbstractClassMetaData;
import org.datanucleus.metadata.AbstractMemberMetaData;
import org.datanucleus.metadata.MetaDataManager;
import org.datanucleus.state.FetchPlanState;
import org.datanucleus.state.ObjectProvider;
import org.datanucleus.store.FieldValues;
import org.datanucleus.store.StoreManager;
import org.datanucleus.store.scostore.CollectionStore;
import org.datanucleus.store.scostore.MapStore;
import org.datanucleus.store.scostore.SetStore;
import org.datanucleus.store.types.SCO;
import org.datanucleus.store.types.SCOContainer;
import org.datanucleus.store.types.SCOList;
import org.datanucleus.store.types.TypeManager;
import org.datanucleus.util.ClassUtils;
import org.datanucleus.util.Localiser;
import org.datanucleus.util.NucleusLogger;
import org.datanucleus.util.StringUtils;

public class SCOUtils {
    private static final Localiser LOCALISER = Localiser.getInstance("org.datanucleus.Localisation", ClassConstants.NUCLEUS_CONTEXT_LOADER);

    public static SCO newSCOInstance(ObjectProvider ownerOP, AbstractMemberMetaData mmd, Class declaredType, Class instantiatedType, Object value, boolean forInsert, boolean forUpdate, boolean replaceField) {
        if (!mmd.getType().isAssignableFrom(declaredType)) {
            throw new NucleusUserException(LOCALISER.msg("023010", (Object)declaredType.getName(), (Object)mmd.getName(), (Object)mmd.getType()));
        }
        TypeManager typeMgr = ownerOP.getExecutionContext().getNucleusContext().getTypeManager();
        if (value != null && typeMgr.isSecondClassWrapper(value.getClass().getName())) {
            if (replaceField) {
                ownerOP.replaceField(mmd.getAbsoluteFieldNumber(), value);
            }
            return (SCO)value;
        }
        String typeName = declaredType.getName();
        if (instantiatedType != null) {
            typeName = instantiatedType.getName();
        }
        if (value != null) {
            typeName = value.getClass().getName();
        }
        StoreManager storeMgr = ownerOP.getExecutionContext().getStoreManager();
        boolean backedWrapper = storeMgr.useBackedSCOWrapperForMember(mmd, ownerOP.getExecutionContext());
        Class wrapperType = null;
        wrapperType = backedWrapper ? SCOUtils.getBackedWrapperTypeForType(declaredType, instantiatedType, typeName, typeMgr) : SCOUtils.getSimpleWrapperTypeForType(declaredType, instantiatedType, typeName, typeMgr);
        if (wrapperType == null) {
            throw new NucleusUserException(LOCALISER.msg("023011", (Object)declaredType.getName(), (Object)StringUtils.toJVMIDString(value), (Object)mmd.getFullFieldName()));
        }
        SCO sco = null;
        try {
            sco = SCOUtils.createSCOWrapper(wrapperType, ownerOP, mmd, replaceField, value, forInsert, forUpdate);
        }
        catch (UnsupportedOperationException uoe) {
            if (backedWrapper) {
                NucleusLogger.PERSISTENCE.warn("Creation of backed wrapper for " + mmd.getFullFieldName() + " unsupported, so trying simple wrapper");
                wrapperType = SCOUtils.getSimpleWrapperTypeForType(declaredType, instantiatedType, typeName, typeMgr);
                sco = SCOUtils.createSCOWrapper(wrapperType, ownerOP, mmd, replaceField, value, forInsert, forUpdate);
            }
            throw uoe;
        }
        return sco;
    }

    private static Class getBackedWrapperTypeForType(Class declaredType, Class instantiatedType, String typeName, TypeManager typeMgr) {
        Class wrapperType = typeMgr.getWrappedTypeBackedForType(typeName);
        if (wrapperType == null) {
            if (instantiatedType != null) {
                wrapperType = typeMgr.getWrappedTypeBackedForType(instantiatedType.getName());
            }
            if (wrapperType == null) {
                wrapperType = typeMgr.getWrappedTypeBackedForType(declaredType.getName());
            }
        }
        return wrapperType;
    }

    private static Class getSimpleWrapperTypeForType(Class declaredType, Class instantiatedType, String typeName, TypeManager typeMgr) {
        Class wrapperType = typeMgr.getWrapperTypeForType(typeName);
        if (wrapperType == null) {
            if (instantiatedType != null) {
                wrapperType = typeMgr.getWrapperTypeForType(instantiatedType.getName());
            }
            if (wrapperType == null) {
                wrapperType = typeMgr.getWrapperTypeForType(declaredType.getName());
            }
        }
        return wrapperType;
    }

    private static SCO createSCOWrapper(Class wrapperType, ObjectProvider ownerOP, AbstractMemberMetaData mmd, boolean replaceField, Object fieldValue, boolean forInsert, boolean forUpdate) {
        SCO sco = (SCO)ClassUtils.newInstance(wrapperType, new Class[]{ObjectProvider.class, AbstractMemberMetaData.class}, new Object[]{ownerOP, mmd});
        if (replaceField) {
            ownerOP.replaceField(mmd.getAbsoluteFieldNumber(), sco);
        }
        if (fieldValue != null) {
            sco.initialise(fieldValue, forInsert, forUpdate);
        } else {
            sco.initialise();
        }
        return sco;
    }

    public static String getContainerInfoMessage(ObjectProvider ownerOP, String fieldName, SCOContainer cont, boolean useCache, boolean queued, boolean allowNulls, boolean lazyLoading) {
        String msg = LOCALISER.msg("023004", (Object)ownerOP.getObjectAsPrintable(), (Object)fieldName, (Object)cont.getClass().getName(), (Object)("[cache-values=" + useCache + ", lazy-loading=" + lazyLoading + ", queued-operations=" + queued + ", allow-nulls=" + allowNulls + "]"));
        return msg;
    }

    public static String getSCOWrapperOptionsMessage(boolean useCache, boolean queued, boolean allowNulls, boolean lazyLoading) {
        StringBuilder str = new StringBuilder();
        if (useCache) {
            str.append("cached");
        }
        if (lazyLoading) {
            if (str.length() > 0) {
                str.append(",");
            }
            str.append("lazy-loaded");
        }
        if (queued) {
            if (str.length() > 0) {
                str.append(",");
            }
            str.append("queued");
        }
        if (allowNulls) {
            if (str.length() > 0) {
                str.append(",");
            }
            str.append("allowNulls");
        }
        return str.toString();
    }

    public static boolean allowNullsInContainer(boolean defaultValue, AbstractMemberMetaData mmd) {
        if (mmd.getContainer() == null) {
            return defaultValue;
        }
        if (Boolean.TRUE.equals(mmd.getContainer().allowNulls())) {
            return true;
        }
        if (Boolean.FALSE.equals(mmd.getContainer().allowNulls())) {
            return false;
        }
        return defaultValue;
    }

    public static boolean useContainerCache(ObjectProvider ownerOP, AbstractMemberMetaData mmd) {
        if (ownerOP == null) {
            return false;
        }
        boolean useCache = ownerOP.getExecutionContext().getNucleusContext().getConfiguration().getBooleanProperty("datanucleus.cache.collections");
        if (ownerOP.getExecutionContext().getBooleanProperty("datanucleus.cache.collections") != null) {
            useCache = ownerOP.getExecutionContext().getBooleanProperty("datanucleus.cache.collections");
        }
        if (mmd.getOrderMetaData() != null && !mmd.getOrderMetaData().isIndexedList()) {
            useCache = true;
        } else if (mmd.getContainer() != null && mmd.getContainer().hasExtension("cache")) {
            useCache = Boolean.parseBoolean(mmd.getContainer().getValueForExtension("cache"));
        }
        return useCache;
    }

    public static boolean useCachedLazyLoading(ObjectProvider ownerOP, AbstractMemberMetaData mmd) {
        if (ownerOP == null) {
            return false;
        }
        boolean lazy = false;
        AbstractClassMetaData cmd = ownerOP.getClassMetaData();
        Boolean lazyCollections = ownerOP.getExecutionContext().getNucleusContext().getConfiguration().getBooleanObjectProperty("datanucleus.cache.collections.lazy");
        if (lazyCollections != null) {
            lazy = lazyCollections;
        } else if (mmd.getContainer() != null && mmd.getContainer().hasExtension("cache-lazy-loading")) {
            lazy = Boolean.parseBoolean(mmd.getContainer().getValueForExtension("cache-lazy-loading"));
        } else {
            boolean inFP = false;
            int[] fpFields = ownerOP.getExecutionContext().getFetchPlan().getFetchPlanForClass(cmd).getMemberNumbers();
            int fieldNo = mmd.getAbsoluteFieldNumber();
            if (fpFields != null && fpFields.length > 0) {
                for (int i = 0; i < fpFields.length; ++i) {
                    if (fpFields[i] != fieldNo) continue;
                    inFP = true;
                    break;
                }
            }
            lazy = !inFP;
        }
        return lazy;
    }

    public static boolean collectionHasElementsWithoutIdentity(AbstractMemberMetaData mmd) {
        boolean elementsWithoutIdentity = false;
        if (mmd.isSerialized()) {
            elementsWithoutIdentity = true;
        } else if (mmd.getElementMetaData() != null && mmd.getElementMetaData().getEmbeddedMetaData() != null && mmd.getJoinMetaData() != null) {
            elementsWithoutIdentity = true;
        } else if (mmd.getCollection() != null && mmd.getCollection().isEmbeddedElement()) {
            elementsWithoutIdentity = true;
        }
        return elementsWithoutIdentity;
    }

    public static boolean mapHasKeysWithoutIdentity(AbstractMemberMetaData fmd) {
        boolean keysWithoutIdentity = false;
        if (fmd.isSerialized()) {
            keysWithoutIdentity = true;
        } else if (fmd.getKeyMetaData() != null && fmd.getKeyMetaData().getEmbeddedMetaData() != null && fmd.getJoinMetaData() != null) {
            keysWithoutIdentity = true;
        } else if (fmd.getMap() != null && fmd.getMap().isEmbeddedKey()) {
            keysWithoutIdentity = true;
        }
        return keysWithoutIdentity;
    }

    public static boolean mapHasValuesWithoutIdentity(AbstractMemberMetaData fmd) {
        boolean valuesWithoutIdentity = false;
        if (fmd.isSerialized()) {
            valuesWithoutIdentity = true;
        } else if (fmd.getValueMetaData() != null && fmd.getValueMetaData().getEmbeddedMetaData() != null && fmd.getJoinMetaData() != null) {
            valuesWithoutIdentity = true;
        } else if (fmd.getMap() != null && fmd.getMap().isEmbeddedValue()) {
            valuesWithoutIdentity = true;
        }
        return valuesWithoutIdentity;
    }

    public static boolean collectionHasSerialisedElements(AbstractMemberMetaData fmd) {
        boolean serialised = fmd.isSerialized();
        if (fmd.getCollection() != null && fmd.getCollection().isEmbeddedElement() && fmd.getJoinMetaData() == null) {
            serialised = true;
        }
        return serialised;
    }

    public static boolean arrayIsStoredInSingleColumn(AbstractMemberMetaData fmd, MetaDataManager mmgr) {
        boolean singleColumn = fmd.isSerialized();
        if (!singleColumn && fmd.getArray() != null && fmd.getJoinMetaData() == null) {
            if (fmd.getArray().isEmbeddedElement()) {
                singleColumn = true;
            }
            Class<?> elementClass = fmd.getType().getComponentType();
            ApiAdapter api = mmgr.getApiAdapter();
            if (!elementClass.isInterface() && !api.isPersistable(elementClass)) {
                singleColumn = true;
            }
        }
        return singleColumn;
    }

    public static boolean mapHasSerialisedKeysAndValues(AbstractMemberMetaData fmd) {
        boolean inverseKeyField = false;
        if (fmd.getKeyMetaData() != null && fmd.getKeyMetaData().getMappedBy() != null) {
            inverseKeyField = true;
        }
        boolean inverseValueField = false;
        if (fmd.getValueMetaData() != null && fmd.getValueMetaData().getMappedBy() != null) {
            inverseValueField = true;
        }
        boolean serialised = fmd.isSerialized();
        if (fmd.getMap() != null && fmd.getJoinMetaData() == null && fmd.getMap().isEmbeddedKey() && fmd.getMap().isEmbeddedValue() && !inverseKeyField && !inverseValueField) {
            serialised = true;
        }
        return serialised;
    }

    public static boolean attachCopyElements(ObjectProvider ownerOP, Collection scoColl, Collection detachedElements, boolean elementsWithoutId) {
        boolean contained;
        boolean updated = false;
        ApiAdapter api = ownerOP.getExecutionContext().getApiAdapter();
        Iterator scoCollIter = scoColl.iterator();
        while (scoCollIter.hasNext()) {
            Object currentElem = scoCollIter.next();
            Object currentElemId = api.getIdForObject(currentElem);
            Iterator desiredIter = detachedElements.iterator();
            contained = false;
            if (elementsWithoutId) {
                contained = detachedElements.contains(currentElem);
            } else {
                while (desiredIter.hasNext()) {
                    Object desiredElem = desiredIter.next();
                    if (currentElemId != null) {
                        if (!currentElemId.equals(api.getIdForObject(desiredElem))) continue;
                        contained = true;
                        break;
                    }
                    if (currentElem != desiredElem) continue;
                    contained = true;
                    break;
                }
            }
            if (contained) continue;
            scoCollIter.remove();
            updated = true;
        }
        for (Object detachedElement : detachedElements) {
            if (elementsWithoutId) {
                if (scoColl.contains(detachedElement)) continue;
                scoColl.add(detachedElement);
                updated = true;
                continue;
            }
            Object detachedElemId = api.getIdForObject(detachedElement);
            scoCollIter = scoColl.iterator();
            contained = false;
            while (scoCollIter.hasNext()) {
                Object scoCollElem = scoCollIter.next();
                Object scoCollElemId = api.getIdForObject(scoCollElem);
                if (scoCollElemId == null || !scoCollElemId.equals(detachedElemId)) continue;
                contained = true;
                break;
            }
            if (!contained) {
                scoColl.add(detachedElement);
                updated = true;
                continue;
            }
            ownerOP.getExecutionContext().attachObjectCopy(ownerOP, detachedElement, false);
        }
        return updated;
    }

    public static void attachCopyForCollection(ObjectProvider ownerOP, Object[] detachedElements, Collection attached, boolean elementsWithoutIdentity) {
        ApiAdapter api = ownerOP.getExecutionContext().getApiAdapter();
        for (int i = 0; i < detachedElements.length; ++i) {
            if (api.isPersistable(detachedElements[i]) && api.isDetachable(detachedElements[i])) {
                attached.add(ownerOP.getExecutionContext().attachObjectCopy(ownerOP, detachedElements[i], elementsWithoutIdentity));
                continue;
            }
            attached.add(detachedElements[i]);
        }
    }

    public static boolean updateListWithListElements(List list, List elements) {
        boolean updated = false;
        ArrayList newCopy = new ArrayList(elements);
        Iterator attachedIter = list.iterator();
        while (attachedIter.hasNext()) {
            Object attachedElement = attachedIter.next();
            if (newCopy.remove(attachedElement)) continue;
            attachedIter.remove();
            updated = true;
        }
        ArrayList oldCopy = new ArrayList(list);
        for (Object element : elements) {
            if (oldCopy.remove(element)) continue;
            list.add(element);
            updated = true;
        }
        Iterator elementsIter = elements.iterator();
        int position = 0;
        while (elementsIter.hasNext()) {
            Object element = elementsIter.next();
            Object currentElement = list.get(position);
            boolean updatePosition = false;
            if (element == null && currentElement != null || element != null && currentElement == null) {
                updatePosition = true;
            } else if (element != null && currentElement != null && !currentElement.equals(element)) {
                updatePosition = true;
            }
            if (updatePosition) {
                ((SCOList)((Object)list)).set(position, element, false);
                updated = true;
            }
            ++position;
        }
        return updated;
    }

    public static void attachCopyForMap(ObjectProvider ownerOP, Set detachedEntries, Map attached, boolean keysWithoutIdentity, boolean valuesWithoutIdentity) {
        Iterator iter = detachedEntries.iterator();
        ApiAdapter api = ownerOP.getExecutionContext().getApiAdapter();
        while (iter.hasNext()) {
            Map.Entry entry = (Map.Entry)iter.next();
            Object val = entry.getValue();
            Object key = entry.getKey();
            if (api.isPersistable(val) && api.isDetachable(val)) {
                val = ownerOP.getExecutionContext().attachObjectCopy(ownerOP, val, valuesWithoutIdentity);
            }
            if (api.isPersistable(key) && api.isDetachable(key)) {
                key = ownerOP.getExecutionContext().attachObjectCopy(ownerOP, key, keysWithoutIdentity);
            }
            attached.put(key, val);
        }
    }

    public static boolean updateMapWithMapKeysValues(ApiAdapter api, Map map, Map keysValues) {
        boolean updated = false;
        HashMap copy = new HashMap(map);
        for (Map.Entry entry : copy.entrySet()) {
            Object key = entry.getKey();
            if (keysValues.containsKey(key)) continue;
            map.remove(key);
            updated = true;
        }
        for (Map.Entry entry : keysValues.entrySet()) {
            Object key = entry.getKey();
            Object value = entry.getValue();
            if (!map.containsKey(key)) {
                map.put(key, keysValues.get(key));
                updated = true;
                continue;
            }
            Object oldValue = map.get(key);
            if (api.isPersistable(value) && api.getIdForObject(value) != api.getIdForObject(oldValue)) {
                map.put(key, value);
                continue;
            }
            if ((oldValue != null || value == null) && (oldValue == null || oldValue.equals(value))) continue;
            map.put(key, value);
        }
        return updated;
    }

    public static void populateMapDelegateWithStoreData(Map delegate, MapStore store, ObjectProvider ownerOP) {
        HashSet keys = new HashSet();
        if (!store.keysAreEmbedded() && !store.keysAreSerialised()) {
            SetStore keystore = store.keySetStore();
            Iterator keyIter = keystore.iterator(ownerOP);
            while (keyIter.hasNext()) {
                keys.add(keyIter.next());
            }
        }
        ArrayList values = new ArrayList();
        if (!store.valuesAreEmbedded() && !store.valuesAreSerialised()) {
            CollectionStore valuestore = store.valueCollectionStore();
            Iterator valueIter = valuestore.iterator(ownerOP);
            while (valueIter.hasNext()) {
                values.add(valueIter.next());
            }
        }
        SetStore entries = store.entrySetStore();
        Iterator entryIter = entries.iterator(ownerOP);
        while (entryIter.hasNext()) {
            Map.Entry entry = (Map.Entry)entryIter.next();
            Object key = entry.getKey();
            Object value = entry.getValue();
            delegate.put(key, value);
        }
        if (!store.keysAreEmbedded() && !store.keysAreSerialised() && delegate.size() != keys.size()) {
            NucleusLogger.DATASTORE_RETRIEVE.warn("The number of Map key objects (" + keys.size() + ")" + " was different to the number of entries (" + delegate.size() + ")." + " Likely there is a bug in your datastore");
        }
        if (!store.valuesAreEmbedded() && !store.valuesAreSerialised() && delegate.size() != values.size()) {
            NucleusLogger.DATASTORE_RETRIEVE.warn("The number of Map value objects (" + values.size() + ")" + " was different to the number of entries (" + delegate.size() + ")." + " Likely there is a bug in your datastore");
        }
        keys.clear();
        values.clear();
    }

    public static Object[] toArray(CollectionStore backingStore, ObjectProvider op) {
        Object[] result = new Object[backingStore.size(op)];
        Iterator it = backingStore.iterator(op);
        int i = 0;
        while (it.hasNext()) {
            result[i] = it.next();
            ++i;
        }
        return result;
    }

    public static Object[] toArray(CollectionStore backingStore, ObjectProvider op, Object[] a) {
        int size = backingStore.size(op);
        if (a.length < size) {
            a = (Object[])Array.newInstance(a.getClass().getComponentType(), size);
        }
        Iterator it = backingStore.iterator(op);
        for (int i = 0; i < size; ++i) {
            a[i] = it.next();
        }
        if (a.length > size) {
            a[size] = null;
        }
        return a;
    }

    public static Comparator getComparator(AbstractMemberMetaData fmd, ClassLoaderResolver clr) {
        Comparator comparator = null;
        String comparatorName = null;
        if (fmd.hasMap() && fmd.getMap().hasExtension("comparator-name")) {
            comparatorName = fmd.getMap().getValueForExtension("comparator-name");
        } else if (fmd.hasCollection() && fmd.getCollection().hasExtension("comparator-name")) {
            comparatorName = fmd.getCollection().getValueForExtension("comparator-name");
        }
        if (comparatorName != null) {
            Class comparatorCls = null;
            try {
                comparatorCls = clr.classForName(comparatorName);
                comparator = (Comparator)ClassUtils.newInstance(comparatorCls, null, null);
            }
            catch (NucleusException jpe) {
                NucleusLogger.PERSISTENCE.warn(LOCALISER.msg("023012", (Object)fmd.getFullFieldName(), (Object)comparatorName));
            }
        }
        return comparator;
    }

    public static void refreshFetchPlanFieldsForCollection(ObjectProvider ownerOP, Object[] elements) {
        ApiAdapter api = ownerOP.getExecutionContext().getApiAdapter();
        for (int i = 0; i < elements.length; ++i) {
            if (!api.isPersistable(elements[i])) continue;
            ownerOP.getExecutionContext().refreshObject(elements[i]);
        }
    }

    public static void refreshFetchPlanFieldsForMap(ObjectProvider ownerOP, Set entries) {
        ApiAdapter api = ownerOP.getExecutionContext().getApiAdapter();
        for (Map.Entry entry : entries) {
            Object val = entry.getValue();
            Object key = entry.getKey();
            if (api.isPersistable(key)) {
                ownerOP.getExecutionContext().refreshObject(key);
            }
            if (!api.isPersistable(val)) continue;
            ownerOP.getExecutionContext().refreshObject(val);
        }
    }

    public static void detachForCollection(ObjectProvider ownerOP, Object[] elements, FetchPlanState state) {
        ApiAdapter api = ownerOP.getExecutionContext().getApiAdapter();
        for (int i = 0; i < elements.length; ++i) {
            if (!api.isPersistable(elements[i])) continue;
            ownerOP.getExecutionContext().detachObject(elements[i], state);
        }
    }

    public static void detachCopyForCollection(ObjectProvider ownerOP, Object[] elements, FetchPlanState state, Collection detached) {
        ApiAdapter api = ownerOP.getExecutionContext().getApiAdapter();
        for (int i = 0; i < elements.length; ++i) {
            if (elements[i] == null) {
                detached.add(null);
                continue;
            }
            Object object = elements[i];
            if (api.isPersistable(object)) {
                detached.add(ownerOP.getExecutionContext().detachObjectCopy(object, state));
                continue;
            }
            detached.add(object);
        }
    }

    public static void attachForCollection(ObjectProvider ownerOP, Object[] elements, boolean elementsWithoutIdentity) {
        ExecutionContext ec = ownerOP.getExecutionContext();
        ApiAdapter api = ec.getApiAdapter();
        for (int i = 0; i < elements.length; ++i) {
            Object attached;
            if (!api.isPersistable(elements[i]) || (attached = ec.getAttachedObjectForId(api.getIdForObject(elements[i]))) != null) continue;
            ec.attachObject(ownerOP, elements[i], elementsWithoutIdentity);
        }
    }

    public static void detachForMap(ObjectProvider ownerOP, Set entries, FetchPlanState state) {
        ApiAdapter api = ownerOP.getExecutionContext().getApiAdapter();
        for (Map.Entry entry : entries) {
            Object val = entry.getValue();
            Object key = entry.getKey();
            if (api.isPersistable(key)) {
                ownerOP.getExecutionContext().detachObject(key, state);
            }
            if (!api.isPersistable(val)) continue;
            ownerOP.getExecutionContext().detachObject(val, state);
        }
    }

    public static void detachCopyForMap(ObjectProvider ownerOP, Set entries, FetchPlanState state, Map detached) {
        ApiAdapter api = ownerOP.getExecutionContext().getApiAdapter();
        for (Map.Entry entry : entries) {
            Object val = entry.getValue();
            Object key = entry.getKey();
            if (api.isPersistable(val)) {
                val = ownerOP.getExecutionContext().detachObjectCopy(val, state);
            }
            if (api.isPersistable(key)) {
                key = ownerOP.getExecutionContext().detachObjectCopy(key, state);
            }
            detached.put(key, val);
        }
    }

    public static void attachForMap(ObjectProvider ownerOP, Set entries, boolean keysWithoutIdentity, boolean valuesWithoutIdentity) {
        ExecutionContext ec = ownerOP.getExecutionContext();
        ApiAdapter api = ec.getApiAdapter();
        for (Map.Entry entry : entries) {
            Object attached;
            Object val = entry.getValue();
            Object key = entry.getKey();
            if (api.isPersistable(key) && (attached = ec.getAttachedObjectForId(api.getIdForObject(key))) == null) {
                ownerOP.getExecutionContext().attachObject(ownerOP, key, keysWithoutIdentity);
            }
            if (!api.isPersistable(val) || (attached = ec.getAttachedObjectForId(api.getIdForObject(val))) != null) continue;
            ownerOP.getExecutionContext().attachObject(ownerOP, val, valuesWithoutIdentity);
        }
    }

    public static boolean validateObjectForWriting(ExecutionContext ec, Object object, FieldValues fieldValues) {
        boolean persisted = false;
        ApiAdapter api = ec.getApiAdapter();
        if (api.isPersistable(object)) {
            ExecutionContext objectEC = api.getExecutionContext(object);
            if (objectEC != null && ec != objectEC) {
                throw new NucleusUserException(LOCALISER.msg("023009", (Object)StringUtils.toJVMIDString(object)), api.getIdForObject(object));
            }
            if (!api.isPersistent(object)) {
                boolean exists = false;
                if (api.isDetached(object)) {
                    if (ec.getBooleanProperty("datanucleus.attachSameDatastore").booleanValue()) {
                        exists = true;
                    } else {
                        try {
                            ObjectProvider objSM;
                            Object obj = ec.findObject(api.getIdForObject(object), true, false, object.getClass().getName());
                            if (obj != null && (objSM = ec.findObjectProvider(obj)) != null) {
                                ec.evictFromTransaction(objSM);
                            }
                            exists = true;
                        }
                        catch (NucleusObjectNotFoundException onfe) {
                            exists = false;
                        }
                    }
                }
                if (!exists) {
                    ec.persistObjectInternal(object, fieldValues, 0);
                    persisted = true;
                }
            } else {
                ObjectProvider objectSM = ec.findObjectProvider(object);
                if (objectSM.isWaitingToBeFlushedToDatastore()) {
                    if (fieldValues != null) {
                        objectSM.loadFieldValues(fieldValues);
                    }
                    objectSM.flush();
                    persisted = true;
                }
            }
        }
        return persisted;
    }

    public static void validateObjectsForWriting(ExecutionContext ec, Object objects) {
        block3: {
            block4: {
                if (objects == null) break block3;
                if (!objects.getClass().isArray()) break block4;
                if (objects.getClass().getComponentType().isPrimitive()) break block3;
                Object[] obj = (Object[])objects;
                for (int i = 0; i < obj.length; ++i) {
                    SCOUtils.validateObjectForWriting(ec, obj[i], null);
                }
                break block3;
            }
            if (objects instanceof Collection) {
                Collection col = (Collection)objects;
                Iterator it = col.iterator();
                while (it.hasNext()) {
                    SCOUtils.validateObjectForWriting(ec, it.next(), null);
                }
            }
        }
    }

    public static boolean isListBased(Class type) {
        if (type == null) {
            return false;
        }
        if (List.class.isAssignableFrom(type)) {
            return true;
        }
        return Queue.class.isAssignableFrom(type);
    }

    public static Class getContainerInstanceType(Class declaredType, Boolean ordered) {
        if (declaredType.isInterface()) {
            if (SortedSet.class.isAssignableFrom(declaredType)) {
                return TreeSet.class;
            }
            if (SortedMap.class.isAssignableFrom(declaredType)) {
                return TreeMap.class;
            }
            if (List.class.isAssignableFrom(declaredType)) {
                return ArrayList.class;
            }
            if (Set.class.isAssignableFrom(declaredType)) {
                return HashSet.class;
            }
            if (Map.class.isAssignableFrom(declaredType)) {
                return HashMap.class;
            }
            if (ordered.booleanValue()) {
                return ArrayList.class;
            }
            return HashSet.class;
        }
        return declaredType;
    }

    public static boolean detachAsWrapped(ObjectProvider ownerOP) {
        return ownerOP.getExecutionContext().getBooleanProperty("datanucleus.detachAsWrapped");
    }

    public static boolean useQueuedUpdate(boolean queued, ObjectProvider op) {
        return queued && !op.getExecutionContext().isFlushing() && op.getExecutionContext().getTransaction().isActive();
    }

    public static boolean hasDependentElement(AbstractMemberMetaData mmd) {
        return !SCOUtils.collectionHasElementsWithoutIdentity(mmd) && mmd.getCollection() != null && mmd.getCollection().isDependentElement();
    }

    public static boolean hasDependentKey(AbstractMemberMetaData mmd) {
        return !SCOUtils.mapHasKeysWithoutIdentity(mmd) && mmd.getMap() != null && mmd.getMap().isDependentKey();
    }

    public static boolean hasDependentValue(AbstractMemberMetaData mmd) {
        return !SCOUtils.mapHasValuesWithoutIdentity(mmd) && mmd.getMap() != null && mmd.getMap().isDependentValue();
    }

    public static boolean collectionsAreEqual(ApiAdapter api, Collection oldColl, Collection newColl) {
        if (oldColl == null && newColl == null) {
            return true;
        }
        if (oldColl == null || newColl == null) {
            return false;
        }
        if (oldColl.size() != newColl.size()) {
            return false;
        }
        Iterator oldIter = oldColl.iterator();
        Iterator newIter = newColl.iterator();
        while (oldIter.hasNext()) {
            Object oldVal = oldIter.next();
            Object newVal = newIter.next();
            if (oldVal == null && newVal == null) continue;
            if (oldVal == null || newVal == null) {
                return false;
            }
            if (api.isPersistable(oldVal)) {
                Object oldId = api.getIdForObject(oldVal);
                Object newId = api.getIdForObject(newVal);
                if (oldId == null || newId == null) {
                    return false;
                }
                if (oldId.equals(newId)) continue;
                return false;
            }
            if (oldVal.equals(newVal)) continue;
            return false;
        }
        return true;
    }
}

