/*
 * Decompiled with CFR 0.152.
 */
package org.datanucleus.plugin;

import java.io.File;
import java.io.FilenameFilter;
import java.io.IOException;
import java.io.InputStream;
import java.io.Serializable;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.net.JarURLConnection;
import java.net.MalformedURLException;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.jar.JarFile;
import java.util.jar.JarInputStream;
import java.util.jar.Manifest;
import javax.xml.parsers.DocumentBuilder;
import org.datanucleus.ClassConstants;
import org.datanucleus.ClassLoaderResolver;
import org.datanucleus.exceptions.NucleusException;
import org.datanucleus.plugin.Bundle;
import org.datanucleus.plugin.ConfigurationElement;
import org.datanucleus.plugin.Extension;
import org.datanucleus.plugin.ExtensionPoint;
import org.datanucleus.plugin.PluginParser;
import org.datanucleus.plugin.PluginRegistry;
import org.datanucleus.util.Localiser;
import org.datanucleus.util.NucleusLogger;
import org.datanucleus.util.StringUtils;

public class NonManagedPluginRegistry
implements PluginRegistry {
    protected static final Localiser LOCALISER = Localiser.getInstance("org.datanucleus.Localisation", ClassConstants.NUCLEUS_CONTEXT_LOADER);
    private static final String DATANUCLEUS_PKG = "org.datanucleus";
    private static final String PLUGIN_DIR = "/";
    private static final FilenameFilter MANIFEST_FILE_FILTER = new FilenameFilter(){

        @Override
        public boolean accept(File dir, String name) {
            if (name.equalsIgnoreCase("meta-inf")) {
                return true;
            }
            if (!dir.getName().equalsIgnoreCase("meta-inf")) {
                return false;
            }
            return name.equalsIgnoreCase("manifest.mf");
        }
    };
    private static final char JAR_SEPARATOR = '!';
    private final ClassLoaderResolver clr;
    Map<String, ExtensionPoint> extensionPointsByUniqueId = new HashMap<String, ExtensionPoint>();
    Map<String, Bundle> registeredPluginByPluginId = new HashMap<String, Bundle>();
    ExtensionPoint[] extensionPoints;
    private String bundleCheckType = "EXCEPTION";
    private boolean allowUserBundles = false;

    public NonManagedPluginRegistry(ClassLoaderResolver clr, String bundleCheckType, boolean allowUserBundles) {
        this.clr = clr;
        this.extensionPoints = new ExtensionPoint[0];
        this.bundleCheckType = bundleCheckType != null ? bundleCheckType : "EXCEPTION";
        this.allowUserBundles = allowUserBundles;
    }

    @Override
    public ExtensionPoint getExtensionPoint(String id) {
        return this.extensionPointsByUniqueId.get(id);
    }

    @Override
    public ExtensionPoint[] getExtensionPoints() {
        return this.extensionPoints;
    }

    @Override
    public void registerExtensionPoints() {
        this.registerExtensions();
    }

    public void registerExtensionsForPlugin(URL pluginURL, Bundle bundle) {
        DocumentBuilder docBuilder = PluginParser.getDocumentBuilder();
        List[] elements = PluginParser.parsePluginElements(docBuilder, this, pluginURL, bundle, this.clr);
        this.registerExtensionPointsForPluginInternal(elements[0], true);
        for (Extension extension : elements[1]) {
            ExtensionPoint exPoint = this.extensionPointsByUniqueId.get(extension.getExtensionPointId());
            if (exPoint == null) {
                NucleusLogger.GENERAL.warn(LOCALISER.msg("024002", (Object)extension.getExtensionPointId(), (Object)extension.getPlugin().getSymbolicName(), (Object)extension.getPlugin().getManifestLocation().toString()));
                continue;
            }
            extension.setExtensionPoint(exPoint);
            exPoint.addExtension(extension);
        }
    }

    @Override
    public void registerExtensions() {
        if (this.extensionPoints.length > 0) {
            return;
        }
        ArrayList registeringExtensions = new ArrayList();
        DocumentBuilder docBuilder = PluginParser.getDocumentBuilder();
        try {
            Enumeration<URL> paths = this.clr.getResources("/plugin.xml", ClassConstants.NUCLEUS_CONTEXT_LOADER);
            while (paths.hasMoreElements()) {
                Bundle bundle;
                URL pluginURL = paths.nextElement();
                URL manifest = this.getManifestURL(pluginURL);
                if (manifest == null || (bundle = this.registerBundle(manifest)) == null) continue;
                List[] elements = PluginParser.parsePluginElements(docBuilder, this, pluginURL, bundle, this.clr);
                this.registerExtensionPointsForPluginInternal(elements[0], false);
                registeringExtensions.addAll(elements[1]);
            }
        }
        catch (IOException e) {
            throw new NucleusException("Error loading resource", e).setFatal();
        }
        this.extensionPoints = this.extensionPointsByUniqueId.values().toArray(new ExtensionPoint[this.extensionPointsByUniqueId.values().size()]);
        for (int i = 0; i < registeringExtensions.size(); ++i) {
            Extension extension = (Extension)registeringExtensions.get(i);
            ExtensionPoint exPoint = this.getExtensionPoint(extension.getExtensionPointId());
            if (exPoint == null) {
                if (extension.getPlugin() == null || extension.getPlugin().getSymbolicName() == null || !extension.getPlugin().getSymbolicName().startsWith(DATANUCLEUS_PKG)) continue;
                NucleusLogger.GENERAL.warn(LOCALISER.msg("024002", (Object)extension.getExtensionPointId(), (Object)extension.getPlugin().getSymbolicName(), (Object)extension.getPlugin().getManifestLocation().toString()));
                continue;
            }
            extension.setExtensionPoint(exPoint);
            exPoint.addExtension(extension);
        }
        if (this.allowUserBundles) {
            ExtensionSorter sorter = new ExtensionSorter();
            for (int i = 0; i < this.extensionPoints.length; ++i) {
                ExtensionPoint pt = this.extensionPoints[i];
                pt.sortExtensions(sorter);
            }
        }
    }

    protected void registerExtensionPointsForPluginInternal(List extPoints, boolean updateExtensionPointsArray) {
        for (ExtensionPoint exPoint : extPoints) {
            this.extensionPointsByUniqueId.put(exPoint.getUniqueId(), exPoint);
        }
        if (updateExtensionPointsArray) {
            this.extensionPoints = this.extensionPointsByUniqueId.values().toArray(new ExtensionPoint[this.extensionPointsByUniqueId.values().size()]);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected Bundle registerBundle(URL manifest) {
        if (manifest == null) {
            throw new IllegalArgumentException(LOCALISER.msg("024007"));
        }
        InputStream is = null;
        try {
            Manifest mf = null;
            if (manifest.getProtocol().equals("jar") || manifest.getProtocol().equals("zip") || manifest.getProtocol().equals("wsjar")) {
                File jarFile;
                int index;
                String path;
                String jarPath;
                if (manifest.getPath().startsWith("http://") || manifest.getPath().startsWith("https://")) {
                    JarURLConnection jarConnection = (JarURLConnection)manifest.openConnection();
                    URL url = jarConnection.getJarFileURL();
                    mf = jarConnection.getManifest();
                    if (mf == null) {
                        Bundle bundle = null;
                        return bundle;
                    }
                    Bundle bundle = this.registerBundle(mf, url);
                    return bundle;
                }
                int begin = 4;
                if (manifest.getProtocol().equals("wsjar")) {
                    begin = 6;
                }
                if ((jarPath = (path = StringUtils.getDecodedStringFromURLString(manifest.toExternalForm())).substring(begin, index = path.indexOf(33))).startsWith("file:")) {
                    jarPath = jarPath.substring(5);
                }
                if ((mf = new JarFile(jarFile = new File(jarPath)).getManifest()) == null) {
                    Bundle bundle = null;
                    return bundle;
                }
                Bundle bundle = this.registerBundle(mf, jarFile.toURI().toURL());
                return bundle;
            }
            if (manifest.getProtocol().equals("rar") || manifest.getProtocol().equals("war")) {
                String path = StringUtils.getDecodedStringFromURLString(manifest.toExternalForm());
                int index = path.indexOf(33);
                String rarPath = path.substring(4, index);
                File file = new File(rarPath);
                URL rarUrl = file.toURI().toURL();
                String jarPath = path.substring(index + 1, path.indexOf(33, index + 1));
                JarFile rarFile = new JarFile(file);
                try (JarInputStream jis = new JarInputStream(rarFile.getInputStream(rarFile.getEntry(jarPath)));){
                    mf = jis.getManifest();
                    if (mf == null) {
                        Bundle bundle = null;
                        return bundle;
                    }
                }
                Bundle bundle = this.registerBundle(mf, rarUrl);
                return bundle;
            }
            is = manifest.openStream();
            mf = new Manifest(is);
            Bundle bundle = this.registerBundle(mf, manifest);
            return bundle;
        }
        catch (IOException e) {
            throw new NucleusException(LOCALISER.msg("024008", manifest), e).setFatal();
        }
        finally {
            if (is != null) {
                try {
                    is.close();
                }
                catch (IOException e) {}
            }
        }
    }

    protected Bundle registerBundle(Manifest mf, URL manifest) {
        Bundle bundle = PluginParser.parseManifest(mf, manifest);
        if (bundle == null || bundle.getSymbolicName() == null) {
            return null;
        }
        if (!this.allowUserBundles && !bundle.getSymbolicName().startsWith(DATANUCLEUS_PKG)) {
            NucleusLogger.GENERAL.debug("Ignoring bundle " + bundle.getSymbolicName() + " since not DataNucleus, and only loading DataNucleus bundles");
            return null;
        }
        if (this.registeredPluginByPluginId.get(bundle.getSymbolicName()) == null) {
            if (NucleusLogger.GENERAL.isDebugEnabled()) {
                NucleusLogger.GENERAL.debug("Registering bundle " + bundle.getSymbolicName() + " version " + bundle.getVersion() + " at URL " + bundle.getManifestLocation() + ".");
            }
            this.registeredPluginByPluginId.put(bundle.getSymbolicName(), bundle);
        } else {
            Bundle previousBundle = this.registeredPluginByPluginId.get(bundle.getSymbolicName());
            if (bundle.getSymbolicName().startsWith(DATANUCLEUS_PKG) && !bundle.getManifestLocation().toExternalForm().equals(previousBundle.getManifestLocation().toExternalForm())) {
                String msg = LOCALISER.msg("024009", (Object)bundle.getSymbolicName(), (Object)bundle.getManifestLocation(), (Object)previousBundle.getManifestLocation());
                if (this.bundleCheckType.equalsIgnoreCase("EXCEPTION")) {
                    throw new NucleusException(msg);
                }
                if (this.bundleCheckType.equalsIgnoreCase("LOG")) {
                    NucleusLogger.GENERAL.warn(msg);
                }
            }
        }
        return bundle;
    }

    private URL getManifestURL(URL pluginURL) {
        if (pluginURL == null) {
            return null;
        }
        if (pluginURL.toString().startsWith("jar") || pluginURL.toString().startsWith("zip") || pluginURL.toString().startsWith("rar") || pluginURL.toString().startsWith("war") || pluginURL.toString().startsWith("wsjar")) {
            return pluginURL;
        }
        if (pluginURL.toString().startsWith("vfs")) {
            String urlStr = pluginURL.toString().replace("plugin.xml", "META-INF/MANIFEST.MF");
            try {
                return new URL(urlStr);
            }
            catch (MalformedURLException e) {
                NucleusLogger.GENERAL.warn(LOCALISER.msg("024010", (Object)urlStr), e);
                return null;
            }
        }
        if (pluginURL.toString().startsWith("jndi")) {
            String urlStr = pluginURL.toString().substring(5);
            urlStr = urlStr.replaceAll("\\.jar/", ".jar!/");
            urlStr = "jar:file:" + urlStr;
            try {
                return new URL(urlStr);
            }
            catch (MalformedURLException e) {
                NucleusLogger.GENERAL.warn(LOCALISER.msg("024010", (Object)urlStr), e);
                return null;
            }
        }
        if (pluginURL.toString().startsWith("code-source")) {
            String urlStr = pluginURL.toString().substring(12);
            urlStr = "jar:file:" + urlStr;
            try {
                return new URL(urlStr);
            }
            catch (MalformedURLException e) {
                NucleusLogger.GENERAL.warn(LOCALISER.msg("024010", (Object)urlStr), e);
                return null;
            }
        }
        try {
            File[] files;
            File file = new File(new URI(pluginURL.toString()).getPath());
            File[] dirs = new File(file.getParent()).listFiles(MANIFEST_FILE_FILTER);
            if (dirs != null && dirs.length > 0 && (files = dirs[0].listFiles(MANIFEST_FILE_FILTER)) != null && files.length > 0) {
                try {
                    return files[0].toURI().toURL();
                }
                catch (MalformedURLException e) {
                    NucleusLogger.GENERAL.warn(LOCALISER.msg("024011", pluginURL), e);
                    return null;
                }
            }
        }
        catch (URISyntaxException use) {
            use.printStackTrace();
            NucleusLogger.GENERAL.warn(LOCALISER.msg("024011", pluginURL), use);
            return null;
        }
        NucleusLogger.GENERAL.warn(LOCALISER.msg("024012", pluginURL));
        return null;
    }

    @Override
    public Object createExecutableExtension(ConfigurationElement confElm, String name, Class[] argsClass, Object[] args) throws ClassNotFoundException, SecurityException, NoSuchMethodException, IllegalArgumentException, InstantiationException, IllegalAccessException, InvocationTargetException {
        Class cls = this.clr.classForName(confElm.getAttribute(name), ClassConstants.NUCLEUS_CONTEXT_LOADER);
        Constructor constructor = cls.getConstructor(argsClass);
        return constructor.newInstance(args);
    }

    @Override
    public Class loadClass(String pluginId, String className) throws ClassNotFoundException {
        return this.clr.classForName(className, ClassConstants.NUCLEUS_CONTEXT_LOADER);
    }

    @Override
    public URL resolveURLAsFileURL(URL url) throws IOException {
        return url;
    }

    @Override
    public void resolveConstraints() {
        for (Bundle bundle : this.registeredPluginByPluginId.values()) {
            List set = bundle.getRequireBundle();
            for (Bundle.BundleDescription bd : set) {
                String symbolicName = bd.getBundleSymbolicName();
                Bundle requiredBundle = this.registeredPluginByPluginId.get(symbolicName);
                if (requiredBundle == null) {
                    if (bd.getParameter("resolution") != null && bd.getParameter("resolution").equalsIgnoreCase("optional")) {
                        NucleusLogger.GENERAL.debug(LOCALISER.msg("024013", (Object)bundle.getSymbolicName(), (Object)symbolicName));
                    } else {
                        NucleusLogger.GENERAL.error(LOCALISER.msg("024014", (Object)bundle.getSymbolicName(), (Object)symbolicName));
                    }
                }
                if (bd.getParameter("bundle-version") == null || requiredBundle == null || this.isVersionInInterval(requiredBundle.getVersion(), bd.getParameter("bundle-version"))) continue;
                NucleusLogger.GENERAL.error(LOCALISER.msg("024015", (Object)bundle.getSymbolicName(), (Object)symbolicName, (Object)bd.getParameter("bundle-version"), (Object)bundle.getVersion()));
            }
        }
    }

    private boolean isVersionInInterval(String version, String interval) {
        Bundle.BundleVersionRange versionRange = PluginParser.parseVersionRange(version);
        Bundle.BundleVersionRange intervalRange = PluginParser.parseVersionRange(interval);
        int compare_floor = versionRange.floor.compareTo(intervalRange.floor);
        boolean result = true;
        if (intervalRange.floor_inclusive) {
            result = compare_floor >= 0;
        } else {
            boolean bl = result = compare_floor > 0;
        }
        if (intervalRange.ceiling != null) {
            int compare_ceiling = versionRange.floor.compareTo(intervalRange.ceiling);
            result = intervalRange.ceiling_inclusive ? compare_ceiling <= 0 : compare_ceiling < 0;
        }
        return result;
    }

    @Override
    public Bundle[] getBundles() {
        return this.registeredPluginByPluginId.values().toArray(new Bundle[this.registeredPluginByPluginId.values().size()]);
    }

    protected static class ExtensionSorter
    implements Comparator<Extension>,
    Serializable {
        protected ExtensionSorter() {
        }

        @Override
        public int compare(Extension o1, Extension o2) {
            String name1 = o1.getPlugin().getSymbolicName();
            String name2 = o2.getPlugin().getSymbolicName();
            if (name1.startsWith(NonManagedPluginRegistry.DATANUCLEUS_PKG) && !name2.startsWith(NonManagedPluginRegistry.DATANUCLEUS_PKG)) {
                return -1;
            }
            if (!name1.startsWith(NonManagedPluginRegistry.DATANUCLEUS_PKG) && name2.startsWith(NonManagedPluginRegistry.DATANUCLEUS_PKG)) {
                return 1;
            }
            return name1.compareTo(name2);
        }
    }
}

