/*
 * Decompiled with CFR 0.152.
 */
package org.datanucleus.identity;

import java.lang.reflect.Constructor;
import java.lang.reflect.Modifier;
import org.datanucleus.ClassConstants;
import org.datanucleus.ClassLoaderResolver;
import org.datanucleus.PersistenceNucleusContext;
import org.datanucleus.enhancer.EnhancementHelper;
import org.datanucleus.enhancer.Persistable;
import org.datanucleus.exceptions.ClassNotResolvedException;
import org.datanucleus.exceptions.NucleusException;
import org.datanucleus.exceptions.NucleusUserException;
import org.datanucleus.identity.DatastoreId;
import org.datanucleus.identity.DatastoreIdImpl;
import org.datanucleus.identity.DatastoreUniqueLongId;
import org.datanucleus.identity.IdentityKeyTranslator;
import org.datanucleus.identity.IdentityManager;
import org.datanucleus.identity.IdentityStringTranslator;
import org.datanucleus.identity.SingleFieldId;
import org.datanucleus.metadata.AbstractClassMetaData;
import org.datanucleus.metadata.IdentityType;
import org.datanucleus.util.ClassUtils;
import org.datanucleus.util.Localiser;
import org.datanucleus.util.NucleusLogger;

public class IdentityManagerImpl
implements IdentityManager {
    protected static final Localiser LOCALISER = Localiser.getInstance("org.datanucleus.Localisation", ClassConstants.NUCLEUS_CONTEXT_LOADER);
    protected Class datastoreIdClass = null;
    protected IdentityStringTranslator idStringTranslator = null;
    protected IdentityKeyTranslator idKeyTranslator = null;
    PersistenceNucleusContext nucCtx;

    public IdentityManagerImpl(PersistenceNucleusContext nucCtx) {
        String stringTranslatorType;
        this.nucCtx = nucCtx;
        String dsidName = nucCtx.getConfiguration().getStringProperty("datanucleus.datastoreIdentityType");
        String datastoreIdentityClassName = nucCtx.getPluginManager().getAttributeValueForExtension("org.datanucleus.store_datastoreidentity", "name", dsidName, "class-name");
        if (datastoreIdentityClassName == null) {
            throw new NucleusUserException(LOCALISER.msg("002001", (Object)dsidName)).setFatal();
        }
        ClassLoaderResolver clr = nucCtx.getClassLoaderResolver(null);
        try {
            this.datastoreIdClass = clr.classForName(datastoreIdentityClassName, ClassConstants.NUCLEUS_CONTEXT_LOADER);
        }
        catch (ClassNotResolvedException cnre) {
            throw new NucleusUserException(LOCALISER.msg("002002", (Object)dsidName, (Object)datastoreIdentityClassName)).setFatal();
        }
        String keyTranslatorType = nucCtx.getConfiguration().getStringProperty("datanucleus.identityKeyTranslatorType");
        if (keyTranslatorType != null) {
            try {
                this.idKeyTranslator = (IdentityKeyTranslator)nucCtx.getPluginManager().createExecutableExtension("org.datanucleus.identity_key_translator", "name", keyTranslatorType, "class-name", null, null);
            }
            catch (Exception e) {
                throw new NucleusUserException(LOCALISER.msg("002001", (Object)keyTranslatorType)).setFatal();
            }
        }
        if ((stringTranslatorType = nucCtx.getConfiguration().getStringProperty("datanucleus.identityStringTranslatorType")) != null) {
            try {
                this.idStringTranslator = (IdentityStringTranslator)nucCtx.getPluginManager().createExecutableExtension("org.datanucleus.identity_string_translator", "name", stringTranslatorType, "class-name", null, null);
            }
            catch (Exception e) {
                throw new NucleusUserException(LOCALISER.msg("002001", (Object)stringTranslatorType)).setFatal();
            }
        }
    }

    @Override
    public Class getDatastoreIdClass() {
        return this.datastoreIdClass;
    }

    @Override
    public IdentityStringTranslator getIdentityStringTranslator() {
        return this.idStringTranslator;
    }

    @Override
    public IdentityKeyTranslator getIdentityKeyTranslator() {
        return this.idKeyTranslator;
    }

    @Override
    public DatastoreId getDatastoreId(String className, Object value) {
        DatastoreId oid = this.datastoreIdClass == ClassConstants.IDENTITY_OID_IMPL ? new DatastoreIdImpl(className, value) : (DatastoreId)ClassUtils.newInstance(this.datastoreIdClass, new Class[]{String.class, Object.class}, new Object[]{className, value});
        return oid;
    }

    @Override
    public DatastoreId getDatastoreId(long value) {
        DatastoreId oid = this.datastoreIdClass == DatastoreUniqueLongId.class ? new DatastoreUniqueLongId(value) : (DatastoreId)ClassUtils.newInstance(this.datastoreIdClass, new Class[]{Long.class}, new Object[]{value});
        return oid;
    }

    @Override
    public DatastoreId getDatastoreId(String oidString) {
        DatastoreId oid = this.datastoreIdClass == ClassConstants.IDENTITY_OID_IMPL ? new DatastoreIdImpl(oidString) : (DatastoreId)ClassUtils.newInstance(this.datastoreIdClass, new Class[]{String.class}, new Object[]{oidString});
        return oid;
    }

    @Override
    public SingleFieldId getSingleFieldId(Class idType, Class pcType, Object key) {
        if (idType == null) {
            throw new NucleusException(LOCALISER.msg("029001", pcType)).setFatal();
        }
        if (pcType == null) {
            throw new NucleusException(LOCALISER.msg("029000", idType)).setFatal();
        }
        if (key == null) {
            throw new NucleusException(LOCALISER.msg("029003", idType, (Object)pcType)).setFatal();
        }
        if (!SingleFieldId.class.isAssignableFrom(idType)) {
            throw new NucleusException(LOCALISER.msg("029002", (Object)idType.getName(), (Object)pcType.getName())).setFatal();
        }
        SingleFieldId id = null;
        Class keyType = null;
        if (idType == ClassConstants.IDENTITY_SINGLEFIELD_LONG) {
            keyType = Long.class;
            if (!(key instanceof Long)) {
                throw new NucleusException(LOCALISER.msg("029004", (Object)idType.getName(), (Object)pcType.getName(), (Object)key.getClass().getName(), (Object)"Long")).setFatal();
            }
        } else if (idType == ClassConstants.IDENTITY_SINGLEFIELD_INT) {
            keyType = Integer.class;
            if (!(key instanceof Integer)) {
                throw new NucleusException(LOCALISER.msg("029004", (Object)idType.getName(), (Object)pcType.getName(), (Object)key.getClass().getName(), (Object)"Integer")).setFatal();
            }
        } else if (idType == ClassConstants.IDENTITY_SINGLEFIELD_STRING) {
            keyType = String.class;
            if (!(key instanceof String)) {
                throw new NucleusException(LOCALISER.msg("029004", (Object)idType.getName(), (Object)pcType.getName(), (Object)key.getClass().getName(), (Object)"String")).setFatal();
            }
        } else if (idType == ClassConstants.IDENTITY_SINGLEFIELD_BYTE) {
            keyType = Byte.class;
            if (!(key instanceof Byte)) {
                throw new NucleusException(LOCALISER.msg("029004", (Object)idType.getName(), (Object)pcType.getName(), (Object)key.getClass().getName(), (Object)"Byte")).setFatal();
            }
        } else if (idType == ClassConstants.IDENTITY_SINGLEFIELD_SHORT) {
            keyType = Short.class;
            if (!(key instanceof Short)) {
                throw new NucleusException(LOCALISER.msg("029004", (Object)idType.getName(), (Object)pcType.getName(), (Object)key.getClass().getName(), (Object)"Short")).setFatal();
            }
        } else if (idType == ClassConstants.IDENTITY_SINGLEFIELD_CHAR) {
            keyType = Character.class;
            if (!(key instanceof Character)) {
                throw new NucleusException(LOCALISER.msg("029004", (Object)idType.getName(), (Object)pcType.getName(), (Object)key.getClass().getName(), (Object)"Character")).setFatal();
            }
        } else {
            keyType = Object.class;
        }
        try {
            Class[] ctrArgs = new Class[]{Class.class, keyType};
            Object[] args = new Object[]{pcType, key};
            id = (SingleFieldId)idType.getConstructor(ctrArgs).newInstance(args);
        }
        catch (Exception e) {
            NucleusLogger.PERSISTENCE.error("Error encountered while creating SingleFieldIdentity instance of type \"" + idType.getName() + "\"");
            NucleusLogger.PERSISTENCE.error(e);
            return null;
        }
        return id;
    }

    @Override
    public Object getApplicationId(ClassLoaderResolver clr, AbstractClassMetaData acmd, String keyToString) {
        if (acmd.getIdentityType() != IdentityType.APPLICATION) {
            throw new NucleusException("This class (" + acmd.getFullClassName() + ") doesn't use application-identity!");
        }
        Class targetClass = clr.classForName(acmd.getFullClassName());
        Class idType = clr.classForName(acmd.getObjectidClass());
        Object id = null;
        if (acmd.usesSingleFieldIdentityClass()) {
            try {
                Class[] ctrArgs = ClassConstants.IDENTITY_SINGLEFIELD_OBJECT.isAssignableFrom(idType) ? new Class[]{Class.class, Object.class} : new Class[]{Class.class, String.class};
                Object[] args = new Object[]{targetClass, keyToString};
                id = idType.getConstructor(ctrArgs).newInstance(args);
            }
            catch (Exception e) {
                throw new NucleusException("Error encountered while creating single-field identity instance with key \"" + keyToString + "\"", e);
            }
        } else if (Modifier.isAbstract(targetClass.getModifiers()) && acmd.getObjectidClass() != null) {
            try {
                Constructor c = clr.classForName(acmd.getObjectidClass()).getDeclaredConstructor(String.class);
                id = c.newInstance(keyToString);
            }
            catch (Exception e) {
                String msg = LOCALISER.msg("010030", (Object)acmd.getObjectidClass(), (Object)acmd.getFullClassName());
                NucleusLogger.PERSISTENCE.error(msg);
                NucleusLogger.PERSISTENCE.error(e);
                throw new NucleusUserException(msg);
            }
        } else {
            clr.classForName(targetClass.getName(), true);
            id = EnhancementHelper.getInstance().newObjectIdInstance(targetClass, keyToString);
        }
        return id;
    }

    @Override
    public Object getApplicationId(Object pc, AbstractClassMetaData cmd) {
        if (pc == null || cmd == null) {
            return null;
        }
        try {
            Object id = ((Persistable)pc).dnNewObjectIdInstance();
            if (!cmd.usesSingleFieldIdentityClass()) {
                ((Persistable)pc).dnCopyKeyFieldsToObjectId(id);
            }
            return id;
        }
        catch (Exception e) {
            return null;
        }
    }

    @Override
    public Object getApplicationId(Class cls, Object key) {
        return EnhancementHelper.getInstance().newObjectIdInstance(cls, key);
    }
}

