/*
 * Decompiled with CFR 0.152.
 */
package org.datanucleus.store.types.converters;

import java.math.BigDecimal;
import org.datanucleus.exceptions.NucleusDataStoreException;
import org.datanucleus.store.types.converters.TypeConverter;

public class BigDecimalDoubleConverter
implements TypeConverter<BigDecimal, Double> {
    @Override
    public BigDecimal toMemberType(Double val) {
        if (val == null) {
            return null;
        }
        try {
            return BigDecimal.valueOf(val);
        }
        catch (NumberFormatException nfe) {
            throw new NucleusDataStoreException(LOCALISER.msg("016002", val, (Object)BigDecimal.class.getName()), nfe);
        }
    }

    @Override
    public Double toDatastoreType(BigDecimal bd) {
        return bd.doubleValue();
    }
}

