/*
 * Decompiled with CFR 0.152.
 */
package org.datanucleus.store;

import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.concurrent.ConcurrentHashMap;
import org.datanucleus.ClassConstants;
import org.datanucleus.metadata.AbstractMemberMetaData;
import org.datanucleus.store.StoreData;
import org.datanucleus.util.Localiser;
import org.datanucleus.util.NucleusLogger;

public class StoreDataManager {
    protected static final Localiser LOCALISER = Localiser.getInstance("org.datanucleus.Localisation", ClassConstants.NUCLEUS_CONTEXT_LOADER);
    protected ConcurrentHashMap<Object, StoreData> storeDataByClass = new ConcurrentHashMap();
    protected ConcurrentHashMap<Object, StoreData> savedStoreDataByClass;

    public void clear() {
        if (NucleusLogger.PERSISTENCE.isDebugEnabled()) {
            NucleusLogger.PERSISTENCE.debug(LOCALISER.msg("032002"));
        }
        this.storeDataByClass.clear();
    }

    public void deregisterClass(String className) {
        this.storeDataByClass.remove(className);
    }

    protected void registerStoreData(StoreData data) {
        if (data.isFCO()) {
            if (this.storeDataByClass.containsKey(data.getName())) {
                return;
            }
            this.storeDataByClass.put(data.getName(), data);
        } else {
            if (this.storeDataByClass.containsKey(data.getMetaData())) {
                return;
            }
            this.storeDataByClass.put(data.getMetaData(), data);
        }
        if (NucleusLogger.PERSISTENCE.isDebugEnabled()) {
            NucleusLogger.PERSISTENCE.debug(LOCALISER.msg("032001", data));
        }
    }

    public StoreData[] getStoreDataForProperties(String key1, Object value1, String key2, Object value2) {
        HashSet<StoreData> results = null;
        Collection<StoreData> storeDatas = this.storeDataByClass.values();
        for (StoreData data : storeDatas) {
            if (data.getProperties() == null) continue;
            Object prop1Value = data.getProperties().get(key1);
            Object prop2Value = data.getProperties().get(key2);
            if (prop1Value == null || !prop1Value.equals(value1) || prop2Value == null || !prop2Value.equals(value2)) continue;
            if (results == null) {
                results = new HashSet<StoreData>();
            }
            results.add(data);
        }
        if (results != null) {
            return results.toArray(new StoreData[results.size()]);
        }
        return null;
    }

    public boolean managesClass(String className) {
        return this.storeDataByClass.containsKey(className);
    }

    public Collection<StoreData> getManagedStoreData() {
        return Collections.unmodifiableCollection(this.storeDataByClass.values());
    }

    public StoreData get(String className) {
        return this.storeDataByClass.get(className);
    }

    public StoreData get(AbstractMemberMetaData apmd) {
        return this.storeDataByClass.get(apmd);
    }

    public int size() {
        return this.storeDataByClass.size();
    }

    public void begin() {
        this.savedStoreDataByClass = new ConcurrentHashMap<Object, StoreData>(this.storeDataByClass);
    }

    public void rollback() {
        this.storeDataByClass = this.savedStoreDataByClass;
        this.savedStoreDataByClass = null;
    }

    public void commit() {
        this.savedStoreDataByClass = null;
    }
}

