/*
 * Decompiled with CFR 0.152.
 */
package org.datanucleus.store;

import java.util.HashMap;
import java.util.Map;
import org.datanucleus.ClassConstants;
import org.datanucleus.metadata.AbstractMemberMetaData;
import org.datanucleus.metadata.ClassMetaData;
import org.datanucleus.metadata.MetaData;
import org.datanucleus.util.Localiser;

public class StoreData {
    protected static final Localiser LOCALISER = Localiser.getInstance("org.datanucleus.Localisation", ClassConstants.NUCLEUS_CONTEXT_LOADER);
    public static final int FCO_TYPE = 1;
    public static final int SCO_TYPE = 2;
    protected final String name;
    protected final int type;
    protected Map properties = new HashMap();

    public StoreData(String name, int type) {
        this(name, null, type, null);
    }

    public StoreData(String name, MetaData metadata, int type, String interfaceName) {
        this.name = name;
        this.type = type;
        if (metadata != null) {
            this.addProperty("metadata", metadata);
        }
        if (interfaceName != null) {
            this.addProperty("interface-name", interfaceName);
        }
    }

    public String getName() {
        return this.name;
    }

    public MetaData getMetaData() {
        return (MetaData)this.properties.get("metadata");
    }

    public void setMetaData(MetaData md) {
        this.addProperty("metadata", md);
    }

    public boolean isFCO() {
        return this.type == 1;
    }

    public boolean isSCO() {
        return this.type == 2;
    }

    public int getType() {
        return this.type;
    }

    public String getInterfaceName() {
        return (String)this.properties.get("interface-name");
    }

    public void addProperty(String key, Object value) {
        this.properties.put(key, value);
    }

    public Object getProperty(String key) {
        return this.properties.get(key);
    }

    public Map getProperties() {
        return this.properties;
    }

    public String toString() {
        MetaData metadata = this.getMetaData();
        if (metadata instanceof ClassMetaData) {
            ClassMetaData cmd = (ClassMetaData)metadata;
            return LOCALISER.msg("035004", (Object)this.name, (Object)"(none)", (Object)cmd.getInheritanceMetaData().getStrategy().toString());
        }
        if (metadata instanceof AbstractMemberMetaData) {
            return LOCALISER.msg("035003", (Object)this.name, null);
        }
        return LOCALISER.msg("035002", (Object)this.name, null);
    }
}

