/*
 * Decompiled with CFR 0.152.
 */
package org.datanucleus.metadata;

import java.io.Serializable;
import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import org.datanucleus.ClassConstants;
import org.datanucleus.ClassLoaderResolver;
import org.datanucleus.exceptions.NucleusException;
import org.datanucleus.metadata.ExtensionMetaData;
import org.datanucleus.metadata.InvalidMetaDataException;
import org.datanucleus.metadata.MetaDataManager;
import org.datanucleus.metadata.MetaDataUtils;
import org.datanucleus.util.Localiser;

public class MetaData
implements Serializable {
    protected static final Localiser LOCALISER = Localiser.getInstance("org.datanucleus.Localisation", ClassConstants.NUCLEUS_CONTEXT_LOADER);
    public static final int METADATA_CREATED_STATE = 0;
    public static final int METADATA_POPULATED_STATE = 1;
    public static final int METADATA_INITIALISED_STATE = 2;
    public static final int METADATA_USED_STATE = 3;
    protected int metaDataState = 0;
    protected MetaData parent;
    public static final String VENDOR_NAME = "datanucleus";
    private static final String VENDOR_NAME_OLD = "jpox";
    protected Collection<ExtensionMetaData> extensions = null;

    public MetaData() {
    }

    public MetaData(MetaData parent) {
        this.parent = parent;
    }

    public MetaData(MetaData parent, MetaData copy) {
        this.parent = parent;
        if (copy != null && copy.extensions != null) {
            for (ExtensionMetaData extmd : copy.extensions) {
                this.addExtension(extmd.getVendorName(), extmd.getKey(), extmd.getValue());
            }
        }
    }

    public void initialise(ClassLoaderResolver clr, MetaDataManager mmgr) {
        this.setInitialised();
    }

    void setInitialised() {
        this.metaDataState = 2;
    }

    void setPopulated() {
        this.metaDataState = 1;
    }

    void setUsed() {
        this.metaDataState = 3;
    }

    public void setParent(MetaData md) {
        if (this.isPopulated() || this.isInitialised()) {
            throw new NucleusException("Cannot set parent of " + this + " since it is already populated/initialised");
        }
        this.parent = md;
    }

    public MetaData addExtension(String vendor, String key, String value) {
        if (vendor == null || this.isSupportedVendor(vendor) && (key == null || value == null)) {
            throw new InvalidMetaDataException(LOCALISER, "044160", vendor, key, value);
        }
        if (this.isSupportedVendor(vendor) && this.hasExtension(key)) {
            this.removeExtension(key);
        }
        if (this.extensions == null) {
            this.extensions = new HashSet<ExtensionMetaData>(2);
        }
        this.extensions.add(new ExtensionMetaData(vendor, key, value));
        return this;
    }

    public MetaData addExtension(String key, String value) {
        return this.addExtension(VENDOR_NAME, key, value);
    }

    public ExtensionMetaData newExtensionMetaData(String vendor, String key, String value) {
        if (vendor == null || this.isSupportedVendor(vendor) && (key == null || value == null)) {
            throw new InvalidMetaDataException(LOCALISER, "044160", vendor, key, value);
        }
        ExtensionMetaData extmd = new ExtensionMetaData(vendor, key, value);
        if (this.extensions == null) {
            this.extensions = new HashSet<ExtensionMetaData>(2);
        }
        this.extensions.add(extmd);
        return extmd;
    }

    public MetaData removeExtension(String key) {
        if (this.extensions == null) {
            return this;
        }
        Iterator<ExtensionMetaData> iter = this.extensions.iterator();
        while (iter.hasNext()) {
            ExtensionMetaData ex = iter.next();
            if (!ex.getKey().equals(key) || !this.isSupportedVendor(ex.getVendorName())) continue;
            iter.remove();
            break;
        }
        return this;
    }

    public MetaData getParent() {
        return this.parent;
    }

    public boolean isPopulated() {
        return this.metaDataState >= 1;
    }

    public boolean isInitialised() {
        return this.metaDataState >= 2;
    }

    public boolean isUsed() {
        return this.metaDataState == 3;
    }

    public int getNoOfExtensions() {
        return this.extensions != null ? this.extensions.size() : 0;
    }

    public ExtensionMetaData[] getExtensions() {
        if (this.extensions == null || this.extensions.size() == 0) {
            return null;
        }
        return this.extensions.toArray(new ExtensionMetaData[this.extensions.size()]);
    }

    public boolean hasExtension(String key) {
        if (this.extensions == null || key == null) {
            return false;
        }
        for (ExtensionMetaData ex : this.extensions) {
            if (!ex.getKey().equals(key) || !this.isSupportedVendor(ex.getVendorName())) continue;
            return true;
        }
        return false;
    }

    public String getValueForExtension(String key) {
        if (this.extensions == null || key == null) {
            return null;
        }
        for (ExtensionMetaData ex : this.extensions) {
            if (!ex.getKey().equals(key) || !this.isSupportedVendor(ex.getVendorName())) continue;
            return ex.getValue();
        }
        return null;
    }

    public String[] getValuesForExtension(String key) {
        if (this.extensions == null || key == null) {
            return null;
        }
        for (ExtensionMetaData ex : this.extensions) {
            if (!ex.getKey().equals(key) || !this.isSupportedVendor(ex.getVendorName())) continue;
            return MetaDataUtils.getInstance().getValuesForCommaSeparatedAttribute(ex.getValue());
        }
        return null;
    }

    public String toString() {
        return this.toString("", "");
    }

    public String toString(String prefix, String indent) {
        if (this.extensions == null || this.extensions.size() == 0) {
            return "";
        }
        StringBuilder sb = new StringBuilder();
        for (ExtensionMetaData ex : this.extensions) {
            sb.append(prefix).append(ex.toString()).append("\n");
        }
        return sb.toString();
    }

    private boolean isSupportedVendor(String vendorName) {
        return vendorName.equalsIgnoreCase(VENDOR_NAME) || vendorName.equalsIgnoreCase(VENDOR_NAME_OLD);
    }
}

