/*
 * Decompiled with CFR 0.152.
 */
package org.datanucleus.identity;

import org.datanucleus.ClassConstants;
import org.datanucleus.PersistenceNucleusContext;
import org.datanucleus.identity.DatastoreUniqueOID;
import org.datanucleus.identity.OID;
import org.datanucleus.identity.OIDImpl;
import org.datanucleus.util.ClassUtils;

public class OIDFactory {
    private OIDFactory() {
    }

    public static OID getInstance(PersistenceNucleusContext nucleusCtx, String className, Object value) {
        Class oidClass = nucleusCtx.getDatastoreIdentityClass();
        OID oid = oidClass == ClassConstants.OID_IMPL ? new OIDImpl(className, value) : (OID)ClassUtils.newInstance(oidClass, new Class[]{String.class, Object.class}, new Object[]{className, value});
        return oid;
    }

    public static OID getInstance(PersistenceNucleusContext nucleusCtx, long value) {
        Class oidClass = nucleusCtx.getDatastoreIdentityClass();
        OID oid = oidClass == DatastoreUniqueOID.class ? new DatastoreUniqueOID(value) : (OID)ClassUtils.newInstance(oidClass, new Class[]{Long.class}, new Object[]{value});
        return oid;
    }

    public static OID getInstance(PersistenceNucleusContext nucleusCtx, String oidString) {
        Class oidClass = nucleusCtx.getDatastoreIdentityClass();
        OID oid = oidClass == ClassConstants.OID_IMPL ? new OIDImpl(oidString) : (OID)ClassUtils.newInstance(oidClass, new Class[]{String.class}, new Object[]{oidString});
        return oid;
    }
}

