/*
 * Decompiled with CFR 0.152.
 */
package org.datanucleus.store.schema.table;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.datanucleus.ClassLoaderResolver;
import org.datanucleus.exceptions.NucleusUserException;
import org.datanucleus.metadata.AbstractClassMetaData;
import org.datanucleus.metadata.AbstractMemberMetaData;
import org.datanucleus.metadata.ColumnMetaData;
import org.datanucleus.metadata.DiscriminatorMetaData;
import org.datanucleus.metadata.EmbeddedMetaData;
import org.datanucleus.metadata.FieldPersistenceModifier;
import org.datanucleus.metadata.IdentityType;
import org.datanucleus.metadata.MetaDataManager;
import org.datanucleus.metadata.MetaDataUtils;
import org.datanucleus.metadata.RelationType;
import org.datanucleus.metadata.VersionMetaData;
import org.datanucleus.store.StoreManager;
import org.datanucleus.store.schema.naming.ColumnType;
import org.datanucleus.store.schema.naming.NamingFactory;
import org.datanucleus.store.schema.table.Column;
import org.datanucleus.store.schema.table.ColumnAttributer;
import org.datanucleus.store.schema.table.ColumnImpl;
import org.datanucleus.store.schema.table.Table;
import org.datanucleus.util.NucleusLogger;

public class CompleteClassTable
implements Table {
    StoreManager storeMgr;
    AbstractClassMetaData cmd;
    String catalogName;
    String schemaName;
    String identifier;
    List<Column> columns = null;
    Column versionColumn;
    Column discriminatorColumn;
    Column datastoreIdColumn;
    Column multitenancyColumn;
    Map<AbstractMemberMetaData, Column> columnByMember = new HashMap<AbstractMemberMetaData, Column>();
    Map<List<AbstractMemberMetaData>, Column> columnByEmbeddedMember = new HashMap<List<AbstractMemberMetaData>, Column>();
    Map<Integer, Column> columnByPosition = new HashMap<Integer, Column>();
    ColumnAttributer columnAttributer;

    public CompleteClassTable(StoreManager storeMgr, AbstractClassMetaData cmd, ColumnAttributer colAttr) {
        VersionMetaData vermd;
        ColumnImpl col;
        this.storeMgr = storeMgr;
        this.cmd = cmd;
        this.columnAttributer = colAttr;
        this.schemaName = cmd.getSchema() != null ? cmd.getSchema() : storeMgr.getStringProperty("datanucleus.mapping.Schema");
        this.catalogName = cmd.getCatalog() != null ? cmd.getCatalog() : storeMgr.getStringProperty("datanucleus.mapping.Catalog");
        this.identifier = storeMgr.getNamingFactory().getTableName(cmd);
        this.columns = new ArrayList<Column>();
        ClassLoaderResolver clr = storeMgr.getNucleusContext().getClassLoaderResolver(null);
        int numMembers = cmd.getAllMemberPositions().length;
        for (int i = 0; i < numMembers; ++i) {
            ColumnImpl col2;
            String colName;
            ColumnMetaData[] colmds;
            AbstractMemberMetaData mmd = cmd.getMetaDataForManagedMemberAtAbsolutePosition(i);
            if (mmd.getPersistenceModifier() != FieldPersistenceModifier.PERSISTENT) continue;
            RelationType relationType = mmd.getRelationType(clr);
            if (relationType == RelationType.NONE) {
                colmds = mmd.getColumnMetaData();
                if (colmds != null && colmds.length > 1) {
                    throw new NucleusUserException("Dont currently support member having more than 1 column");
                }
                colName = storeMgr.getNamingFactory().getColumnName(mmd, ColumnType.COLUMN, 0);
                col2 = this.addColumn(this.columns, mmd, colName);
                if (colmds == null || colmds.length != 1 || colmds[0].getPosition() == null) continue;
                col2.setPosition(colmds[0].getPosition());
                continue;
            }
            if (MetaDataUtils.getInstance().isMemberEmbedded(storeMgr.getMetaDataManager(), clr, mmd, relationType, null)) {
                if (RelationType.isRelationSingleValued(relationType)) {
                    ArrayList<AbstractMemberMetaData> embMmds = new ArrayList<AbstractMemberMetaData>();
                    embMmds.add(mmd);
                    this.processEmbeddedMember(this.columns, embMmds, clr);
                    continue;
                }
                if (!RelationType.isRelationMultiValued(relationType)) continue;
                NucleusLogger.DATASTORE_SCHEMA.warn("Member " + mmd.getFullFieldName() + " is an embedded collection. Not supported so ignoring");
                continue;
            }
            colmds = mmd.getColumnMetaData();
            if (colmds != null && colmds.length > 1) {
                throw new NucleusUserException("Dont currently support member having more than 1 column");
            }
            colName = storeMgr.getNamingFactory().getColumnName(mmd, ColumnType.COLUMN, 0);
            col2 = this.addColumn(this.columns, mmd, colName);
            if (colmds == null || colmds.length != 1 || colmds[0].getPosition() == null) continue;
            col2.setPosition(colmds[0].getPosition());
        }
        if (cmd.getIdentityType() == IdentityType.DATASTORE) {
            String colName = storeMgr.getNamingFactory().getColumnName(cmd, ColumnType.DATASTOREID_COLUMN);
            col = this.addColumn(this.columns, null, colName, ColumnType.DATASTOREID_COLUMN);
            if (cmd.getIdentityMetaData() != null && cmd.getIdentityMetaData().getColumnMetaData() != null && cmd.getIdentityMetaData().getColumnMetaData().getPosition() != null) {
                col.setPosition(cmd.getIdentityMetaData().getColumnMetaData().getPosition());
            }
            this.datastoreIdColumn = col;
        }
        if (cmd.isVersioned() && (vermd = cmd.getVersionMetaDataForClass()) != null && vermd.getFieldName() == null) {
            String colName = storeMgr.getNamingFactory().getColumnName(cmd, ColumnType.VERSION_COLUMN);
            ColumnImpl col3 = this.addColumn(this.columns, null, colName, ColumnType.VERSION_COLUMN);
            if (vermd.getColumnMetaData() != null && vermd.getColumnMetaData().getPosition() != null) {
                col3.setPosition(vermd.getColumnMetaData().getPosition());
            }
            this.versionColumn = col3;
        }
        if (cmd.hasDiscriminatorStrategy()) {
            String colName = storeMgr.getNamingFactory().getColumnName(cmd, ColumnType.DISCRIMINATOR_COLUMN);
            col = this.addColumn(this.columns, null, colName, ColumnType.DISCRIMINATOR_COLUMN);
            DiscriminatorMetaData dismd = cmd.getDiscriminatorMetaDataForTable();
            if (dismd != null && dismd.getColumnMetaData() != null && dismd.getColumnMetaData().getPosition() != null) {
                col.setPosition(dismd.getColumnMetaData().getPosition());
            }
            this.discriminatorColumn = col;
        }
        if (storeMgr.getStringProperty("datanucleus.TenantID") != null && !"true".equalsIgnoreCase(cmd.getValueForExtension("multitenancy-disable"))) {
            String colName = storeMgr.getNamingFactory().getColumnName(cmd, ColumnType.MULTITENANCY_COLUMN);
            col = this.addColumn(this.columns, null, colName, ColumnType.MULTITENANCY_COLUMN);
            this.multitenancyColumn = col;
        }
    }

    protected void processEmbeddedMember(List<Column> columns, List<AbstractMemberMetaData> mmds, ClassLoaderResolver clr) {
        AbstractMemberMetaData lastMmd = mmds.get(mmds.size() - 1);
        EmbeddedMetaData embmd = mmds.get(0).getEmbeddedMetaData();
        MetaDataManager mmgr = this.storeMgr.getMetaDataManager();
        NamingFactory namingFactory = this.storeMgr.getNamingFactory();
        AbstractClassMetaData embCmd = mmgr.getMetaDataForClass(lastMmd.getType(), clr);
        int[] memberPositions = embCmd.getAllMemberPositions();
        for (int i = 0; i < memberPositions.length; ++i) {
            ArrayList<AbstractMemberMetaData> embMmds;
            AbstractMemberMetaData mmd = embCmd.getMetaDataForManagedMemberAtAbsolutePosition(memberPositions[i]);
            if (mmd.getPersistenceModifier() != FieldPersistenceModifier.PERSISTENT || mmds.size() == 1 && embmd != null && embmd.getOwnerMember() != null && embmd.getOwnerMember().equals(mmd.getName())) continue;
            RelationType relationType = mmd.getRelationType(clr);
            if (relationType != RelationType.NONE && MetaDataUtils.getInstance().isMemberEmbedded(mmgr, clr, mmd, relationType, lastMmd)) {
                if (RelationType.isRelationSingleValued(relationType)) {
                    embMmds = new ArrayList<AbstractMemberMetaData>(mmds);
                    embMmds.add(mmd);
                    this.processEmbeddedMember(columns, embMmds, clr);
                    continue;
                }
                NucleusLogger.DATASTORE_SCHEMA.warn("Member " + mmd.getFullFieldName() + " is an embedded collection. Not supported so ignoring");
                continue;
            }
            embMmds = new ArrayList<AbstractMemberMetaData>(mmds);
            embMmds.add(mmd);
            String colName = namingFactory.getColumnName(embMmds, 0);
            this.addEmbeddedColumn(columns, embMmds, colName);
        }
    }

    protected ColumnImpl addColumn(List<Column> cols, AbstractMemberMetaData mmd, String colName) {
        return this.addColumn(cols, mmd, colName, ColumnType.COLUMN);
    }

    protected ColumnImpl addColumn(List<Column> cols, AbstractMemberMetaData mmd, String colName, ColumnType colType) {
        ColumnImpl col = new ColumnImpl(this, colName, colType);
        if (mmd != null) {
            col.setMemberMetaData(mmd);
            if (mmd.isPrimaryKey()) {
                col.setPrimaryKey();
            }
            this.columnByMember.put(mmd, col);
            this.columnAttributer.attributeColumn(col, mmd);
        } else {
            if (colType == ColumnType.DATASTOREID_COLUMN) {
                col.setPrimaryKey();
            }
            this.columnAttributer.attributeColumn(col, null);
        }
        cols.add(col);
        return col;
    }

    protected ColumnImpl addEmbeddedColumn(List<Column> cols, List<AbstractMemberMetaData> mmds, String colName) {
        ColumnImpl col = new ColumnImpl(this, colName, ColumnType.COLUMN);
        if (mmds != null && mmds.size() > 0) {
            col.setMemberMetaData(mmds.get(mmds.size() - 1));
        }
        cols.add(col);
        this.columnAttributer.attributeEmbeddedColumn(col, mmds);
        this.columnByEmbeddedMember.put(mmds, col);
        return col;
    }

    @Override
    public AbstractClassMetaData getClassMetaData() {
        return this.cmd;
    }

    @Override
    public StoreManager getStoreManager() {
        return this.storeMgr;
    }

    @Override
    public String getSchemaName() {
        return this.schemaName;
    }

    @Override
    public String getCatalogName() {
        return this.catalogName;
    }

    @Override
    public String getIdentifier() {
        return this.identifier;
    }

    @Override
    public int getNumberOfColumns() {
        return this.columns.size();
    }

    @Override
    public List<Column> getColumns() {
        return this.columns;
    }

    @Override
    public Column getDatastoreIdColumn() {
        return this.datastoreIdColumn;
    }

    @Override
    public Column getVersionColumn() {
        return this.versionColumn;
    }

    @Override
    public Column getDiscriminatorColumn() {
        return this.discriminatorColumn;
    }

    @Override
    public Column getMultitenancyColumn() {
        return this.multitenancyColumn;
    }

    @Override
    public Column getColumnForPosition(int pos) {
        return this.columnByPosition.get(pos);
    }

    @Override
    public Column getColumnForMember(AbstractMemberMetaData mmd) {
        return this.columnByMember.get(mmd);
    }

    @Override
    public Column getColumnForEmbeddedMember(List<AbstractMemberMetaData> mmds) {
        return this.columnByEmbeddedMember.get(mmds);
    }

    public String toString() {
        return "Table: " + this.identifier;
    }
}

