/*
 * Decompiled with CFR 0.152.
 */
package org.datanucleus.query.evaluator.memory;

import org.datanucleus.ClassConstants;
import org.datanucleus.exceptions.NucleusException;
import org.datanucleus.query.QueryUtils;
import org.datanucleus.query.evaluator.memory.InMemoryExpressionEvaluator;
import org.datanucleus.query.evaluator.memory.InvocationEvaluator;
import org.datanucleus.query.expression.DyadicExpression;
import org.datanucleus.query.expression.Expression;
import org.datanucleus.query.expression.InvokeExpression;
import org.datanucleus.query.expression.Literal;
import org.datanucleus.query.expression.ParameterExpression;
import org.datanucleus.query.expression.PrimaryExpression;
import org.datanucleus.util.Localiser;

public class StringCharAtMethodEvaluator
implements InvocationEvaluator {
    protected static final Localiser LOCALISER = Localiser.getInstance("org.datanucleus.Localisation", ClassConstants.NUCLEUS_CONTEXT_LOADER);

    public Object evaluate(InvokeExpression expr, Object invokedValue, InMemoryExpressionEvaluator eval) {
        String method = expr.getOperation();
        if (invokedValue == null) {
            return -1;
        }
        if (!(invokedValue instanceof String)) {
            throw new NucleusException(LOCALISER.msg("021011", (Object)method, (Object)invokedValue.getClass().getName()));
        }
        Object arg1Obj = null;
        Expression param = expr.getArguments().get(0);
        if (param instanceof PrimaryExpression) {
            PrimaryExpression primExpr = (PrimaryExpression)param;
            arg1Obj = eval.getValueForPrimaryExpression(primExpr);
        } else if (param instanceof ParameterExpression) {
            ParameterExpression paramExpr = (ParameterExpression)param;
            arg1Obj = QueryUtils.getValueForParameterExpression(eval.getParameterValues(), paramExpr);
        } else if (param instanceof Literal) {
            arg1Obj = ((Literal)param).getLiteral();
        } else if (param instanceof InvokeExpression) {
            arg1Obj = eval.getValueForInvokeExpression((InvokeExpression)param);
        } else if (param instanceof DyadicExpression) {
            arg1Obj = ((DyadicExpression)param).evaluate(eval);
        } else {
            throw new NucleusException(method + "(param1) where param is instanceof " + param.getClass().getName() + " not supported");
        }
        if (!(arg1Obj instanceof Number)) {
            throw new NucleusException(method + "(param1]) : param1 must be numeric");
        }
        int arg1 = ((Number)arg1Obj).intValue();
        return ((String)invokedValue).indexOf(arg1);
    }
}

