/*
 * Decompiled with CFR 0.152.
 */
package org.datanucleus;

import javax.naming.InitialContext;
import javax.naming.NamingException;
import javax.transaction.NotSupportedException;
import javax.transaction.Synchronization;
import javax.transaction.SystemException;
import javax.transaction.Transaction;
import javax.transaction.TransactionManager;
import javax.transaction.UserTransaction;
import org.datanucleus.ExecutionContext;
import org.datanucleus.PersistenceConfiguration;
import org.datanucleus.TransactionImpl;
import org.datanucleus.exceptions.NucleusException;
import org.datanucleus.store.connection.ConnectionResourceType;
import org.datanucleus.transaction.NucleusTransactionException;
import org.datanucleus.transaction.jta.JTASyncRegistry;
import org.datanucleus.util.NucleusLogger;

public class JTATransactionImpl
extends TransactionImpl
implements Synchronization {
    private static boolean JBOSS_SERVER = System.getProperty("jboss.server.name") != null;
    private TransactionManager jtaTM;
    private Transaction jtaTx;
    private JTASyncRegistry jtaSyncRegistry;
    protected JoinStatus joinStatus = JoinStatus.NO_TXN;
    private UserTransaction userTransaction;
    protected boolean autoJoin = true;

    JTATransactionImpl(ExecutionContext ec, boolean autoJoin) {
        super(ec);
        this.autoJoin = autoJoin;
        PersistenceConfiguration conf = ec.getNucleusContext().getPersistenceConfiguration();
        if (!ConnectionResourceType.JTA.toString().equalsIgnoreCase(conf.getStringProperty("datanucleus.connection.resourceType")) || !ConnectionResourceType.JTA.toString().equalsIgnoreCase(conf.getStringProperty("datanucleus.connection2.resourceType"))) {
            throw new NucleusException("Internal error: either datanucleus.connection.resourceType or datanucleus.connection2.resourceType have not been set to JTA; this should have happened automatically.");
        }
        this.txnMgr.setContainerManagedConnections(true);
        this.jtaTM = ec.getNucleusContext().getJtaTransactionManager();
        if (this.jtaTM == null) {
            throw new NucleusTransactionException(LOCALISER.msg("015030"));
        }
        this.jtaSyncRegistry = ec.getNucleusContext().getJtaSyncRegistry();
        if (autoJoin) {
            this.joinTransaction();
        }
    }

    public boolean isJoined() {
        return this.joinStatus == JoinStatus.JOINED;
    }

    private int getTransactionStatus() {
        try {
            return this.jtaTM.getStatus();
        }
        catch (SystemException se) {
            throw new NucleusTransactionException(LOCALISER.msg("015026"), se);
        }
    }

    public void joinTransaction() {
        block12: {
            if (this.joinStatus != JoinStatus.JOINED) {
                try {
                    boolean allow_join;
                    Transaction txn = this.jtaTM.getTransaction();
                    int txnstat = this.jtaTM.getStatus();
                    if (this.jtaTx != null && !this.jtaTx.equals(txn)) {
                        if (this.joinStatus != JoinStatus.IMPOSSIBLE) {
                            throw new InternalError("JTA Transaction changed without being notified");
                        }
                        this.jtaTx = null;
                        this.joinStatus = JoinStatus.NO_TXN;
                        this.joinTransaction();
                        break block12;
                    }
                    if (this.jtaTx != null) break block12;
                    this.jtaTx = txn;
                    boolean bl = allow_join = txnstat == 0;
                    if (allow_join) {
                        this.joinStatus = JoinStatus.IMPOSSIBLE;
                        try {
                            if (this.jtaSyncRegistry != null) {
                                this.jtaSyncRegistry.register(this);
                            } else {
                                this.jtaTx.registerSynchronization((Synchronization)this);
                            }
                            boolean was_active = super.isActive();
                            if (!was_active) {
                                this.internalBegin();
                            }
                        }
                        catch (Exception e) {
                            e.printStackTrace();
                            throw new NucleusTransactionException("Cannot register Synchronization to a valid JTA Transaction");
                        }
                        this.joinStatus = JoinStatus.JOINED;
                        break block12;
                    }
                    if (this.jtaTx != null) {
                        this.joinStatus = JoinStatus.IMPOSSIBLE;
                    }
                }
                catch (SystemException e) {
                    throw new NucleusTransactionException(LOCALISER.msg("015026"), e);
                }
            }
        }
    }

    public boolean getIsActive() {
        if (this.closed) {
            return false;
        }
        int txnStatus = this.getTransactionStatus();
        if (txnStatus == 3 || txnStatus == 4) {
            return false;
        }
        return super.getIsActive();
    }

    public boolean isActive() {
        if (this.autoJoin) {
            if (this.joinStatus == JoinStatus.JOINED) {
                return super.isActive();
            }
            this.joinTransaction();
            return super.isActive() || this.joinStatus == JoinStatus.IMPOSSIBLE;
        }
        return super.isActive();
    }

    public void begin() {
        UserTransaction utx;
        this.joinTransaction();
        if (this.joinStatus != JoinStatus.NO_TXN) {
            throw new NucleusTransactionException("JTA Transaction is already active");
        }
        try {
            InitialContext ctx = new InitialContext();
            utx = JBOSS_SERVER ? (UserTransaction)ctx.lookup("UserTransaction") : (UserTransaction)ctx.lookup("java:comp/UserTransaction");
        }
        catch (NamingException e) {
            throw this.ec.getApiAdapter().getUserExceptionForException("Failed to obtain UserTransaction", e);
        }
        try {
            utx.begin();
        }
        catch (NotSupportedException e) {
            throw this.ec.getApiAdapter().getUserExceptionForException("Failed to begin UserTransaction", (Exception)((Object)e));
        }
        catch (SystemException e) {
            throw this.ec.getApiAdapter().getUserExceptionForException("Failed to begin UserTransaction", (Exception)((Object)e));
        }
        this.joinTransaction();
        if (this.joinStatus != JoinStatus.JOINED) {
            throw new NucleusTransactionException("Cannot join an auto started UserTransaction");
        }
        this.userTransaction = utx;
    }

    public void commit() {
        if (this.userTransaction == null) {
            throw new NucleusTransactionException("No internal UserTransaction");
        }
        try {
            try {
                this.userTransaction.commit();
            }
            catch (Exception e) {
                throw this.ec.getApiAdapter().getUserExceptionForException("Failed to commit UserTransaction", e);
            }
            Object var3_1 = null;
            this.userTransaction = null;
        }
        catch (Throwable throwable) {
            Object var3_2 = null;
            this.userTransaction = null;
            throw throwable;
        }
    }

    public void rollback() {
        if (this.userTransaction == null) {
            throw new NucleusTransactionException("No internal UserTransaction");
        }
        try {
            try {
                this.userTransaction.rollback();
            }
            catch (Exception e) {
                throw this.ec.getApiAdapter().getUserExceptionForException("Failed to rollback UserTransaction", e);
            }
            Object var3_1 = null;
            this.userTransaction = null;
        }
        catch (Throwable throwable) {
            Object var3_2 = null;
            this.userTransaction = null;
            throw throwable;
        }
    }

    public void setRollbackOnly() {
        if (this.userTransaction == null) {
            throw new NucleusTransactionException("No internal UserTransaction");
        }
        try {
            this.userTransaction.setRollbackOnly();
        }
        catch (Exception e) {
            throw this.ec.getApiAdapter().getUserExceptionForException("Failed to rollback-only UserTransaction", e);
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void beforeCompletion() {
        RuntimeException thr = null;
        boolean success = false;
        try {
            try {
                this.flush();
                this.internalPreCommit();
                this.flush();
                return;
            }
            catch (RuntimeException e) {
                thr = e;
                throw e;
            }
        }
        catch (Throwable throwable) {
            Object var5_4 = null;
            if (success) throw throwable;
            NucleusLogger.TRANSACTION.error(LOCALISER.msg("015044"), thr);
            try {
                this.jtaTx.setRollbackOnly();
                throw throwable;
            }
            catch (Exception e) {
                NucleusLogger.TRANSACTION.fatal(LOCALISER.msg("015045"), e);
            }
            throw throwable;
        }
    }

    public synchronized void afterCompletion(int status) {
        if (this.closed) {
            NucleusLogger.TRANSACTION.warn(LOCALISER.msg("015048", this));
            return;
        }
        RuntimeException thr = null;
        boolean success = false;
        try {
            try {
                if (status == 4) {
                    super.rollback();
                } else if (status == 3) {
                    super.internalPostCommit();
                } else {
                    NucleusLogger.TRANSACTION.fatal(LOCALISER.msg("015047", status));
                }
                success = true;
            }
            catch (RuntimeException re) {
                thr = re;
                NucleusLogger.TRANSACTION.error("Exception in afterCompletion : " + re.getMessage(), re);
                throw re;
            }
            Object var6_4 = null;
            this.jtaTx = null;
            this.joinStatus = JoinStatus.NO_TXN;
            if (!success) {
                NucleusLogger.TRANSACTION.error(LOCALISER.msg("015046"), thr);
            }
        }
        catch (Throwable throwable) {
            Object var6_5 = null;
            this.jtaTx = null;
            this.joinStatus = JoinStatus.NO_TXN;
            if (!success) {
                NucleusLogger.TRANSACTION.error(LOCALISER.msg("015046"), thr);
            }
            throw throwable;
        }
        if (this.active) {
            throw new NucleusTransactionException("internal error, must not be active after afterCompletion()!");
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static enum JoinStatus {
        NO_TXN,
        IMPOSSIBLE,
        JOINED;

    }
}

