/*
 * Decompiled with CFR 0.152.
 */
package org.datanucleus;

import java.lang.reflect.Constructor;
import java.lang.reflect.Modifier;
import java.util.ArrayList;
import java.util.BitSet;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;
import org.datanucleus.ClassConstants;
import org.datanucleus.ClassLoaderResolver;
import org.datanucleus.ExecutionContext;
import org.datanucleus.ExecutionContextListener;
import org.datanucleus.FetchGroup;
import org.datanucleus.FetchGroupManager;
import org.datanucleus.FetchPlan;
import org.datanucleus.ImplementationCreator;
import org.datanucleus.JTAJCATransactionImpl;
import org.datanucleus.JTATransactionImpl;
import org.datanucleus.NucleusContext;
import org.datanucleus.NullCallbackHandler;
import org.datanucleus.PersistenceConfiguration;
import org.datanucleus.Transaction;
import org.datanucleus.TransactionEventListener;
import org.datanucleus.TransactionImpl;
import org.datanucleus.api.ApiAdapter;
import org.datanucleus.cache.CachedPC;
import org.datanucleus.cache.L2CachePopulateFieldManager;
import org.datanucleus.cache.Level1Cache;
import org.datanucleus.cache.Level2Cache;
import org.datanucleus.exceptions.ClassNotDetachableException;
import org.datanucleus.exceptions.ClassNotPersistableException;
import org.datanucleus.exceptions.ClassNotResolvedException;
import org.datanucleus.exceptions.CommitStateTransitionException;
import org.datanucleus.exceptions.NoPersistenceInformationException;
import org.datanucleus.exceptions.NucleusException;
import org.datanucleus.exceptions.NucleusFatalUserException;
import org.datanucleus.exceptions.NucleusObjectNotFoundException;
import org.datanucleus.exceptions.NucleusOptimisticException;
import org.datanucleus.exceptions.NucleusUserException;
import org.datanucleus.exceptions.ObjectDetachedException;
import org.datanucleus.exceptions.RollbackStateTransitionException;
import org.datanucleus.exceptions.TransactionActiveOnCloseException;
import org.datanucleus.exceptions.TransactionNotActiveException;
import org.datanucleus.flush.FlushProcess;
import org.datanucleus.flush.Operation;
import org.datanucleus.flush.OperationQueue;
import org.datanucleus.identity.DatastoreUniqueOID;
import org.datanucleus.identity.IdentityKeyTranslator;
import org.datanucleus.identity.IdentityReference;
import org.datanucleus.identity.IdentityStringTranslator;
import org.datanucleus.identity.IdentityUtils;
import org.datanucleus.identity.OID;
import org.datanucleus.identity.OIDFactory;
import org.datanucleus.identity.SCOID;
import org.datanucleus.management.ManagerStatistics;
import org.datanucleus.management.jmx.ManagementManager;
import org.datanucleus.metadata.AbstractClassMetaData;
import org.datanucleus.metadata.AbstractMemberMetaData;
import org.datanucleus.metadata.IdentityType;
import org.datanucleus.metadata.MetaDataManager;
import org.datanucleus.metadata.TransactionType;
import org.datanucleus.properties.BasePropertyStore;
import org.datanucleus.state.CallbackHandler;
import org.datanucleus.state.DetachState;
import org.datanucleus.state.FetchPlanState;
import org.datanucleus.state.LifeCycleState;
import org.datanucleus.state.LockManager;
import org.datanucleus.state.LockManagerImpl;
import org.datanucleus.state.ObjectProvider;
import org.datanucleus.state.RelationshipManager;
import org.datanucleus.state.RelationshipManagerImpl;
import org.datanucleus.store.Extent;
import org.datanucleus.store.FieldValues;
import org.datanucleus.store.PersistenceBatchType;
import org.datanucleus.store.StoreManager;
import org.datanucleus.store.query.Query;
import org.datanucleus.store.scostore.Store;
import org.datanucleus.store.types.TypeManager;
import org.datanucleus.util.Localiser;
import org.datanucleus.util.NucleusLogger;
import org.datanucleus.util.StringUtils;
import org.datanucleus.util.WeakValueMap;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ExecutionContextImpl
implements ExecutionContext,
TransactionEventListener {
    protected static final Localiser LOCALISER = Localiser.getInstance("org.datanucleus.Localisation", ClassConstants.NUCLEUS_CONTEXT_LOADER);
    NucleusContext nucCtx;
    private Object owner;
    private boolean closed;
    private FetchPlan fetchPlan;
    private ClassLoaderResolver clr = null;
    private CallbackHandler callbacks;
    protected Level1Cache cache;
    private BasePropertyStore properties = new BasePropertyStore();
    private Object objectLookingForOP = null;
    private ObjectProvider foundOP = null;
    private Transaction tx;
    private Map<Object, ObjectProvider> enlistedOPCache = new WeakValueMap();
    private List<ObjectProvider> dirtyOPs = new ArrayList<ObjectProvider>();
    private List<ObjectProvider> indirectDirtyOPs = new ArrayList<ObjectProvider>();
    private OperationQueue operationQueue = null;
    private Set<ObjectProvider> nontxProcessedOPs = null;
    protected boolean l2CacheEnabled = false;
    private Set l2CacheTxIds = null;
    private Map<Object, BitSet> l2CacheTxFieldsToUpdateById = null;
    private int flushing = 0;
    private boolean runningDetachAllOnTxnEnd = false;
    private FetchGroupManager fetchGrpMgr;
    private LockManager lockMgr = null;
    protected Lock lock;
    private boolean runningManageRelations = false;
    Map<ObjectProvider, RelationshipManager> managedRelationDetails = null;
    Map<ObjectProvider, Object> opAttachDetachObjectReferenceMap = null;
    Map<ObjectProvider, List<ExecutionContext.EmbeddedOwnerRelation>> opEmbeddedInfoByOwner = null;
    Map<ObjectProvider, List<ExecutionContext.EmbeddedOwnerRelation>> opEmbeddedInfoByEmbedded = null;
    protected Map<ObjectProvider, Map<?, ?>> opAssociatedValuesMapByOP = null;
    private boolean runningPBRAtCommit = false;
    private Set reachabilityPersistedIds = null;
    private Set reachabilityDeletedIds = null;
    private Set reachabilityFlushedNewIds = null;
    private Set reachabilityEnlistedIds = null;
    ManagerStatistics statistics = null;
    private Set<ExecutionContextListener> ecListeners = null;
    private ThreadLocal contextInfoThreadLocal;
    private ObjectProvider[] detachAllOnTxnEndOPs = null;

    public ExecutionContextImpl(NucleusContext ctx, Object owner, Map<String, Object> options) {
        this.nucCtx = ctx;
        if (ctx.getPersistenceConfiguration().getBooleanProperty("datanucleus.Multithreaded")) {
            this.lock = new ReentrantLock();
        }
        this.initialise(owner, options);
        this.initialiseLevel1Cache();
        if (this.getReachabilityAtCommit()) {
            this.reachabilityPersistedIds = new HashSet();
            this.reachabilityDeletedIds = new HashSet();
            this.reachabilityFlushedNewIds = new HashSet();
            this.reachabilityEnlistedIds = new HashSet();
        }
        this.setLevel2Cache(true);
    }

    @Override
    public void initialise(Object owner, Map<String, Object> options) {
        this.owner = owner;
        this.closed = false;
        ClassLoader contextLoader = Thread.currentThread().getContextClassLoader();
        this.clr = this.nucCtx.getClassLoaderResolver(contextLoader);
        try {
            ImplementationCreator ic = this.nucCtx.getImplementationCreator();
            if (ic != null) {
                this.clr.setRuntimeClassLoader(ic.getClassLoader());
            }
        }
        catch (Exception ex) {
            // empty catch block
        }
        PersistenceConfiguration conf = this.nucCtx.getPersistenceConfiguration();
        for (Map.Entry<String, Object> entry : conf.getManagerOverrideableProperties().entrySet()) {
            this.properties.setProperty(entry.getKey().toLowerCase(Locale.ENGLISH), entry.getValue());
        }
        this.fetchPlan = new FetchPlan(this, this.clr).setMaxFetchDepth(conf.getIntProperty("datanucleus.maxFetchDepth"));
        if (TransactionType.JTA.toString().equalsIgnoreCase(conf.getStringProperty("datanucleus.TransactionType"))) {
            if (this.getNucleusContext().isJcaMode()) {
                this.tx = new JTAJCATransactionImpl(this);
            } else {
                boolean autoJoin = true;
                if (options != null && options.containsKey("jta_autojoin")) {
                    autoJoin = Boolean.valueOf((String)options.get("jta_autojoin"));
                }
                this.tx = new JTATransactionImpl(this, autoJoin);
            }
        } else {
            this.tx = new TransactionImpl(this);
        }
        if (NucleusLogger.PERSISTENCE.isDebugEnabled()) {
            NucleusLogger.PERSISTENCE.debug(LOCALISER.msg("010000", this, (Object)this.nucCtx.getStoreManager(), (Object)this.tx));
        }
        if (this.nucCtx.statisticsEnabled()) {
            String name = null;
            if (this.nucCtx.getJMXManager() != null) {
                ManagementManager mgmtMgr = this.nucCtx.getJMXManager();
                name = mgmtMgr.getDomainName() + ":InstanceName=" + mgmtMgr.getInstanceName() + ",Type=" + ManagerStatistics.class.getName() + ",Name=Manager" + NucleusContext.random.nextLong();
            }
            this.statistics = new ManagerStatistics(name, this.nucCtx.getStatistics());
            if (this.nucCtx.getJMXManager() != null) {
                this.nucCtx.getJMXManager().registerMBean(this.statistics, name);
            }
        }
        this.contextInfoThreadLocal = new ThreadLocal(){

            protected Object initialValue() {
                return new ThreadContextInfo();
            }
        };
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void close() {
        if (this.closed) {
            throw new NucleusUserException(LOCALISER.msg("010002"));
        }
        if (this.tx.getIsActive()) {
            throw new TransactionActiveOnCloseException(this);
        }
        if (!this.dirtyOPs.isEmpty() && this.tx.getNontransactionalWrite()) {
            if (this.isNonTxAtomic()) {
                this.processNontransactionalUpdate();
            } else {
                try {
                    this.tx.begin();
                    this.tx.commit();
                }
                finally {
                    if (this.tx.isActive()) {
                        this.tx.rollback();
                    }
                }
            }
        }
        if (this.getDetachOnClose()) {
            this.performDetachOnClose();
        }
        ExecutionContext.LifecycleListener[] listener = this.nucCtx.getExecutionContextListeners();
        for (int i = 0; i < listener.length; ++i) {
            listener[i].preClose(this);
        }
        this.disconnectObjectProvidersFromCache();
        this.disconnectLifecycleListener();
        if (this.ecListeners != null) {
            for (ExecutionContextListener lstr : this.ecListeners) {
                lstr.executionContextClosing(this);
            }
            this.ecListeners.clear();
            this.ecListeners = null;
        }
        this.fetchPlan.clearGroups().addGroup("default");
        if (this.statistics != null) {
            if (this.nucCtx.getJMXManager() != null) {
                this.nucCtx.getJMXManager().deregisterMBean(this.statistics.getRegisteredName());
            }
            this.statistics = null;
        }
        this.cache.clear();
        this.enlistedOPCache.clear();
        this.dirtyOPs.clear();
        this.indirectDirtyOPs.clear();
        if (this.nontxProcessedOPs != null) {
            this.nontxProcessedOPs.clear();
            this.nontxProcessedOPs = null;
        }
        if (this.managedRelationDetails != null) {
            this.managedRelationDetails.clear();
            this.managedRelationDetails = null;
        }
        if (this.l2CacheTxIds != null) {
            this.l2CacheTxIds.clear();
        }
        if (this.l2CacheTxFieldsToUpdateById != null) {
            this.l2CacheTxFieldsToUpdateById.clear();
        }
        if (this.getReachabilityAtCommit()) {
            this.reachabilityPersistedIds.clear();
            this.reachabilityDeletedIds.clear();
            this.reachabilityFlushedNewIds.clear();
            this.reachabilityEnlistedIds.clear();
        }
        if (this.opEmbeddedInfoByOwner != null) {
            this.opEmbeddedInfoByOwner.clear();
            this.opEmbeddedInfoByOwner = null;
        }
        if (this.opEmbeddedInfoByEmbedded != null) {
            this.opEmbeddedInfoByEmbedded.clear();
            this.opEmbeddedInfoByEmbedded = null;
        }
        if (this.opAssociatedValuesMapByOP != null) {
            this.opAssociatedValuesMapByOP.clear();
            this.opAssociatedValuesMapByOP = null;
        }
        this.closed = true;
        this.tx.close();
        this.tx = null;
        if (NucleusLogger.PERSISTENCE.isDebugEnabled()) {
            NucleusLogger.PERSISTENCE.debug(LOCALISER.msg("010001", this));
        }
        this.nucCtx.getExecutionContextPool().checkIn(this);
    }

    protected void setLevel2Cache(boolean flag) {
        if (flag && this.nucCtx.hasLevel2Cache() && !this.l2CacheEnabled) {
            this.l2CacheTxIds = new HashSet();
            this.l2CacheTxFieldsToUpdateById = new HashMap<Object, BitSet>();
            this.l2CacheEnabled = true;
        } else if (!flag && this.l2CacheEnabled) {
            if (NucleusLogger.CACHE.isDebugEnabled()) {
                NucleusLogger.CACHE.debug("Disabling L2 caching for " + this);
            }
            this.l2CacheTxIds.clear();
            this.l2CacheTxIds = null;
            this.l2CacheTxFieldsToUpdateById.clear();
            this.l2CacheTxFieldsToUpdateById = null;
            this.l2CacheEnabled = false;
        }
    }

    @Override
    public boolean isClosed() {
        return this.closed;
    }

    protected ThreadContextInfo acquireThreadContextInfo() {
        ThreadContextInfo threadInfo = (ThreadContextInfo)this.contextInfoThreadLocal.get();
        ++threadInfo.referenceCounter;
        return threadInfo;
    }

    protected ThreadContextInfo getThreadContextInfo() {
        return (ThreadContextInfo)this.contextInfoThreadLocal.get();
    }

    protected void releaseThreadContextInfo() {
        ThreadContextInfo threadInfo = (ThreadContextInfo)this.contextInfoThreadLocal.get();
        if (--threadInfo.referenceCounter <= 0) {
            threadInfo.referenceCounter = 0;
            if (threadInfo.attachedOwnerByObject != null) {
                threadInfo.attachedOwnerByObject.clear();
            }
            threadInfo.attachedOwnerByObject = null;
            if (threadInfo.attachedPCById != null) {
                threadInfo.attachedPCById.clear();
            }
            threadInfo.attachedPCById = null;
            this.contextInfoThreadLocal.remove();
        }
    }

    @Override
    public void transactionStarted() {
        this.getStoreManager().transactionStarted(this);
        this.postBegin();
    }

    @Override
    public void transactionPreFlush() {
    }

    @Override
    public void transactionFlushed() {
    }

    @Override
    public void transactionPreCommit() {
        this.preCommit();
    }

    @Override
    public void transactionCommitted() {
        this.getStoreManager().transactionCommitted(this);
        this.postCommit();
    }

    @Override
    public void transactionPreRollBack() {
        this.preRollback();
    }

    @Override
    public void transactionRolledBack() {
        this.getStoreManager().transactionRolledBack(this);
        this.postRollback();
    }

    @Override
    public void transactionEnded() {
    }

    @Override
    public ManagerStatistics getStatistics() {
        return this.statistics;
    }

    protected void initialiseLevel1Cache() {
        String level1Type = this.nucCtx.getPersistenceConfiguration().getStringProperty("datanucleus.cache.level1.type");
        if (level1Type != null && level1Type.equalsIgnoreCase("none")) {
            return;
        }
        String level1ClassName = this.getNucleusContext().getPluginManager().getAttributeValueForExtension("org.datanucleus.cache_level1", "name", level1Type, "class-name");
        if (level1ClassName == null) {
            throw new NucleusUserException(LOCALISER.msg("003001", (Object)level1Type)).setFatal();
        }
        try {
            this.cache = (Level1Cache)this.getNucleusContext().getPluginManager().createExecutableExtension("org.datanucleus.cache_level1", "name", level1Type, "class-name", null, null);
            if (NucleusLogger.CACHE.isDebugEnabled()) {
                NucleusLogger.CACHE.debug(LOCALISER.msg("003003", (Object)level1Type));
            }
        }
        catch (Exception e) {
            throw new NucleusUserException(LOCALISER.msg("003002", (Object)level1Type, (Object)level1ClassName), e).setFatal();
        }
    }

    @Override
    public ClassLoaderResolver getClassLoaderResolver() {
        return this.clr;
    }

    @Override
    public StoreManager getStoreManager() {
        return this.getNucleusContext().getStoreManager();
    }

    @Override
    public ApiAdapter getApiAdapter() {
        return this.getNucleusContext().getApiAdapter();
    }

    @Override
    public TypeManager getTypeManager() {
        return this.getNucleusContext().getTypeManager();
    }

    @Override
    public LockManager getLockManager() {
        if (this.lockMgr == null) {
            this.lockMgr = new LockManagerImpl();
        }
        return this.lockMgr;
    }

    @Override
    public FetchPlan getFetchPlan() {
        this.assertIsOpen();
        return this.fetchPlan;
    }

    @Override
    public Object getOwner() {
        return this.owner;
    }

    @Override
    public NucleusContext getNucleusContext() {
        return this.nucCtx;
    }

    @Override
    public MetaDataManager getMetaDataManager() {
        return this.getNucleusContext().getMetaDataManager();
    }

    @Override
    public void setProperties(Map props) {
        if (props == null) {
            return;
        }
        for (Map.Entry entry : props.entrySet()) {
            if (!(entry.getKey() instanceof String)) continue;
            this.setProperty((String)entry.getKey(), entry.getValue());
        }
    }

    @Override
    public void setProperty(String name, Object value) {
        if (this.properties.hasProperty(name.toLowerCase(Locale.ENGLISH))) {
            String intName = this.getNucleusContext().getPersistenceConfiguration().getInternalNameForProperty(name);
            this.getNucleusContext().getPersistenceConfiguration().validatePropertyValue(intName, value);
            this.properties.setProperty(intName.toLowerCase(Locale.ENGLISH), value);
        } else if (name.equalsIgnoreCase("datanucleus.cache.level2.type")) {
            if ("none".equalsIgnoreCase((String)value)) {
                this.setLevel2Cache(false);
            }
        } else {
            String intName = this.getNucleusContext().getPersistenceConfiguration().getInternalNameForProperty(name);
            if (intName != null && !intName.equalsIgnoreCase(name)) {
                this.getNucleusContext().getPersistenceConfiguration().validatePropertyValue(intName, value);
                this.properties.setProperty(intName.toLowerCase(Locale.ENGLISH), value);
            } else {
                NucleusLogger.PERSISTENCE.warn("Attempt to set property \"" + name + "\" on PM/EM yet this is not supported. Ignored");
            }
        }
    }

    @Override
    public Map<String, Object> getProperties() {
        HashMap<String, Object> props = new HashMap<String, Object>();
        for (Map.Entry<String, Object> entry : this.properties.getProperties().entrySet()) {
            String propName = this.nucCtx.getPersistenceConfiguration().getCaseSensitiveNameForPropertyName(entry.getKey());
            props.put(propName, entry.getValue());
        }
        return props;
    }

    @Override
    public Boolean getBooleanProperty(String name) {
        if (this.properties.hasProperty(name.toLowerCase(Locale.ENGLISH))) {
            this.assertIsOpen();
            String intName = this.getNucleusContext().getPersistenceConfiguration().getInternalNameForProperty(name);
            return this.properties.getBooleanProperty(intName);
        }
        return null;
    }

    @Override
    public Integer getIntProperty(String name) {
        if (this.properties.hasProperty(name.toLowerCase(Locale.ENGLISH))) {
            this.assertIsOpen();
            String intName = this.getNucleusContext().getPersistenceConfiguration().getInternalNameForProperty(name);
            return this.properties.getIntProperty(intName);
        }
        return null;
    }

    @Override
    public Object getProperty(String name) {
        if (this.properties.hasProperty(name.toLowerCase(Locale.ENGLISH))) {
            this.assertIsOpen();
            String intName = this.getNucleusContext().getPersistenceConfiguration().getInternalNameForProperty(name);
            return this.properties.getProperty(intName.toLowerCase(Locale.ENGLISH));
        }
        return null;
    }

    @Override
    public Set<String> getSupportedProperties() {
        return this.nucCtx.getPersistenceConfiguration().getManagedOverrideablePropertyNames();
    }

    @Override
    public Integer getDatastoreReadTimeoutMillis() {
        return this.properties.getIntProperty("datanucleus.datastoreReadTimeout".toLowerCase(Locale.ENGLISH));
    }

    @Override
    public Integer getDatastoreWriteTimeoutMillis() {
        return this.properties.getIntProperty("datanucleus.datastoreWriteTimeout".toLowerCase(Locale.ENGLISH));
    }

    @Override
    public boolean getMultithreaded() {
        return false;
    }

    protected boolean getDetachOnClose() {
        return this.properties.getBooleanProperty("datanucleus.DetachOnClose".toLowerCase(Locale.ENGLISH));
    }

    protected boolean getDetachAllOnCommit() {
        return this.properties.getBooleanProperty("datanucleus.DetachAllOnCommit".toLowerCase(Locale.ENGLISH));
    }

    protected boolean getDetachAllOnRollback() {
        return this.properties.getBooleanProperty("datanucleus.DetachAllOnRollback".toLowerCase(Locale.ENGLISH));
    }

    protected boolean getReachabilityAtCommit() {
        return this.properties.getBooleanProperty("datanucleus.persistenceByReachabilityAtCommit".toLowerCase(Locale.ENGLISH));
    }

    public boolean getCopyOnAttach() {
        return this.properties.getBooleanProperty("datanucleus.CopyOnAttach".toLowerCase(Locale.ENGLISH));
    }

    @Override
    public boolean getIgnoreCache() {
        return this.properties.getBooleanProperty("datanucleus.IgnoreCache".toLowerCase(Locale.ENGLISH));
    }

    @Override
    public boolean isDelayDatastoreOperationsEnabled() {
        if (this.isFlushing() || this.tx.isCommitting()) {
            return false;
        }
        String flushModeString = (String)this.getProperty("datanucleus.flush.mode");
        if (flushModeString != null) {
            return !flushModeString.equalsIgnoreCase("AUTO");
        }
        if (this.tx.isActive()) {
            return this.tx.getOptimistic();
        }
        return !this.isNonTxAtomic();
    }

    @Override
    public boolean isInserting(Object pc) {
        ObjectProvider op = this.findObjectProvider(pc);
        if (op == null) {
            return false;
        }
        return op.isInserting();
    }

    @Override
    public Transaction getTransaction() {
        this.assertIsOpen();
        return this.tx;
    }

    @Override
    public void enlistInTransaction(ObjectProvider op) {
        this.assertActiveTransaction();
        if (NucleusLogger.TRANSACTION.isDebugEnabled()) {
            NucleusLogger.TRANSACTION.debug(LOCALISER.msg("015017", (Object)StringUtils.toJVMIDString(op.getObject()), (Object)op.getInternalObjectId().toString()));
        }
        if (this.getReachabilityAtCommit() && this.tx.isActive()) {
            if (this.getApiAdapter().isNew(op.getObject())) {
                this.reachabilityFlushedNewIds.add(op.getInternalObjectId());
            } else if (this.getApiAdapter().isPersistent(op.getObject()) && !this.getApiAdapter().isDeleted(op.getObject()) && !this.reachabilityFlushedNewIds.contains(op.getInternalObjectId())) {
                this.reachabilityPersistedIds.add(op.getInternalObjectId());
            }
            if (!this.runningPBRAtCommit) {
                this.reachabilityEnlistedIds.add(op.getInternalObjectId());
            }
        }
        this.enlistedOPCache.put(op.getInternalObjectId(), op);
    }

    @Override
    public void evictFromTransaction(ObjectProvider op) {
        if (NucleusLogger.TRANSACTION.isDebugEnabled()) {
            NucleusLogger.TRANSACTION.debug(LOCALISER.msg("015019", (Object)StringUtils.toJVMIDString(op.getObject()), (Object)IdentityUtils.getIdentityAsString(this.getApiAdapter(), op.getInternalObjectId())));
        }
        if (this.enlistedOPCache.remove(op.getInternalObjectId()) == null && NucleusLogger.TRANSACTION.isDebugEnabled()) {
            NucleusLogger.TRANSACTION.debug(LOCALISER.msg("010023", (Object)StringUtils.toJVMIDString(op.getObject()), (Object)IdentityUtils.getIdentityAsString(this.getApiAdapter(), op.getInternalObjectId())));
        }
    }

    @Override
    public boolean isEnlistedInTransaction(Object id) {
        if (!this.getReachabilityAtCommit() || !this.tx.isActive()) {
            return false;
        }
        if (id == null) {
            return false;
        }
        return this.reachabilityEnlistedIds.contains(id);
    }

    @Override
    public Object getAttachedObjectForId(Object id) {
        ObjectProvider op = this.enlistedOPCache.get(id);
        if (op != null) {
            return op.getObject();
        }
        if (this.cache != null && (op = (ObjectProvider)this.cache.get(id)) != null) {
            return op.getObject();
        }
        return null;
    }

    @Override
    public void addObjectProvider(ObjectProvider op) {
        this.putObjectIntoLevel1Cache(op);
    }

    @Override
    public void removeObjectProvider(ObjectProvider op) {
        List<ExecutionContext.EmbeddedOwnerRelation> embRels;
        this.removeObjectFromLevel1Cache(op.getInternalObjectId());
        this.enlistedOPCache.remove(op.getInternalObjectId());
        if (this.opEmbeddedInfoByEmbedded != null && (embRels = this.opEmbeddedInfoByEmbedded.get(op)) != null) {
            for (ExecutionContext.EmbeddedOwnerRelation rel : embRels) {
                this.opEmbeddedInfoByOwner.remove(rel.getOwnerOP());
            }
            this.opEmbeddedInfoByEmbedded.remove(op);
        }
        if (this.opEmbeddedInfoByOwner != null && (embRels = this.opEmbeddedInfoByOwner.get(op)) != null) {
            for (ExecutionContext.EmbeddedOwnerRelation rel : embRels) {
                this.opEmbeddedInfoByEmbedded.remove(rel.getEmbeddedOP());
            }
            this.opEmbeddedInfoByOwner.remove(op);
        }
        if (this.opAssociatedValuesMapByOP != null) {
            this.opAssociatedValuesMapByOP.remove(op);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ObjectProvider findObjectProvider(Object pc) {
        ObjectProvider op = null;
        Object previousLookingFor = this.objectLookingForOP;
        ObjectProvider previousFound = this.foundOP;
        try {
            this.objectLookingForOP = pc;
            this.foundOP = null;
            ExecutionContext ec = this.getApiAdapter().getExecutionContext(pc);
            if (ec != null && this != ec) {
                throw new NucleusUserException(LOCALISER.msg("010007", this.getApiAdapter().getIdForObject(pc)));
            }
            op = this.foundOP;
        }
        finally {
            this.objectLookingForOP = previousLookingFor;
            this.foundOP = previousFound;
        }
        return op;
    }

    @Override
    public ObjectProvider findObjectProvider(Object pc, boolean persist) {
        ObjectProvider op = this.findObjectProvider(pc);
        if (op == null && persist) {
            int objectType = 0;
            Object object2 = this.persistObjectInternal(pc, null, null, -1, objectType);
            op = this.findObjectProvider(object2);
        } else if (op == null) {
            return null;
        }
        return op;
    }

    @Override
    public ObjectProvider findObjectProviderForEmbedded(Object value, ObjectProvider owner, AbstractMemberMetaData mmd) {
        ObjectProvider embeddedOP = this.findObjectProvider(value);
        if (embeddedOP == null) {
            embeddedOP = this.newObjectProviderForEmbedded(value, false, owner, owner.getClassMetaData().getMetaDataForMember(mmd.getName()).getAbsoluteFieldNumber());
        }
        if (embeddedOP.getEmbeddedOwners() == null || embeddedOP.getEmbeddedOwners().length == 0) {
            int absoluteFieldNumber = owner.getClassMetaData().getMetaDataForMember(mmd.getName()).getAbsoluteFieldNumber();
            this.registerEmbeddedRelation(owner, absoluteFieldNumber, embeddedOP);
            embeddedOP.setPcObjectType((short)1);
        }
        return embeddedOP;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ObjectProvider findObjectProviderOfOwnerForAttachingObject(Object pc) {
        ThreadContextInfo threadInfo = this.acquireThreadContextInfo();
        try {
            if (threadInfo.attachedOwnerByObject == null) {
                ObjectProvider objectProvider = null;
                return objectProvider;
            }
            ObjectProvider objectProvider = threadInfo.attachedOwnerByObject.get(pc);
            return objectProvider;
        }
        finally {
            this.releaseThreadContextInfo();
        }
    }

    @Override
    public ObjectProvider newObjectProviderForHollow(Class pcClass, Object id) {
        return this.nucCtx.getObjectProviderFactory().newForHollow(this, pcClass, id);
    }

    @Override
    public ObjectProvider newObjectProviderForHollowPreConstructed(Object id, Object pc) {
        return this.nucCtx.getObjectProviderFactory().newForHollowPreConstructed(this, id, pc);
    }

    @Override
    public ObjectProvider newObjectProviderForHollowPopulated(Class pcClass, Object id, FieldValues fv) {
        return this.nucCtx.getObjectProviderFactory().newForHollow(this, pcClass, id, fv);
    }

    @Override
    public ObjectProvider newObjectProviderForPersistentClean(Object id, Object pc) {
        return this.nucCtx.getObjectProviderFactory().newForPersistentClean(this, id, pc);
    }

    @Override
    public ObjectProvider newObjectProviderForHollowPopulatedAppId(Class pcClass, FieldValues fv) {
        return this.nucCtx.getObjectProviderFactory().newForHollowPopulatedAppId(this, pcClass, fv);
    }

    @Override
    public ObjectProvider newObjectProviderForEmbedded(Object pc, boolean copyPc, ObjectProvider ownerOP, int ownerFieldNumber) {
        return this.nucCtx.getObjectProviderFactory().newForEmbedded(this, pc, copyPc, ownerOP, ownerFieldNumber);
    }

    @Override
    public ObjectProvider newObjectProviderForEmbedded(AbstractClassMetaData cmd, ObjectProvider ownerOP, int ownerFieldNumber) {
        return this.nucCtx.getObjectProviderFactory().newForEmbedded(this, cmd, ownerOP, ownerFieldNumber);
    }

    @Override
    public ObjectProvider newObjectProviderForPersistentNew(Object pc, FieldValues preInsertChanges) {
        return this.nucCtx.getObjectProviderFactory().newForPersistentNew(this, pc, preInsertChanges);
    }

    @Override
    public ObjectProvider newObjectProviderForTransactionalTransient(Object pc) {
        return this.nucCtx.getObjectProviderFactory().newForTransactionalTransient(this, pc);
    }

    @Override
    public ObjectProvider newObjectProviderForDetached(Object pc, Object id, Object version) {
        return this.nucCtx.getObjectProviderFactory().newForDetached(this, pc, id, version);
    }

    @Override
    public ObjectProvider newObjectProviderForPNewToBeDeleted(Object pc) {
        return this.nucCtx.getObjectProviderFactory().newForPNewToBeDeleted(this, pc);
    }

    protected ObjectProvider newObjectProviderForCachedPC(Object id, CachedPC cachedPC) {
        return this.nucCtx.getObjectProviderFactory().newForCachedPC(this, id, cachedPC);
    }

    @Override
    public void hereIsObjectProvider(ObjectProvider op, Object pc) {
        if (this.objectLookingForOP == pc) {
            this.foundOP = op;
        }
    }

    protected void disconnectObjectProvidersFromCache() {
        if (this.cache != null) {
            HashSet cachedOPsClone = new HashSet(this.cache.values());
            for (ObjectProvider op : cachedOPsClone) {
                if (op == null) continue;
                op.disconnect();
            }
            this.cache.clear();
            if (NucleusLogger.CACHE.isDebugEnabled()) {
                NucleusLogger.CACHE.debug(LOCALISER.msg("003011"));
            }
        }
    }

    private boolean isNonTxAtomic() {
        return this.getNucleusContext().getPersistenceConfiguration().getBooleanProperty("datanucleus.nontx.atomic");
    }

    @Override
    public void processNontransactionalUpdate() {
        if (this.tx.isActive() || !this.tx.getNontransactionalWrite() || !this.isNonTxAtomic()) {
            return;
        }
        ThreadContextInfo threadInfo = this.acquireThreadContextInfo();
        if (threadInfo.nontxPersistDelete) {
            return;
        }
        this.processNontransactionalAtomicChanges();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void processNontransactionalAtomicChanges() {
        if (this.tx.isActive() || !this.tx.getNontransactionalWrite()) {
            return;
        }
        if (!this.isNonTxAtomic()) {
            return;
        }
        if (!this.dirtyOPs.isEmpty()) {
            for (ObjectProvider op : this.dirtyOPs) {
                this.enlistedOPCache.put(op.getInternalObjectId(), op);
            }
            this.flushInternal(true);
            if (this.l2CacheEnabled) {
                this.performLevel2CacheUpdateAtCommit();
            }
            if (this.getDetachAllOnCommit()) {
                this.performDetachAllOnTxnEndPreparation();
                this.performDetachAllOnTxnEnd();
            }
            ArrayList<RuntimeException> failures = null;
            try {
                ApiAdapter api = this.getApiAdapter();
                ObjectProvider[] ops = this.enlistedOPCache.values().toArray(new ObjectProvider[this.enlistedOPCache.size()]);
                for (int i = 0; i < ops.length; ++i) {
                    try {
                        if (ops[i] != null && ops[i].getObject() != null && api.isPersistent(ops[i].getObject()) && api.isDirty(ops[i].getObject())) {
                            ops[i].postCommit(this.getTransaction());
                            continue;
                        }
                        NucleusLogger.PERSISTENCE.debug(">> Atomic nontransactional processing : Not performing postCommit on " + ops[i]);
                        continue;
                    }
                    catch (RuntimeException e) {
                        if (failures == null) {
                            failures = new ArrayList<RuntimeException>();
                        }
                        failures.add(e);
                    }
                }
            }
            finally {
                this.resetTransactionalVariables();
            }
            if (failures != null && !failures.isEmpty()) {
                throw new CommitStateTransitionException(failures.toArray(new Exception[failures.size()]));
            }
        }
        if (this.nontxProcessedOPs != null && !this.nontxProcessedOPs.isEmpty()) {
            for (ObjectProvider op : this.nontxProcessedOPs) {
                if (op == null || op.getLifecycleState() == null || !op.getLifecycleState().isDeleted()) continue;
                this.removeObjectFromLevel1Cache(op.getInternalObjectId());
                this.removeObjectFromLevel2Cache(op.getInternalObjectId());
            }
            this.nontxProcessedOPs.clear();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void evictObject(Object obj) {
        if (obj == null) {
            return;
        }
        try {
            this.clr.setPrimary(obj.getClass().getClassLoader());
            this.assertClassPersistable(obj.getClass());
            this.assertNotDetached(obj);
            ObjectProvider op = this.findObjectProvider(obj);
            if (op == null) {
                throw new NucleusUserException(LOCALISER.msg("010007", this.getApiAdapter().getIdForObject(obj)));
            }
            op.evict();
        }
        finally {
            this.clr.unsetPrimary();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void evictObjects(Class cls, boolean subclasses) {
        if (this.cache != null) {
            try {
                if (this.getMultithreaded()) {
                    this.lock.lock();
                }
                ArrayList opsToEvict = new ArrayList();
                opsToEvict.addAll(this.cache.values());
                for (ObjectProvider op : opsToEvict) {
                    Object pc = op.getObject();
                    boolean evict = false;
                    if (!subclasses && pc.getClass() == cls) {
                        evict = true;
                    } else if (subclasses && cls.isAssignableFrom(pc.getClass())) {
                        evict = true;
                    }
                    if (!evict) continue;
                    op.evict();
                    this.removeObjectFromLevel1Cache(this.getApiAdapter().getIdForObject(pc));
                }
            }
            finally {
                if (this.getMultithreaded()) {
                    this.lock.unlock();
                }
            }
        }
    }

    @Override
    public void evictAllObjects() {
        if (this.cache != null) {
            ArrayList opsToEvict = new ArrayList();
            opsToEvict.addAll(this.cache.values());
            for (ObjectProvider op : opsToEvict) {
                Object pc = op.getObject();
                op.evict();
                this.removeObjectFromLevel1Cache(this.getApiAdapter().getIdForObject(pc));
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void refreshObject(Object obj) {
        if (obj == null) {
            return;
        }
        try {
            this.clr.setPrimary(obj.getClass().getClassLoader());
            this.assertClassPersistable(obj.getClass());
            this.assertNotDetached(obj);
            ObjectProvider op = this.findObjectProvider(obj);
            if (op == null) {
                throw new NucleusUserException(LOCALISER.msg("010007", this.getApiAdapter().getIdForObject(obj)));
            }
            if (this.getApiAdapter().isPersistent(obj) && op.isWaitingToBeFlushedToDatastore()) {
                return;
            }
            op.refresh();
        }
        finally {
            this.clr.unsetPrimary();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void refreshAllObjects() {
        HashSet<ObjectProvider> toRefresh = new HashSet<ObjectProvider>();
        toRefresh.addAll(this.enlistedOPCache.values());
        toRefresh.addAll(this.dirtyOPs);
        toRefresh.addAll(this.indirectDirtyOPs);
        if (!this.tx.isActive() && this.cache != null) {
            toRefresh.addAll(this.cache.values());
        }
        try {
            if (this.getMultithreaded()) {
                this.lock.lock();
            }
            ArrayList<RuntimeException> failures = null;
            for (ObjectProvider op : toRefresh) {
                try {
                    op.refresh();
                }
                catch (RuntimeException e) {
                    if (failures == null) {
                        failures = new ArrayList<RuntimeException>();
                    }
                    failures.add(e);
                }
            }
            if (failures != null && !failures.isEmpty()) {
                throw new NucleusUserException(LOCALISER.msg("010037"), failures.toArray(new Exception[failures.size()]));
            }
        }
        finally {
            if (this.getMultithreaded()) {
                this.lock.unlock();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void retrieveObject(Object obj, boolean fgOnly) {
        if (obj == null) {
            return;
        }
        try {
            this.clr.setPrimary(obj.getClass().getClassLoader());
            this.assertClassPersistable(obj.getClass());
            this.assertNotDetached(obj);
            ObjectProvider op = this.findObjectProvider(obj);
            if (op == null) {
                throw new NucleusUserException(LOCALISER.msg("010007", this.getApiAdapter().getIdForObject(obj)));
            }
            op.retrieve(fgOnly);
        }
        finally {
            this.clr.unsetPrimary();
        }
    }

    /*
     * Loose catch block
     */
    @Override
    public Object persistObject(Object obj, boolean merging) {
        if (obj == null) {
            return null;
        }
        ThreadContextInfo threadInfo = this.acquireThreadContextInfo();
        try {
            if (merging && this.nucCtx.getPersistenceConfiguration().getBooleanProperty("datanucleus.allowAttachOfTransient", false)) {
                threadInfo.merging = true;
            }
            if (threadInfo.attachedOwnerByObject == null) {
                threadInfo.attachedOwnerByObject = new HashMap<Object, ObjectProvider>();
            }
            if (threadInfo.attachedPCById == null) {
                threadInfo.attachedPCById = new HashMap();
            }
            if (this.tx.isActive()) {
                Object object = this.persistObjectWork(obj);
                return object;
            }
            threadInfo.nontxPersistDelete = true;
            boolean success = true;
            HashSet cachedIds = this.cache != null ? new HashSet(this.cache.keySet()) : null;
            try {
                Object object = this.persistObjectWork(obj);
                return object;
            }
            catch (RuntimeException re) {
                success = false;
                if (this.cache != null) {
                    Iterator cacheIter = this.cache.keySet().iterator();
                    while (cacheIter.hasNext()) {
                        Object id = cacheIter.next();
                        if (cachedIds.contains(id)) continue;
                        cacheIter.remove();
                    }
                }
                throw re;
            }
            finally {
                threadInfo.nontxPersistDelete = false;
                if (success) {
                    this.processNontransactionalAtomicChanges();
                }
            }
            {
                catch (Throwable throwable) {
                    throw throwable;
                }
            }
        }
        finally {
            this.releaseThreadContextInfo();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Object[] persistObjects(Object[] objs) {
        if (objs == null) {
            return null;
        }
        Object[] persistedObjs = new Object[objs.length];
        ThreadContextInfo threadInfo = this.acquireThreadContextInfo();
        try {
            if (threadInfo.attachedOwnerByObject == null) {
                threadInfo.attachedOwnerByObject = new HashMap<Object, ObjectProvider>();
            }
            if (threadInfo.attachedPCById == null) {
                threadInfo.attachedPCById = new HashMap();
            }
            if (!this.tx.isActive()) {
                threadInfo.nontxPersistDelete = true;
            }
            try {
                this.getStoreManager().getPersistenceHandler().batchStart(this, PersistenceBatchType.PERSIST);
                ArrayList<RuntimeException> failures = null;
                for (int i = 0; i < objs.length; ++i) {
                    try {
                        if (objs[i] == null) continue;
                        persistedObjs[i] = this.persistObjectWork(objs[i]);
                        continue;
                    }
                    catch (RuntimeException e) {
                        if (failures == null) {
                            failures = new ArrayList<RuntimeException>();
                        }
                        failures.add(e);
                    }
                }
                if (failures != null && !failures.isEmpty()) {
                    RuntimeException e = (RuntimeException)failures.get(0);
                    if (e instanceof NucleusException && ((NucleusException)e).isFatal()) {
                        throw new NucleusFatalUserException(LOCALISER.msg("010039"), failures.toArray(new Exception[failures.size()]));
                    }
                    throw new NucleusUserException(LOCALISER.msg("010039"), failures.toArray(new Exception[failures.size()]));
                }
            }
            finally {
                this.getStoreManager().getPersistenceHandler().batchEnd(this, PersistenceBatchType.PERSIST);
                if (!this.tx.isActive()) {
                    threadInfo.nontxPersistDelete = false;
                    this.processNontransactionalAtomicChanges();
                }
            }
        }
        finally {
            this.releaseThreadContextInfo();
        }
        return persistedObjs;
    }

    private Object persistObjectWork(Object obj) {
        boolean detached = this.getApiAdapter().isDetached(obj);
        Object persistedPc = this.persistObjectInternal(obj, null, null, -1, 0);
        ObjectProvider op = this.findObjectProvider(persistedPc);
        if (op != null) {
            if (this.indirectDirtyOPs.contains(op)) {
                this.dirtyOPs.add(op);
                this.indirectDirtyOPs.remove(op);
            } else if (!this.dirtyOPs.contains(op)) {
                this.dirtyOPs.add(op);
                if (this.l2CacheTxIds != null && this.nucCtx.isClassCacheable(op.getClassMetaData())) {
                    this.l2CacheTxIds.add(op.getInternalObjectId());
                }
            }
            if (this.getReachabilityAtCommit() && this.tx.isActive() && (detached || this.getApiAdapter().isNew(persistedPc))) {
                this.reachabilityPersistedIds.add(op.getInternalObjectId());
            }
        }
        return persistedPc;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Object persistObjectInternal(Object obj, FieldValues preInsertChanges, ObjectProvider ownerOP, int ownerFieldNum, int objectType) {
        if (obj == null) {
            return null;
        }
        ApiAdapter api = this.getApiAdapter();
        Object id = null;
        try {
            this.clr.setPrimary(obj.getClass().getClassLoader());
            this.assertClassPersistable(obj.getClass());
            ExecutionContext ec = api.getExecutionContext(obj);
            if (ec != null && ec != this) {
                throw new NucleusUserException(LOCALISER.msg("010007", obj));
            }
            boolean cacheable = false;
            Object persistedPc = obj;
            if (api.isDetached(obj)) {
                this.assertDetachable(obj);
                if (this.getCopyOnAttach()) {
                    persistedPc = this.attachObjectCopy(ownerOP, obj, api.getIdForObject(obj) == null);
                } else {
                    this.attachObject(ownerOP, obj, api.getIdForObject(obj) == null);
                    persistedPc = obj;
                }
            } else if (api.isTransactional(obj) && !api.isPersistent(obj)) {
                ObjectProvider op;
                if (NucleusLogger.PERSISTENCE.isDebugEnabled()) {
                    NucleusLogger.PERSISTENCE.debug(LOCALISER.msg("010015", (Object)StringUtils.toJVMIDString(obj)));
                }
                if ((op = this.findObjectProvider(obj)) == null) {
                    throw new NucleusUserException(LOCALISER.msg("010007", this.getApiAdapter().getIdForObject(obj)));
                }
                op.makePersistentTransactionalTransient();
            } else if (!api.isPersistent(obj)) {
                if (NucleusLogger.PERSISTENCE.isDebugEnabled()) {
                    NucleusLogger.PERSISTENCE.debug(LOCALISER.msg("010015", (Object)StringUtils.toJVMIDString(obj)));
                }
                boolean merged = false;
                ThreadContextInfo threadInfo = this.acquireThreadContextInfo();
                try {
                    if (threadInfo.merging) {
                        AbstractClassMetaData cmd = this.getMetaDataManager().getMetaDataForClass(obj.getClass(), this.clr);
                        if (cmd.getIdentityType() == IdentityType.APPLICATION) {
                            Object transientId = api.getNewApplicationIdentityObjectId(obj, cmd);
                            Object existingObj = this.findObject(transientId, true, true, cmd.getFullClassName());
                            ObjectProvider existingOP = this.findObjectProvider(existingObj);
                            existingOP.attach(obj);
                            id = transientId;
                            merged = true;
                            persistedPc = existingObj;
                        }
                        cacheable = this.nucCtx.isClassCacheable(cmd);
                    }
                }
                catch (NucleusObjectNotFoundException onfe) {
                }
                finally {
                    this.releaseThreadContextInfo();
                }
                if (!merged) {
                    ObjectProvider op = this.findObjectProvider(obj);
                    if (op == null) {
                        if ((objectType == 2 || objectType == 3 || objectType == 4 || objectType == 1) && ownerOP != null) {
                            op = this.newObjectProviderForEmbedded(obj, false, ownerOP, ownerFieldNum);
                            op.setPcObjectType((short)objectType);
                            op.makePersistent();
                            id = op.getInternalObjectId();
                        } else {
                            op = this.newObjectProviderForPersistentNew(obj, preInsertChanges);
                            op.makePersistent();
                            id = op.getInternalObjectId();
                        }
                    } else if (op.getReferencedPC() == null) {
                        op.makePersistent();
                        id = op.getInternalObjectId();
                    } else {
                        persistedPc = op.getReferencedPC();
                    }
                    if (op != null) {
                        cacheable = this.nucCtx.isClassCacheable(op.getClassMetaData());
                    }
                }
            } else if (api.isPersistent(obj) && api.getIdForObject(obj) == null) {
                if (NucleusLogger.PERSISTENCE.isDebugEnabled()) {
                    NucleusLogger.PERSISTENCE.debug(LOCALISER.msg("010015", (Object)StringUtils.toJVMIDString(obj)));
                }
                ObjectProvider op = this.findObjectProvider(obj);
                op.makePersistent();
                id = op.getInternalObjectId();
                cacheable = this.nucCtx.isClassCacheable(op.getClassMetaData());
            } else if (api.isDeleted(obj)) {
                if (NucleusLogger.PERSISTENCE.isDebugEnabled()) {
                    NucleusLogger.PERSISTENCE.debug(LOCALISER.msg("010015", (Object)StringUtils.toJVMIDString(obj)));
                }
                ObjectProvider op = this.findObjectProvider(obj);
                op.makePersistent();
                id = op.getInternalObjectId();
                cacheable = this.nucCtx.isClassCacheable(op.getClassMetaData());
            } else if (api.isPersistent(obj) && api.isTransactional(obj) && api.isDirty(obj) && this.isDelayDatastoreOperationsEnabled()) {
                if (NucleusLogger.PERSISTENCE.isDebugEnabled()) {
                    NucleusLogger.PERSISTENCE.debug(LOCALISER.msg("010015", (Object)StringUtils.toJVMIDString(obj)));
                }
                ObjectProvider op = this.findObjectProvider(obj);
                op.makePersistent();
                id = op.getInternalObjectId();
                cacheable = this.nucCtx.isClassCacheable(op.getClassMetaData());
            }
            if (id != null && this.l2CacheTxIds != null && cacheable) {
                this.l2CacheTxIds.add(id);
            }
            Object object = persistedPc;
            return object;
        }
        finally {
            this.clr.unsetPrimary();
        }
    }

    @Override
    public Object persistObjectInternal(Object pc, ObjectProvider ownerOP, int ownerFieldNum, int objectType) {
        if (ownerOP != null) {
            ObjectProvider op = this.findObjectProvider(ownerOP.getObject());
            return this.persistObjectInternal(pc, null, op, ownerFieldNum, objectType);
        }
        return this.persistObjectInternal(pc, null, null, ownerFieldNum, objectType);
    }

    @Override
    public Object persistObjectInternal(Object pc, FieldValues preInsertChanges, int objectType) {
        return this.persistObjectInternal(pc, preInsertChanges, null, -1, objectType);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void deleteObjects(Object[] objs) {
        if (objs == null) {
            return;
        }
        ThreadContextInfo threadInfo = this.acquireThreadContextInfo();
        try {
            if (!this.tx.isActive()) {
                threadInfo.nontxPersistDelete = true;
            }
            this.getStoreManager().getPersistenceHandler().batchStart(this, PersistenceBatchType.DELETE);
            ArrayList<RuntimeException> failures = null;
            for (int i = 0; i < objs.length; ++i) {
                try {
                    if (objs[i] == null) continue;
                    this.deleteObjectWork(objs[i]);
                    continue;
                }
                catch (RuntimeException e) {
                    if (failures == null) {
                        failures = new ArrayList<RuntimeException>();
                    }
                    failures.add(e);
                }
            }
            if (failures != null && !failures.isEmpty()) {
                RuntimeException e = (RuntimeException)failures.get(0);
                if (e instanceof NucleusException && ((NucleusException)e).isFatal()) {
                    throw new NucleusFatalUserException(LOCALISER.msg("010040"), failures.toArray(new Exception[failures.size()]));
                }
                throw new NucleusUserException(LOCALISER.msg("010040"), failures.toArray(new Exception[failures.size()]));
            }
        }
        finally {
            this.getStoreManager().getPersistenceHandler().batchEnd(this, PersistenceBatchType.DELETE);
            if (!this.tx.isActive()) {
                threadInfo.nontxPersistDelete = false;
                this.processNontransactionalAtomicChanges();
            }
            this.releaseThreadContextInfo();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void deleteObject(Object obj) {
        if (obj == null) {
            return;
        }
        ThreadContextInfo threadInfo = this.acquireThreadContextInfo();
        try {
            if (!this.tx.isActive()) {
                threadInfo.nontxPersistDelete = true;
            }
            this.deleteObjectWork(obj);
        }
        finally {
            if (!this.tx.isActive()) {
                threadInfo.nontxPersistDelete = false;
                this.processNontransactionalAtomicChanges();
            }
            this.releaseThreadContextInfo();
        }
    }

    void deleteObjectWork(Object obj) {
        ObjectProvider op = this.findObjectProvider(obj);
        if (op == null && this.getApiAdapter().isDetached(obj)) {
            Object attachedObj = this.findObject(this.getApiAdapter().getIdForObject(obj), true, false, obj.getClass().getName());
            op = this.findObjectProvider(attachedObj);
        }
        if (op != null) {
            if (this.indirectDirtyOPs.contains(op)) {
                this.indirectDirtyOPs.remove(op);
                this.dirtyOPs.add(op);
            } else if (!this.dirtyOPs.contains(op)) {
                this.dirtyOPs.add(op);
                if (this.l2CacheTxIds != null && this.nucCtx.isClassCacheable(op.getClassMetaData())) {
                    this.l2CacheTxIds.add(op.getInternalObjectId());
                }
            }
        }
        this.deleteObjectInternal(obj);
        if (this.getReachabilityAtCommit() && this.tx.isActive() && op != null && this.getApiAdapter().isDeleted(obj)) {
            this.reachabilityDeletedIds.add(op.getInternalObjectId());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void deleteObjectInternal(Object obj) {
        if (obj == null) {
            return;
        }
        try {
            ObjectProvider op;
            this.clr.setPrimary(obj.getClass().getClassLoader());
            this.assertClassPersistable(obj.getClass());
            Object pc = obj;
            if (this.getApiAdapter().isDetached(obj)) {
                pc = this.findObject(this.getApiAdapter().getIdForObject(obj), true, true, null);
            }
            if (NucleusLogger.PERSISTENCE.isDebugEnabled()) {
                NucleusLogger.PERSISTENCE.debug(LOCALISER.msg("010019", (Object)StringUtils.toJVMIDString(pc)));
            }
            if (this.getApiAdapter().getName().equals("JDO")) {
                if (!this.getApiAdapter().isPersistent(pc) && !this.getApiAdapter().isTransactional(pc)) {
                    throw new NucleusUserException(LOCALISER.msg("010020"));
                }
                if (!this.getApiAdapter().isPersistent(pc) && this.getApiAdapter().isTransactional(pc)) {
                    throw new NucleusUserException(LOCALISER.msg("010021", this.getApiAdapter().getIdForObject(obj)));
                }
            }
            if ((op = this.findObjectProvider(pc)) == null) {
                if (!this.getApiAdapter().allowDeleteOfNonPersistentObject()) {
                    throw new NucleusUserException(LOCALISER.msg("010007", this.getApiAdapter().getIdForObject(pc)));
                }
                op = this.newObjectProviderForPNewToBeDeleted(pc);
            }
            if (this.l2CacheTxIds != null && this.nucCtx.isClassCacheable(op.getClassMetaData())) {
                this.l2CacheTxIds.add(op.getInternalObjectId());
            }
            op.deletePersistent();
        }
        finally {
            this.clr.unsetPrimary();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void makeObjectTransient(Object obj, FetchPlanState state) {
        if (obj == null) {
            return;
        }
        try {
            this.clr.setPrimary(obj.getClass().getClassLoader());
            this.assertClassPersistable(obj.getClass());
            this.assertNotDetached(obj);
            if (NucleusLogger.PERSISTENCE.isDebugEnabled()) {
                NucleusLogger.PERSISTENCE.debug(LOCALISER.msg("010022", (Object)StringUtils.toJVMIDString(obj)));
            }
            if (this.getApiAdapter().isPersistent(obj)) {
                ObjectProvider op = this.findObjectProvider(obj);
                op.makeTransient(state);
            }
        }
        finally {
            this.clr.unsetPrimary();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void makeObjectTransactional(Object obj) {
        if (obj == null) {
            return;
        }
        try {
            ObjectProvider op;
            this.clr.setPrimary(obj.getClass().getClassLoader());
            this.assertClassPersistable(obj.getClass());
            this.assertNotDetached(obj);
            if (this.getApiAdapter().isPersistent(obj)) {
                this.assertActiveTransaction();
            }
            if ((op = this.findObjectProvider(obj)) == null) {
                op = this.newObjectProviderForTransactionalTransient(obj);
            }
            op.makeTransactional();
        }
        finally {
            this.clr.unsetPrimary();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void makeObjectNontransactional(Object obj) {
        if (obj == null) {
            return;
        }
        try {
            this.clr.setPrimary(obj.getClass().getClassLoader());
            this.assertClassPersistable(obj.getClass());
            if (!this.getApiAdapter().isPersistent(obj) && this.getApiAdapter().isTransactional(obj) && this.getApiAdapter().isDirty(obj)) {
                throw new NucleusUserException(LOCALISER.msg("010024"));
            }
            ObjectProvider op = this.findObjectProvider(obj);
            op.makeNontransactional();
        }
        finally {
            this.clr.unsetPrimary();
        }
    }

    @Override
    public void attachObject(ObjectProvider ownerOP, Object pc, boolean sco) {
        ApiAdapter api;
        Object id;
        this.assertClassPersistable(pc.getClass());
        Map<Object, ObjectProvider> attachedOwnerByObject = this.getThreadContextInfo().attachedOwnerByObject;
        if (attachedOwnerByObject != null) {
            attachedOwnerByObject.put(pc, ownerOP);
        }
        if ((id = (api = this.getApiAdapter()).getIdForObject(pc)) != null && this.isInserting(pc)) {
            return;
        }
        if (id == null && !sco) {
            this.persistObjectInternal(pc, null, null, -1, 0);
            return;
        }
        if (api.isDetached(pc)) {
            ObjectProvider l1CachedOP;
            if (this.cache != null && (l1CachedOP = (ObjectProvider)this.cache.get(id)) != null && l1CachedOP.getObject() != pc) {
                throw new NucleusUserException(LOCALISER.msg("010017", (Object)StringUtils.toJVMIDString(pc)));
            }
            if (NucleusLogger.PERSISTENCE.isDebugEnabled()) {
                NucleusLogger.PERSISTENCE.debug(LOCALISER.msg("010016", (Object)StringUtils.toJVMIDString(pc)));
            }
        } else {
            return;
        }
        ObjectProvider op = this.newObjectProviderForDetached(pc, id, api.getVersionForObject(pc));
        op.attach(sco);
    }

    @Override
    public Object attachObjectCopy(ObjectProvider ownerOP, Object pc, boolean sco) {
        ApiAdapter api;
        Object id;
        this.assertClassPersistable(pc.getClass());
        this.assertDetachable(pc);
        Map<Object, ObjectProvider> attachedOwnerByObject = this.getThreadContextInfo().attachedOwnerByObject;
        if (attachedOwnerByObject != null) {
            attachedOwnerByObject.put(pc, ownerOP);
        }
        if ((id = (api = this.getApiAdapter()).getIdForObject(pc)) != null && this.isInserting(pc)) {
            return pc;
        }
        if (id == null && !sco) {
            return this.persistObjectInternal(pc, null, null, -1, 0);
        }
        if (api.isPersistent(pc)) {
            return pc;
        }
        Object pcTarget = null;
        if (sco) {
            boolean detached = this.getApiAdapter().isDetached(pc);
            ObjectProvider targetOP = this.newObjectProviderForEmbedded(pc, true, null, -1);
            pcTarget = targetOP.getObject();
            if (detached) {
                if (NucleusLogger.PERSISTENCE.isDebugEnabled()) {
                    NucleusLogger.PERSISTENCE.debug(LOCALISER.msg("010018", (Object)StringUtils.toJVMIDString(pc), (Object)StringUtils.toJVMIDString(pcTarget)));
                }
                targetOP.attachCopy(pc, sco);
            }
        } else {
            boolean detached = this.getApiAdapter().isDetached(pc);
            pcTarget = this.findObject(id, false, false, pc.getClass().getName());
            if (detached) {
                Object obj = null;
                Map attachedPCById = this.getThreadContextInfo().attachedPCById;
                if (attachedPCById != null) {
                    obj = attachedPCById.get(this.getApiAdapter().getIdForObject(pc));
                }
                if (obj != null) {
                    pcTarget = obj;
                } else {
                    if (NucleusLogger.PERSISTENCE.isDebugEnabled()) {
                        NucleusLogger.PERSISTENCE.debug(LOCALISER.msg("010018", (Object)StringUtils.toJVMIDString(pc), (Object)StringUtils.toJVMIDString(pcTarget)));
                    }
                    pcTarget = this.findObjectProvider(pcTarget).attachCopy(pc, sco);
                    if (attachedPCById != null) {
                        attachedPCById.put(this.getApiAdapter().getIdForObject(pc), pcTarget);
                    }
                }
            }
        }
        return pcTarget;
    }

    @Override
    public void detachObject(Object obj, FetchPlanState state) {
        ObjectProvider op;
        if (this.getApiAdapter().isDetached(obj)) {
            return;
        }
        if (!this.getApiAdapter().isPersistent(obj)) {
            if (this.runningDetachAllOnTxnEnd && !this.getMetaDataManager().getMetaDataForClass(obj.getClass(), this.clr).isDetachable()) {
                return;
            }
            if (this.tx.isActive()) {
                this.persistObjectInternal(obj, null, null, -1, 0);
            }
        }
        if ((op = this.findObjectProvider(obj)) == null) {
            throw new NucleusUserException(LOCALISER.msg("010007", this.getApiAdapter().getIdForObject(obj)));
        }
        op.detach(state);
        if (this.dirtyOPs.contains(op) || this.indirectDirtyOPs.contains(op)) {
            NucleusLogger.GENERAL.info(LOCALISER.msg("010047", (Object)StringUtils.toJVMIDString(obj)));
            this.clearDirty(op);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Object detachObjectCopy(Object pc, FetchPlanState state) {
        Object thePC = pc;
        try {
            ObjectProvider op;
            this.clr.setPrimary(pc.getClass().getClassLoader());
            if (!this.getApiAdapter().isPersistent(pc) && !this.getApiAdapter().isDetached(pc)) {
                if (this.tx.isActive()) {
                    thePC = this.persistObjectInternal(pc, null, null, -1, 0);
                } else {
                    throw new NucleusUserException(LOCALISER.msg("010014"));
                }
            }
            if (this.getApiAdapter().isDetached(thePC)) {
                thePC = this.findObject(this.getApiAdapter().getIdForObject(thePC), false, true, null);
            }
            if ((op = this.findObjectProvider(thePC)) == null) {
                throw new NucleusUserException(LOCALISER.msg("010007", this.getApiAdapter().getIdForObject(thePC)));
            }
            Object object = op.detachCopy(state);
            return object;
        }
        finally {
            this.clr.unsetPrimary();
        }
    }

    @Override
    public void detachAll() {
        HashSet<ObjectProvider> opsToDetach = new HashSet<ObjectProvider>();
        opsToDetach.addAll(this.enlistedOPCache.values());
        if (this.cache != null) {
            opsToDetach.addAll(this.cache.values());
        }
        FetchPlanState fps = new FetchPlanState();
        Iterator iter = opsToDetach.iterator();
        while (iter.hasNext()) {
            ((ObjectProvider)iter.next()).detach(fps);
        }
    }

    @Override
    public Object getAttachDetachReferencedObject(ObjectProvider op) {
        if (this.opAttachDetachObjectReferenceMap == null) {
            return null;
        }
        return this.opAttachDetachObjectReferenceMap.get(op);
    }

    @Override
    public void setAttachDetachReferencedObject(ObjectProvider op, Object obj) {
        if (obj != null) {
            if (this.opAttachDetachObjectReferenceMap == null) {
                this.opAttachDetachObjectReferenceMap = new HashMap<ObjectProvider, Object>();
            }
            this.opAttachDetachObjectReferenceMap.put(op, obj);
        } else if (this.opAttachDetachObjectReferenceMap != null) {
            this.opAttachDetachObjectReferenceMap.remove(op);
        }
    }

    @Override
    public Object newInstance(Class cls) {
        if (this.getApiAdapter().isPersistable(cls) && !Modifier.isAbstract(cls.getModifiers())) {
            try {
                return cls.newInstance();
            }
            catch (IllegalAccessException iae) {
                throw new NucleusUserException(iae.toString(), iae);
            }
            catch (InstantiationException ie) {
                throw new NucleusUserException(ie.toString(), ie);
            }
        }
        this.assertHasImplementationCreator();
        return this.getNucleusContext().getImplementationCreator().newInstance(cls, this.clr);
    }

    @Override
    public boolean exists(Object obj) {
        if (obj == null) {
            return false;
        }
        Object id = this.getApiAdapter().getIdForObject(obj);
        if (id == null) {
            return false;
        }
        try {
            this.findObject(id, true, false, obj.getClass().getName());
        }
        catch (NucleusObjectNotFoundException onfe) {
            return false;
        }
        return true;
    }

    @Override
    public Set getManagedObjects() {
        if (!this.tx.isActive()) {
            return null;
        }
        HashSet<Object> objs = new HashSet<Object>();
        for (ObjectProvider op : this.enlistedOPCache.values()) {
            objs.add(op.getObject());
        }
        return objs;
    }

    @Override
    public Set getManagedObjects(Class[] classes) {
        if (!this.tx.isActive()) {
            return null;
        }
        HashSet<Object> objs = new HashSet<Object>();
        block0: for (ObjectProvider op : this.enlistedOPCache.values()) {
            for (int i = 0; i < classes.length; ++i) {
                if (classes[i] != op.getObject().getClass()) continue;
                objs.add(op.getObject());
                continue block0;
            }
        }
        return objs;
    }

    @Override
    public Set getManagedObjects(String[] states) {
        if (!this.tx.isActive()) {
            return null;
        }
        HashSet<Object> objs = new HashSet<Object>();
        block0: for (ObjectProvider op : this.enlistedOPCache.values()) {
            for (int i = 0; i < states.length; ++i) {
                if (!this.getApiAdapter().getObjectState(op.getObject()).equals(states[i])) continue;
                objs.add(op.getObject());
                continue block0;
            }
        }
        return objs;
    }

    @Override
    public Set getManagedObjects(String[] states, Class[] classes) {
        if (!this.tx.isActive()) {
            return null;
        }
        HashSet<Object> objs = new HashSet<Object>();
        block0: for (ObjectProvider op : this.enlistedOPCache.values()) {
            boolean matches = false;
            for (int i = 0; i < states.length; ++i) {
                if (this.getApiAdapter().getObjectState(op.getObject()).equals(states[i])) {
                    int j = 0;
                    while (i < classes.length) {
                        if (classes[j] == op.getObject().getClass()) {
                            matches = true;
                            objs.add(op.getObject());
                            break;
                        }
                        ++i;
                    }
                }
                if (matches) continue block0;
            }
        }
        return objs;
    }

    @Override
    public Object findObject(Object id, FieldValues fv, Class cls, boolean ignoreCache, boolean checkInheritance) {
        this.assertIsOpen();
        boolean createdHollow = false;
        Object pc = null;
        ObjectProvider op = null;
        if (!ignoreCache) {
            pc = this.getObjectFromCache(id);
        }
        if (pc == null) {
            pc = this.getStoreManager().getPersistenceHandler().findObject(this, id);
        }
        if (pc == null) {
            String className;
            String string = className = cls != null ? cls.getName() : null;
            if (!(id instanceof SCOID)) {
                ClassDetailsForId details = this.getClassDetailsForId(id, className, checkInheritance);
                if (details.className != null && cls != null && !cls.getName().equals(details.className)) {
                    cls = this.clr.classForName(details.className);
                }
                className = details.className;
                id = details.id;
                if (details.pc != null) {
                    pc = details.pc;
                    op = this.findObjectProvider(pc);
                }
            }
            if (pc == null) {
                if (cls == null) {
                    try {
                        cls = this.clr.classForName(className, id.getClass().getClassLoader());
                    }
                    catch (ClassNotResolvedException e) {
                        String msg = LOCALISER.msg("010027", (Object)IdentityUtils.getIdentityAsString(this.getApiAdapter(), id));
                        NucleusLogger.PERSISTENCE.warn(msg);
                        throw new NucleusUserException(msg, e);
                    }
                }
                createdHollow = true;
                op = this.newObjectProviderForHollowPopulated(cls, id, fv);
                pc = op.getObject();
                this.putObjectIntoLevel1Cache(op);
                this.putObjectIntoLevel2Cache(op, false);
            }
        }
        if (pc != null && fv != null && !createdHollow) {
            if (op == null) {
                op = this.findObjectProvider(pc);
            }
            if (op != null) {
                fv.fetchNonLoadedFields(op);
            }
        }
        return pc;
    }

    @Override
    public Object[] findObjects(Object[] identities, boolean validate) {
        Map pcsById;
        if (identities == null) {
            return null;
        }
        if (identities.length == 1) {
            return new Object[]{this.findObject(identities[0], validate, validate, null)};
        }
        for (int i = 0; i < identities.length; ++i) {
            if (identities[i] != null) continue;
            throw new NucleusUserException(LOCALISER.msg("010044"));
        }
        Object[] ids = new Object[identities.length];
        for (int i = 0; i < identities.length; ++i) {
            if (this.getNucleusContext().getIdentityStringTranslator() != null && identities[i] instanceof String) {
                IdentityStringTranslator translator = this.getNucleusContext().getIdentityStringTranslator();
                ids[i] = translator.getIdentity(this, (String)identities[i]);
                continue;
            }
            ids[i] = identities[i];
        }
        HashMap<Object, Object> pcById = new HashMap<Object, Object>(identities.length);
        ArrayList<Object> idsToFind = new ArrayList<Object>();
        ApiAdapter api = this.getApiAdapter();
        for (int i = 0; i < ids.length; ++i) {
            Object pc = this.getObjectFromLevel1Cache(ids[i]);
            if (pc != null) {
                if (ids[i] instanceof SCOID && api.isPersistent(pc) && !api.isNew(pc) && !api.isDeleted(pc) && !api.isTransactional(pc)) {
                    throw new NucleusUserException(LOCALISER.msg("010005"));
                }
                pcById.put(ids[i], pc);
                continue;
            }
            idsToFind.add(ids[i]);
        }
        if (!idsToFind.isEmpty() && this.l2CacheEnabled && !(pcsById = this.getObjectsFromLevel2Cache(idsToFind)).isEmpty()) {
            for (Map.Entry entry : pcsById.entrySet()) {
                pcById.put(entry.getKey(), entry.getValue());
                idsToFind.remove(entry.getKey());
            }
        }
        boolean performValidationWhenCached = this.nucCtx.getPersistenceConfiguration().getBooleanProperty("datanucleus.findObject.validateWhenCached");
        ArrayList<ObjectProvider> opsToValidate = new ArrayList<ObjectProvider>();
        if (validate && performValidationWhenCached) {
            Collection pcValues = pcById.values();
            for (Object pc : pcValues) {
                if (api.isTransactional(pc)) continue;
                ObjectProvider op = this.findObjectProvider(pc);
                opsToValidate.add(op);
            }
        }
        Object[] foundPcs = null;
        if (!idsToFind.isEmpty()) {
            foundPcs = this.getStoreManager().getPersistenceHandler().findObjects(this, idsToFind.toArray());
        }
        int foundPcIdx = 0;
        for (Object id : idsToFind) {
            Object idOrig = id;
            Object pc = foundPcs[foundPcIdx++];
            ObjectProvider op = null;
            if (pc != null) {
                op = this.findObjectProvider(pc);
                this.putObjectIntoLevel1Cache(op);
            } else {
                ClassDetailsForId details = this.getClassDetailsForId(id, null, validate);
                String className = details.className;
                id = details.id;
                if (details.pc != null) {
                    pc = details.pc;
                    op = this.findObjectProvider(pc);
                    if (performValidationWhenCached && validate && !api.isTransactional(pc)) {
                        opsToValidate.add(op);
                    }
                } else {
                    try {
                        Class pcClass = this.clr.classForName(className, id instanceof OID ? null : id.getClass().getClassLoader());
                        if (Modifier.isAbstract(pcClass.getModifiers())) {
                            throw new NucleusObjectNotFoundException(LOCALISER.msg("010027", (Object)IdentityUtils.getIdentityAsString(this.getApiAdapter(), id), (Object)className));
                        }
                        op = this.newObjectProviderForHollow(pcClass, id);
                        pc = op.getObject();
                        if (!validate) {
                            op.markForInheritanceValidation();
                        }
                        this.putObjectIntoLevel1Cache(op);
                    }
                    catch (ClassNotResolvedException e) {
                        NucleusLogger.PERSISTENCE.warn(LOCALISER.msg("010027", (Object)IdentityUtils.getIdentityAsString(this.getApiAdapter(), id)));
                        throw new NucleusUserException(LOCALISER.msg("010027", (Object)IdentityUtils.getIdentityAsString(this.getApiAdapter(), id)), e);
                    }
                    if (validate) {
                        opsToValidate.add(op);
                    }
                }
            }
            pcById.put(idOrig, pc);
        }
        if (!opsToValidate.isEmpty()) {
            try {
                this.getStoreManager().getPersistenceHandler().locateObjects(opsToValidate.toArray(new ObjectProvider[opsToValidate.size()]));
            }
            catch (NucleusObjectNotFoundException nonfe) {
                NucleusObjectNotFoundException[] nonfes = (NucleusObjectNotFoundException[])nonfe.getNestedExceptions();
                if (nonfes != null) {
                    for (int i = 0; i < nonfes.length; ++i) {
                        Object missingId = nonfes[i].getFailedObject();
                        this.removeObjectFromLevel1Cache(missingId);
                    }
                }
                throw nonfe;
            }
        }
        Object[] objs = new Object[ids.length];
        for (int i = 0; i < ids.length; ++i) {
            Object id = ids[i];
            objs[i] = pcById.get(id);
        }
        return objs;
    }

    private ClassDetailsForId getClassDetailsForId(Object id, String objectClassName, boolean checkInheritance) {
        ApiAdapter api = this.getApiAdapter();
        String className = null;
        String originalClassName = null;
        boolean checkedClassName = false;
        if (id instanceof SCOID) {
            throw new NucleusUserException(LOCALISER.msg("010006"));
        }
        if (id instanceof DatastoreUniqueOID) {
            throw new NucleusObjectNotFoundException(LOCALISER.msg("010026"), id);
        }
        if (objectClassName != null) {
            originalClassName = objectClassName;
        } else if (api.isDatastoreIdentity(id) || api.isSingleFieldIdentity(id)) {
            originalClassName = this.getStoreManager().manageClassForIdentity(id, this.clr);
        } else {
            originalClassName = this.getStoreManager().getClassNameForObjectID(id, this.clr, this);
            checkedClassName = true;
        }
        Object pc = null;
        if (checkInheritance) {
            String[] subclasses;
            String string = className = checkedClassName ? originalClassName : this.getStoreManager().getClassNameForObjectID(id, this.clr, this);
            if (className == null) {
                throw new NucleusObjectNotFoundException(LOCALISER.msg("010026"), id);
            }
            if (!checkedClassName && (api.isDatastoreIdentity(id) || api.isSingleFieldIdentity(id)) && (subclasses = this.getMetaDataManager().getSubclassesForClass(className, true)) != null) {
                for (int i = 0; i < subclasses.length; ++i) {
                    Object oid = null;
                    if (api.isDatastoreIdentity(id)) {
                        oid = OIDFactory.getInstance(this.nucCtx, subclasses[i], ((OID)id).getKeyValue());
                    } else if (api.isSingleFieldIdentity(id)) {
                        oid = api.getNewSingleFieldIdentity(id.getClass(), this.getClassLoaderResolver().classForName(subclasses[i]), api.getTargetKeyForSingleFieldIdentity(id));
                    }
                    pc = this.getObjectFromCache(oid);
                    if (pc == null) continue;
                    className = subclasses[i];
                    break;
                }
            }
            if (pc == null && originalClassName != null && !originalClassName.equals(className)) {
                if (api.isDatastoreIdentity(id)) {
                    id = OIDFactory.getInstance(this.getNucleusContext(), className, ((OID)id).getKeyValue());
                    pc = this.getObjectFromCache(id);
                } else if (api.isSingleFieldIdentity(id)) {
                    id = api.getNewSingleFieldIdentity(id.getClass(), this.clr.classForName(className), api.getTargetKeyForSingleFieldIdentity(id));
                    pc = this.getObjectFromCache(id);
                }
            }
        } else {
            className = originalClassName;
        }
        return new ClassDetailsForId(id, className, pc);
    }

    @Override
    public Object findObject(Object id, boolean validate, boolean checkInheritance, String objectClassName) {
        if (id == null) {
            throw new NucleusUserException(LOCALISER.msg("010044"));
        }
        IdentityStringTranslator translator = this.getNucleusContext().getIdentityStringTranslator();
        if (translator != null && id instanceof String) {
            id = translator.getIdentity(this, (String)id);
        }
        ApiAdapter api = this.getApiAdapter();
        boolean fromCache = false;
        Object pc = this.getObjectFromCache(id);
        ObjectProvider op = null;
        if (pc != null) {
            fromCache = true;
            if (id instanceof SCOID && api.isPersistent(pc) && !api.isNew(pc) && !api.isDeleted(pc) && !api.isTransactional(pc)) {
                throw new NucleusUserException(LOCALISER.msg("010005"));
            }
            if (api.isTransactional(pc)) {
                return pc;
            }
            op = this.findObjectProvider(pc);
        } else {
            pc = this.getStoreManager().getPersistenceHandler().findObject(this, id);
            if (pc != null) {
                op = this.findObjectProvider(pc);
                this.putObjectIntoLevel1Cache(op);
                this.putObjectIntoLevel2Cache(op, false);
            } else {
                ClassDetailsForId details = this.getClassDetailsForId(id, objectClassName, checkInheritance);
                String className = details.className;
                id = details.id;
                if (details.pc != null) {
                    pc = details.pc;
                    op = this.findObjectProvider(pc);
                    fromCache = true;
                } else {
                    try {
                        Class pcClass = this.clr.classForName(className, id instanceof OID ? null : id.getClass().getClassLoader());
                        if (Modifier.isAbstract(pcClass.getModifiers())) {
                            throw new NucleusObjectNotFoundException(LOCALISER.msg("010027", (Object)IdentityUtils.getIdentityAsString(this.getApiAdapter(), id), (Object)className));
                        }
                        op = this.newObjectProviderForHollow(pcClass, id);
                        pc = op.getObject();
                        if (!checkInheritance && !validate) {
                            op.markForInheritanceValidation();
                        }
                        this.putObjectIntoLevel1Cache(op);
                    }
                    catch (ClassNotResolvedException e) {
                        NucleusLogger.PERSISTENCE.warn(LOCALISER.msg("010027", (Object)IdentityUtils.getIdentityAsString(this.getApiAdapter(), id)));
                        throw new NucleusUserException(LOCALISER.msg("010027", (Object)IdentityUtils.getIdentityAsString(this.getApiAdapter(), id)), e);
                    }
                }
            }
        }
        boolean performValidationWhenCached = this.nucCtx.getPersistenceConfiguration().getBooleanProperty("datanucleus.findObject.validateWhenCached");
        if (validate && (!fromCache || performValidationWhenCached)) {
            if (op != null && !fromCache) {
                this.putObjectIntoLevel1Cache(op);
            }
            try {
                op.validate();
                if (op.getObject() != pc) {
                    fromCache = false;
                    pc = op.getObject();
                    this.putObjectIntoLevel1Cache(op);
                }
            }
            catch (NucleusObjectNotFoundException onfe) {
                this.removeObjectFromLevel1Cache(op.getInternalObjectId());
                throw onfe;
            }
        }
        if (!fromCache) {
            this.putObjectIntoLevel2Cache(op, false);
        }
        return pc;
    }

    @Override
    public Object newObjectId(Class pcClass, Object key) {
        IdentityKeyTranslator translator;
        if (pcClass == null) {
            throw new NucleusUserException(LOCALISER.msg("010028"));
        }
        this.assertClassPersistable(pcClass);
        AbstractClassMetaData cmd = this.getMetaDataManager().getMetaDataForClass(pcClass, this.clr);
        if (cmd == null) {
            throw new NoPersistenceInformationException(pcClass.getName());
        }
        if (!this.getStoreManager().managesClass(cmd.getFullClassName())) {
            this.getStoreManager().addClass(cmd.getFullClassName(), this.clr);
        }
        if ((translator = this.getNucleusContext().getIdentityKeyTranslator()) != null) {
            key = translator.getKey(this, pcClass, key);
        }
        Object id = null;
        if (cmd.usesSingleFieldIdentityClass()) {
            Class idType = this.clr.classForName(cmd.getObjectidClass());
            id = this.getApiAdapter().getNewSingleFieldIdentity(idType, pcClass, key);
        } else if (key instanceof String) {
            if (cmd.getIdentityType() == IdentityType.APPLICATION) {
                if (Modifier.isAbstract(pcClass.getModifiers()) && cmd.getObjectidClass() != null) {
                    try {
                        Constructor c = this.clr.classForName(cmd.getObjectidClass()).getDeclaredConstructor(String.class);
                        id = c.newInstance((String)key);
                    }
                    catch (Exception e) {
                        String msg = LOCALISER.msg("010030", (Object)cmd.getObjectidClass(), (Object)cmd.getFullClassName());
                        NucleusLogger.PERSISTENCE.error(msg);
                        NucleusLogger.PERSISTENCE.error(e);
                        throw new NucleusUserException(msg);
                    }
                } else {
                    this.clr.classForName(pcClass.getName(), true);
                    id = this.getApiAdapter().getNewApplicationIdentityObjectId(pcClass, key);
                }
            } else {
                id = OIDFactory.getInstance(this.getNucleusContext(), (String)key);
            }
        } else {
            throw new NucleusUserException(LOCALISER.msg("010029", (Object)pcClass.getName(), (Object)key.getClass().getName()));
        }
        return id;
    }

    @Override
    public Object newObjectId(String className, Object pc) {
        AbstractClassMetaData cmd = this.getMetaDataManager().getMetaDataForClass(className, this.clr);
        if (cmd.getIdentityType() == IdentityType.DATASTORE) {
            Object nextIdentifier = this.getStoreManager().getStrategyValue(this, cmd, -1);
            return OIDFactory.getInstance(this.getNucleusContext(), cmd.getFullClassName(), nextIdentifier);
        }
        if (cmd.getIdentityType() == IdentityType.APPLICATION) {
            return this.getApiAdapter().getNewApplicationIdentityObjectId(pc, cmd);
        }
        return new SCOID(className);
    }

    @Override
    public void clearDirty(ObjectProvider op) {
        this.dirtyOPs.remove(op);
        this.indirectDirtyOPs.remove(op);
    }

    @Override
    public void clearDirty() {
        this.dirtyOPs.clear();
        this.indirectDirtyOPs.clear();
    }

    @Override
    public void markDirty(ObjectProvider op, boolean directUpdate) {
        if (this.tx.isCommitting() && !this.tx.isActive()) {
            throw new NucleusException("Cannot change objects when transaction is no longer active.");
        }
        boolean isInDirty = this.dirtyOPs.contains(op);
        boolean isInIndirectDirty = this.indirectDirtyOPs.contains(op);
        if (!(this.isDelayDatastoreOperationsEnabled() || isInDirty || isInIndirectDirty || this.dirtyOPs.size() < this.getNucleusContext().getPersistenceConfiguration().getIntProperty("datanucleus.datastoreTransactionFlushLimit"))) {
            this.flushInternal(false);
        }
        if (directUpdate) {
            if (isInIndirectDirty) {
                this.indirectDirtyOPs.remove(op);
                this.dirtyOPs.add(op);
            } else if (!isInDirty) {
                this.dirtyOPs.add(op);
                if (this.l2CacheTxIds != null && this.nucCtx.isClassCacheable(op.getClassMetaData())) {
                    this.l2CacheTxIds.add(op.getInternalObjectId());
                }
            }
        } else if (!isInDirty && !isInIndirectDirty) {
            this.indirectDirtyOPs.add(op);
            if (this.l2CacheTxIds != null && this.nucCtx.isClassCacheable(op.getClassMetaData())) {
                this.l2CacheTxIds.add(op.getInternalObjectId());
            }
        }
    }

    @Override
    public boolean getManageRelations() {
        return this.properties.getBooleanProperty("datanucleus.manageRelationships");
    }

    public boolean getManageRelationsChecks() {
        return this.properties.getBooleanProperty("datanucleus.manageRelationshipsChecks");
    }

    @Override
    public RelationshipManager getRelationshipManager(ObjectProvider op) {
        RelationshipManager relMgr;
        if (!this.getManageRelations()) {
            return null;
        }
        if (this.managedRelationDetails == null) {
            this.managedRelationDetails = new ConcurrentHashMap<ObjectProvider, RelationshipManager>();
        }
        if ((relMgr = this.managedRelationDetails.get(op)) == null) {
            relMgr = new RelationshipManagerImpl(op);
            this.managedRelationDetails.put(op, relMgr);
        }
        return relMgr;
    }

    @Override
    public boolean isManagingRelations() {
        return this.runningManageRelations;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void performManagedRelationships() {
        if (this.getManageRelations() && this.managedRelationDetails != null && !this.managedRelationDetails.isEmpty()) {
            try {
                RelationshipManager relMgr;
                LifeCycleState lc;
                this.runningManageRelations = true;
                if (NucleusLogger.PERSISTENCE.isDebugEnabled()) {
                    NucleusLogger.PERSISTENCE.debug(LOCALISER.msg("013000"));
                }
                if (this.getManageRelationsChecks()) {
                    for (ObjectProvider op : this.managedRelationDetails.keySet()) {
                        lc = op.getLifecycleState();
                        if (lc == null || lc.isDeleted()) continue;
                        relMgr = this.managedRelationDetails.get(op);
                        relMgr.checkConsistency();
                    }
                }
                for (ObjectProvider op : this.managedRelationDetails.keySet()) {
                    lc = op.getLifecycleState();
                    if (lc == null || lc.isDeleted()) continue;
                    relMgr = this.managedRelationDetails.get(op);
                    relMgr.process();
                    relMgr.clearFields();
                }
                this.managedRelationDetails.clear();
                if (NucleusLogger.PERSISTENCE.isDebugEnabled()) {
                    NucleusLogger.PERSISTENCE.debug(LOCALISER.msg("013001"));
                }
            }
            finally {
                this.runningManageRelations = false;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public List<ObjectProvider> getObjectsToBeFlushed() {
        ArrayList<ObjectProvider> ops = new ArrayList<ObjectProvider>();
        try {
            if (this.getMultithreaded()) {
                this.lock.lock();
            }
            ops.addAll(this.dirtyOPs);
            ops.addAll(this.indirectDirtyOPs);
        }
        finally {
            if (this.getMultithreaded()) {
                this.lock.unlock();
            }
        }
        return ops;
    }

    @Override
    public boolean isFlushing() {
        return this.flushing > 0;
    }

    @Override
    public void flush() {
        if (this.tx.isActive()) {
            this.performManagedRelationships();
            this.flushInternal(true);
            if (this.dirtyOPs.size() > 0 || this.indirectDirtyOPs.size() > 0) {
                NucleusLogger.GENERAL.info("Flush pass 1 resulted in " + (this.dirtyOPs.size() + this.indirectDirtyOPs.size()) + " additional objects being made dirty. Performing flush pass 2");
                this.flushInternal(true);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void flushInternal(boolean flushToDatastore) {
        if (!flushToDatastore && this.dirtyOPs.size() == 0 && this.indirectDirtyOPs.size() == 0) {
            return;
        }
        if (!this.tx.isActive()) {
            if (this.nontxProcessedOPs == null) {
                this.nontxProcessedOPs = new HashSet<ObjectProvider>();
            }
            this.nontxProcessedOPs.addAll(this.dirtyOPs);
            this.nontxProcessedOPs.addAll(this.indirectDirtyOPs);
        }
        ++this.flushing;
        try {
            if (flushToDatastore) {
                this.tx.preFlush();
            }
            FlushProcess flusher = this.getStoreManager().getFlushProcess();
            List<NucleusOptimisticException> optimisticFailures = flusher.execute(this, this.dirtyOPs, this.indirectDirtyOPs, this.operationQueue);
            if (flushToDatastore) {
                this.tx.flush();
            }
            if (optimisticFailures != null) {
                throw new NucleusOptimisticException(LOCALISER.msg("010031"), optimisticFailures.toArray(new Throwable[optimisticFailures.size()]));
            }
        }
        finally {
            if (NucleusLogger.PERSISTENCE.isDebugEnabled()) {
                NucleusLogger.PERSISTENCE.debug(LOCALISER.msg("010004"));
            }
            --this.flushing;
        }
    }

    @Override
    public OperationQueue getOperationQueue() {
        return this.operationQueue;
    }

    @Override
    public void addOperationToQueue(Operation oper) {
        if (this.operationQueue == null) {
            this.operationQueue = new OperationQueue();
        }
        this.operationQueue.enqueue(oper);
    }

    @Override
    public void flushOperationsForBackingStore(Store backingStore, ObjectProvider op) {
        if (this.operationQueue != null) {
            this.operationQueue.performAll(backingStore, op);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void postBegin() {
        try {
            int i;
            if (this.getMultithreaded()) {
                this.lock.lock();
            }
            ObjectProvider[] ops = this.dirtyOPs.toArray(new ObjectProvider[this.dirtyOPs.size()]);
            for (i = 0; i < ops.length; ++i) {
                ops[i].preBegin(this.tx);
            }
            ops = this.indirectDirtyOPs.toArray(new ObjectProvider[this.indirectDirtyOPs.size()]);
            for (i = 0; i < ops.length; ++i) {
                ops[i].preBegin(this.tx);
            }
        }
        finally {
            if (this.getMultithreaded()) {
                this.lock.unlock();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void preCommit() {
        try {
            if (this.getMultithreaded()) {
                this.lock.lock();
            }
            this.flush();
            if (this.getReachabilityAtCommit()) {
                try {
                    this.runningPBRAtCommit = true;
                    this.performReachabilityAtCommit();
                }
                catch (Throwable t) {
                    NucleusLogger.PERSISTENCE.error(t);
                    if (t instanceof NucleusException) {
                        throw (NucleusException)t;
                    }
                    throw new NucleusException("Unexpected error during precommit", t);
                }
                finally {
                    this.runningPBRAtCommit = false;
                }
            }
            if (this.l2CacheEnabled) {
                this.performLevel2CacheUpdateAtCommit();
            }
            if (this.getDetachAllOnCommit()) {
                this.performDetachAllOnTxnEndPreparation();
            }
        }
        finally {
            if (this.getMultithreaded()) {
                this.lock.unlock();
            }
        }
    }

    @Override
    public boolean isObjectModifiedInTransaction(Object id) {
        if (this.l2CacheTxIds != null) {
            return this.l2CacheTxIds.contains(id);
        }
        return false;
    }

    @Override
    public void markFieldsForUpdateInLevel2Cache(Object id, boolean[] fields) {
        if (this.l2CacheTxFieldsToUpdateById == null) {
            return;
        }
        BitSet bits = this.l2CacheTxFieldsToUpdateById.get(id);
        if (bits == null) {
            bits = new BitSet();
            this.l2CacheTxFieldsToUpdateById.put(id, bits);
        }
        for (int i = 0; i < fields.length; ++i) {
            if (!fields[i]) continue;
            bits.set(i);
        }
    }

    private void performLevel2CacheUpdateAtCommit() {
        if (this.l2CacheTxIds == null) {
            return;
        }
        String cacheStoreMode = this.getLevel2CacheStoreMode();
        if (cacheStoreMode.equalsIgnoreCase("bypass")) {
            return;
        }
        HashSet<ObjectProvider> opsToCache = null;
        HashSet<Object> idsToRemove = null;
        for (Object id : this.l2CacheTxIds) {
            ObjectProvider op = this.enlistedOPCache.get(id);
            if (op == null) {
                if (NucleusLogger.CACHE.isDebugEnabled() && this.nucCtx.getLevel2Cache().containsOid(id)) {
                    NucleusLogger.CACHE.debug(LOCALISER.msg("004014", id));
                }
                if (idsToRemove == null) {
                    idsToRemove = new HashSet<Object>();
                }
                idsToRemove.add(id);
                continue;
            }
            Object obj = op.getObject();
            Object objID = this.getApiAdapter().getIdForObject(obj);
            if (objID == null) continue;
            if (this.getApiAdapter().isDeleted(obj)) {
                if (NucleusLogger.CACHE.isDebugEnabled()) {
                    NucleusLogger.CACHE.debug(LOCALISER.msg("004007", (Object)StringUtils.toJVMIDString(obj), op.getInternalObjectId()));
                }
                if (idsToRemove == null) {
                    idsToRemove = new HashSet();
                }
                idsToRemove.add(objID);
                continue;
            }
            if (this.getApiAdapter().isDetached(obj)) continue;
            if (opsToCache == null) {
                opsToCache = new HashSet<ObjectProvider>();
            }
            opsToCache.add(op);
        }
        if (idsToRemove != null && !idsToRemove.isEmpty()) {
            this.nucCtx.getLevel2Cache().evictAll(idsToRemove);
        }
        if (opsToCache != null && !opsToCache.isEmpty()) {
            this.putObjectsIntoLevel2Cache((Set<ObjectProvider>)opsToCache);
        }
        this.l2CacheTxIds.clear();
        this.l2CacheTxFieldsToUpdateById.clear();
    }

    private void performReachabilityAtCommit() {
        if (NucleusLogger.PERSISTENCE.isDebugEnabled()) {
            NucleusLogger.PERSISTENCE.debug(LOCALISER.msg("010032"));
        }
        if (this.reachabilityPersistedIds.size() > 0 && this.reachabilityFlushedNewIds.size() > 0) {
            HashSet currentReachables = new HashSet();
            Object[] ids = this.reachabilityPersistedIds.toArray();
            HashSet<Object> objectNotFound = new HashSet<Object>();
            for (int i = 0; i < ids.length; ++i) {
                if (this.reachabilityDeletedIds.contains(ids[i])) continue;
                if (NucleusLogger.PERSISTENCE.isDebugEnabled()) {
                    NucleusLogger.PERSISTENCE.debug("Performing reachability algorithm on object with id \"" + ids[i] + "\"");
                }
                try {
                    ObjectProvider op = this.findObjectProvider(this.findObject(ids[i], true, true, null));
                    op.runReachability(currentReachables);
                    continue;
                }
                catch (NucleusObjectNotFoundException ex) {
                    objectNotFound.add(ids[i]);
                }
            }
            this.reachabilityFlushedNewIds.removeAll(currentReachables);
            Object[] nonReachableIds = this.reachabilityFlushedNewIds.toArray();
            if (nonReachableIds != null && nonReachableIds.length > 0) {
                ObjectProvider op;
                int i;
                for (i = 0; i < nonReachableIds.length; ++i) {
                    if (NucleusLogger.PERSISTENCE.isDebugEnabled()) {
                        NucleusLogger.PERSISTENCE.debug(LOCALISER.msg("010033", nonReachableIds[i]));
                    }
                    try {
                        if (objectNotFound.contains(nonReachableIds[i])) continue;
                        op = this.findObjectProvider(this.findObject(nonReachableIds[i], true, true, null));
                        op.nullifyFields();
                        continue;
                    }
                    catch (NucleusObjectNotFoundException ex) {
                        // empty catch block
                    }
                }
                for (i = 0; i < nonReachableIds.length; ++i) {
                    try {
                        if (objectNotFound.contains(nonReachableIds[i])) continue;
                        op = this.findObjectProvider(this.findObject(nonReachableIds[i], true, true, null));
                        op.deletePersistent();
                        continue;
                    }
                    catch (NucleusObjectNotFoundException ex) {
                        // empty catch block
                    }
                }
            }
            this.flushInternal(true);
        }
        if (NucleusLogger.PERSISTENCE.isDebugEnabled()) {
            NucleusLogger.PERSISTENCE.debug(LOCALISER.msg("010034"));
        }
    }

    private void performDetachAllOnTxnEndPreparation() {
        ArrayList<ObjectProvider> ops = new ArrayList<ObjectProvider>();
        Collection roots = this.fetchPlan.getDetachmentRoots();
        Class[] rootClasses = this.fetchPlan.getDetachmentRootClasses();
        if (roots != null && roots.size() > 0) {
            for (Object obj : roots) {
                ops.add(this.findObjectProvider(obj));
            }
        } else if (rootClasses != null && rootClasses.length > 0) {
            ObjectProvider[] txOPs = this.enlistedOPCache.values().toArray(new ObjectProvider[this.enlistedOPCache.size()]);
            block3: for (int i = 0; i < txOPs.length; ++i) {
                for (int j = 0; j < rootClasses.length; ++j) {
                    if (txOPs[i].getObject().getClass() != rootClasses[j]) continue;
                    ops.add(txOPs[i]);
                    continue block3;
                }
            }
        } else if (this.cache != null) {
            ops.addAll(this.cache.values());
        }
        Iterator opsIter = ops.iterator();
        while (opsIter.hasNext()) {
            ObjectProvider op = (ObjectProvider)opsIter.next();
            Object pc = op.getObject();
            if (pc == null || this.getApiAdapter().isDetached(pc) || this.getApiAdapter().isDeleted(pc)) continue;
            FetchPlanState state = new FetchPlanState();
            try {
                op.loadFieldsInFetchPlan(state);
            }
            catch (NucleusObjectNotFoundException onfe) {
                NucleusLogger.PERSISTENCE.warn(LOCALISER.msg("010013", (Object)StringUtils.toJVMIDString(pc), op.getInternalObjectId()));
                opsIter.remove();
            }
        }
        this.detachAllOnTxnEndOPs = ops.toArray(new ObjectProvider[ops.size()]);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void performDetachAllOnTxnEnd() {
        try {
            this.runningDetachAllOnTxnEnd = true;
            if (this.detachAllOnTxnEndOPs != null) {
                ObjectProvider[] opsToDetach = this.detachAllOnTxnEndOPs;
                DetachState state = new DetachState(this.getApiAdapter());
                for (int i = 0; i < opsToDetach.length; ++i) {
                    Object pc = opsToDetach[i].getObject();
                    if (pc == null) continue;
                    opsToDetach[i].detach(state);
                }
            }
        }
        finally {
            this.detachAllOnTxnEndOPs = null;
            this.runningDetachAllOnTxnEnd = false;
        }
    }

    @Override
    public boolean isRunningDetachAllOnCommit() {
        return this.runningDetachAllOnTxnEnd;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void performDetachOnClose() {
        if (this.cache != null && this.cache.size() > 0) {
            NucleusLogger.PERSISTENCE.debug(LOCALISER.msg("010011"));
            ArrayList<ObjectProvider> toDetach = new ArrayList<ObjectProvider>();
            toDetach.addAll(this.cache.values());
            if (this.tx.getNontransactionalRead()) {
                this.performDetachOnCloseWork(toDetach);
            } else {
                try {
                    this.tx.begin();
                    this.performDetachOnCloseWork(toDetach);
                    this.tx.commit();
                }
                finally {
                    if (this.tx.isActive()) {
                        this.tx.rollback();
                    }
                }
            }
            NucleusLogger.PERSISTENCE.debug(LOCALISER.msg("010012"));
        }
    }

    private void performDetachOnCloseWork(List<ObjectProvider> smsToDetach) {
        for (ObjectProvider op : smsToDetach) {
            if (op == null || op.getObject() == null || op.getExecutionContext().getApiAdapter().isDeleted(op.getObject()) || op.getExternalObjectId() == null) continue;
            try {
                op.detach(new DetachState(this.getApiAdapter()));
            }
            catch (NucleusObjectNotFoundException onfe) {}
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void postCommit() {
        try {
            if (this.getMultithreaded()) {
                this.lock.lock();
            }
            if (this.getDetachAllOnCommit()) {
                this.performDetachAllOnTxnEnd();
            }
            ArrayList<RuntimeException> failures = null;
            try {
                ApiAdapter api = this.getApiAdapter();
                ObjectProvider[] ops = this.enlistedOPCache.values().toArray(new ObjectProvider[this.enlistedOPCache.size()]);
                for (int i = 0; i < ops.length; ++i) {
                    try {
                        if (ops[i] == null || ops[i].getObject() == null || !api.isPersistent(ops[i].getObject()) && !api.isTransactional(ops[i].getObject())) continue;
                        ops[i].postCommit(this.getTransaction());
                        if (!this.getDetachAllOnCommit() || !api.isDetachable(ops[i].getObject())) continue;
                        this.removeObjectProvider(ops[i]);
                        continue;
                    }
                    catch (RuntimeException e) {
                        if (failures == null) {
                            failures = new ArrayList<RuntimeException>();
                        }
                        failures.add(e);
                    }
                }
            }
            finally {
                this.resetTransactionalVariables();
            }
            if (failures != null && !failures.isEmpty()) {
                throw new CommitStateTransitionException(failures.toArray(new Exception[failures.size()]));
            }
        }
        finally {
            if (this.getMultithreaded()) {
                this.lock.unlock();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void preRollback() {
        try {
            if (this.getMultithreaded()) {
                this.lock.lock();
            }
            ArrayList<RuntimeException> failures = null;
            try {
                Collection<ObjectProvider> ops = this.enlistedOPCache.values();
                for (ObjectProvider op : ops) {
                    try {
                        op.preRollback(this.getTransaction());
                    }
                    catch (RuntimeException e) {
                        if (failures == null) {
                            failures = new ArrayList<RuntimeException>();
                        }
                        failures.add(e);
                    }
                }
                this.clearDirty();
            }
            finally {
                this.resetTransactionalVariables();
            }
            if (failures != null && !failures.isEmpty()) {
                throw new RollbackStateTransitionException(failures.toArray(new Exception[failures.size()]));
            }
            if (this.getDetachAllOnRollback()) {
                this.performDetachAllOnTxnEndPreparation();
            }
        }
        finally {
            if (this.getMultithreaded()) {
                this.lock.unlock();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void postRollback() {
        try {
            if (this.getMultithreaded()) {
                this.lock.lock();
            }
            if (this.getDetachAllOnRollback()) {
                this.performDetachAllOnTxnEnd();
            }
        }
        finally {
            if (this.getMultithreaded()) {
                this.lock.unlock();
            }
        }
    }

    private void resetTransactionalVariables() {
        if (this.getReachabilityAtCommit()) {
            this.reachabilityEnlistedIds.clear();
            this.reachabilityPersistedIds.clear();
            this.reachabilityDeletedIds.clear();
            this.reachabilityFlushedNewIds.clear();
        }
        this.enlistedOPCache.clear();
        this.dirtyOPs.clear();
        this.indirectDirtyOPs.clear();
        this.fetchPlan.resetDetachmentRoots();
        if (this.getManageRelations() && this.managedRelationDetails != null) {
            this.managedRelationDetails.clear();
        }
        if (this.l2CacheTxIds != null) {
            this.l2CacheTxIds.clear();
        }
        if (this.l2CacheTxFieldsToUpdateById != null) {
            this.l2CacheTxFieldsToUpdateById.clear();
        }
        if (this.operationQueue != null) {
            if (!this.operationQueue.getOperations().isEmpty()) {
                NucleusLogger.PERSISTENCE.warn("Queue of operations for flushing is not empty! Ignoring unprocessed operations. Generate a testcase and report this. See the log for full details of unflushed ops");
                this.operationQueue.log();
            }
            this.operationQueue.clear();
        }
        this.opAttachDetachObjectReferenceMap = null;
    }

    protected String getLevel2CacheRetrieveMode() {
        String setting = (String)this.getProperty("datanucleus.cache.level2.retrieveMode");
        if (setting == null) {
            setting = this.nucCtx.getPersistenceConfiguration().getStringProperty("datanucleus.cache.level2.retrieveMode");
        }
        return setting;
    }

    protected String getLevel2CacheStoreMode() {
        String setting = (String)this.getProperty("datanucleus.cache.level2.storeMode");
        if (setting == null) {
            setting = this.nucCtx.getPersistenceConfiguration().getStringProperty("datanucleus.cache.level2.storeMode");
        }
        return setting;
    }

    @Override
    public void putObjectIntoLevel1Cache(ObjectProvider op) {
        if (this.cache != null) {
            Object id = op.getInternalObjectId();
            if (id == null || op.getObject() == null) {
                NucleusLogger.CACHE.warn(LOCALISER.msg("003006"));
                return;
            }
            ObjectProvider oldOP = this.cache.put(id, op);
            if (NucleusLogger.CACHE.isDebugEnabled() && oldOP == null) {
                NucleusLogger.CACHE.debug(LOCALISER.msg("003004", (Object)StringUtils.toJVMIDString(op.getObject()), (Object)IdentityUtils.getIdentityAsString(this.getApiAdapter(), id), (Object)StringUtils.booleanArrayToString(op.getLoadedFields())));
            }
        }
    }

    protected void putObjectIntoLevel2Cache(ObjectProvider op, boolean updateIfPresent) {
        if (op.getInternalObjectId() == null || !this.nucCtx.isClassCacheable(op.getClassMetaData())) {
            return;
        }
        String storeMode = this.getLevel2CacheStoreMode();
        if (storeMode.equalsIgnoreCase("bypass")) {
            return;
        }
        if (this.l2CacheTxIds != null && !this.l2CacheTxIds.contains(op.getInternalObjectId())) {
            this.putObjectIntoLevel2CacheInternal(op, updateIfPresent);
        }
    }

    protected CachedPC getL2CacheableObject(ObjectProvider op, CachedPC currentCachedPC) {
        CachedPC cachedPC = null;
        int[] fieldsToUpdate = null;
        if (currentCachedPC != null) {
            cachedPC = currentCachedPC.getCopy();
            cachedPC.setVersion(op.getTransactionalVersion());
            BitSet fieldsToUpdateBitSet = this.l2CacheTxFieldsToUpdateById.get(op.getInternalObjectId());
            if (fieldsToUpdateBitSet != null) {
                int num = 0;
                for (int i = 0; i < fieldsToUpdateBitSet.length(); ++i) {
                    if (!fieldsToUpdateBitSet.get(i)) continue;
                    ++num;
                }
                fieldsToUpdate = new int[num];
                int j = 0;
                for (int i = 0; i < fieldsToUpdateBitSet.length(); ++i) {
                    if (!fieldsToUpdateBitSet.get(i)) continue;
                    fieldsToUpdate[j++] = i;
                }
            }
            if (fieldsToUpdate == null || fieldsToUpdate.length == 0) {
                return null;
            }
            if (NucleusLogger.CACHE.isDebugEnabled()) {
                int[] loadedFieldNums = cachedPC.getLoadedFieldNumbers();
                String fieldNames = loadedFieldNums == null || loadedFieldNums.length == 0 ? "" : StringUtils.intArrayToString(loadedFieldNums);
                NucleusLogger.CACHE.debug(LOCALISER.msg("004015", (Object)StringUtils.toJVMIDString(op.getObject()), op.getInternalObjectId(), (Object)fieldNames, cachedPC.getVersion(), (Object)StringUtils.intArrayToString(fieldsToUpdate)));
            }
        } else {
            int[] loadedFieldNumbers = op.getLoadedFieldNumbers();
            if (loadedFieldNumbers == null || loadedFieldNumbers.length == 0) {
                return null;
            }
            cachedPC = new CachedPC(op.getObject().getClass(), op.getLoadedFields(), op.getTransactionalVersion());
            fieldsToUpdate = loadedFieldNumbers;
            if (NucleusLogger.CACHE.isDebugEnabled()) {
                int[] loadedFieldNums = cachedPC.getLoadedFieldNumbers();
                String fieldNames = loadedFieldNums == null || loadedFieldNums.length == 0 ? "" : StringUtils.intArrayToString(loadedFieldNums);
                NucleusLogger.CACHE.debug(LOCALISER.msg("004003", (Object)StringUtils.toJVMIDString(op.getObject()), op.getInternalObjectId(), (Object)fieldNames, cachedPC.getVersion()));
            }
        }
        op.provideFields(fieldsToUpdate, new L2CachePopulateFieldManager(op, cachedPC));
        return cachedPC;
    }

    protected void putObjectsIntoLevel2Cache(Set<ObjectProvider> ops) {
        int batchSize = this.nucCtx.getPersistenceConfiguration().getIntProperty("datanucleus.cache.level2.batchSize");
        Level2Cache l2Cache = this.nucCtx.getLevel2Cache();
        HashMap<Object, CachedPC> dataToUpdate = new HashMap<Object, CachedPC>();
        for (ObjectProvider op : ops) {
            Object id;
            CachedPC currentCachedPC;
            CachedPC cachedPC = this.getL2CacheableObject(op, currentCachedPC = l2Cache.get(id = op.getInternalObjectId()));
            if (cachedPC == null || id == null || id instanceof IdentityReference) continue;
            dataToUpdate.put(id, cachedPC);
            if (dataToUpdate.size() != batchSize) continue;
            l2Cache.putAll(dataToUpdate);
            dataToUpdate.clear();
        }
        if (!dataToUpdate.isEmpty()) {
            l2Cache.putAll(dataToUpdate);
            dataToUpdate.clear();
        }
    }

    protected void putObjectIntoLevel2CacheInternal(ObjectProvider op, boolean updateIfPresent) {
        Object id = op.getInternalObjectId();
        if (id == null || id instanceof IdentityReference) {
            return;
        }
        Level2Cache l2Cache = this.nucCtx.getLevel2Cache();
        if (!updateIfPresent && l2Cache.containsOid(id)) {
            return;
        }
        CachedPC currentCachedPC = l2Cache.get(id);
        CachedPC cachedPC = this.getL2CacheableObject(op, currentCachedPC);
        if (cachedPC != null) {
            l2Cache.put(id, cachedPC);
        }
    }

    @Override
    public void removeObjectFromLevel1Cache(Object id) {
        if (id != null && this.cache != null) {
            Object pcRemoved;
            if (NucleusLogger.CACHE.isDebugEnabled()) {
                NucleusLogger.CACHE.debug(LOCALISER.msg("003009", (Object)IdentityUtils.getIdentityAsString(this.getApiAdapter(), id), (Object)String.valueOf(this.cache.size())));
            }
            if ((pcRemoved = this.cache.remove(id)) == null && NucleusLogger.CACHE.isDebugEnabled()) {
                NucleusLogger.CACHE.debug(LOCALISER.msg("003010", (Object)IdentityUtils.getIdentityAsString(this.getApiAdapter(), id)));
            }
        }
    }

    @Override
    public void removeObjectFromLevel2Cache(Object id) {
        Level2Cache l2Cache;
        if (id != null && (l2Cache = this.nucCtx.getLevel2Cache()).containsOid(id)) {
            if (NucleusLogger.CACHE.isDebugEnabled()) {
                NucleusLogger.CACHE.debug(LOCALISER.msg("004016", id));
            }
            l2Cache.evict(id);
        }
    }

    @Override
    public boolean hasIdentityInCache(Object id) {
        Level2Cache l2Cache;
        if (this.cache != null && this.cache.containsKey(id)) {
            return true;
        }
        return this.l2CacheEnabled && (l2Cache = this.nucCtx.getLevel2Cache()).containsOid(id);
    }

    @Override
    public Object getObjectFromCache(Object id) {
        Object pc = this.getObjectFromLevel1Cache(id);
        if (pc != null) {
            return pc;
        }
        return this.getObjectFromLevel2Cache(id);
    }

    @Override
    public Object[] getObjectsFromCache(Object[] ids) {
        if (ids == null || ids.length == 0) {
            return null;
        }
        Object[] objs = new Object[ids.length];
        HashSet<Object> idsNotFound = new HashSet<Object>();
        for (int i = 0; i < ids.length; ++i) {
            objs[i] = this.getObjectFromLevel1Cache(ids[i]);
            if (objs[i] != null) continue;
            idsNotFound.add(ids[i]);
        }
        if (idsNotFound.size() > 0) {
            Map l2ObjsById = this.getObjectsFromLevel2Cache(idsNotFound);
            for (int i = 0; i < ids.length; ++i) {
                if (objs[i] != null) continue;
                objs[i] = l2ObjsById.get(ids[i]);
            }
        }
        return objs;
    }

    public Object getObjectFromLevel1Cache(Object id) {
        Object pc = null;
        ObjectProvider op = null;
        if (this.cache != null) {
            op = (ObjectProvider)this.cache.get(id);
            if (op != null) {
                pc = op.getObject();
                if (NucleusLogger.CACHE.isDebugEnabled()) {
                    NucleusLogger.CACHE.debug(LOCALISER.msg("003008", (Object)StringUtils.toJVMIDString(pc), (Object)IdentityUtils.getIdentityAsString(this.getApiAdapter(), id), (Object)StringUtils.booleanArrayToString(op.getLoadedFields()), (Object)("" + this.cache.size())));
                }
                op.resetDetachState();
                return pc;
            }
            if (NucleusLogger.CACHE.isDebugEnabled()) {
                NucleusLogger.CACHE.debug(LOCALISER.msg("003007", (Object)IdentityUtils.getIdentityAsString(this.getApiAdapter(), id), (Object)("" + this.cache.size())));
            }
        }
        return null;
    }

    protected Object getObjectFromLevel2Cache(Object id) {
        Object pc = null;
        if (this.l2CacheEnabled) {
            if (!this.nucCtx.isClassWithIdentityCacheable(id)) {
                return null;
            }
            String cacheRetrieveMode = this.getLevel2CacheRetrieveMode();
            if (cacheRetrieveMode.equalsIgnoreCase("bypass")) {
                return null;
            }
            Level2Cache l2Cache = this.nucCtx.getLevel2Cache();
            CachedPC cachedPC = l2Cache.get(id);
            if (cachedPC != null) {
                ObjectProvider op = this.newObjectProviderForCachedPC(id, cachedPC);
                pc = op.getObject();
                if (NucleusLogger.CACHE.isDebugEnabled()) {
                    NucleusLogger.CACHE.debug(LOCALISER.msg("004006", (Object)IdentityUtils.getIdentityAsString(this.getApiAdapter(), id), (Object)StringUtils.intArrayToString(cachedPC.getLoadedFieldNumbers()), cachedPC.getVersion(), (Object)StringUtils.toJVMIDString(pc)));
                }
                if (this.tx.isActive() && this.tx.getOptimistic()) {
                    op.makeNontransactional();
                } else if (!this.tx.isActive() && this.getApiAdapter().isTransactional(pc)) {
                    op.makeNontransactional();
                }
                return pc;
            }
            if (NucleusLogger.CACHE.isDebugEnabled()) {
                NucleusLogger.CACHE.debug(LOCALISER.msg("004005", (Object)IdentityUtils.getIdentityAsString(this.getApiAdapter(), id)));
            }
        }
        return null;
    }

    protected Map getObjectsFromLevel2Cache(Collection ids) {
        if (this.l2CacheEnabled) {
            Level2Cache l2Cache = this.nucCtx.getLevel2Cache();
            Map<Object, CachedPC> cachedPCs = l2Cache.getAll(ids);
            HashMap<Object, Object> pcsById = new HashMap<Object, Object>(cachedPCs.size());
            for (Map.Entry<Object, CachedPC> entry : cachedPCs.entrySet()) {
                Object id = entry.getKey();
                CachedPC cachedPC = entry.getValue();
                if (cachedPC != null) {
                    ObjectProvider op = this.newObjectProviderForCachedPC(id, cachedPC);
                    Object pc = op.getObject();
                    if (NucleusLogger.CACHE.isDebugEnabled()) {
                        NucleusLogger.CACHE.debug(LOCALISER.msg("004006", (Object)IdentityUtils.getIdentityAsString(this.getApiAdapter(), id), (Object)StringUtils.intArrayToString(cachedPC.getLoadedFieldNumbers()), cachedPC.getVersion(), (Object)StringUtils.toJVMIDString(pc)));
                    }
                    if (this.tx.isActive() && this.tx.getOptimistic()) {
                        op.makeNontransactional();
                    } else if (!this.tx.isActive() && this.getApiAdapter().isTransactional(pc)) {
                        op.makeNontransactional();
                    }
                    pcsById.put(id, pc);
                    continue;
                }
                if (!NucleusLogger.CACHE.isDebugEnabled()) continue;
                NucleusLogger.CACHE.debug(LOCALISER.msg("004005", (Object)IdentityUtils.getIdentityAsString(this.getApiAdapter(), id)));
            }
            return pcsById;
        }
        return null;
    }

    @Override
    public void replaceObjectId(Object pc, Object oldID, Object newID) {
        if (pc == null || this.getApiAdapter().getIdForObject(pc) == null) {
            NucleusLogger.CACHE.warn(LOCALISER.msg("003006"));
            return;
        }
        ObjectProvider op = this.findObjectProvider(pc);
        if (this.cache != null) {
            Object o = this.cache.get(oldID);
            if (o != null) {
                if (NucleusLogger.CACHE.isDebugEnabled()) {
                    NucleusLogger.CACHE.debug(LOCALISER.msg("003012", (Object)StringUtils.toJVMIDString(pc), (Object)IdentityUtils.getIdentityAsString(this.getApiAdapter(), oldID), (Object)IdentityUtils.getIdentityAsString(this.getApiAdapter(), newID)));
                }
                this.cache.remove(oldID);
            }
            if (op != null) {
                this.putObjectIntoLevel1Cache(op);
            }
        }
        if (this.enlistedOPCache.get(oldID) != null && op != null) {
            this.enlistedOPCache.remove(oldID);
            this.enlistedOPCache.put(newID, op);
            if (NucleusLogger.TRANSACTION.isDebugEnabled()) {
                NucleusLogger.TRANSACTION.debug(LOCALISER.msg("015018", (Object)StringUtils.toJVMIDString(pc), (Object)IdentityUtils.getIdentityAsString(this.getApiAdapter(), oldID), (Object)IdentityUtils.getIdentityAsString(this.getApiAdapter(), newID)));
            }
        }
        if (this.l2CacheTxIds != null && this.l2CacheTxIds.contains(oldID)) {
            this.l2CacheTxIds.remove(oldID);
            this.l2CacheTxIds.add(newID);
        }
        if (this.getReachabilityAtCommit() && this.tx.isActive()) {
            if (this.reachabilityEnlistedIds.remove(oldID)) {
                this.reachabilityEnlistedIds.add(newID);
            }
            if (this.reachabilityFlushedNewIds.remove(oldID)) {
                this.reachabilityFlushedNewIds.add(newID);
            }
            if (this.reachabilityPersistedIds.remove(oldID)) {
                this.reachabilityPersistedIds.add(newID);
            }
            if (this.reachabilityDeletedIds.remove(oldID)) {
                this.reachabilityDeletedIds.add(newID);
            }
        }
    }

    @Override
    public boolean getSerializeReadForClass(String className) {
        AbstractClassMetaData cmd;
        if (this.tx.isActive() && this.tx.getSerializeRead() != null) {
            return this.tx.getSerializeRead();
        }
        if (this.getProperty("datanucleus.SerializeRead") != null) {
            return this.properties.getBooleanProperty("datanucleus.SerializeRead");
        }
        if (className != null && (cmd = this.getMetaDataManager().getMetaDataForClass(className, this.clr)) != null) {
            return cmd.isSerializeRead();
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Extent getExtent(Class pcClass, boolean subclasses) {
        try {
            this.clr.setPrimary(pcClass.getClassLoader());
            this.assertClassPersistable(pcClass);
            Extent extent = this.getStoreManager().getExtent(this, pcClass, subclasses);
            return extent;
        }
        finally {
            this.clr.unsetPrimary();
        }
    }

    @Override
    public Query newQuery() {
        Query q = this.getStoreManager().getQueryManager().newQuery("JDOQL", this, null);
        if (this.ecListeners == null) {
            this.ecListeners = new HashSet<ExecutionContextListener>();
        }
        this.ecListeners.add(q);
        return q;
    }

    public void removeAllInstanceLifecycleListeners() {
        if (this.callbacks != null) {
            this.callbacks.close();
        }
    }

    @Override
    public CallbackHandler getCallbackHandler() {
        if (this.callbacks != null) {
            return this.callbacks;
        }
        if (!this.getNucleusContext().getPersistenceConfiguration().getBooleanProperty("datanucleus.allowCallbacks")) {
            this.callbacks = new NullCallbackHandler();
            return this.callbacks;
        }
        String callbackHandlerClassName = this.getNucleusContext().getPluginManager().getAttributeValueForExtension("org.datanucleus.callbackhandler", "name", this.getNucleusContext().getApiName(), "class-name");
        if (callbackHandlerClassName != null) {
            try {
                this.callbacks = (CallbackHandler)this.getNucleusContext().getPluginManager().createExecutableExtension("org.datanucleus.callbackhandler", "name", this.getNucleusContext().getApiName(), "class-name", new Class[]{ClassConstants.NUCLEUS_CONTEXT}, new Object[]{this.getNucleusContext()});
                return this.callbacks;
            }
            catch (Exception e) {
                NucleusLogger.PERSISTENCE.error(LOCALISER.msg("025000", (Object)callbackHandlerClassName, (Object)e));
            }
        }
        return null;
    }

    @Override
    public void addListener(Object listener, Class[] classes) {
        if (listener == null) {
            return;
        }
        this.getCallbackHandler().addListener(listener, classes);
    }

    @Override
    public void removeListener(Object listener) {
        if (listener != null) {
            this.getCallbackHandler().removeListener(listener);
        }
    }

    @Override
    public void disconnectLifecycleListener() {
        if (this.callbacks != null) {
            this.callbacks.close();
        }
    }

    protected void assertIsOpen() {
        if (this.isClosed()) {
            throw new NucleusUserException(LOCALISER.msg("010002")).setFatal();
        }
    }

    @Override
    public void assertClassPersistable(Class cls) {
        if (cls != null && !this.getNucleusContext().getApiAdapter().isPersistable(cls) && !cls.isInterface()) {
            throw new ClassNotPersistableException(cls.getName());
        }
        if (!this.hasPersistenceInformationForClass(cls)) {
            throw new NoPersistenceInformationException(cls.getName());
        }
    }

    protected void assertDetachable(Object object) {
        if (object != null && !this.getApiAdapter().isDetachable(object)) {
            throw new ClassNotDetachableException(object.getClass().getName());
        }
    }

    protected void assertNotDetached(Object object) {
        if (object != null && this.getApiAdapter().isDetached(object)) {
            throw new ObjectDetachedException(object.getClass().getName());
        }
    }

    protected void assertActiveTransaction() {
        if (!this.tx.isActive()) {
            throw new TransactionNotActiveException();
        }
    }

    protected void assertHasImplementationCreator() {
        if (this.getNucleusContext().getImplementationCreator() == null) {
            throw new NucleusUserException(LOCALISER.msg("010035"));
        }
    }

    @Override
    public boolean hasPersistenceInformationForClass(Class cls) {
        if (cls == null) {
            return false;
        }
        if (this.getMetaDataManager().getMetaDataForClass(cls, this.clr) != null) {
            return true;
        }
        if (cls.isInterface()) {
            try {
                this.newInstance(cls);
            }
            catch (RuntimeException ex) {
                NucleusLogger.PERSISTENCE.warn(ex);
            }
            return this.getMetaDataManager().getMetaDataForClass(cls, this.clr) != null;
        }
        return false;
    }

    protected FetchGroupManager getFetchGroupManager() {
        if (this.fetchGrpMgr == null) {
            this.fetchGrpMgr = new FetchGroupManager(this.getNucleusContext());
        }
        return this.fetchGrpMgr;
    }

    @Override
    public void addInternalFetchGroup(FetchGroup grp) {
        this.getFetchGroupManager().addFetchGroup(grp);
    }

    protected void removeInternalFetchGroup(FetchGroup grp) {
        if (this.fetchGrpMgr == null) {
            return;
        }
        this.getFetchGroupManager().removeFetchGroup(grp);
    }

    @Override
    public FetchGroup getInternalFetchGroup(Class cls, String name) {
        if (!cls.isInterface() && !this.getNucleusContext().getApiAdapter().isPersistable(cls)) {
            throw new NucleusUserException("Cannot create FetchGroup for " + cls + " since it is not persistable");
        }
        if (cls.isInterface() && !this.getNucleusContext().getMetaDataManager().isPersistentInterface(cls.getName())) {
            throw new NucleusUserException("Cannot create FetchGroup for " + cls + " since it is not persistable");
        }
        if (this.fetchGrpMgr == null) {
            return null;
        }
        return this.getFetchGroupManager().getFetchGroup(cls, name);
    }

    @Override
    public Set getFetchGroupsWithName(String name) {
        if (this.fetchGrpMgr == null) {
            return null;
        }
        return this.getFetchGroupManager().getFetchGroupsWithName(name);
    }

    @Override
    public Lock getLock() {
        return this.lock;
    }

    @Override
    public ExecutionContext.EmbeddedOwnerRelation registerEmbeddedRelation(ObjectProvider ownerOP, int ownerFieldNum, ObjectProvider embOP) {
        List<ExecutionContext.EmbeddedOwnerRelation> relations;
        ExecutionContext.EmbeddedOwnerRelation relation = new ExecutionContext.EmbeddedOwnerRelation(ownerOP, ownerFieldNum, embOP);
        if (this.opEmbeddedInfoByEmbedded == null) {
            this.opEmbeddedInfoByEmbedded = new HashMap<ObjectProvider, List<ExecutionContext.EmbeddedOwnerRelation>>();
        }
        if ((relations = this.opEmbeddedInfoByEmbedded.get(embOP)) == null) {
            relations = new ArrayList<ExecutionContext.EmbeddedOwnerRelation>();
        }
        relations.add(relation);
        this.opEmbeddedInfoByEmbedded.put(embOP, relations);
        if (this.opEmbeddedInfoByOwner == null) {
            this.opEmbeddedInfoByOwner = new HashMap<ObjectProvider, List<ExecutionContext.EmbeddedOwnerRelation>>();
        }
        if ((relations = this.opEmbeddedInfoByOwner.get(ownerOP)) == null) {
            relations = new ArrayList<ExecutionContext.EmbeddedOwnerRelation>();
        }
        relations.add(relation);
        this.opEmbeddedInfoByOwner.put(ownerOP, relations);
        return relation;
    }

    @Override
    public void deregisterEmbeddedRelation(ExecutionContext.EmbeddedOwnerRelation rel) {
        if (this.opEmbeddedInfoByEmbedded != null) {
            List<ExecutionContext.EmbeddedOwnerRelation> ownerRels = this.opEmbeddedInfoByEmbedded.get(rel.getEmbeddedOP());
            ownerRels.remove(rel);
            if (ownerRels.size() == 0) {
                this.opEmbeddedInfoByEmbedded.remove(rel.getEmbeddedOP());
                if (this.opEmbeddedInfoByEmbedded.size() == 0) {
                    this.opEmbeddedInfoByEmbedded = null;
                }
            }
        }
        if (this.opEmbeddedInfoByOwner != null) {
            List<ExecutionContext.EmbeddedOwnerRelation> embRels = this.opEmbeddedInfoByOwner.get(rel.getOwnerOP());
            embRels.remove(rel);
            if (embRels.size() == 0) {
                this.opEmbeddedInfoByOwner.remove(rel.getOwnerOP());
                if (this.opEmbeddedInfoByOwner.size() == 0) {
                    this.opEmbeddedInfoByOwner = null;
                }
            }
        }
    }

    @Override
    public void removeEmbeddedOwnerRelation(ObjectProvider ownerOP, int ownerFieldNum, ObjectProvider embOP) {
        if (this.opEmbeddedInfoByOwner != null) {
            List<ExecutionContext.EmbeddedOwnerRelation> ownerRels = this.opEmbeddedInfoByOwner.get(ownerOP);
            ExecutionContext.EmbeddedOwnerRelation rel = null;
            for (ExecutionContext.EmbeddedOwnerRelation ownerRel : ownerRels) {
                if (ownerRel.getEmbeddedOP() != embOP || ownerRel.getOwnerFieldNum() != ownerFieldNum) continue;
                rel = ownerRel;
                break;
            }
            if (rel != null) {
                this.deregisterEmbeddedRelation(rel);
            }
        }
    }

    @Override
    public List<ExecutionContext.EmbeddedOwnerRelation> getOwnerInformationForEmbedded(ObjectProvider embOP) {
        if (this.opEmbeddedInfoByEmbedded == null) {
            return null;
        }
        return this.opEmbeddedInfoByEmbedded.get(embOP);
    }

    @Override
    public List<ExecutionContext.EmbeddedOwnerRelation> getEmbeddedInformationForOwner(ObjectProvider ownerOP) {
        if (this.opEmbeddedInfoByOwner == null) {
            return null;
        }
        return this.opEmbeddedInfoByOwner.get(ownerOP);
    }

    @Override
    public void setObjectProviderAssociatedValue(ObjectProvider op, Object key, Object value) {
        Map<?, ?> opMap = null;
        if (this.opAssociatedValuesMapByOP == null) {
            this.opAssociatedValuesMapByOP = new HashMap();
            opMap = new HashMap();
            this.opAssociatedValuesMapByOP.put(op, opMap);
        } else {
            opMap = this.opAssociatedValuesMapByOP.get(op);
            if (opMap == null) {
                opMap = new HashMap();
                this.opAssociatedValuesMapByOP.put(op, opMap);
            }
        }
        opMap.put(key, value);
    }

    @Override
    public Object getObjectProviderAssociatedValue(ObjectProvider op, Object key) {
        if (this.opAssociatedValuesMapByOP == null) {
            return null;
        }
        Map<?, ?> opMap = this.opAssociatedValuesMapByOP.get(op);
        return opMap == null ? null : opMap.get(key);
    }

    @Override
    public void removeObjectProviderAssociatedValue(ObjectProvider op, Object key) {
        Map<?, ?> opMap;
        if (this.opAssociatedValuesMapByOP != null && (opMap = this.opAssociatedValuesMapByOP.get(op)) != null) {
            opMap.remove(key);
        }
    }

    @Override
    public boolean containsObjectProviderAssociatedValue(ObjectProvider op, Object key) {
        if (this.opAssociatedValuesMapByOP != null && this.opAssociatedValuesMapByOP.containsKey(op)) {
            return this.opAssociatedValuesMapByOP.get(op).containsKey(key);
        }
        return false;
    }

    private static class ClassDetailsForId {
        Object id;
        String className;
        Object pc;

        public ClassDetailsForId(Object id, String className, Object pc) {
            this.id = id;
            this.className = className;
            this.pc = pc;
        }
    }

    static class ThreadContextInfo {
        int referenceCounter = 0;
        Map<Object, ObjectProvider> attachedOwnerByObject = null;
        Map attachedPCById = null;
        boolean merging = false;
        boolean nontxPersistDelete = false;

        ThreadContextInfo() {
        }
    }
}

