/*
 * Decompiled with CFR 0.152.
 */
package org.datanucleus.store.types.backed;

import java.io.ObjectStreamException;
import java.util.Collection;
import java.util.Comparator;
import java.util.HashSet;
import java.util.Iterator;
import org.datanucleus.ClassLoaderResolver;
import org.datanucleus.ExecutionContext;
import org.datanucleus.exceptions.NucleusDataStoreException;
import org.datanucleus.exceptions.NucleusException;
import org.datanucleus.flush.CollectionAddOperation;
import org.datanucleus.flush.CollectionClearOperation;
import org.datanucleus.flush.CollectionRemoveOperation;
import org.datanucleus.flush.ListRemoveAtOperation;
import org.datanucleus.metadata.AbstractMemberMetaData;
import org.datanucleus.metadata.FieldPersistenceModifier;
import org.datanucleus.state.ObjectProvider;
import org.datanucleus.store.BackedSCOStoreManager;
import org.datanucleus.store.scostore.ListStore;
import org.datanucleus.store.scostore.Store;
import org.datanucleus.store.types.SCOCollectionIterator;
import org.datanucleus.store.types.SCOUtils;
import org.datanucleus.store.types.backed.BackedSCO;
import org.datanucleus.util.ClassUtils;
import org.datanucleus.util.NucleusLogger;

public class PriorityQueue
extends org.datanucleus.store.types.simple.PriorityQueue
implements BackedSCO {
    protected transient ListStore backingStore;
    protected transient boolean allowNulls = false;
    protected transient boolean useCache = true;
    protected transient boolean isCacheLoaded = false;
    protected transient boolean queued = false;

    public PriorityQueue(ObjectProvider op, AbstractMemberMetaData mmd) {
        super(op, mmd);
        ExecutionContext ec = op.getExecutionContext();
        this.allowNulls = SCOUtils.allowNullsInContainer(this.allowNulls, mmd);
        this.queued = ec.isDelayDatastoreOperationsEnabled();
        this.useCache = SCOUtils.useContainerCache(op, mmd);
        if (!SCOUtils.collectionHasSerialisedElements(mmd) && mmd.getPersistenceModifier() == FieldPersistenceModifier.PERSISTENT) {
            ClassLoaderResolver clr = ec.getClassLoaderResolver();
            this.backingStore = (ListStore)((BackedSCOStoreManager)((Object)ec.getStoreManager())).getBackingStoreForField(clr, mmd, java.util.PriorityQueue.class);
        }
        Comparator comparator = null;
        String comparatorName = null;
        if (mmd.getCollection().hasExtension("comparatorName")) {
            comparatorName = mmd.getCollection().getValueForExtension("comparatorName");
            Class comparatorCls = null;
            try {
                comparatorCls = op.getExecutionContext().getClassLoaderResolver().classForName(comparatorName);
                comparator = (Comparator)ClassUtils.newInstance(comparatorCls, null, null);
            }
            catch (NucleusException jpe) {
                NucleusLogger.PERSISTENCE.warn(LOCALISER.msg("023012", (Object)mmd.getFullFieldName(), (Object)comparatorName));
            }
        }
        this.delegate = comparator != null ? new java.util.PriorityQueue(5, comparator) : new java.util.PriorityQueue();
        if (NucleusLogger.PERSISTENCE.isDebugEnabled()) {
            NucleusLogger.PERSISTENCE.debug(SCOUtils.getContainerInfoMessage(op, this.ownerMmd.getName(), this, this.useCache, this.queued, this.allowNulls, SCOUtils.useCachedLazyLoading(op, this.ownerMmd)));
        }
    }

    public void initialise(Object o, boolean forInsert, boolean forUpdate) {
        Collection c = (Collection)o;
        if (c != null) {
            if (SCOUtils.collectionHasSerialisedElements(this.ownerMmd) && this.ownerMmd.getCollection().elementIsPersistent()) {
                ExecutionContext ec = this.ownerOP.getExecutionContext();
                for (Object pc : c) {
                    ObjectProvider objSM = ec.findObjectProvider(pc);
                    if (objSM != null) continue;
                    objSM = ec.newObjectProviderForEmbedded(pc, false, this.ownerOP, this.ownerMmd.getAbsoluteFieldNumber());
                }
            }
            if (this.backingStore != null && this.useCache && !this.isCacheLoaded) {
                this.isCacheLoaded = true;
            }
            if (forInsert) {
                if (NucleusLogger.PERSISTENCE.isDebugEnabled()) {
                    NucleusLogger.PERSISTENCE.debug(LOCALISER.msg("023007", (Object)this.ownerOP.getObjectAsPrintable(), (Object)this.ownerMmd.getName(), (Object)("" + c.size())));
                }
                if (this.useCache) {
                    this.loadFromStore();
                }
                if (this.backingStore != null) {
                    if (SCOUtils.useQueuedUpdate(this.queued, this.ownerOP)) {
                        for (Object element : c) {
                            this.ownerOP.getExecutionContext().addOperationToQueue(new CollectionAddOperation(this.ownerOP, this.backingStore, element));
                        }
                    } else {
                        try {
                            this.backingStore.addAll(this.ownerOP, c, this.useCache ? this.delegate.size() : -1);
                        }
                        catch (NucleusDataStoreException dse) {
                            NucleusLogger.PERSISTENCE.warn(LOCALISER.msg("023013", (Object)"addAll", (Object)this.ownerMmd.getName(), (Object)dse));
                        }
                    }
                }
                this.makeDirty();
                this.delegate.addAll(c);
            } else if (forUpdate) {
                if (NucleusLogger.PERSISTENCE.isDebugEnabled()) {
                    NucleusLogger.PERSISTENCE.debug(LOCALISER.msg("023008", (Object)this.ownerOP.getObjectAsPrintable(), (Object)this.ownerMmd.getName(), (Object)("" + c.size())));
                }
                if (this.backingStore != null) {
                    if (SCOUtils.useQueuedUpdate(this.queued, this.ownerOP)) {
                        this.ownerOP.getExecutionContext().addOperationToQueue(new CollectionClearOperation(this.ownerOP, this.backingStore));
                    } else {
                        this.backingStore.clear(this.ownerOP);
                    }
                }
                if (this.useCache) {
                    this.loadFromStore();
                }
                if (this.backingStore != null) {
                    if (SCOUtils.useQueuedUpdate(this.queued, this.ownerOP)) {
                        for (Object element : c) {
                            this.ownerOP.getExecutionContext().addOperationToQueue(new CollectionAddOperation(this.ownerOP, this.backingStore, element));
                        }
                    } else {
                        try {
                            this.backingStore.addAll(this.ownerOP, c, this.useCache ? this.delegate.size() : -1);
                        }
                        catch (NucleusDataStoreException dse) {
                            NucleusLogger.PERSISTENCE.warn(LOCALISER.msg("023013", (Object)"addAll", (Object)this.ownerMmd.getName(), (Object)dse));
                        }
                    }
                }
                this.delegate.addAll(c);
                this.makeDirty();
            } else {
                if (NucleusLogger.PERSISTENCE.isDebugEnabled()) {
                    NucleusLogger.PERSISTENCE.debug(LOCALISER.msg("023007", (Object)this.ownerOP.getObjectAsPrintable(), (Object)this.ownerMmd.getName(), (Object)("" + c.size())));
                }
                this.delegate.clear();
                this.delegate.addAll(c);
            }
        }
    }

    public void initialise() {
        if (this.useCache && !SCOUtils.useCachedLazyLoading(this.ownerOP, this.ownerMmd)) {
            this.loadFromStore();
        }
    }

    public Object getValue() {
        this.loadFromStore();
        return super.getValue();
    }

    public void load() {
        if (this.useCache) {
            this.loadFromStore();
        }
    }

    public boolean isLoaded() {
        return this.useCache ? this.isCacheLoaded : false;
    }

    protected void loadFromStore() {
        if (this.backingStore != null && !this.isCacheLoaded) {
            if (NucleusLogger.PERSISTENCE.isDebugEnabled()) {
                NucleusLogger.PERSISTENCE.debug(LOCALISER.msg("023006", (Object)this.ownerOP.getObjectAsPrintable(), (Object)this.ownerMmd.getName()));
            }
            this.delegate.clear();
            Iterator iter = this.backingStore.iterator(this.ownerOP);
            while (iter.hasNext()) {
                this.delegate.add(iter.next());
            }
            this.isCacheLoaded = true;
        }
    }

    public Store getBackingStore() {
        return this.backingStore;
    }

    public void updateEmbeddedElement(Object element, int fieldNumber, Object value) {
        if (this.backingStore != null) {
            this.backingStore.updateEmbeddedElement(this.ownerOP, element, fieldNumber, value);
        }
    }

    public synchronized void unsetOwner() {
        super.unsetOwner();
        if (this.backingStore != null) {
            this.backingStore = null;
        }
    }

    public Object clone() {
        if (this.useCache) {
            this.loadFromStore();
        }
        return super.clone();
    }

    public Comparator comparator() {
        return this.delegate.comparator();
    }

    public synchronized boolean contains(Object element) {
        if (this.useCache && this.isCacheLoaded) {
            return this.delegate.contains(element);
        }
        if (this.backingStore != null) {
            return this.backingStore.contains(this.ownerOP, element);
        }
        return this.delegate.contains(element);
    }

    public synchronized boolean containsAll(Collection c) {
        if (this.useCache) {
            this.loadFromStore();
        } else if (this.backingStore != null) {
            HashSet h = new HashSet(c);
            Iterator iter = this.iterator();
            while (iter.hasNext()) {
                h.remove(iter.next());
            }
            return h.isEmpty();
        }
        return this.delegate.containsAll(c);
    }

    public synchronized boolean equals(Object o) {
        if (this.useCache) {
            this.loadFromStore();
        }
        if (o == this) {
            return true;
        }
        if (!(o instanceof java.util.PriorityQueue)) {
            return false;
        }
        java.util.PriorityQueue c = (java.util.PriorityQueue)o;
        return c.size() == this.size() && this.containsAll((Collection)c);
    }

    public synchronized int hashCode() {
        if (this.useCache) {
            this.loadFromStore();
        }
        return this.delegate.hashCode();
    }

    public synchronized boolean isEmpty() {
        return this.size() == 0;
    }

    public synchronized Iterator iterator() {
        if (this.useCache) {
            this.loadFromStore();
        }
        return new SCOCollectionIterator(this, this.ownerOP, this.delegate, this.backingStore, this.useCache);
    }

    public synchronized Object peek() {
        if (this.useCache) {
            this.loadFromStore();
        } else if (this.backingStore != null) {
            return this.backingStore.get(this.ownerOP, 0);
        }
        return this.delegate.peek();
    }

    public synchronized int size() {
        if (this.useCache && this.isCacheLoaded) {
            return this.delegate.size();
        }
        if (this.backingStore != null) {
            return this.backingStore.size(this.ownerOP);
        }
        return this.delegate.size();
    }

    public synchronized Object[] toArray() {
        if (this.useCache) {
            this.loadFromStore();
        } else if (this.backingStore != null) {
            return SCOUtils.toArray(this.backingStore, this.ownerOP);
        }
        return this.delegate.toArray();
    }

    public synchronized Object[] toArray(Object[] a) {
        if (this.useCache) {
            this.loadFromStore();
        } else if (this.backingStore != null) {
            return SCOUtils.toArray(this.backingStore, this.ownerOP, a);
        }
        return this.delegate.toArray(a);
    }

    public String toString() {
        StringBuffer s = new StringBuffer("[");
        int i = 0;
        Iterator iter = this.iterator();
        while (iter.hasNext()) {
            if (i > 0) {
                s.append(',');
            }
            s.append(iter.next());
            ++i;
        }
        s.append("]");
        return s.toString();
    }

    public synchronized boolean add(Object element) {
        if (!this.allowNulls && element == null) {
            throw new NullPointerException("Nulls not allowed for collection at field " + this.ownerMmd.getName() + " but element is null");
        }
        if (this.useCache) {
            this.loadFromStore();
        }
        boolean backingSuccess = true;
        if (this.backingStore != null) {
            if (SCOUtils.useQueuedUpdate(this.queued, this.ownerOP)) {
                this.ownerOP.getExecutionContext().addOperationToQueue(new CollectionAddOperation(this.ownerOP, this.backingStore, element));
            } else {
                try {
                    this.backingStore.add(this.ownerOP, element, this.useCache ? this.delegate.size() : -1);
                }
                catch (NucleusDataStoreException dse) {
                    NucleusLogger.PERSISTENCE.warn(LOCALISER.msg("023013", (Object)"add", (Object)this.ownerMmd.getName(), (Object)dse));
                    backingSuccess = false;
                }
            }
        }
        this.makeDirty();
        boolean delegateSuccess = this.delegate.add(element);
        if (this.ownerOP != null && !this.ownerOP.getExecutionContext().getTransaction().isActive()) {
            this.ownerOP.getExecutionContext().processNontransactionalUpdate();
        }
        return this.backingStore != null ? backingSuccess : delegateSuccess;
    }

    public synchronized boolean addAll(Collection elements) {
        if (this.useCache) {
            this.loadFromStore();
        }
        boolean backingSuccess = true;
        if (this.backingStore != null) {
            if (SCOUtils.useQueuedUpdate(this.queued, this.ownerOP)) {
                for (Object element : elements) {
                    this.ownerOP.getExecutionContext().addOperationToQueue(new CollectionAddOperation(this.ownerOP, this.backingStore, element));
                }
            } else {
                try {
                    backingSuccess = this.backingStore.addAll(this.ownerOP, elements, this.useCache ? this.delegate.size() : -1);
                }
                catch (NucleusDataStoreException dse) {
                    NucleusLogger.PERSISTENCE.warn(LOCALISER.msg("023013", (Object)"addAll", (Object)this.ownerMmd.getName(), (Object)dse));
                    backingSuccess = false;
                }
            }
        }
        this.makeDirty();
        boolean delegateSuccess = this.delegate.addAll(elements);
        if (this.ownerOP != null && !this.ownerOP.getExecutionContext().getTransaction().isActive()) {
            this.ownerOP.getExecutionContext().processNontransactionalUpdate();
        }
        return this.backingStore != null ? backingSuccess : delegateSuccess;
    }

    public synchronized void clear() {
        this.makeDirty();
        this.delegate.clear();
        if (this.backingStore != null) {
            if (SCOUtils.useQueuedUpdate(this.queued, this.ownerOP)) {
                this.ownerOP.getExecutionContext().addOperationToQueue(new CollectionClearOperation(this.ownerOP, this.backingStore));
            } else {
                this.backingStore.clear(this.ownerOP);
            }
        }
        if (this.ownerOP != null && !this.ownerOP.getExecutionContext().getTransaction().isActive()) {
            this.ownerOP.getExecutionContext().processNontransactionalUpdate();
        }
    }

    public synchronized boolean offer(Object element) {
        return this.add(element);
    }

    public synchronized Object poll() {
        this.makeDirty();
        if (this.useCache) {
            this.loadFromStore();
        }
        int size = this.useCache ? this.delegate.size() : -1;
        Object delegateObject = this.delegate.poll();
        Object backingObject = null;
        if (this.backingStore != null) {
            if (SCOUtils.useQueuedUpdate(this.queued, this.ownerOP)) {
                this.ownerOP.getExecutionContext().addOperationToQueue(new ListRemoveAtOperation(this.ownerOP, this.backingStore, 0));
            } else {
                try {
                    backingObject = this.backingStore.remove(this.ownerOP, 0, size);
                }
                catch (NucleusDataStoreException dse) {
                    backingObject = null;
                }
            }
        }
        if (this.ownerOP != null && !this.ownerOP.getExecutionContext().getTransaction().isActive()) {
            this.ownerOP.getExecutionContext().processNontransactionalUpdate();
        }
        return this.backingStore != null ? backingObject : (Object)delegateObject;
    }

    public synchronized boolean remove(Object element) {
        return this.remove(element, true);
    }

    public boolean remove(Object element, boolean allowCascadeDelete) {
        this.makeDirty();
        if (this.useCache) {
            this.loadFromStore();
        }
        int size = this.useCache ? this.delegate.size() : -1;
        boolean contained = this.delegate.contains(element);
        boolean delegateSuccess = this.delegate.remove(element);
        boolean backingSuccess = true;
        if (this.backingStore != null) {
            if (SCOUtils.useQueuedUpdate(this.queued, this.ownerOP)) {
                backingSuccess = contained;
                if (backingSuccess) {
                    this.ownerOP.getExecutionContext().addOperationToQueue(new CollectionRemoveOperation(this.ownerOP, this.backingStore, element, allowCascadeDelete));
                }
            } else {
                try {
                    backingSuccess = this.backingStore.remove(this.ownerOP, element, size, allowCascadeDelete);
                }
                catch (NucleusDataStoreException dse) {
                    NucleusLogger.PERSISTENCE.warn(LOCALISER.msg("023013", (Object)"remove", (Object)this.ownerMmd.getName(), (Object)dse));
                    backingSuccess = false;
                }
            }
        }
        if (this.ownerOP != null && !this.ownerOP.getExecutionContext().getTransaction().isActive()) {
            this.ownerOP.getExecutionContext().processNontransactionalUpdate();
        }
        return this.backingStore != null ? backingSuccess : delegateSuccess;
    }

    public synchronized boolean removeAll(Collection elements) {
        this.makeDirty();
        if (this.useCache) {
            this.loadFromStore();
        }
        int size = this.useCache ? this.delegate.size() : -1;
        HashSet contained = null;
        if (this.backingStore != null && SCOUtils.useQueuedUpdate(this.queued, this.ownerOP)) {
            contained = new HashSet();
            for (Object elem : elements) {
                if (!this.contains(elem)) continue;
                contained.add(elem);
            }
        }
        boolean delegateSuccess = this.delegate.removeAll(elements);
        if (this.backingStore != null) {
            boolean backingSuccess = true;
            if (SCOUtils.useQueuedUpdate(this.queued, this.ownerOP)) {
                backingSuccess = false;
                for (Object element : contained) {
                    backingSuccess = true;
                    this.ownerOP.getExecutionContext().addOperationToQueue(new CollectionRemoveOperation(this.ownerOP, this.backingStore, element, true));
                }
            } else {
                try {
                    backingSuccess = this.backingStore.removeAll(this.ownerOP, elements, size);
                }
                catch (NucleusDataStoreException dse) {
                    NucleusLogger.PERSISTENCE.warn(LOCALISER.msg("023013", (Object)"removeAll", (Object)this.ownerMmd.getName(), (Object)dse));
                    backingSuccess = false;
                }
            }
            if (this.ownerOP != null && !this.ownerOP.getExecutionContext().getTransaction().isActive()) {
                this.ownerOP.getExecutionContext().processNontransactionalUpdate();
            }
            return backingSuccess;
        }
        if (this.ownerOP != null && !this.ownerOP.getExecutionContext().getTransaction().isActive()) {
            this.ownerOP.getExecutionContext().processNontransactionalUpdate();
        }
        return delegateSuccess;
    }

    public synchronized boolean retainAll(Collection c) {
        this.makeDirty();
        if (this.useCache) {
            this.loadFromStore();
        }
        boolean modified = false;
        Iterator iter = this.iterator();
        while (iter.hasNext()) {
            Object element = iter.next();
            if (c.contains(element)) continue;
            iter.remove();
            modified = true;
        }
        if (this.ownerOP != null && !this.ownerOP.getExecutionContext().getTransaction().isActive()) {
            this.ownerOP.getExecutionContext().processNontransactionalUpdate();
        }
        return modified;
    }

    protected Object writeReplace() throws ObjectStreamException {
        if (this.useCache) {
            this.loadFromStore();
            return new java.util.PriorityQueue(this.delegate);
        }
        return new java.util.PriorityQueue(this.delegate);
    }
}

