/*
 * Decompiled with CFR 0.152.
 */
package org.datanucleus.metadata;

import java.util.HashSet;
import java.util.Set;
import org.datanucleus.ClassLoaderResolver;
import org.datanucleus.metadata.FetchGroupMemberMetaData;
import org.datanucleus.metadata.MetaData;
import org.datanucleus.metadata.MetaDataManager;
import org.datanucleus.util.StringUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class FetchGroupMetaData
extends MetaData {
    Boolean postLoad;
    final String name;
    protected Set<FetchGroupMetaData> fetchGroups = null;
    protected Set<FetchGroupMemberMetaData> members = null;

    public FetchGroupMetaData(String name) {
        this.name = name;
    }

    @Override
    public void initialise(ClassLoaderResolver clr, MetaDataManager mmgr) {
        if (this.postLoad == null) {
            this.postLoad = Boolean.FALSE;
        }
        if (this.fetchGroups != null) {
            for (FetchGroupMetaData fgmd : this.fetchGroups) {
                fgmd.initialise(clr, mmgr);
            }
        }
        super.initialise(clr, mmgr);
    }

    public final String getName() {
        return this.name;
    }

    public final Boolean getPostLoad() {
        return this.postLoad;
    }

    public FetchGroupMetaData setPostLoad(Boolean postLoad) {
        this.postLoad = postLoad;
        return this;
    }

    public FetchGroupMetaData setPostLoad(String postLoad) {
        if (!StringUtils.isWhitespace(postLoad)) {
            if (postLoad.equalsIgnoreCase("true")) {
                this.postLoad = Boolean.TRUE;
            } else if (postLoad.equalsIgnoreCase("false")) {
                this.postLoad = Boolean.FALSE;
            }
        }
        return this;
    }

    public final Set<FetchGroupMetaData> getFetchGroups() {
        return this.fetchGroups;
    }

    public final Set<FetchGroupMemberMetaData> getMembers() {
        return this.members;
    }

    public int getNumberOfMembers() {
        return this.members != null ? this.members.size() : 0;
    }

    public void addFetchGroup(FetchGroupMetaData fgmd) {
        if (this.fetchGroups == null) {
            this.fetchGroups = new HashSet<FetchGroupMetaData>();
        }
        this.fetchGroups.add(fgmd);
        fgmd.parent = this;
    }

    public void addMember(FetchGroupMemberMetaData fgmmd) {
        if (this.members == null) {
            this.members = new HashSet<FetchGroupMemberMetaData>();
        }
        this.members.add(fgmmd);
        fgmmd.parent = this;
    }

    public FetchGroupMemberMetaData newMemberMetaData(String name) {
        FetchGroupMemberMetaData fgmmd = new FetchGroupMemberMetaData((MetaData)this, name);
        this.addMember(fgmmd);
        return fgmmd;
    }

    @Override
    public String toString(String prefix, String indent) {
        StringBuffer sb = new StringBuffer();
        sb.append(prefix).append("<fetch-group name=\"" + this.name + "\"\n");
        if (this.fetchGroups != null) {
            for (FetchGroupMetaData fgmd : this.fetchGroups) {
                sb.append(fgmd.toString(prefix + indent, indent));
            }
        }
        if (this.members != null) {
            for (FetchGroupMemberMetaData fgmmd : this.members) {
                sb.append(fgmmd.toString(prefix + indent, indent));
            }
        }
        sb.append(prefix + "</fetch-group>\n");
        return sb.toString();
    }
}

