/*
 * Decompiled with CFR 0.152.
 */
package org.datanucleus.store.types.simple;

import java.io.ObjectStreamException;
import java.io.Serializable;
import java.util.AbstractQueue;
import java.util.Collection;
import java.util.Comparator;
import java.util.HashSet;
import java.util.Iterator;
import org.datanucleus.metadata.AbstractMemberMetaData;
import org.datanucleus.state.FetchPlanState;
import org.datanucleus.state.ObjectProvider;
import org.datanucleus.store.types.SCOCollection;
import org.datanucleus.store.types.SCOCollectionIterator;
import org.datanucleus.store.types.SCOMtoN;
import org.datanucleus.store.types.SCOUtils;
import org.datanucleus.store.types.simple.PriorityQueue;
import org.datanucleus.util.Localiser;
import org.datanucleus.util.NucleusLogger;

public class Queue
extends AbstractQueue
implements SCOCollection,
SCOMtoN,
Cloneable,
Serializable {
    protected static final Localiser LOCALISER = Localiser.getInstance("org.datanucleus.Localisation", PriorityQueue.class.getClassLoader());
    protected ObjectProvider ownerOP;
    protected AbstractMemberMetaData ownerMmd;
    protected java.util.Queue delegate;

    public Queue(ObjectProvider ownerSM, AbstractMemberMetaData mmd) {
        this.ownerOP = ownerSM;
        this.ownerMmd = mmd;
    }

    public void initialise(Object o, boolean forInsert, boolean forUpdate) {
        Collection c = (Collection)o;
        if (c != null) {
            this.initialiseDelegate();
            this.delegate.addAll(c);
        } else {
            this.initialiseDelegate();
        }
        if (NucleusLogger.PERSISTENCE.isDebugEnabled()) {
            NucleusLogger.PERSISTENCE.debug(LOCALISER.msg("023003", (Object)this.ownerOP.getObjectAsPrintable(), (Object)this.ownerMmd.getName(), (Object)("" + this.size()), (Object)SCOUtils.getSCOWrapperOptionsMessage(true, false, false, false)));
        }
    }

    public void initialise() {
        this.initialiseDelegate();
        if (NucleusLogger.PERSISTENCE.isDebugEnabled()) {
            NucleusLogger.PERSISTENCE.debug(LOCALISER.msg("023003", (Object)this.ownerOP.getObjectAsPrintable(), (Object)this.ownerMmd.getName(), (Object)("" + this.size()), (Object)SCOUtils.getSCOWrapperOptionsMessage(true, false, false, false)));
        }
    }

    protected void initialiseDelegate() {
        Comparator comparator = SCOUtils.getComparator(this.ownerMmd, this.ownerOP.getExecutionContext().getClassLoaderResolver());
        this.delegate = comparator != null ? new java.util.PriorityQueue(5, comparator) : new java.util.PriorityQueue();
    }

    public Object getValue() {
        return this.delegate;
    }

    public void load() {
    }

    public boolean isLoaded() {
        return true;
    }

    public void updateEmbeddedElement(Object element, int fieldNumber, Object value) {
        this.makeDirty();
    }

    public String getFieldName() {
        return this.ownerMmd.getName();
    }

    public Object getOwner() {
        return this.ownerOP != null ? this.ownerOP.getObject() : null;
    }

    public synchronized void unsetOwner() {
        if (this.ownerOP != null) {
            this.ownerOP = null;
            this.ownerMmd = null;
        }
    }

    public void makeDirty() {
        if (this.ownerOP != null) {
            this.ownerOP.makeDirty(this.ownerMmd.getAbsoluteFieldNumber());
        }
    }

    public Object detachCopy(FetchPlanState state) {
        java.util.PriorityQueue detached = new java.util.PriorityQueue();
        SCOUtils.detachCopyForCollection(this.ownerOP, this.toArray(), state, detached);
        return detached;
    }

    public void attachCopy(Object value) {
        Collection c = (Collection)value;
        boolean elementsWithoutIdentity = SCOUtils.collectionHasElementsWithoutIdentity(this.ownerMmd);
        HashSet attachedElements = new HashSet(c.size());
        SCOUtils.attachRemoveDeletedElements(this.ownerOP.getExecutionContext().getApiAdapter(), this, c, elementsWithoutIdentity);
        SCOUtils.attachCopyForCollection(this.ownerOP, c.toArray(), attachedElements, elementsWithoutIdentity);
        SCOUtils.attachAddNewElements(this.ownerOP.getExecutionContext().getApiAdapter(), this, attachedElements, elementsWithoutIdentity);
    }

    public Object clone() {
        return null;
    }

    public synchronized boolean contains(Object element) {
        return this.delegate.contains(element);
    }

    public synchronized boolean containsAll(Collection c) {
        return this.delegate.containsAll(c);
    }

    public synchronized boolean equals(Object o) {
        return this.delegate.equals(o);
    }

    public synchronized int hashCode() {
        return this.delegate.hashCode();
    }

    public synchronized boolean isEmpty() {
        return this.delegate.isEmpty();
    }

    public synchronized Iterator iterator() {
        return new SCOCollectionIterator(this, this.ownerOP, this.delegate, null, true);
    }

    public synchronized Object peek() {
        return this.delegate.peek();
    }

    public synchronized int size() {
        return this.delegate.size();
    }

    public synchronized Object[] toArray() {
        return this.delegate.toArray();
    }

    public synchronized Object[] toArray(Object[] a) {
        return this.delegate.toArray(a);
    }

    public synchronized boolean add(Object element) {
        boolean success = this.delegate.add(element);
        if (success) {
            this.makeDirty();
            if (this.ownerOP != null && !this.ownerOP.getExecutionContext().getTransaction().isActive()) {
                this.ownerOP.getExecutionContext().processNontransactionalUpdate();
            }
        }
        return success;
    }

    public synchronized boolean addAll(Collection elements) {
        boolean success = this.delegate.addAll(elements);
        if (success) {
            this.makeDirty();
            if (this.ownerOP != null && !this.ownerOP.getExecutionContext().getTransaction().isActive()) {
                this.ownerOP.getExecutionContext().processNontransactionalUpdate();
            }
        }
        return success;
    }

    public synchronized void clear() {
        if (this.ownerOP != null && !this.delegate.isEmpty() && SCOUtils.hasDependentElement(this.ownerMmd)) {
            Iterator iter = this.delegate.iterator();
            while (iter.hasNext()) {
                this.ownerOP.getExecutionContext().deleteObjectInternal(iter.next());
            }
        }
        this.delegate.clear();
        this.makeDirty();
        if (this.ownerOP != null && !this.ownerOP.getExecutionContext().getTransaction().isActive()) {
            this.ownerOP.getExecutionContext().processNontransactionalUpdate();
        }
    }

    public synchronized boolean offer(Object element) {
        boolean success = this.delegate.offer(element);
        if (success) {
            this.makeDirty();
            if (this.ownerOP != null && !this.ownerOP.getExecutionContext().getTransaction().isActive()) {
                this.ownerOP.getExecutionContext().processNontransactionalUpdate();
            }
        }
        return success;
    }

    public synchronized Object poll() {
        Object obj = this.delegate.poll();
        this.makeDirty();
        if (this.ownerOP != null && !this.ownerOP.getExecutionContext().getTransaction().isActive()) {
            this.ownerOP.getExecutionContext().processNontransactionalUpdate();
        }
        return obj;
    }

    public synchronized boolean remove(Object element) {
        return this.remove(element, true);
    }

    public synchronized boolean remove(Object element, boolean allowCascadeDelete) {
        boolean success = this.delegate.remove(element);
        if (this.ownerOP != null && allowCascadeDelete && SCOUtils.hasDependentElement(this.ownerMmd)) {
            this.ownerOP.getExecutionContext().deleteObjectInternal(element);
        }
        if (success) {
            this.makeDirty();
            if (this.ownerOP != null && !this.ownerOP.getExecutionContext().getTransaction().isActive()) {
                this.ownerOP.getExecutionContext().processNontransactionalUpdate();
            }
        }
        return success;
    }

    public synchronized boolean removeAll(Collection elements) {
        boolean success = this.delegate.removeAll(elements);
        if (this.ownerOP != null && elements != null && !elements.isEmpty() && SCOUtils.hasDependentElement(this.ownerMmd)) {
            Iterator iter = elements.iterator();
            while (iter.hasNext()) {
                this.ownerOP.getExecutionContext().deleteObjectInternal(iter.next());
            }
        }
        if (success) {
            this.makeDirty();
            if (this.ownerOP != null && !this.ownerOP.getExecutionContext().getTransaction().isActive()) {
                this.ownerOP.getExecutionContext().processNontransactionalUpdate();
            }
        }
        return success;
    }

    public synchronized boolean retainAll(Collection c) {
        boolean success = this.delegate.retainAll(c);
        if (success) {
            this.makeDirty();
            if (this.ownerOP != null && !this.ownerOP.getExecutionContext().getTransaction().isActive()) {
                this.ownerOP.getExecutionContext().processNontransactionalUpdate();
            }
        }
        return success;
    }

    protected Object writeReplace() throws ObjectStreamException {
        return new java.util.PriorityQueue(this.delegate);
    }
}

