/*
 * Decompiled with CFR 0.152.
 */
package org.datanucleus.store.types.backed;

import java.io.ObjectStreamException;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import org.datanucleus.ClassLoaderResolver;
import org.datanucleus.ExecutionContext;
import org.datanucleus.flush.MapClearOperation;
import org.datanucleus.flush.MapPutOperation;
import org.datanucleus.flush.MapRemoveOperation;
import org.datanucleus.metadata.AbstractMemberMetaData;
import org.datanucleus.metadata.FieldPersistenceModifier;
import org.datanucleus.state.ObjectProvider;
import org.datanucleus.store.BackedSCOStoreManager;
import org.datanucleus.store.scostore.MapStore;
import org.datanucleus.store.scostore.Store;
import org.datanucleus.store.types.SCOUtils;
import org.datanucleus.store.types.backed.BackedSCO;
import org.datanucleus.store.types.backed.Set;
import org.datanucleus.util.NucleusLogger;

public class Map
extends org.datanucleus.store.types.simple.Map
implements BackedSCO {
    protected transient boolean allowNulls = true;
    protected transient MapStore backingStore;
    protected transient boolean useCache = true;
    protected transient boolean isCacheLoaded = false;
    protected transient boolean queued = false;

    public Map(ObjectProvider op, AbstractMemberMetaData mmd) {
        super(op, mmd);
        this.delegate = new HashMap();
        ExecutionContext ec = op.getExecutionContext();
        this.allowNulls = SCOUtils.allowNullsInContainer(this.allowNulls, mmd);
        this.queued = ec.isDelayDatastoreOperationsEnabled();
        this.useCache = SCOUtils.useContainerCache(op, mmd);
        if (!SCOUtils.mapHasSerialisedKeysAndValues(mmd) && mmd.getPersistenceModifier() == FieldPersistenceModifier.PERSISTENT) {
            ClassLoaderResolver clr = ec.getClassLoaderResolver();
            this.backingStore = (MapStore)((BackedSCOStoreManager)((Object)ec.getStoreManager())).getBackingStoreForField(clr, mmd, java.util.Map.class);
        }
        if (NucleusLogger.PERSISTENCE.isDebugEnabled()) {
            NucleusLogger.PERSISTENCE.debug(SCOUtils.getContainerInfoMessage(op, this.ownerMmd.getName(), this, this.useCache, this.queued, this.allowNulls, SCOUtils.useCachedLazyLoading(op, this.ownerMmd)));
        }
    }

    public synchronized void initialise(Object o, boolean forInsert, boolean forUpdate) {
        java.util.Map m = (java.util.Map)o;
        if (m != null) {
            if (SCOUtils.mapHasSerialisedKeysAndValues(this.ownerMmd) && (this.ownerMmd.getMap().keyIsPersistent() || this.ownerMmd.getMap().valueIsPersistent())) {
                ExecutionContext ec = this.ownerOP.getExecutionContext();
                for (Map.Entry entry : m.entrySet()) {
                    ObjectProvider objSM;
                    Object key = entry.getKey();
                    Object value = entry.getValue();
                    if (this.ownerMmd.getMap().keyIsPersistent() && (objSM = ec.findObjectProvider(key)) == null) {
                        objSM = ec.newObjectProviderForEmbedded(key, false, this.ownerOP, this.ownerMmd.getAbsoluteFieldNumber());
                    }
                    if (!this.ownerMmd.getMap().valueIsPersistent() || (objSM = ec.findObjectProvider(value)) != null) continue;
                    objSM = ec.newObjectProviderForEmbedded(value, false, this.ownerOP, this.ownerMmd.getAbsoluteFieldNumber());
                }
            }
            if (this.backingStore != null && this.useCache && !this.isCacheLoaded) {
                this.isCacheLoaded = true;
            }
            if (forInsert) {
                if (NucleusLogger.PERSISTENCE.isDebugEnabled()) {
                    NucleusLogger.PERSISTENCE.debug(LOCALISER.msg("023007", (Object)this.ownerOP.getObjectAsPrintable(), (Object)this.ownerMmd.getName(), (Object)("" + m.size())));
                }
                this.makeDirty();
                if (this.useCache) {
                    this.loadFromStore();
                }
                if (this.backingStore != null) {
                    if (SCOUtils.useQueuedUpdate(this.queued, this.ownerOP)) {
                        for (Map.Entry entry : m.entrySet()) {
                            this.ownerOP.getExecutionContext().addOperationToQueue(new MapPutOperation(this.ownerOP, this.backingStore, entry.getKey(), entry.getValue()));
                        }
                    } else {
                        this.backingStore.putAll(this.ownerOP, m);
                    }
                }
                this.delegate.putAll(m);
            } else if (forUpdate) {
                if (NucleusLogger.PERSISTENCE.isDebugEnabled()) {
                    NucleusLogger.PERSISTENCE.debug(LOCALISER.msg("023008", (Object)this.ownerOP.getObjectAsPrintable(), (Object)this.ownerMmd.getName(), (Object)("" + m.size())));
                }
                this.delegate.clear();
                if (this.backingStore != null) {
                    if (SCOUtils.useQueuedUpdate(this.queued, this.ownerOP)) {
                        this.ownerOP.getExecutionContext().addOperationToQueue(new MapClearOperation(this.ownerOP, this.backingStore));
                    } else {
                        this.backingStore.clear(this.ownerOP);
                    }
                }
                if (this.useCache) {
                    this.loadFromStore();
                }
                if (this.backingStore != null) {
                    if (SCOUtils.useQueuedUpdate(this.queued, this.ownerOP)) {
                        for (Map.Entry entry : m.entrySet()) {
                            this.ownerOP.getExecutionContext().addOperationToQueue(new MapPutOperation(this.ownerOP, this.backingStore, entry.getKey(), entry.getValue()));
                        }
                    } else {
                        this.backingStore.putAll(this.ownerOP, m);
                    }
                }
                this.delegate.putAll(m);
                this.makeDirty();
            } else {
                if (NucleusLogger.PERSISTENCE.isDebugEnabled()) {
                    NucleusLogger.PERSISTENCE.debug(LOCALISER.msg("023007", (Object)this.ownerOP.getObjectAsPrintable(), (Object)this.ownerMmd.getName(), (Object)("" + m.size())));
                }
                this.delegate.clear();
                this.delegate.putAll(m);
            }
        }
    }

    public void initialise() {
        if (this.useCache && !SCOUtils.useCachedLazyLoading(this.ownerOP, this.ownerMmd)) {
            this.loadFromStore();
        }
    }

    public Object getValue() {
        this.loadFromStore();
        return super.getValue();
    }

    public void load() {
        if (this.useCache) {
            this.loadFromStore();
        }
    }

    public boolean isLoaded() {
        return this.useCache ? this.isCacheLoaded : false;
    }

    protected void loadFromStore() {
        if (this.backingStore != null && !this.isCacheLoaded) {
            if (NucleusLogger.PERSISTENCE.isDebugEnabled()) {
                NucleusLogger.PERSISTENCE.debug(LOCALISER.msg("023006", (Object)this.ownerOP.getObjectAsPrintable(), (Object)this.ownerMmd.getName()));
            }
            this.delegate.clear();
            SCOUtils.populateMapDelegateWithStoreData(this.delegate, this.backingStore, this.ownerOP);
            this.isCacheLoaded = true;
        }
    }

    public Store getBackingStore() {
        return this.backingStore;
    }

    public void updateEmbeddedKey(Object key, int fieldNumber, Object newValue) {
        if (this.backingStore != null) {
            this.backingStore.updateEmbeddedKey(this.ownerOP, key, fieldNumber, newValue);
        }
    }

    public void updateEmbeddedValue(Object value, int fieldNumber, Object newValue) {
        if (this.backingStore != null) {
            this.backingStore.updateEmbeddedValue(this.ownerOP, value, fieldNumber, newValue);
        }
    }

    public synchronized void unsetOwner() {
        super.unsetOwner();
        if (this.backingStore != null) {
            this.backingStore = null;
        }
    }

    public Object clone() {
        if (this.useCache) {
            this.loadFromStore();
        }
        return ((HashMap)this.delegate).clone();
    }

    public synchronized boolean containsKey(Object key) {
        if (this.useCache && this.isCacheLoaded) {
            return this.delegate.containsKey(key);
        }
        if (this.backingStore != null) {
            return this.backingStore.containsKey(this.ownerOP, key);
        }
        return this.delegate.containsKey(key);
    }

    public synchronized boolean containsValue(Object value) {
        if (this.useCache && this.isCacheLoaded) {
            return this.delegate.containsValue(value);
        }
        if (this.backingStore != null) {
            return this.backingStore.containsValue(this.ownerOP, value);
        }
        return this.delegate.containsValue(value);
    }

    public synchronized java.util.Set entrySet() {
        if (this.useCache) {
            this.loadFromStore();
        } else if (this.backingStore != null) {
            return new Set(this.ownerOP, this.ownerMmd, false, this.backingStore.entrySetStore());
        }
        return this.delegate.entrySet();
    }

    public synchronized boolean equals(Object o) {
        if (this.useCache) {
            this.loadFromStore();
        }
        if (o == this) {
            return true;
        }
        if (!(o instanceof java.util.Map)) {
            return false;
        }
        java.util.Map m = (java.util.Map)o;
        return ((Object)this.entrySet()).equals(m.entrySet());
    }

    public synchronized Object get(Object key) {
        if (this.useCache) {
            this.loadFromStore();
        } else if (this.backingStore != null) {
            return this.backingStore.get(this.ownerOP, key);
        }
        return this.delegate.get(key);
    }

    public synchronized int hashCode() {
        if (this.useCache) {
            this.loadFromStore();
        } else if (this.backingStore != null) {
            int h = 0;
            Iterator i = this.entrySet().iterator();
            while (i.hasNext()) {
                h += i.next().hashCode();
            }
            return h;
        }
        return ((Object)this.delegate).hashCode();
    }

    public synchronized boolean isEmpty() {
        return this.size() == 0;
    }

    public synchronized java.util.Set keySet() {
        if (this.useCache) {
            this.loadFromStore();
        } else if (this.backingStore != null) {
            return new Set(this.ownerOP, this.ownerMmd, false, this.backingStore.keySetStore());
        }
        return this.delegate.keySet();
    }

    public synchronized int size() {
        if (this.useCache && this.isCacheLoaded) {
            return this.delegate.size();
        }
        if (this.backingStore != null) {
            return this.backingStore.entrySetStore().size(this.ownerOP);
        }
        return this.delegate.size();
    }

    public synchronized Collection values() {
        if (this.useCache) {
            this.loadFromStore();
        } else if (this.backingStore != null) {
            return new Set(this.ownerOP, this.ownerMmd, true, this.backingStore.valueSetStore());
        }
        return this.delegate.values();
    }

    public String toString() {
        StringBuffer s = new StringBuffer("{");
        Iterator i = this.entrySet().iterator();
        boolean hasNext = i.hasNext();
        while (hasNext) {
            Map.Entry e = (Map.Entry)i.next();
            Object key = e.getKey();
            Object val = e.getValue();
            s.append(key).append('=').append(val);
            hasNext = i.hasNext();
            if (!hasNext) continue;
            s.append(',');
        }
        s.append("}");
        return s.toString();
    }

    public synchronized void clear() {
        this.makeDirty();
        this.delegate.clear();
        if (this.backingStore != null) {
            if (SCOUtils.useQueuedUpdate(this.queued, this.ownerOP)) {
                this.ownerOP.getExecutionContext().addOperationToQueue(new MapClearOperation(this.ownerOP, this.backingStore));
            } else {
                this.backingStore.clear(this.ownerOP);
            }
        }
        if (this.ownerOP != null && !this.ownerOP.getExecutionContext().getTransaction().isActive()) {
            this.ownerOP.getExecutionContext().processNontransactionalUpdate();
        }
    }

    public synchronized Object put(Object key, Object value) {
        if (!this.allowNulls) {
            if (value == null) {
                throw new NullPointerException("Nulls not allowed for map at field " + this.ownerMmd.getName() + " but value is null");
            }
            if (key == null) {
                throw new NullPointerException("Nulls not allowed for map at field " + this.ownerMmd.getName() + " but key is null");
            }
        }
        if (this.useCache) {
            this.loadFromStore();
        }
        this.makeDirty();
        Object oldValue = null;
        if (this.backingStore != null) {
            if (SCOUtils.useQueuedUpdate(this.queued, this.ownerOP)) {
                this.ownerOP.getExecutionContext().addOperationToQueue(new MapPutOperation(this.ownerOP, this.backingStore, key, value));
            } else {
                oldValue = this.backingStore.put(this.ownerOP, key, value);
            }
        }
        Object delegateOldValue = this.delegate.put(key, value);
        if (this.backingStore == null) {
            oldValue = delegateOldValue;
        } else if (SCOUtils.useQueuedUpdate(this.queued, this.ownerOP)) {
            oldValue = delegateOldValue;
        }
        if (this.ownerOP != null && !this.ownerOP.getExecutionContext().getTransaction().isActive()) {
            this.ownerOP.getExecutionContext().processNontransactionalUpdate();
        }
        return oldValue;
    }

    public synchronized void putAll(java.util.Map m) {
        this.makeDirty();
        if (this.useCache) {
            this.loadFromStore();
        }
        if (this.backingStore != null) {
            if (SCOUtils.useQueuedUpdate(this.queued, this.ownerOP)) {
                for (Map.Entry entry : m.entrySet()) {
                    this.ownerOP.getExecutionContext().addOperationToQueue(new MapPutOperation(this.ownerOP, this.backingStore, entry.getKey(), entry.getValue()));
                }
            } else {
                this.backingStore.putAll(this.ownerOP, m);
            }
        }
        this.delegate.putAll(m);
        if (this.ownerOP != null && !this.ownerOP.getExecutionContext().getTransaction().isActive()) {
            this.ownerOP.getExecutionContext().processNontransactionalUpdate();
        }
    }

    public synchronized Object remove(Object key) {
        this.makeDirty();
        if (this.useCache) {
            this.loadFromStore();
        }
        Object removed = null;
        Object delegateRemoved = this.delegate.remove(key);
        if (this.backingStore != null) {
            if (SCOUtils.useQueuedUpdate(this.queued, this.ownerOP)) {
                this.ownerOP.getExecutionContext().addOperationToQueue(new MapRemoveOperation(this.ownerOP, this.backingStore, key));
                removed = delegateRemoved;
            } else {
                removed = this.backingStore.remove(this.ownerOP, key);
            }
        } else {
            removed = delegateRemoved;
        }
        if (this.ownerOP != null && !this.ownerOP.getExecutionContext().getTransaction().isActive()) {
            this.ownerOP.getExecutionContext().processNontransactionalUpdate();
        }
        return removed;
    }

    protected Object writeReplace() throws ObjectStreamException {
        if (this.useCache) {
            this.loadFromStore();
            return new HashMap(this.delegate);
        }
        return new HashMap(this.delegate);
    }
}

