/*
 * Decompiled with CFR 0.152.
 */
package org.datanucleus.query.compiler;

import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.datanucleus.ClassLoaderResolver;
import org.datanucleus.exceptions.NucleusUserException;
import org.datanucleus.metadata.MetaDataManager;
import org.datanucleus.query.JDOQLQueryHelper;
import org.datanucleus.query.compiler.JDOQLParser;
import org.datanucleus.query.compiler.JavaQueryCompiler;
import org.datanucleus.query.compiler.QueryCompilation;
import org.datanucleus.query.compiler.QueryCompilerOptimiser;
import org.datanucleus.query.expression.DyadicExpression;
import org.datanucleus.query.expression.Expression;
import org.datanucleus.query.expression.InvokeExpression;
import org.datanucleus.query.expression.Literal;
import org.datanucleus.query.expression.OrderExpression;
import org.datanucleus.query.expression.ParameterExpression;
import org.datanucleus.query.expression.PrimaryExpression;
import org.datanucleus.query.expression.VariableExpression;
import org.datanucleus.query.symbol.PropertySymbol;
import org.datanucleus.query.symbol.SymbolResolver;
import org.datanucleus.query.symbol.SymbolTable;
import org.datanucleus.util.Imports;

public class JDOQLCompiler
extends JavaQueryCompiler
implements SymbolResolver {
    public JDOQLCompiler(MetaDataManager metaDataManager, ClassLoaderResolver clr, String from, Class candidateClass, Collection candidates, String filter, Imports imports, String ordering, String result, String grouping, String having, String params, String variables, String update) {
        super(metaDataManager, clr, from, candidateClass, candidates, filter, imports, ordering, result, grouping, having, params, variables, update);
    }

    public QueryCompilation compile(Map parameters, Map subqueryMap) {
        HashMap<String, Boolean> parseOptions = new HashMap<String, Boolean>();
        if (this.parameters != null) {
            parseOptions.put("explicitParameters", true);
        } else {
            parseOptions.put("implicitParameters", true);
        }
        this.parser = new JDOQLParser(parseOptions);
        this.symtbl = new SymbolTable();
        this.symtbl.setSymbolResolver(this);
        if (this.parentCompiler != null) {
            this.symtbl.setParentSymbolTable(this.parentCompiler.symtbl);
        }
        if (subqueryMap != null && !subqueryMap.isEmpty()) {
            for (String subqueryName : subqueryMap.keySet()) {
                PropertySymbol sym = new PropertySymbol(subqueryName);
                sym.setType(2);
                this.symtbl.addSymbol(sym);
            }
        }
        Expression[] exprFrom = this.compileFrom();
        this.compileCandidatesParametersVariables(parameters);
        Expression exprFilter = this.compileFilter();
        Expression[] exprOrdering = this.compileOrdering();
        Expression[] exprResult = this.compileResult();
        Expression[] exprGrouping = this.compileGrouping();
        Expression exprHaving = this.compileHaving();
        Expression[] exprUpdate = this.compileUpdate();
        if (exprGrouping != null) {
            int i;
            if (exprResult != null) {
                for (i = 0; i < exprResult.length; ++i) {
                    if (JDOQLCompiler.isExpressionGroupingOrAggregate(exprResult[i], exprGrouping)) continue;
                    throw new NucleusUserException("JDOQL query has result clause " + exprResult[i] + " but this is invalid (see JDO spec 14.6.10)." + " When specified with grouping should be aggregate, or grouping expression");
                }
            }
            if (exprOrdering != null) {
                for (i = 0; i < exprOrdering.length; ++i) {
                    if (JDOQLCompiler.isExpressionGroupingOrAggregate(exprOrdering[i], exprGrouping)) continue;
                    throw new NucleusUserException("JDOQL query has ordering clause " + exprOrdering[i] + " but this is invalid (see JDO spec 14.6.10)." + " When specified with grouping should be aggregate, or grouping expression");
                }
            }
        }
        if (exprHaving != null && !JDOQLCompiler.containsOnlyGroupingOrAggregates(exprHaving, exprGrouping)) {
            throw new NucleusUserException("JDOQL query has having clause " + exprHaving + " but this is invalid (see JDO spec 14.6.10)." + " Should contain only aggregates, or grouping expressions");
        }
        QueryCompilation compilation = new QueryCompilation(this.candidateClass, this.candidateAlias, this.symtbl, exprResult, exprFrom, exprFilter, exprGrouping, exprHaving, exprOrdering, exprUpdate);
        compilation.setQueryLanguage(this.getLanguage());
        boolean optimise = this.metaDataManager.getNucleusContext().getPersistenceConfiguration().getBooleanProperty("datanucleus.query.compileOptimised");
        if (optimise) {
            QueryCompilerOptimiser optimiser = new QueryCompilerOptimiser(compilation);
            optimiser.optimise();
        }
        return compilation;
    }

    public Expression[] compileUpdate() {
        boolean allowAll = this.metaDataManager.getNucleusContext().getPersistenceConfiguration().getBooleanProperty("datanucleus.query.jdoql.allowAll");
        if (allowAll && this.update != null) {
            ((JDOQLParser)this.parser).allowSingleEquals(true);
        }
        Expression[] result = super.compileUpdate();
        ((JDOQLParser)this.parser).allowSingleEquals(false);
        return result;
    }

    private static boolean containsOnlyGroupingOrAggregates(Expression expr, Expression[] exprGrouping) {
        if (expr == null) {
            return true;
        }
        if (expr instanceof DyadicExpression) {
            Expression left = expr.getLeft();
            Expression right = expr.getRight();
            if (!JDOQLCompiler.containsOnlyGroupingOrAggregates(left, exprGrouping)) {
                return false;
            }
            return JDOQLCompiler.containsOnlyGroupingOrAggregates(right, exprGrouping);
        }
        if (expr instanceof InvokeExpression) {
            InvokeExpression invExpr = (InvokeExpression)expr;
            if (JDOQLCompiler.isExpressionGroupingOrAggregate(invExpr, exprGrouping)) {
                return true;
            }
            Expression invokedExpr = invExpr.getLeft();
            if (invokedExpr != null && !JDOQLCompiler.containsOnlyGroupingOrAggregates(invokedExpr, exprGrouping)) {
                return false;
            }
            List<Expression> invArgs = invExpr.getArguments();
            if (invArgs != null) {
                for (Expression argExpr : invArgs) {
                    if (JDOQLCompiler.containsOnlyGroupingOrAggregates(argExpr, exprGrouping)) continue;
                    return false;
                }
            }
            return true;
        }
        if (expr instanceof PrimaryExpression) {
            return JDOQLCompiler.isExpressionGroupingOrAggregate(expr, exprGrouping);
        }
        if (expr instanceof Literal) {
            return true;
        }
        if (expr instanceof ParameterExpression) {
            return true;
        }
        return expr instanceof VariableExpression;
    }

    private static boolean isExpressionGroupingOrAggregate(Expression expr, Expression[] exprGrouping) {
        if (expr instanceof InvokeExpression) {
            String methodName;
            InvokeExpression invExpr = (InvokeExpression)expr;
            if (invExpr.getLeft() == null && ((methodName = invExpr.getOperation()).equals("avg") || methodName.equals("AVG") || methodName.equals("count") || methodName.equals("COUNT") || methodName.equals("sum") || methodName.equals("SUM") || methodName.equals("min") || methodName.equals("MIN") || methodName.equals("max") || methodName.equals("MAX"))) {
                return true;
            }
            for (int j = 0; j < exprGrouping.length; ++j) {
                if (!(exprGrouping[j] instanceof InvokeExpression) || !invExpr.toStringWithoutAlias().equalsIgnoreCase(exprGrouping[j].toString())) continue;
                return true;
            }
        } else if (expr instanceof PrimaryExpression) {
            PrimaryExpression primExpr = (PrimaryExpression)expr;
            String id = primExpr.getId();
            if (id.equals("this")) {
                return true;
            }
            for (int j = 0; j < exprGrouping.length; ++j) {
                String groupId;
                if (!(exprGrouping[j] instanceof PrimaryExpression) || !id.equals(groupId = ((PrimaryExpression)exprGrouping[j]).getId())) continue;
                return true;
            }
        } else {
            if (expr instanceof OrderExpression) {
                Expression orderExpr = ((OrderExpression)expr).getLeft();
                return JDOQLCompiler.isExpressionGroupingOrAggregate(orderExpr, exprGrouping);
            }
            if (expr instanceof Literal) {
                return true;
            }
            if (expr instanceof ParameterExpression) {
                return true;
            }
            if (expr instanceof VariableExpression) {
                return true;
            }
            String exprStr = expr.toString();
            for (int j = 0; j < exprGrouping.length; ++j) {
                if (!exprGrouping[j].toString().equals(exprStr)) continue;
                return true;
            }
        }
        return false;
    }

    public boolean supportsImplicitVariables() {
        return this.variables == null;
    }

    public boolean caseSensitiveSymbolNames() {
        return true;
    }

    public String getLanguage() {
        return "JDOQL";
    }

    protected boolean isKeyword(String name) {
        if (name == null) {
            return false;
        }
        return JDOQLQueryHelper.isKeyword(name);
    }
}

