/*
 * Decompiled with CFR 0.152.
 */
package org.datanucleus.state;

import org.datanucleus.ClassConstants;
import org.datanucleus.ClassLoaderResolver;
import org.datanucleus.ExecutionContext;
import org.datanucleus.NucleusContext;
import org.datanucleus.PersistenceConfiguration;
import org.datanucleus.cache.CachedPC;
import org.datanucleus.exceptions.ClassNotResolvedException;
import org.datanucleus.exceptions.NucleusUserException;
import org.datanucleus.metadata.AbstractClassMetaData;
import org.datanucleus.state.JDOStateManager;
import org.datanucleus.state.ObjectProvider;
import org.datanucleus.state.ObjectProviderFactory;
import org.datanucleus.state.ObjectProviderPool;
import org.datanucleus.store.FieldValues;
import org.datanucleus.util.Localiser;

public class ObjectProviderFactoryImpl
implements ObjectProviderFactory {
    protected static final Localiser LOCALISER = Localiser.getInstance("org.datanucleus.Localisation", ClassConstants.NUCLEUS_CONTEXT_LOADER);
    ObjectProviderPool opPool = null;

    public ObjectProviderFactoryImpl(NucleusContext nucCtx) {
        PersistenceConfiguration conf = nucCtx.getPersistenceConfiguration();
        this.opPool = new ObjectProviderPool(conf.getIntProperty("datanucleus.objectProvider.maxIdle"), conf.getBooleanProperty("datanucleus.objectProvider.reaperThread"));
    }

    public void close() {
        this.opPool.close();
    }

    public ObjectProvider newForHollow(ExecutionContext ec, Class pcClass, Object id) {
        Class cls = this.getInitialisedClassForClass(pcClass, ec.getClassLoaderResolver());
        AbstractClassMetaData cmd = ec.getMetaDataManager().getMetaDataForClass(pcClass, ec.getClassLoaderResolver());
        ObjectProvider op = this.getObjectProvider(ec, cmd);
        op.initialiseForHollow(id, null, cls);
        return op;
    }

    public ObjectProvider newForHollow(ExecutionContext ec, Class pcClass, Object id, FieldValues fv) {
        Class cls = this.getInitialisedClassForClass(pcClass, ec.getClassLoaderResolver());
        AbstractClassMetaData cmd = ec.getMetaDataManager().getMetaDataForClass(pcClass, ec.getClassLoaderResolver());
        ObjectProvider op = this.getObjectProvider(ec, cmd);
        op.initialiseForHollow(id, fv, cls);
        return op;
    }

    public ObjectProvider newForHollowPreConstructed(ExecutionContext ec, Object id, Object pc) {
        AbstractClassMetaData cmd = ec.getMetaDataManager().getMetaDataForClass(pc.getClass(), ec.getClassLoaderResolver());
        ObjectProvider op = this.getObjectProvider(ec, cmd);
        op.initialiseForHollowPreConstructed(id, pc);
        return op;
    }

    public ObjectProvider newForHollowPopulatedAppId(ExecutionContext ec, Class pcClass, FieldValues fv) {
        Class cls = this.getInitialisedClassForClass(pcClass, ec.getClassLoaderResolver());
        AbstractClassMetaData cmd = ec.getMetaDataManager().getMetaDataForClass(pcClass, ec.getClassLoaderResolver());
        ObjectProvider op = this.getObjectProvider(ec, cmd);
        op.initialiseForHollowAppId(fv, cls);
        return op;
    }

    public ObjectProvider newForPersistentClean(ExecutionContext ec, Object id, Object pc) {
        AbstractClassMetaData cmd = ec.getMetaDataManager().getMetaDataForClass(pc.getClass(), ec.getClassLoaderResolver());
        ObjectProvider op = this.getObjectProvider(ec, cmd);
        op.initialiseForPersistentClean(id, pc);
        return op;
    }

    public ObjectProvider newForEmbedded(ExecutionContext ec, Object pc, boolean copyPc, ObjectProvider ownerOP, int ownerFieldNumber) {
        AbstractClassMetaData cmd = ec.getMetaDataManager().getMetaDataForClass(pc.getClass(), ec.getClassLoaderResolver());
        ObjectProvider op = this.getObjectProvider(ec, cmd);
        op.initialiseForEmbedded(pc, copyPc);
        if (ownerOP != null) {
            op.addEmbeddedOwner(ownerOP, ownerFieldNumber);
        }
        return op;
    }

    public ObjectProvider newForEmbedded(ExecutionContext ec, AbstractClassMetaData cmd, ObjectProvider ownerOP, int ownerFieldNumber) {
        Class pcClass = ec.getClassLoaderResolver().classForName(cmd.getFullClassName());
        ObjectProvider op = this.newForHollow(ec, pcClass, null);
        op.initialiseForEmbedded(op.getObject(), false);
        if (ownerOP != null) {
            op.addEmbeddedOwner(ownerOP, ownerFieldNumber);
        }
        return op;
    }

    public ObjectProvider newForPersistentNew(ExecutionContext ec, Object pc, FieldValues preInsertChanges) {
        AbstractClassMetaData cmd = ec.getMetaDataManager().getMetaDataForClass(pc.getClass(), ec.getClassLoaderResolver());
        ObjectProvider op = this.getObjectProvider(ec, cmd);
        op.initialiseForPersistentNew(pc, preInsertChanges);
        return op;
    }

    public ObjectProvider newForTransactionalTransient(ExecutionContext ec, Object pc) {
        AbstractClassMetaData cmd = ec.getMetaDataManager().getMetaDataForClass(pc.getClass(), ec.getClassLoaderResolver());
        ObjectProvider op = this.getObjectProvider(ec, cmd);
        op.initialiseForTransactionalTransient(pc);
        return op;
    }

    public ObjectProvider newForDetached(ExecutionContext ec, Object pc, Object id, Object version) {
        AbstractClassMetaData cmd = ec.getMetaDataManager().getMetaDataForClass(pc.getClass(), ec.getClassLoaderResolver());
        ObjectProvider op = this.getObjectProvider(ec, cmd);
        op.initialiseForDetached(pc, id, version);
        return op;
    }

    public ObjectProvider newForPNewToBeDeleted(ExecutionContext ec, Object pc) {
        AbstractClassMetaData cmd = ec.getMetaDataManager().getMetaDataForClass(pc.getClass(), ec.getClassLoaderResolver());
        ObjectProvider op = this.getObjectProvider(ec, cmd);
        op.initialiseForPNewToBeDeleted(pc);
        return op;
    }

    public ObjectProvider newForCachedPC(ExecutionContext ec, Object id, CachedPC cachedPC) {
        AbstractClassMetaData cmd = ec.getMetaDataManager().getMetaDataForClass(cachedPC.getObjectClass(), ec.getClassLoaderResolver());
        ObjectProvider op = this.getObjectProvider(ec, cmd);
        op.initialiseForCachedPC(cachedPC, id);
        return op;
    }

    public void disconnectObjectProvider(ObjectProvider op) {
    }

    protected ObjectProvider getObjectProvider(ExecutionContext ec, AbstractClassMetaData cmd) {
        return new JDOStateManager(ec, cmd);
    }

    private Class getInitialisedClassForClass(Class pcCls, ClassLoaderResolver clr) {
        try {
            return clr.classForName(pcCls.getName(), pcCls.getClassLoader(), true);
        }
        catch (ClassNotResolvedException e) {
            throw new NucleusUserException(LOCALISER.msg("026015", (Object)pcCls.getName())).setFatal();
        }
    }
}

